<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	
class Hisabctrl extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		$this->load->model('hisabmdl');
		$this->load->library('session');
		$this->load->library('upload');
		$this->load->library('pagination');
		$this->config->load('extra');
		$this->load->library('db_operations');
	}

	public function index()
	{	
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$this->load->view('pages/master/index');
		} else {
			redirect('loginctrl/logout');	
		}
	}

/*City Master */
	public function hisab()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {

			if($_GET['ac'] == "view") 
			{
				$config = array();
				$this->config->load('extra');
				$config = $this->config->item('pagination');
				$config['per_page'] = 250;
				
				$config['total_rows'] = $this->hisabmdl->get_hisab_data_count($_SESSION['fin_year']);

				$config['base_url']   = base_url('hisabctrl/hisab?search=true');

				foreach ($_GET as $key => $value) {
		            if ($key != 'search' && $key != 'offset') {
		                $config['base_url'] .= '&' . $key . '=' . $value;
		            }
		        }

		        $offset = (!empty($_GET['offset'])) ? $_GET['offset'] :  0;

		        $this->pagination->initialize($config);

				$record 	= $this->hisabmdl->get_hisab_data($_SESSION['fin_year'],$config['per_page'],$offset);
				$record['count'] 		= $offset;
				$record['total_rows'] 	= $config['total_rows'];

				$record['search_data'] 	= $this->config->item('hisab_search');

				// echo "<pre>";print_r($record);exit();
				$this->load->view('pages/hisab/hisab_master',$record);
			}
			else if ($_GET['ac'] == "add") 
			{
				$record = $this->hisabmdl->get_data_for_hisab_entry($_SESSION['fin_year']);
				
				$this->load->view('pages/hisab/hisab_form',$record);

			}
			else if ($_GET['ac'] == "update") 
			{
				$id 		= $_GET['id'];
                $hisab_id 	= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                if (!empty($hisab_id)) {
                	$record = $this->hisabmdl->get_single_hisab_data_for_update($hisab_id);

                	// echo "<pre>";print_r($record);exit();
					$this->load->view('pages/hisab/hisab_form',$record);
                } else {
					$this->load->view('errors/error');
                }
			}
			else if ($_GET['ac'] == "print") 
			{
				$id 		= $_GET['id'];
                $hisab_id 	= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                if (!empty($hisab_id)) {
                	$record = $this->hisabmdl->get_single_hisab_data_for_update($hisab_id);

                	// echo "<pre>";print_r($record);exit();
					$this->load->view('pdfs/hisab_bill',$record);
                } else {
					$this->load->view('errors/error');
                }
			}

		} else {
			redirect('loginctrl/logout');	
		}
	}

	public function hisab_insert($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			
			$form_data = $this->input->post();

			// echo "<pre>";print_r($form_data);exit();
			
			/*hisab master data*/


			$hisab_data = array();
			$hisab_data['hm_karigar_id'] 	= $form_data['hm_karigar_id'];
			$hisab_data['hm_entry_date'] 	= date('Y-m-d',strtotime($form_data['hm_entry_date']));
			$hisab_data['hm_amount'] 		= $form_data['hm_amount'];
			$hisab_data['hm_notes'] 		= $form_data['hm_notes'];
			
			
			if($id == 0) 
			{
				$this->db->trans_begin();
				$max_id = $this->hisabmdl->get_fin_year_wise_max_id('hisab_master','hm_entry_no','hm_fin_year',$_SESSION['fin_year']);
				
				$hisab_data['hm_entry_no'] 		= $max_id;
				$hisab_data['hm_fin_year'] 		= $_SESSION['fin_year'];
				$hisab_data['hm_user_id'] 		= $_SESSION['user_id'];
				$hisab_data['hm_date_create'] 	= date('Y-m-d H:i:s');
				$hisab_data['hm_update_id'] 	= $_SESSION['user_id'];
				$hisab_data['hm_date_update'] 	= date('Y-m-d H:i:s');

				$hisab_insertid = $this->db_operations->data_insert('hisab_master', $hisab_data);

				if (!empty($hisab_insertid)) 
				{
					$ot_result 	= $this->insert_update_hisab_trans($form_data, $hisab_insertid);
				}

				if ($this->db->trans_status() === FALSE) 
				{
				    $this->db->trans_rollback();
				    echo 0;
				} 
				else 
				{
				    $this->db->trans_commit();
					echo 1;
				}		
			}
			else
			{
				$this->db->trans_begin();
				/*update code*/
				$edit_cnt = $this->hisabmdl->check_edit_duplicate_hisab_entry($form_data['hm_entry_no'],$_SESSION['fin_year'],$id);

				if ($edit_cnt != 0) 
				{
					echo 2;
				}
				else
				{
					$hisab_data['hm_entry_no'] 		= $form_data['hm_entry_no'];
					$hisab_data['hm_fin_year'] 		= $_SESSION['fin_year'];
					$hisab_data['hm_update_id'] 	= $_SESSION['user_id'];
					$hisab_data['hm_date_update'] 	= date('Y-m-d H:i:s');

					// echo "<pre>";print_r($order_data);exit();

					/*update data to order_master table*/
					$result = $this->db_operations->data_update('hisab_master', $hisab_data, 'hm_id', $id);

					if (!empty($result)) 
					{
						/*update data to order_trans table*/
						$ot_result 	= $this->insert_update_hisab_trans($form_data, $id);
					}

					if ($this->db->trans_status() === FALSE) {
					    $this->db->trans_rollback();
					    echo 0;
					} else {
					    $this->db->trans_commit();
						echo 1;
					}	
				} 
			}
		}
		else 
		{
			redirect('loginctrl/logout');		
		}
	}

	public function insert_update_hisab_trans($form_data,$hm_id)
	{	
		// 0 = not avialable
		// 1 = avialable
		$hisab_trans_data = $this->db_operations->get_record('hisab_trans',array('ht_hm_id' =>$hm_id)); // get all db record first and all form data and match who is missing and those data delete by system  

		foreach ($hisab_trans_data as $key => $value) 
		{
			if (!in_array($value['ht_id'], $form_data['ht_id'])) 
			{	
				$hisab_reset_flag = array();
				$hisab_reset_flag['ot_hisab_done'] = 0;
				
				$ot_reset_update = $this->db_operations->data_update('order_trans',$hisab_reset_flag,'ot_id',$value['ht_ot_id']);
				/*delete transactions*/
				$del_res = $this->db_operations->delete_record('hisab_trans',array('ht_id' =>$value['ht_id']));
			}
		}

		$final_amount = 0;
		foreach ($form_data['ht_id'] as $key => $value) 
		{
			/*order transaction data*/
			$hisab_trans = array();
			
			$hisab_trans['ht_hm_id'] 			= $hm_id;
			$hisab_trans['ht_ot_id'] 			= $form_data['ht_ot_id'][$key];
			$hisab_trans['ht_chart_no'] 		= $form_data['ht_chart_no'][$key];
			// $hisab_trans['ht_fin_year'] 		= $form_data['ht_fin_year'][$key];
			$hisab_trans['ht_sub_chart_no'] 	= $form_data['ht_sub_chart_no'][$key];
			$hisab_trans['ht_apparel_id'] 		= $form_data['ht_apparel_id'][$key];
			$hisab_trans['ht_qty'] 				= $form_data['ht_qty'][$key];
			$hisab_trans['ht_apparel_charges'] 	= $form_data['ht_apparel_charges'][$key];
			$hisab_trans['ht_apparel_extra_charges'] = $form_data['ht_apparel_extra_charges'][$key];
			$hisab_trans['ht_final_amt'] 		= $form_data['ht_final_amt'][$key];

			if (($value == 0) && ($form_data['insert_row'][$key] == 1)) 
			{
				$hisab_flag = array();
				$hisab_flag['ot_hisab_done'] = 1;

				/*order transaction insert process*/
				$hisab_trans_result = $this->db_operations->data_insert('hisab_trans', $hisab_trans);

				$ot_update = $this->db_operations->data_update('order_trans',$hisab_flag,'ot_id',$form_data['ht_ot_id'][$key]);


			} 
			else if ($form_data['insert_row'][$key] == 1)
			{
				/*order transaction update process*/
				$hisab_trans_result = $this->db_operations->data_update('hisab_trans',$hisab_trans,'ht_id',$value);
			}

			$final_amount += $form_data['ht_final_amt'][$key];
		}

		$hisab_array = array();
		$hisab_array['hm_amount'] 		= $final_amount;
		$this->db_operations->data_update('hisab_master', $hisab_array, 'hm_id', $hm_id);
	}



	public function hisab_delete($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			/*db transaction starts*/
			$this->db->trans_begin();

			$hisab_trans_data = $this->db_operations->get_record('hisab_trans',array('ht_hm_id' =>$id)); // get all db record first and all form data and match who is missing and those data delete by system  
			foreach ($hisab_trans_data as $key => $value) 
			{
				$hisab_reset_flag = array();
				
				$hisab_reset_flag['ot_hisab_done'] = 0;
				$ot_reset_update = $this->db_operations->data_update('order_trans',$hisab_reset_flag,'ot_id',$value['ht_ot_id']);
			}


			$this->db_operations->delete_record('hisab_master', array('hm_id' => $id));
			$this->db_operations->delete_record('hisab_trans', array('ht_hm_id' => $id));
			
			if ($this->db->trans_status() === FALSE) {
			    $this->db->trans_rollback();
			    echo 0;
			} else {
			    $this->db->trans_commit();
				echo 1;
			}	
			
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}
	}


	/*kirgar data Master */
	public function get_karigar_complete_order($km_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {

			$data 	= $this->hisabmdl->get_karigar_done_order($km_id);
			// echo "<pre>";print_r($data);exit();
			echo json_encode($data);
		
		} else {
			redirect('loginctrl/logout');	
		}
	}


/***********************************************************************************************************************************************/
/*Master Ctrl End*/	
}

/*master ctroller End*/
?>
