<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	
class Masterctrl extends CI_Controller
{
	public $mastermdl;
	public $pagination;

	public function __construct()
	{
		parent::__construct();

		$this->load->model('mastermdl');
		$this->load->library('session');
		$this->load->library('upload');
		$this->load->library('pagination');
		$this->config->load('extra');
		$this->load->library('db_operations');
	}

	public function index()
	{	
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {

			$record = $this->mastermdl->get_all_order_details();

			$record['first'] = $this->mastermdl->get_last();
			// echo"<pre>";print_r($record);exit;
			$this->load->view('pages/master/index',$record);
		} else {
			redirect('loginctrl/logout');	
		}
	}

	public function send_sms_for_client($mob,$msg)
    {
		$xml_data ='<?xml version="1.0"?>
		<parent> 
		<child>
		<user>Stylo</user>
		<key>dacec36fb2XX</key>
		<mobile>'.$mob.'</mobile>
		<message>'.$msg.'</message>
		<accusage>1</accusage>
		<senderid>stylo</senderid>
		</child>
		</parent>';
		// print_r($xml_data);exit;
		$URL = "http://sms.interlinkconsultant.com/submitsms.jsp?"; 

		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
		curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);

		$output_array = explode(",", $output);

		// echo "<pre>";print_r($output_array);exit();

		if($output_array[1]=="success")
		{
			return 1;
		}
		else
		{
			return 4;
		}
       
	}

	public function send_rdf_sms()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {

			$form_data = $this->input->post();
			
			// echo"<pre>";print_r($form_data);exit;

			$this->db->trans_begin();
			foreach ($form_data['order_done'] as $key => $value) 
			{
				$record = $this->mastermdl->get_order_single_details($value);
			
				
				$mob = $record[0]['client_mobile1'];
				$order_no = $record[0]['om_no'];
				$balance = $record[0]['om_final_total'] -$record[0]['om_advance'] - $record[0]['om_allocated_amt'] - $record[0]['om_roundoff'];
				

				$msg = "Dear customer, your order (No : ".$order_no.", Balance : ".$balance." Rs/-) is reday for delivery, please collect your order as soon as possible";

				$sms_status =  $this->send_sms_for_client($mob,$msg);
				
				// echo "<pre>";print_r($record);exit();

				if($sms_status == 1)
				{
					$sms_flag = array();
					$sms_flag['om_sms_flag'] = 1;
					$sms_flag['om_sms_date'] = date('Y-m-d H:i:s');
					$result = $this->db_operations->data_update('order_master', $sms_flag, 'om_id', $value);
				}
			}

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				echo 0;
			} else {
				$this->db->trans_commit();
				$resp = array();
				$resp['flag'] = 1;

				echo json_encode($resp);
			}		

		
		} else {
			redirect('loginctrl/logout');	
		}
	}

	public function skip_rdf_sms()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {

			$form_data = $this->input->post();
			// echo"<pre>";print_r($form_data);exit;
			$this->db->trans_begin();
			foreach ($form_data['order_done'] as $key => $value) 
			{
				$sms_flag = array();
				$sms_flag['om_sms_flag'] = 2;
				$result = $this->db_operations->data_update('order_master', $sms_flag, 'om_id', $value);
			}

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				echo 0;
			} else {
				$this->db->trans_commit();
				$resp = array();
				$resp['flag'] = 1;
				echo json_encode($resp);
			}		

		
		} else {
			redirect('loginctrl/logout');	
		}
	}

	public function unskip_rdf_sms()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			
			$form_data = $this->input->post();
			
			// echo "<pre>";print_r($form_data);exit();
			// echo"<pre>";print_r($form_data);exit;

			$this->db->trans_begin();
			foreach ($form_data['order_skipped'] as $key => $value) 
			{
				$sms_flag = array();
				$sms_flag['om_sms_flag'] = 0;
				$result = $this->db_operations->data_update('order_master', $sms_flag, 'om_id', $value);
			}

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				echo 0;
			} else {
				$this->db->trans_commit();
				$resp = array();
				$resp['flag'] = 1;
				echo json_encode($resp);
			}		
		
		} else {
			redirect('loginctrl/logout');	
		}
	}

/*common function*/
	public function generate_token($length)
	{
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $token = substr( str_shuffle( $chars ), 0, $length );
        return $token;
    }
/*/common function */

/***************************** Group Master Start*****************************/

	public function group_master(){

		$user_id = $this->session->userdata('user_id');

		if(!empty($user_id))
		{
			$record['group_data'] = $this->db_operations->get_recordlist("group_master","grp_name", "asc"); 
			$this->load->view('pages/master/group_master', $record);
		}
		else
			redirect('loginctrl/logout');	
	}

	public function get_dealers(){

		$user_id = $this->session->userdata('user_id');

		if(!empty($user_id))
		{
			$record = array();
			echo json_encode($record);
		}
		else
			redirect('loginctrl/logout');	
	}

	public function group_insert($grp_id){

		$user_id = $this->session->userdata('user_id');
		
		if(!empty($user_id)){
			
			$form_data = $this->input->post();
			if($grp_id == 0)
			{
				$cnt = $this->mastermdl->get_cnt('group_master', array('grp_name' => $form_data['grp_name']));
				if ($cnt != 0)
				{
					echo 2;
				}
				else
				{
					$form_data['grp_user_id'] = $user_id;
					$form_data['grp_update_id'] = $user_id;
					$form_data['grp_date_create'] = date("Y-m-d H:i:s");

					$result = $this->db_operations->data_insert('group_master', $form_data);
					echo (!empty($result)) ? 1 : 0;
				}
			}
			else
			{
				$form_data['grp_update_id'] = $user_id;
				echo $this->db_operations->data_update('group_master', $form_data, 'grp_id', $grp_id);
			}
		}
		else
			redirect('loginctrl/logout');		
	}

	public function get_single_group($grp_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->db_operations->get_record("group_master", array("grp_id" => $grp_id));
			echo json_encode($record);
		}
		else
			redirect('loginctrl/logout');
	}

	public function group_delete($grp_id){

		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$this->db_operations->delete_record('group_master', array('grp_id' => $grp_id));
		}
		else
			redirect('loginctrl/logout');
	}

/***************************** Group Master End*****************************/


/************************** country Master *************************************/

public function country_master()
{
	$user_id = $this->session->userdata('user_id');
	if(!empty($user_id))
	{
		$record['country_data'] = $this->db_operations->get_recordlist("country_master", "country_name", "asc");
		$this->load->view('pages/master/country_master', $record);
	}
	else{
		redirect('loginctrl/logout');	
	}
}

public function country_insert($country_id)
{
	$user_id = $this->session->userdata('user_id');
	if(!empty($user_id))
	{
		$form_data = $this->input->post();
		if($country_id == 0)
		{
			$cnt = $this->mastermdl->check_dulicate_country_name($form_data['country_name']);
			if ($cnt != 0)
			{
				echo 2;
			}
			else
			{
				$form_data['country_name'] = strtoupper($form_data['country_name']);
				$form_data['cdate'] = date("Y-m-d H:i:s");
				
				$result = $this->db_operations->data_insert('country_master', $form_data);
				if(!empty($result))
				{
					echo 1;
				}
				else
				{
					echo 0;
				}
			}
		}
		else
		{
			$cnt = $this->mastermdl->check_edit_dulicate_country_name($form_data['country_name'],$country_id);
			if ($cnt != 0)
			{
				echo 2;
			}
			else
			{
				$form_data['country_name'] = strtoupper($form_data['country_name']);
				$form_data['udate'] 	= date("Y-m-d H:i:s");
				echo $this->db_operations->data_update('country_master', $form_data, 'country_id', $country_id);
			}
		}
	}
	else{
		redirect('loginctrl/logout');		
	}
}

public function get_single_country($country_id)
{
	$user_id = $this->session->userdata('user_id');
	if(!empty($user_id))
	{
		$record = $this->db_operations->get_record("country_master", array("country_id" => $country_id));
		echo json_encode($record);
	}
	else{
		redirect('loginctrl/logout');
	}
}

public function country_delete($country_id)
{
	$user_id = $this->session->userdata('user_id');
	if(!empty($user_id))
	{
		echo $this->db_operations->delete_record('country_master', array('country_id' => $country_id));
	}
	else{
		redirect('loginctrl/logout');
	}
}

/************************** country Master End *********************************/


/************************** makki Master *************************************/

public function makki_master()
{
	$user_id = $this->session->userdata('user_id');
	if(!empty($user_id))
	{
		$record['makki_data'] = $this->db_operations->get_recordlist("makki_master", "makki_name", "asc");
		$this->load->view('pages/master/makki_master', $record);
	}
	else{
		redirect('loginctrl/logout');	
	}
}

public function makki_insert($makki_id)
{
	$user_id = $this->session->userdata('user_id');
	if(!empty($user_id))
	{
		$form_data = $this->input->post();
		if($makki_id == 0)
		{
			$cnt = $this->mastermdl->check_dulicate_makki_name($form_data['makki_name']);
			if ($cnt != 0)
			{
				echo 2;
			}
			else
			{
				$form_data['makki_name'] = strtoupper($form_data['makki_name']);
				$form_data['cdate'] = date("Y-m-d H:i:s");
				
				$result = $this->db_operations->data_insert('makki_master', $form_data);
				if(!empty($result))
				{
					echo 1;
				}
				else
				{
					echo 0;
				}
			}
		}
		else
		{
			$cnt = $this->mastermdl->check_edit_dulicate_makki_name($form_data['makki_name'],$makki_id);
			if ($cnt != 0)
			{
				echo 2;
			}
			else
			{
				$form_data['makki_name'] = strtoupper($form_data['makki_name']);
				$form_data['udate'] 	= date("Y-m-d H:i:s");
				echo $this->db_operations->data_update('makki_master', $form_data, 'makki_id', $makki_id);
			}
		}
	}
	else{
		redirect('loginctrl/logout');		
	}
}

public function get_single_makki($makki_id)
{
	$user_id = $this->session->userdata('user_id');
	if(!empty($user_id))
	{
		$record = $this->db_operations->get_record("makki_master", array("makki_id" => $makki_id));
		echo json_encode($record);
	}
	else{
		redirect('loginctrl/logout');
	}
}

public function makki_delete($makki_id)
{
	$user_id = $this->session->userdata('user_id');
	if(!empty($user_id))
	{
		echo $this->db_operations->delete_record('makki_master', array('makki_id' => $makki_id));
	}
	else{
		redirect('loginctrl/logout');
	}
}

/************************** makki Master End *********************************/

/*City Master */
	public function client()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {

			if($_GET['ac'] == "view") 
			{
				$config = array();
				$this->config->load('extra');
				$config = $this->config->item('pagination');
				$config['per_page'] = 250;
				
				$config['total_rows'] = $this->mastermdl->get_client_data_count($_SESSION['fin_year']);

				$config['base_url']   = base_url('masterctrl/client?search=true');

				foreach ($_GET as $key => $value) {
		            if ($key != 'search' && $key != 'offset') {
		                $config['base_url'] .= '&' . $key . '=' . $value;
		            }
		        }

		        $offset = (!empty($_GET['offset'])) ? $_GET['offset'] :  0;

		        $this->pagination->initialize($config);

				$record 	= $this->mastermdl->get_client_data($_SESSION['fin_year'],$config['per_page'],$offset);
				$record['count'] 		= $offset;
				$record['total_rows'] 	= $config['total_rows'];

				$record['search_data'] 	= $this->config->item('client_search');

				// echo "<pre>";print_r($record);exit();
				$this->load->view('pages/master/client',$record);
			}
			else if ($_GET['ac'] == "add") 
			{
				$record = $this->mastermdl->get_data_for_client_entry($_SESSION['fin_year']);
				// echo "<pre>";print_r($record);exit();
				$this->load->view('pages/master/client_form',$record);

			}
			else if ($_GET['ac'] == "update") 
			{
				$id 		= $_GET['id'];
                $client_id 	= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                if (!empty($client_id)) {
                	$record = $this->mastermdl->get_single_client_data_for_update($client_id);
				// echo "<pre>";print_r($record);exit();

					$this->load->view('pages/master/client_form',$record);
                } else {
					$this->load->view('errors/error');
                }
			}
			else if ($_GET['ac'] == "print") 
			{
				$id 		= $_GET['id'];
                $client_id 	= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                if (!empty($client_id)) {
                	$record = $this->mastermdl->get_single_client_data_for_update($client_id);
                	$record['page_arr'] = $this->get_client_pagination($record['client_trans_data']);
				// echo "<pre>";print_r($record);exit();

					$this->load->view('pdfs/client_measer_print',$record);
                } else {
					$this->load->view('errors/error');
                }
			}

		} else {
			redirect('loginctrl/logout');	
		}
	}

	function get_client_pagination($client_trans_data)
	{
		
		$page_arr = array();
		$sum = 0;
		$temp_sum=0;
		$init = 0;
		$limit = 0;
		$pageno = 1;
		$flag = 1;
		$maxnocells = 0;
		$cellcount = 0;
		$buffer=0;

		foreach ($client_trans_data as $key => $value)
		{
			// $cellcount = count($value['ct_id']);
			$cellcount = is_array($value['ct_id']) ? count($value['ct_id']) : 0;
			//$cellcount = $obj_pdf->getNumLines($value['fab_trans_desc']);
		

			$page_arr[$pageno]['init']=$init;

			$page_arr[$pageno]['limit']=$limit;

			$page_arr[$pageno]['flag']=$flag;

			$page_arr[$pageno]['buffer']=$buffer;
			$sum = $sum + $cellcount;
			// echo "<pre>";print_r($cellcount);exit;

			if($sum < 10)
			{
				// echo "<pre>";print_r($sum);
				$buffer=10-$sum;

				$limit++;
				$flag = 0;
				// $sum = 0;
				$cellcount=0;
			}	
			else 
			{

				$pageno++;
				$init = $limit+1;
				$limit++;
				$flag = 1;
				$sum = 0;
				$cellcount=0;
			}
		}
		return $page_arr;
	}

	public function get_measurement_data_by_apparel($mm_id)
	{
		if(sessionExist()) {
			$record['maap'] = $this->mastermdl->get_measurement_data_by_apparel($mm_id);
			$record['style'] = $this->mastermdl->get_measurement_data_by_apparel_style($mm_id);

			// echo "<pre>";print_r($record);exit;

			echo json_encode($record);
		} else {
			redirect('loginctrl/logout');
		}
	}

	public function client_insert($client_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$form_data = $this->input->post();
			// echo "<pre>";print_r($form_data);exit();
			/*client data*/

			$file_data = array();
					
			$file_data = $_FILES;
			if($_FILES['client_photo']['error'] == 0) 
			{
				$filename = time().'_'.$_FILES['client_photo']['name'];
				$filename = str_replace(" ", "_", $filename);

				$config['upload_path']     = 'public/uploads/product/';
            	$config['allowed_types']   = 'gif|jpg|jpeg|png|pdf';
            	$config['file_name']       =  $filename;	
      
            	$this->upload->initialize($config);

            	if (!$this->upload->do_upload('client_photo')) 
            	{
            		$file_data['filename'] = 'no_image.jpg';
            	}
            	else
            	{
            		$file_data['filename'] = $filename;
            	}
			}
			else
			{
				$file_data['filename'] 	= $form_data['client_photo_update'];
			}
			// echo "<pre>"; print_r($form_data); exit();

			$client_data = array();
			$client_data['client_accno'] 	= $form_data['client_accno'];
			$client_data['client_name'] 	= trim($form_data['client_name']);
			$client_data['client_dob'] 		= date('Y-m-d',strtotime($form_data['client_dob']));
			$client_data['client_anniversary'] = date('Y-m-d',strtotime($form_data['client_anniversary']));
			$client_data['client_mobile1']	= trim($form_data['client_mobile1']);
			$client_data['client_mobile1_check']	= !empty($form_data['client_mobile1_check']) ? $form_data['client_mobile1_check'] : 0;

			$client_data['client_mobile2']	= !empty($form_data['client_mobile2']) ? $form_data['client_mobile2'] : '';
			$client_data['client_mobile2_check']	= !empty($form_data['client_mobile2_check']) ? $form_data['client_mobile2_check'] : 0;
			$client_data['client_reference_name']	= !empty($form_data['client_reference_name']) ? $form_data['client_reference_name'] : '';

			$client_data['client_telephone']= trim($form_data['client_telephone']);
			$client_data['client_whatsapp'] = trim($form_data['client_whatsapp']);
			$client_data['client_country'] 	= $form_data['client_country'];
			$client_data['client_location'] = !empty($form_data['client_location']) ? $form_data['client_location'] : '';

			// $client_data['client_bal'] 		= $form_data['client_bal'];
			$client_data['client_email']	= trim($form_data['client_email']);
			$client_data['client_status'] 	= $form_data['client_status'];
			$client_data['client_ref'] 		= $form_data['client_ref'];
			$client_data['client_home_address'] 	= $form_data['client_home_address'];
			$client_data['client_office_address'] 	= $form_data['client_office_address'];
			$client_data['client_other_address'] 	= $form_data['client_other_address'];

			$client_data['client_type'] 	= $form_data['client_type'];
			$client_data['client_gst_type'] = $form_data['client_gst_type'];
			
			// $client_data['client_year'] 	= $form_data['client_year'];
			$client_data['client_city'] 	= $form_data['client_city'];
			$client_data['client_area'] 	= $form_data['client_area'];
			$client_data['client_state'] 	= $form_data['client_state'];
			$client_data['client_notes'] 	= $form_data['client_notes'];

			$client_data['client_photo'] 	= $file_data['filename'];

			if($client_id == 0) 
			{
				$this->db->trans_begin();
				$cnt = $this->db_operations->get_cnt('client_master',array('client_name' => $form_data['client_name']));
				$cnt1 = $this->db_operations->get_cnt('client_master',array('client_mobile1' => $form_data['client_mobile1']));

				// $name_cnt 	= $this->mastermdl->check_duplicate_client_name($form_data['client_name']);
				// $mob_cnt 	= $this->mastermdl->check_duplicate_client_mobile($form_data['client_mobile1']);

				// echo $cnt;
				// echo $cnt1;exit;


				if ($cnt != 0 && $cnt1 != 0) 
				{
					$response['resp'] = 2;
					echo json_encode($response);	
				}
				else 
				{
					$client_data['client_userid'] 		 = $_SESSION['user_id'];
					$client_data['client_cdate'] 		 = date('Y-m-d');
					$client_data['client_modify_userid'] = $_SESSION['user_id'];
					$client_id = $this->db_operations->data_insert('client_master', $client_data);
					// echo "<pre>";print_r($client_id);exit;
					// echo "<pre>";print_r(isset($form_data['ct_id']));exit;

					if (!empty($client_id)) 
					{
						/*insert data to purchase_trans table*/
						if(isset($form_data['ct_id']))
						{
							$ct_id 	= $this->insert_update_client_trans($form_data, $client_id);
							if (!empty($ct_id)) 
							{
								if ($this->db->trans_status() === FALSE) 
								{
								    $this->db->trans_rollback();
								    $response['resp'] = 0;
									echo json_encode($response);						    						
	    						} 
	    						else 
	    						{
								    $this->db->trans_commit();
								    $response['resp'] = 1;
								    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
									echo json_encode($response);						   
								}
							}
							else
							{
								$this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);
							}
						}	
						else
						{
							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);						    						
    						} 
    						else 
    						{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
								echo json_encode($response);						   
							}
						}					
					}
				}
			} 
			else 
			{
				$this->db->trans_begin();
				$edit_cnt = $this->db_operations->get_cnt('client_master',array('client_name'=>$form_data['client_name'],'client_id !='=>$client_id));

				$edit_cnt1 = $this->db_operations->get_cnt('client_master',array('client_mobile1'=>$form_data['client_mobile1'],'client_id !='=>$client_id));

				// $name_edit_cnt 	= $this->mastermdl->check_edit_duplicate_client_name($form_data['client_name'],$id);
				// $mob_edit_cnt 	= $this->mastermdl->check_edit_duplicate_client_mobile($form_data['client_mobile1'],$id);

				if ($edit_cnt != 0 && $edit_cnt1 != 0) 
				{
					$response['resp'] = 2;
					echo json_encode($response);	
				}
				else
				{
					$client_data['client_modify_userid'] = $_SESSION['user_id'];
					$client_data['client_modify_date'] 	 = date('Y-m-d H:i:s');
					$result_id = $this->db_operations->data_update('client_master', $client_data, 'client_id', $client_id);
					// echo "<pre>";print_r($client_id);exit;
					// echo "<pre>";print_r(isset($form_data['ct_id']));exit;

					if (!empty($result_id)) 
					{
						/*insert data to purchase_trans table*/
						if(isset($form_data['ct_id']))
						{
							$ct_id 	= $this->insert_update_client_trans($form_data, $client_id);
							if (!empty($ct_id)) 
							{
								if ($this->db->trans_status() === FALSE) 
								{
								    $this->db->trans_rollback();
								    $response['resp'] = 0;
									echo json_encode($response);						    						
	    						} 
	    						else 
	    						{
								    $this->db->trans_commit();
								    $response['resp'] = 1;
								    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
									echo json_encode($response);						   
								}
							}
							else
							{

								$this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);
							}
						}	
						else
						{
							$ct_cnt = $this->db_operations->get_cnt('client_trans', ['ct_client_id'=>$client_id]);
							if($ct_cnt != 0)
							{
								$this->db_operations->delete_record('client_trans',array('ct_client_id'=>$client_id));
							}
							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);						    						
    						} 
    						else 
    						{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
								echo json_encode($response);						   
							}
						}					
					}
				}
			}
		} 
		else {
			redirect('loginctrl/logout');		
		}
	}
	public function insert_update_client_trans($form_data, $client_id)
	{	
		// 0 = not avialable
		// 1 = avialable
		$flag = 0;

		$client_trans_data = $this->db_operations->get_record('client_trans',array('ct_client_id' => $client_id)); // get all db record first and all form data and match who is missing and those data delete by system  
		// echo "<pre>"; print_r($client_trans_data);
		// echo "<pre>"; print_r($form_data); exit(); 

		if (!empty($client_trans_data))
		{
			foreach ($client_trans_data as $key => $value) 
			{
				if (!in_array($value['ct_id'], $form_data['ct_id']))
				{					
					$this->db_operations->delete_record('client_trans',array('ct_id'=>$value['ct_id']));
				}
			}
		}
		foreach ($form_data as $key => $value)
		{
			// echo "<pre>";print_r($key);die();
			// echo "<pre>";print_r($form_data);die();
			// $key = str_replace('-', '_', $key);
			$key = preg_replace("/[\s\-\.\(\)\/]/", "_", $key);
			// echo "<pre>";print_r(is_array($value));

			if(is_array($value))
			{
				// echo "<pre>";print_r($key);exit();

				$field_name = $this->db->query("SHOW COLUMNS FROM client_trans like '".$key."'")->result_array();
				// echo "<pre>";print_r($field_name);

				// echo "<pre>";print_r(empty($field_name));


				if (empty($field_name)) 
				{
					$this->db->query("ALTER TABLE client_trans ADD ".$key." varchar(200) NOT NULL  ");					
				}
			}
		}
		// exit();
		foreach ($form_data['ct_id'] as $key => $value)
		{
			// echo "<pre>"; print_r($form_data); exit;

			$client_trans_data = array();
			$client_trans_data['ct_client_id']		= $client_id;
			$client_trans_data['ct_app_id']		= $form_data['ct_app_id'][$key];
			$client_trans_data['ct_mm_id']			= $form_data['ct_mm_id'][$key];
			// $client_trans_data['ct_notes'] 			= $form_data['ct_notes'][$form_data['ct_mm_id'][$key]];
			$client_trans_data['ct_notes'] 			= $form_data['ct_notes'][$form_data['ct_mm_id'][$key]];
			$client_trans_data['ct_notes_maap'] 			= $form_data['ct_notes_maap'][$form_data['ct_mm_id'][$key]];
			// echo "<pre>"; print_r($client_trans_data); exit;


			$maap_data = $this->mastermdl->get_measurement_data_by_apparel($form_data['ct_mm_id'][$key]);

			$style_data = $this->mastermdl->get_measurement_data_by_apparel_style($form_data['ct_mm_id'][$key]);
			// echo "<pre>"; print_r($maap_data); 
			// echo "<pre>"; print_r($client_trans_data); exit;

			foreach ($maap_data as $value1) 
			{
				// $col_name = strtolower(trim($value1['maap_name'], ' '));
				// $col_name = str_replace('-', '_', $col_name);
				// $col_name = str_replace(' ', '_', $col_name);
				// $col_name = preg_replace("/[\s\-\.]/", "_", strtolower(trim($value1['maap_name']) ?? ''));

				$col_name = preg_replace("/[\s-.()\/]/", "_", strtolower(trim($value1['maap_name'])));
			// echo "<pre>"; print_r($col_name); 

				if(array_key_exists('ct_'.$col_name, $form_data))
				{

					if(array_key_exists($form_data['ct_mm_id'][$key], $form_data['ct_'.$col_name]))
					{
						$client_trans_data['ct_'.$col_name] = empty($form_data['ct_'.$col_name][$form_data['ct_mm_id'][$key]]) ? '' : $form_data['ct_'.$col_name][$form_data['ct_mm_id'][$key]];
						// echo "<pre>"; print_r($col_name); 
						// echo "<pre>";print_r($client_trans_data);
					}
				}						
			}
			// exit;

			foreach ($style_data as $value2) 
			{
				// $col_name1 = strtolower(trim($value2['style_name'], ' '));
				// $col_name1 = str_replace('-', '_', $col_name1);
				// $col_name1 = str_replace(' ', '_', $col_name1);
				// $col_name1 = preg_replace("/[\s\-\.]/", "_", strtolower(trim($value2['style_name'] ?? '')));

				$col_name1 = preg_replace("/[\s-.()\/]/", "_", strtolower(trim($value2['style_name'])));

				$client_trans_data1 = $this->db_operations->get_record('client_trans',array('ct_id' => $value));  
				// echo "<pre>"; print_r($client_trans_data1[0]); exit;
				
				if(!empty($client_trans_data1))
				{ 
					if(array_key_exists('ct_'.$col_name1, $client_trans_data1[0]))
                    {
                    	$check_update = array();
                    	$check_update['ct_'.$col_name1] = "";
                    }
                    $this->db_operations->data_update('client_trans', $check_update, 'ct_id', $value);
				}




						// echo "<pre>"; print_r($col_name1); 

				if(array_key_exists('ct_'.$col_name1, $form_data))
				{
					if(array_key_exists($form_data['ct_mm_id'][$key], $form_data['ct_'.$col_name1]))
					{
						$client_trans_data['ct_'.$col_name1] = empty($form_data['ct_'.$col_name1][$form_data['ct_mm_id'][$key]]) ? '' : $form_data['ct_'.$col_name1][$form_data['ct_mm_id'][$key]];
						// echo "<pre>"; print_r($col_name); 
						// echo "<pre>";print_r($client_trans_data);
					}
				}						
			}



			// echo "<pre>";print_r($client_trans_data);exit;		
			if ($value == 0)
			{
				$result = $this->db_operations->data_insert('client_trans', $client_trans_data);
									
			}
			else
			{
				
				$result = $this->db_operations->data_update('client_trans',$client_trans_data,'ct_id',$value);
			}	
		}

		if(!empty($result))
		{
			$flag = 1;
		}
		

		return $flag;
	}

	public function client_delete($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			// echo $this->db_operations->delete_record('client_master', array('client_id' => $id));

			$count = $this->db_operations->get_cnt('order_master', array('om_client_id' => $id));
			// echo "<pre>"; print_r($count);
			if ($count >= 1) 
			{
				echo 2;
			}
			else
			{
				$data = array('client_id' => $id, );
				$result = $this->db_operations->delete_record('client_master',$data);
				if(!empty($result))
				{
					// redirect(base_url('cmaster/apparel_master'));
					echo 0;
				}
				else
				{
					echo 0;
				}
			}
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}
	}

	public function get_fraction_data($float) 
	{
    	$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
    	{
    		$bal = $this->get_fraction($float);
			echo json_encode($bal);
    	}
    	else
    	{
    		redirect('loginctrl/logout');
    	}
	}

	public function get_fraction($float) 
	{
		// 1/2, 1/4, 1/8, 1/16, 1/3 ,2/3, 3/4, 3/8, 5/8, 7/8, 3/16, 5/16, 7/16,
    	// 9/16, 11/16, 13/16, 15/16
	    $whole = floor ( $float );
	    $decimal = $float - $whole;
	    $leastCommonDenom = 48; // 16 * 3;
	    $denominators = array (2, 3, 4, 8, 16, 24, 48 );
	    $roundedDecimal = round ( $decimal * $leastCommonDenom ) / $leastCommonDenom;
	    if ($roundedDecimal == 0)
	        return $whole;
	    if ($roundedDecimal == 1)
	        return $whole + 1;
	    foreach ( $denominators as $d ) {
	        if ($roundedDecimal * $d == floor ( $roundedDecimal * $d )) {
	            $denom = $d;
	            break;
	        }
	    }
	    return ($whole == 0 ? '' : $whole) . " " . ($roundedDecimal * $denom) . "/" . $denom;
	}

	/*APPAREL Master */
	public function apparel()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record['apparel_data'] 	= $this->db_operations->get_recordlist("apparel_master");
			$this->load->view('pages/master/apparel_master', $record);
		} else {
			redirect('loginctrl/logout');	
		}
	}

	public function apparel_insert($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{	
			$form_data = $this->input->post();

			// print_r($form_data); exit;

			$master_data = [];
		$master_data['app_name'] 	       = trim($form_data['app_name']);
		$master_data['app_charges']        = trim($form_data['app_charges']);
		$master_data['app_sgst_per']       = trim($form_data['app_sgst_per']);
		$master_data['app_cgst_per']       = trim($form_data['app_cgst_per']);
		$master_data['app_igst_per']       = trim($form_data['app_igst_per']);
		$master_data['app_cat'] 		   = isset($form_data['app_cat']) ? $form_data['app_cat'] : '';
		$master_data['app_fab_per'] 	   = isset($form_data['app_fab_per']);
		$master_data['app_chart_rec'] 	   = isset($form_data['app_chart_rec']);
		$master_data['app_status'] 		   = isset($form_data['app_status']);
		$master_data['app_measurement_type']= $form_data['app_measurement_type'];

			if($id == 0) {
				$cnt = $this->db_operations->get_cnt('apparel_master', array('app_name' => $form_data['app_name']));
				if ($cnt != 0) {
					echo 2;
				} else {
					
					$master_data['app_userid'] 			= $_SESSION['user_id'];
					$master_data['app_cdate'] 			= date('Y-m-d');
					$master_data['app_modify_userid']   = $_SESSION['user_id'];
					$master_data['app_modify_date'] 	= date("Y-m-d H:i:s");

					$id = $this->db_operations->data_insert('apparel_master', $master_data);

					echo (!empty($id)) ? 1 : 0;
				}
			} else {
				
				$master_data['app_modify_userid'] 	= $_SESSION['user_id'];
				$master_data['app_modify_date'] 	= date("Y-m-d H:i:s");

				// print_r($form_data); exit;

				echo $this->db_operations->data_update('apparel_master', $master_data, 'app_id', $id);
			}

			if(isset($form_data['aat_apparel_id'])){
				
			// print_r($form_data); exit;
				$result = $this->add_update_apparel_trans($form_data, $id);
				if(!isset($result['status'])){
					$this->db->trans_rollback();
					return ['msg' => $result['msg']];
				}
			}else{
				$prev_data = $this->db_operations->get_record('apparel_apparel_trans', ['apparel_id' => $id]);
				if(!empty($prev_data)){
					if($this->db_operations->delete_record('apparel_apparel_trans', ['apparel_id' => $id]) < 1){
						$this->db->trans_rollback();
						return ['msg' => '1. Apparel not deleted'];
					}
				}
			}
		} else {
			redirect('loginctrl/logout');		
		}
	}

	public function add_update_apparel_trans($form_data, $id){
		// print_r($form_data); exit;
        $trans_db_data = $this->db_operations->get_record('apparel_apparel_trans', ['apparel_id' => $id]);
        if(!empty($trans_db_data)){
            foreach ($trans_db_data as $key => $value){
                if(!in_array($value['aat_apparel_id'], $form_data['aat_apparel_id'])){
                    if($this->db_operations->delete_record('apparel_apparel_trans', ['aat_apparel_id' => $value['aat_apparel_id']]) < 1){
                        return ['msg' => 'Apparel not deleted.'];
                    }
                } 
            }
        }
        foreach ($form_data['aat_apparel_id'] as $key => $value){
		// print_r($value); exit;

			$trans_data 					= [];
            $trans_data['apparel_id']	    = $id;
            $trans_data['aat_apparel_id']	= $form_data['aat_apparel_id'][$key];

			$prev_data = $this->db_operations->get_record('apparel_apparel_trans', $trans_data);
		

            if(empty($prev_data)){
                if($this->db_operations->data_insert('apparel_apparel_trans', $trans_data) < 1) return ['msg' => 'Apparel not inserted.'];
            }else{
                if($this->db_operations->data_update('apparel_apparel_trans', $trans_data, 'aat_id', $prev_data[0]['aat_id']) < 1) return ['msg' => 'Apparel not updated.'];
            }
    
        }
        return ['status' => TRUE];
    }

	public function get_single_apparel($app_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->db_operations->get_record("apparel_master", array("app_id" => $app_id));

			$record['apparel_data'] = $this->mastermdl->get_apparel_apparel_trans_data($app_id);

			echo json_encode($record);
		} else {
			redirect('loginctrl/logout');
		}
	}

	public function apparel_delete($app_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			echo $this->db_operations->delete_record('apparel_master', array('app_id' => $app_id));
		} else {
			redirect('loginctrl/logout');
		}
	}
/*/APPAREL Master */



/*USER Master */
	public function user_master()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record['role'] 		= $this->config->item('role');
			$record['user_data'] 	= $this->db_operations->get_record("user_master",array('user_status' => 1));

			$this->load->view('pages/master/user_master', $record);
		} else {
			redirect('loginctrl/logout');	
		}
	}

	public function get_role()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record['role'] = $this->config->item('role');
			echo json_encode($record);
		} else {
			redirect('loginctrl/logout');
		}
	}

	public function user_insert($u_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{	
			$form_data = $this->input->post();
			
			if (isset($form_data['user_comm_from'])) 
			{
				$form_data['user_comm_from'] 	= date("Y-m-d",strtotime($form_data['user_comm_from']));
			}

			if (isset($form_data['user_comm_to'])) 
			{
				$form_data['user_comm_to'] 	= date("Y-m-d",strtotime($form_data['user_comm_to']));
			}

			$form_data['user_status'] 		= 1;

			// echo "<pre>";print_r($form_data);exit();

			if($u_id == 0) {
				$cnt = $this->mastermdl->get_cnt('user_master', array('user_name' => $form_data['user_name']));
				if ($cnt != 0) {
					echo 2;
				} else {
					$token = $this->generate_token(32);
					$form_data['user_token'] 		= $token;
					$user_password 					= $form_data['user_password'];
					$form_data['user_password'] 	= md5($form_data['user_password']);
					$form_data['user_date_create'] 	= date("Y-m-d H:i:s");
					$result = $this->db_operations->data_insert('user_master', $form_data);

					echo (!empty($result)) ? 1 : 0;
				}
			} else {
				if($form_data['user_password'] != "") {
					$form_data['user_password'] = md5($form_data['user_password']);
				} else {
					unset($form_data['user_password']);
				}
				
				$token = $this->generate_token(32);
				$form_data['user_token'] = $token;
				echo $this->db_operations->data_update('user_master', $form_data, 'user_id', $u_id);
			}
		} else {
			redirect('loginctrl/logout');		
		}
	}

	public function get_single_user($u_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->db_operations->get_record("user_master", array("user_id" => $u_id));
			echo json_encode($record);
		} else {
			redirect('loginctrl/logout');
		}
	}

	public function user_delete($u_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$user_array = array();
			$user_array['user_status'] = 0;
			echo $this->db_operations->data_update('user_master', $user_array, 'user_id', $u_id);
		} else {
			redirect('loginctrl/logout');
		}
	}
/*/USER Master */



/*Maap Master */
	public function maap_master()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			// $config 				= array();
			// $config 				= $this->config->item('pagination');
			// $config['total_rows'] 	= $this->mastermdl->get_all_maap_data_cnt();
			// $config['base_url'] 	= base_url("masterctrl/maap_master?search=true");

			// foreach ($_GET as $key => $value) 
			// {
			// 	if($key != 'search' && $key != 'offset')
			// 	{
			// 		$config['base_url'] .= "&" . $key . "=" .$value;
			// 	}
			// }

			// $offset = (!empty($_GET['offset'])) ? $_GET['offset'] : 0;
			// $this->pagination->initialize($config);

			// $record['count'] 		= $offset;
			// $record['total_rows'] 	= $config['total_rows'];
			// $record['role'] 		= $this->config->item('role');

			// $record['data']			= $this->mastermdl->get_all_maap_data($config['per_page'],$offset);

			$record['maap_data'] = $this->db_operations->get_recordlist("maap_master", "maap_name", "desc");

			$this->load->view('pages/master/maap_master', $record);
		} else {
			redirect('loginctrl/logout');	
		}
	}
	public function maap_insert($maap_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$form_data = $this->input->post();

			if($maap_id == 0) {
				$cnt = $this->db_operations->get_cnt('maap_master', array('maap_name' => $form_data['maap_name']));				
				if ($cnt != 0) 
				{
					echo 2;
				} 
				else 
				{
					$maap_name = preg_replace("/[\s-.()\/]/", "_", strtoupper(trim($form_data['maap_name'])));

					$form_data['maap_name'] 		= $maap_name;
					$form_data['maap_userid'] 		= $_SESSION['user_id'];
					$form_data['maap_create_date'] 	= date("Y-m-d H:i:s");					
					$form_data['maap_update_userid']= $_SESSION['user_id'];
					$form_data['maap_update_date'] 	= date("Y-m-d H:i:s");					
					$result = $this->db_operations->data_insert('maap_master', $form_data);
					echo (!empty($result)) ? 1 : 0;
				}
			} 
			else 
			{
				$cnt = $this->db_operations->get_cnt('maap_master', array('maap_id !=' => $maap_id,'maap_name' => $form_data['maap_name']));	
				if ($cnt != 0) {
					echo 2;
				} else {
					$maap_name = preg_replace("/[\s-.()\/]/", "_", strtoupper(trim($form_data['maap_name'])));
					
					$form_data['maap_name'] 		= $maap_name;

					// $form_data['maap_name'] 		= trim(strtoupper($form_data['maap_name']));
					$form_data['maap_update_userid']= $_SESSION['user_id'];
					$form_data['maap_update_date'] 	= date("Y-m-d H:i:s");					
					echo $this->db_operations->data_update('maap_master', $form_data, 'maap_id', $maap_id);
				}
			}
		} else {
			redirect('loginctrl/logout');		
		}
	}

	public function get_single_maap($maap_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->mastermdl->get_single_maap($maap_id);
			echo json_encode($record);
		} else {
			redirect('loginctrl/logout');
		}
	}

	public function maap_delete($maap_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$count = $this->db_operations->get_cnt('measurement_trans',array('mt_maap_id' =>$maap_id));

			if ($count >= 1) 
			{
				echo 2;
			}
			else
			{

				echo $this->db_operations->delete_record('maap_master', array('maap_id' => $maap_id));
			}
			
		} else {
			redirect('loginctrl/logout');
		}
	}
/*/Maap Master */
/************************** style Master *************************************/

	public function style_master()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record['style_data'] = $this->db_operations->get_recordlist("style_master", "style_name", "asc");
			$this->load->view('pages/master/style_master', $record);
		}
		else{
			redirect('loginctrl/logout');	
		}
	}

	public function style_insert($style_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();
			if($style_id == 0)
			{
				$cnt = $this->mastermdl->check_dulicate_style_name($form_data['style_name']);
				if ($cnt != 0)
				{
					echo 2;
				}
				else
				{
					$style_name = preg_replace("/[\s-.()\/]/", "_", strtolower(trim($form_data['style_name'])));
					
					$form_data['style_name'] 		= $style_name;
					$form_data['style_create_date'] = date("Y-m-d H:i:s");
					
					$result = $this->db_operations->data_insert('style_master', $form_data);
					if(!empty($result))
					{
						echo 1;
					}
					else
					{
						echo 0;
					}
				}
			}
			else
			{
				$cnt = $this->mastermdl->check_edit_dulicate_style_name($form_data['style_name'],$style_id);
				if ($cnt != 0)
				{
					echo 2;
				}
				else
				{
					$style_name = preg_replace("/[\s-.()\/]/", "_", strtolower(trim($form_data['style_name'])));
					
					$form_data['style_name'] 		= $style_name;
					$form_data['style_update_date'] 	= date("Y-m-d H:i:s");
					echo $this->db_operations->data_update('style_master', $form_data, 'style_id', $style_id);
				}
			}
		}
		else{
			redirect('loginctrl/logout');		
		}
	}

	public function get_single_style($style_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->db_operations->get_record("style_master", array("style_id" => $style_id));
			echo json_encode($record);
		}
		else{
			redirect('loginctrl/logout');
		}
	}

	public function style_delete($style_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$count = $this->db_operations->get_cnt('measurement_style_trans',array('mst_style_id' =>$style_id));

			if ($count >= 1) 
			{
				echo 2;
			}
			else
			{
				echo $this->db_operations->delete_record('style_master', array('style_id' => $style_id));
			}
		}
		else{
			redirect('loginctrl/logout');
		}
	}

/************************** style Master End *********************************/

/*Measurement Master */
	public function measurement_master()
	{
		if(sessionExist()) 
		{
			if($_GET['action'] == 'view')
			{
				$config 				= array();
				$config 				= $this->config->item('pagination');
				$config['total_rows'] 	= $this->mastermdl->get_all_measurement_data_cnt();
				$config['base_url'] 	= base_url("masterctrl/measurement_master?search=true");

				foreach ($_GET as $key => $value) 
				{
					if($key != 'search' && $key != 'offset')
					{
						$config['base_url'] .= "&" . $key . "=" .$value;
					}
				}

				$offset = (!empty($_GET['offset'])) ? $_GET['offset'] : 0;
				$this->pagination->initialize($config);

				$record['count'] 		= $offset;
				$record['total_rows'] 	= $config['total_rows'];
				$record['role'] 		= $this->config->item('role');				
				$record['data']			= $this->mastermdl->get_all_measurement_data($config['per_page'],$offset);
				// echo "<pre>"; print_r($record); exit;
				
				$this->load->view('pages/master/measurement_master', $record);
			}
			else if($_GET['action'] == 'add')
			{
				$record = $this->mastermdl->get_measurement_data();
				// echo "<pre>"; print_r($record); exit;
				$this->load->view('pages/master/measurement_form', $record);
			}
			else if($_GET['action'] == 'edit')
			{
				$mm_id = encrypt_decrypt("decrypt", $_GET['id'], SECRET_KEY);
				$record = $this->mastermdl->get_single_measurement_data($mm_id);
				// echo "<pre>"; print_r($record); exit;
				$this->load->view('pages/master/measurement_form', $record);
			}
			else
			{
				$this->load->view('errors/error');
			}
		} else {
			redirect('loginctrl/logout');	
		}
	}
	public function get_maap_data()
	{
		if(sessionExist()) 
		{
			$record['maap'] = $this->db_operations->get_recordlist("maap_master");
			$record['style'] = $this->db_operations->get_recordlist("style_master");

			echo json_encode($record);
		} else {
			redirect('loginctrl/logout');
		}
	}
	public function get_measurement_data_from_table($app_id)
	{
		if(sessionExist()) 
		{
			$record = $this->mastermdl->get_measurement_data_from_table($app_id);
			echo json_encode($record);
		} else {
			redirect('loginctrl/logout');
		}
	}

	public function get_measurement_data_from_table_style($app_id)
	{
		if(sessionExist()) 
		{
			$record = $this->mastermdl->get_measurement_data_from_table_style($app_id);
			echo json_encode($record);
		} else {
			redirect('loginctrl/logout');
		}
	}

	
	public function measurement_insert($mm_id)
	{
		if(sessionExist()) {
			$form_data = $this->input->post();
			$response = [];
			$measurement_data = [];
			$mt_id = 0;
			$result_id = 0;
			// echo "<pre>"; print_r($form_data); exit();

			$measurement_data['mm_app_id'] = $form_data['mm_app_id'];

			if($mm_id == 0) 
			{
				$this->db->trans_begin();
				$cnt = $this->db_operations->get_cnt('measurement_master', array('mm_app_id' => $measurement_data['mm_app_id']));				
				if ($cnt != 0) 
				{
					$response['resp'] = 2;
					echo json_encode($response);
				} 
				else 
				{
					$measurement_data['mm_userid'] 		= $_SESSION['user_id'];
					$measurement_data['mm_create_date'] 	= date("Y-m-d H:i:s");			
					$measurement_data['mm_update_userid']	= $_SESSION['user_id'];
					$measurement_data['mm_update_date'] 	= date("Y-m-d H:i:s");					
					$mm_id = $this->db_operations->data_insert('measurement_master', $measurement_data);
					if (!empty($mm_id)) 
					{
						/*insert data to purchase_trans table*/
						$mt_id 	= $this->insert_update_measurement_trans($form_data, $mm_id);

						if(isset($form_data['mst_id']))
						{
							$mst_id = $this->insert_update_measurement_style_trans($form_data, $mm_id);
						}


						if (!empty($mt_id) || !empty($mst_id)) 
						{
							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);						    						
    						} 
    						else 
    						{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							    $response['last_id'] = encrypt_decrypt("encrypt", $mm_id, SECRET_KEY);
								echo json_encode($response);						   
							}
						}
						else
						{
							$this->db->trans_rollback();
						    $response['resp'] = 0;
							echo json_encode($response);
						}
					}
				}
			} 
			else 
			{
				$this->db->trans_begin();
				$cnt = $this->db_operations->get_cnt('measurement_master', array('mm_id !='=>$mm_id,'mm_app_id' => $measurement_data['mm_app_id']));				
				if ($cnt != 0) 
				{
					$response['resp'] = 2;
					echo json_encode($response);
				} 
				else 
				{
					$measurement_data['mm_update_userid']	= $_SESSION['user_id'];
					$measurement_data['mm_update_date'] 	= date("Y-m-d H:i:s");					
					$result_id = $this->db_operations->data_update('measurement_master', $measurement_data, 'mm_id', $mm_id);
					if (!empty($result_id)) 
					{
						/*insert data to purchase_trans table*/
						$mt_id 	= $this->insert_update_measurement_trans($form_data, $mm_id);
						if(isset($form_data['mst_id']))
						{
							$mst_id = $this->insert_update_measurement_style_trans($form_data, $mm_id);
						}
						if (!empty($mt_id) || !empty($mst_id)) 
						{
							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);						    						
    						} 
    						else 
    						{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							    $response['last_id'] = encrypt_decrypt("encrypt", $mm_id, SECRET_KEY);
								echo json_encode($response);						   
							}
						}
						else
						{
							$this->db->trans_rollback();
						    $response['resp'] = 0;
							echo json_encode($response);
						}
					}
				}
			}
		} else {
			redirect('loginctrl/logout');		
		}
	}
	public function insert_update_measurement_trans($form_data, $mm_id)
	{	
		// 0 = not avialable
		// 1 = avialable
		$flag = 0;

		$measurement_trans_db = $this->db_operations->get_record('measurement_trans',array('mt_mm_id' =>$mm_id)); // get all db record first and all form data and match who is missing and those data delete by system  
		// echo "<pre>"; print_r($purchase_order_trans_data);
		// echo "<pre>"; print_r($form_data); exit(); 

		foreach ($measurement_trans_db as $key => $value) 
		{
			if (!in_array($value['mt_id'], $form_data['mt_id'])) 
			{	
				/*delete transactions*/
				$del_res = $this->db_operations->delete_record('measurement_trans',array('mt_id' =>$value['mt_id']));
			}
		}

		foreach ($form_data['mt_id'] as $key => $value) 
		{
			/*purchase transaction data*/
			$measurement_trans_data = array();
			
			$measurement_trans_data['mt_mm_id']     = $mm_id;
			$measurement_trans_data['mt_maap_id'] 	= $form_data['mt_maap_id'][$key];
			
			if ($value == 0) 
			{
				/*sale transaction insert process*/

				$flag = $this->db_operations->data_insert('measurement_trans', $measurement_trans_data);

				if($flag < 1)
				{
					return 0;
				}
			} 
			else 
			{
				/*purchase transaction update process*/
				$flag = $this->db_operations->data_update('measurement_trans',$measurement_trans_data,'mt_id',$value);
				if($flag < 1)
				{
					return 0;
				}	
					
			}
			
						
		}
		return $flag;
	}

	public function insert_update_measurement_style_trans($form_data, $mm_id)
	{	
		// 0 = not avialable
		// 1 = avialable
		$flag = 0;

		$measurement_style_trans_db = $this->db_operations->get_record('measurement_style_trans',array('mst_mm_id' =>$mm_id)); // get all db record first and all form data and match who is missing and those data delete by system  
		// echo "<pre>"; print_r($purchase_order_trans_data);
		// echo "<pre>"; print_r($form_data); exit(); 

		foreach ($measurement_style_trans_db as $key => $value) 
		{
			if (!in_array($value['mst_id'], $form_data['mst_id'])) 
			{	
				/*delete transactions*/
				$del_res = $this->db_operations->delete_record('measurement_style_trans',array('mst_id' =>$value['mst_id']));
			}
		}

		foreach ($form_data['mst_id'] as $key => $value) 
		{
			/*purchase transaction data*/
			$measurement_style_trans_data = array();
			
			$measurement_style_trans_data['mst_mm_id'] 	= $mm_id;
			$measurement_style_trans_data['mst_style_id'] = $form_data['mst_style_id'][$key];
			
			if ($value == 0) 
			{
				/*sale transaction insert process*/

				$flag = $this->db_operations->data_insert('measurement_style_trans', $measurement_style_trans_data);

				if($flag < 1)
				{
					return 0;
				}
			} 
			else 
			{
				/*purchase transaction update process*/
				$flag = $this->db_operations->data_update('measurement_style_trans',$measurement_style_trans_data,'mst_id',$value);
				if($flag < 1)
				{
					return 0;
				}	
					
			}
			
						
		}
		return $flag;
	}

	public function get_single_measurement($measurement_id)
	{
		if(sessionExist()) {
			$record = $this->db_operations->get_record("measurement_master", array("mm_id" => $measurement_id));
			echo json_encode($record);
		} else {
			redirect('loginctrl/logout');
		}
	}

	public function measurement_delete($measurement_id)
	{
		if(sessionExist()) 
		{
			$count = $this->db_operations->get_cnt('client_trans',array('ct_mm_id' =>$measurement_id));

			if ($count >= 1) 
			{
				echo 2;
			}
			else
			{

				echo $this->db_operations->delete_record('measurement_trans', array('mt_mm_id' => $measurement_id));
				echo $this->db_operations->delete_record('measurement_style_trans', array('mst_mm_id' => $measurement_id));
				echo $this->db_operations->delete_record('measurement_master', array('mm_id' => $measurement_id));
			}
			
		} else {
			redirect('loginctrl/logout');
		}
	}
/*/Measurement Master */
/************************** Area Master *************************************/

	public function area_master()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record['area_data'] = $this->db_operations->get_recordlist("area_master", "area_name", "asc");
			$this->load->view('pages/master/area_master', $record);
		}
		else{
			redirect('loginctrl/logout');	
		}
	}

	public function area_insert($area_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();
			if($area_id == 0)
			{
				$cnt = $this->mastermdl->check_dulicate_area_name($form_data['area_name']);
				if ($cnt != 0)
				{
					echo 2;
				}
				else
				{
					$form_data['area_cdate'] = date("Y-m-d H:i:s");
					
					$result = $this->db_operations->data_insert('area_master', $form_data);
					if(!empty($result))
					{
						echo 1;
					}
					else
					{
						echo 0;
					}
				}
			}
			else
			{
				$cnt = $this->mastermdl->check_edit_dulicate_area_name($form_data['area_name'],$area_id);
				if ($cnt != 0)
				{
					echo 2;
				}
				else
				{
					$form_data['area_udate'] 	= date("Y-m-d H:i:s");
					echo $this->db_operations->data_update('area_master', $form_data, 'area_id', $area_id);
				}
			}
		}
		else{
			redirect('loginctrl/logout');		
		}
	}

	public function get_single_area($area_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->db_operations->get_record("area_master", array("area_id" => $area_id));
			echo json_encode($record);
		}
		else{
			redirect('loginctrl/logout');
		}
	}

	public function area_delete($area_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			echo $this->db_operations->delete_record('area_master', array('area_id' => $area_id));
		}
		else{
			redirect('loginctrl/logout');
		}
	}

/************************** Area Master End *********************************/

/************************** city Master *************************************/

	public function city_master()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record['city_data'] = $this->db_operations->get_recordlist("city_master", "city_name", "asc");
			$this->load->view('pages/master/city_master', $record);
		}
		else{
			redirect('loginctrl/logout');	
		}
	}

	public function city_insert($city_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();
			if($city_id == 0)
			{
				$cnt = $this->mastermdl->check_dulicate_city_name($form_data['city_name']);
				if ($cnt != 0)
				{
					echo 2;
				}
				else
				{
					$form_data['cdate'] = date("Y-m-d H:i:s");
					
					$result = $this->db_operations->data_insert('city_master', $form_data);
					if(!empty($result))
					{
						echo 1;
					}
					else
					{
						echo 0;
					}
				}
			}
			else
			{
				$cnt = $this->mastermdl->check_edit_dulicate_city_name($form_data['city_name'],$city_id);
				if ($cnt != 0)
				{
					echo 2;
				}
				else
				{
					$form_data['udate'] 	= date("Y-m-d H:i:s");
					echo $this->db_operations->data_update('city_master', $form_data, 'city_id', $city_id);
				}
			}
		}
		else{
			redirect('loginctrl/logout');		
		}
	}

	public function get_single_city($city_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->db_operations->get_record("city_master", array("city_id" => $city_id));
			echo json_encode($record);
		}
		else{
			redirect('loginctrl/logout');
		}
	}

	public function city_delete($city_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			echo $this->db_operations->delete_record('city_master', array('city_id' => $city_id));
		}
		else{
			redirect('loginctrl/logout');
		}
	}

/************************** city Master End *********************************/
/************************** state Master *************************************/

	public function state_master()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record['state_data'] = $this->db_operations->get_recordlist("state_master", "state_name", "asc");
			$this->load->view('pages/master/state_master', $record);
		}
		else{
			redirect('loginctrl/logout');	
		}
	}

	public function state_insert($state_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();
			if($state_id == 0)
			{
				$cnt = $this->mastermdl->check_dulicate_state_name($form_data['state_name']);
				if ($cnt != 0)
				{
					echo 2;
				}
				else
				{
					$form_data['state_date_create'] = date("Y-m-d H:i:s");
					
					$result = $this->db_operations->data_insert('state_master', $form_data);
					if(!empty($result))
					{
						echo 1;
					}
					else
					{
						echo 0;
					}
				}
			}
			else
			{
				$cnt = $this->mastermdl->check_edit_dulicate_state_name($form_data['state_name'],$state_id);
				if ($cnt != 0)
				{
					echo 2;
				}
				else
				{
					$form_data['state_update_date'] 	= date("Y-m-d H:i:s");
					echo $this->db_operations->data_update('state_master', $form_data, 'state_id', $state_id);
				}
			}
		}
		else{
			redirect('loginctrl/logout');		
		}
	}

	public function get_single_state($state_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->db_operations->get_record("state_master", array("state_id" => $state_id));
			echo json_encode($record);
		}
		else{
			redirect('loginctrl/logout');
		}
	}

	public function state_delete($state_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			echo $this->db_operations->delete_record('state_master', array('state_id' => $state_id));
		}
		else{
			redirect('loginctrl/logout');
		}
	}

	//select2

	public function get_select2($func){
		$json = [];
		$data = $this->mastermdl->$func();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}

	public function get_completed_order_data($om_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->mastermdl->get_done_order_trans_data($om_id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

/************************** state Master End *********************************/

/***********************************************************************************************************************************************/
/*Master Ctrl End*/	
}

/*master ctroller End*/
?>
