<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Orderctrl extends CI_Controller {
	public $ordermdl;
	public $pagination;

	public function __construct()
	{
		parent::__construct();

		$this->load->model('ordermdl');
		$this->load->library('session');
		$this->load->library('upload');
		$this->load->library('pagination');
		$this->config->load('extra');
		$this->load->library('db_operations');
	}

	public function index()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$this->load->view('pages/master/index');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}
	}

	public function send_sms($mob,$msg)
    {
        
		$xml_data ='<?xml version="1.0"?>
		<parent> 
		<child>
		<user>STYLO FASHION</user>
		<key>dacec36fb2XX</key>
		<mobile>'.$mob.'</mobile>
		<message>'.$msg.'</message>
		<accusage>1</accusage>
		<senderid>STYLO FASHION</senderid>
		</child>
		</parent>';
		// print_r($xml_data);exit;
		$URL = "http://sms.interlinkconsultant.com/submitsms.jsp?"; 

		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
		curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);
		// print_r($output);
		$output_array = explode(",", $output);
		if($output_array[1]=="success")
		{
			echo 1;
		}
		else
		{
			echo 4;
		}
       
    }
    
    public function send_sms_for_order($mob,$msg)
    {
		$xml_data ='<?xml version="1.0"?>
		<parent> 
		<child>
		<user>STYLO FASHION</user>
		<key>dacec36fb2XX</key>
		<mobile>'.$mob.'</mobile>
		<message>'.$msg.'</message>
		<accusage>1</accusage>
		<senderid>STYLO FASHION</senderid>
		</child>
		</parent>';
		// print_r($xml_data);exit;
		$URL = "http://sms.interlinkconsultant.com/submitsms.jsp?"; 

		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
		curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);
		// print_r($output);
       
    }


	public function order()
	{
		// echo "<pre>";print_r($_SESSION);exit();
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			if($_GET['ac'] == "view") 
			{
				$config = array();
				$this->config->load('extra');
				$config = $this->config->item('pagination');
				$config['per_page'] = 20;
				
				if($_SESSION['user_role_id'] == 1 || $_SESSION['user_role_id'] == 2 || $_SESSION['user_role_id'] == 4 || $_SESSION['user_role_id'] == 5): 
				$config['total_rows'] = $this->ordermdl->get_order_data_count($_SESSION['fin_year']);
				// echo '<pre>';print_r($result);exit;
				elseif($_SESSION['user_role_id'] == 3):
				$config['total_rows'] = $this->ordermdl->get_designer_order_data_count($_SESSION['fin_year'],$_SESSION['user_id']);
				endif;

				$config['base_url']   = base_url('orderctrl/order?search=true');

				foreach ($_GET as $key => $value) {
		            if ($key != 'search' && $key != 'offset') {
		                $config['base_url'] .= '&' . $key . '=' . $value;
		            }
		        }

		        $offset = (!empty($_GET['offset'])) ? $_GET['offset'] :  0;

		        $this->pagination->initialize($config);

		        if($_SESSION['user_role_id'] == 1 || $_SESSION['user_role_id'] == 2 || $_SESSION['user_role_id'] == 4 || $_SESSION['user_role_id'] == 5): 
				$record 	= $this->ordermdl->get_order_data($_SESSION['fin_year'],$config['per_page'],$offset);
				elseif($_SESSION['user_role_id'] == 3):
				$record 	= $this->ordermdl->get_designer_order_data($_SESSION['fin_year'],$config['per_page'],$offset,$_SESSION['user_id']);
				endif;

				$record['count'] 		= $offset;
				$record['total_rows'] 	= $config['total_rows'];
				$record['search_data'] 	= $this->config->item('order_search');

				// echo "<pre>";print_r($record);exit();

				$this->load->view('pages/order/order_master',$record);
			}
			else if ($_GET['ac'] == "add") 
			{
				$record = $this->ordermdl->get_data_for_order_entry($_SESSION['fin_year']);
				// echo "<pre>";print_r($record);exit();
				$this->load->view('pages/order/order_form',$record);

			}
			else if ($_GET['ac'] == "update") 
			{
				$id 		= $_GET['id'];
                $om_id 	= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                if (!empty($om_id)) {
                	$record = $this->ordermdl->get_single_order_data_for_update($om_id);

                	// echo "<pre>";print_r($record);exit();
					$this->load->view('pages/order/order_form',$record);
                } else {
					$this->load->view('errors/error');
                }
			}
			else if ($_GET['ac'] == "print") 
			{
				$id 		= $_GET['id'];
                $om_id 		= encrypt_decrypt("decrypt", $id, SECRET_KEY);

                $c_id 		= isset($_GET['c_id']) ? $_GET['c_id'] : '';
                $client_id 	= encrypt_decrypt("decrypt", $c_id, SECRET_KEY);

                if (!empty($om_id)) {
                	$record = $this->ordermdl->get_single_order_data_for_print($om_id);
                	// echo "<pre>";print_r($record);exit();

                	if ($_GET['tp'] == 'adv') 
                	{
                		$this->load->view('pdfs/order_advance',$record);
                	}
                	elseif ($_GET['tp'] == 'bill') 
                	{
                		$this->load->view('pdfs/order_bill',$record);
                	}
                	elseif ($_GET['tp'] == 'measure') 
                	{
                		$record = $this->ordermdl->get_single_measure_data_for_print($om_id,$client_id);
                	// echo "<pre>";print_r($record);exit();
                		
                		$this->load->view('pdfs/client_measer_print',$record);
                	}
                	elseif ($_GET['tp'] == 'barcode') 
                	{
                		$record = $this->ordermdl->get_stitching_barcode_data_for_print($om_id,$client_id);

                		// echo "<pre>";print_r($record);exit();
                		
                		$this->load->view('pdfs/stitching_barcode_print',$record);
                	}
                	elseif ($_GET['tp'] == 'sum') 
                	{
                		// $data = $this->ordermdl->get_order_summary_data_for_print($om_id);
                		$data = $this->ordermdl->get_done_order_trans_data($om_id);
                		
                		// echo "<pre>";print_r($data);exit();

                		$this->load->view('pdfs/order_bill_summary',$data);
                	}

                } else {
					$this->load->view('errors/error');
                }
			}
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function get_all_acc_details($client_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_customer_record($client_id);
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function get_apparel_data($app_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_apparel_record($app_id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function get_apparel_data_package_fabric($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_apparel_data_package_fabric($id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function get_measurement_data_by_apparel_order($app_id,$client_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$data = [];
			// $query1= "SELECT 
            //     app.*, aat.aat_apparel_id
            //     FROM apparel_apparel_trans aat
            //     INNER JOIN apparel_master app ON(app.app_id = aat.aat_apparel_id)
            //     WHERE 1
            //     AND aat.apparel_id = $app_id
			// 	ORDER BY aat.aat_id";

			$query1= "SELECT 
                app.*
                FROM apparel_master app
                WHERE 1
                AND app.app_id = $app_id
				ORDER BY app.app_id";

				// echo $query1;exit;
			$record['apparel_data'] =$this->db->query($query1)->result_array();
// echo "<pre>"; print_r($record); exit;
			if(!empty($record['apparel_data'])){
				foreach($record['apparel_data'] as $key => $value) {
					$maap = $this->ordermdl->get_measurement_data_by_apparel_order($value['app_id'],$client_id);
					$style = $this->ordermdl->get_measurement_data_by_apparel_style_order($value['app_id'],$client_id);
					if(empty($maap) && empty($style)) return['msg' => '2. Measurement not found.'];

					array_push($data, ['apparel_data' => $value, 'measurement_data' => $maap, 'style_data' => $style]);
				}
			}
			// echo "<pre>"; print_r($data); die;
			echo json_encode($data);
		} else {
			redirect('loginctrl/logout');
		}
	}

	public function client_insert_from_order($client_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$form_data = $this->input->post();
			// echo "<pre>";print_r($form_data);exit();
			/*client data*/
			// echo "<pre>"; print_r($form_data); exit();

			$client_data = array();
			$client_data['client_name'] 	= trim($form_data['client_name']);
			if($client_id == 0) 
			{
				$this->db->trans_begin();
				$cnt = $this->db_operations->get_cnt('client_master',array('client_name' => $form_data['client_name']));

				if ($cnt != 0) 
				{
					$response['resp'] = 2;
					echo json_encode($response);
				}
				else 
				{
					$client_data['client_userid'] 		 = $_SESSION['user_id'];
					$client_data['client_cdate'] 		 = date('Y-m-d');
					$client_data['client_modify_userid'] = $_SESSION['user_id'];
					$client_id = $this->db_operations->data_insert('client_master', $client_data);
					// echo "<pre>";print_r($client_id);exit;
					// echo "<pre>";print_r(isset($form_data['ct_id']));exit;

					if (!empty($client_id)) 
					{
						/*insert data to purchase_trans table*/
						if(isset($form_data['ct_id']))
						{
							$ct_id 	= $this->insert_update_client_trans($form_data, $client_id);
							if (!empty($ct_id)) 
							{
								if ($this->db->trans_status() === FALSE) 
								{
								    $this->db->trans_rollback();
								    $response['resp'] = 0;
									echo json_encode($response);						    						
	    						} 
	    						else 
	    						{
								    $this->db->trans_commit();
								    $response['resp'] = 1;
								    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
									echo json_encode($response);						   
								}
							}
							else
							{
								$this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);
							}
						}	
						else
						{
							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);						    						
    						} 
    						else 
    						{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
								echo json_encode($response);						   
							}
						}					
					}
				}
			} 
			else 
			{
				$this->db->trans_begin();
				// $edit_cnt = $this->db_operations->get_cnt('client_master',array('client_name'=>$form_data['client_name'],'client_id !='=>$client_id));
				// 	echo "<pre>";print_r($edit_cnt);exit;

				// if ($edit_cnt != 0) 
				// {
				// 	$response['resp'] = 2;
				// 	echo json_encode($response);
				// }
				// else
				// {
					$client_data['client_modify_userid'] = $_SESSION['user_id'];
					$client_data['client_modify_date'] 	 = date('Y-m-d H:i:s');
					$result_id = $this->db_operations->data_update('client_master', $client_data, 'client_id', $client_id);
					// echo "<pre>";print_r($client_id);exit;
					// echo "<pre>";print_r(isset($form_data['ct_id']));exit;

					if (!empty($result_id)) 
					{
						/*insert data to purchase_trans table*/
						if(isset($form_data['ct_id']))
						{
							$ct_id 	= $this->insert_update_client_trans($form_data, $client_id);
							if (!empty($ct_id)) 
							{
								if ($this->db->trans_status() === FALSE) 
								{
								    $this->db->trans_rollback();
								    $response['resp'] = 0;
									echo json_encode($response);						    						
	    						} 
	    						else 
	    						{
								    $this->db->trans_commit();
								    $response['resp'] = 1;
								    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
									echo json_encode($response);						   
								}
							}
							else
							{

								$this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);
							}
						}	
						else
						{
							$ct_cnt = $this->db_operations->get_cnt('client_trans', ['ct_client_id'=>$client_id]);
							if($ct_cnt != 0)
							{
								$this->db_operations->delete_record('client_trans',array('ct_client_id'=>$client_id));
							}
							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
								echo json_encode($response);						    						
    						} 
    						else 
    						{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							    $response['last_id'] = encrypt_decrypt("encrypt", $client_id, SECRET_KEY);
								echo json_encode($response);						   
							}
						}					
					}
				// }
			}
		} 
		else {
			redirect('loginctrl/logout');		
		}
	}
	public function insert_update_client_trans($form_data, $client_id)
	{	
		// 0 = not avialable
		// 1 = avialable
		$flag = 0;

		$client_trans_data = $this->db_operations->get_record('client_trans',array('ct_client_id' => $client_id)); // get all db record first and all form data and match who is missing and those data delete by system  
		// echo "<pre>"; print_r($client_trans_data);
		// echo "<pre>"; print_r($form_data); exit(); 

		// if (!empty($client_trans_data))
		// {
		// 	foreach ($client_trans_data as $key => $value) 
		// 	{
		// 		if (!in_array($value['ct_id'], $form_data['ct_id']))
		// 		{					
		// 			$this->db_operations->delete_record('client_trans',array('ct_id'=>$value['ct_id']));
		// 		}
		// 	}
		// }
		foreach ($form_data as $key => $value)
		{
			// echo "<pre>";print_r($key);
			// $key = str_replace('-', '_', $key);
			$key = preg_replace("/[\s\-\.]/", "_", $key);
			// echo "<pre>";print_r(is_array($value));

			if(is_array($value))
			{
				// echo "<pre>";print_r($key);exit();

				$field_name = $this->db->query("SHOW COLUMNS FROM client_trans like '".$key."'")->result_array();
				// echo "<pre>";print_r($field_name);

				// echo "<pre>";print_r(empty($field_name));exit();


				if (empty($field_name)) 
				{
					// echo "<pre>";print_r($value);
					$this->db->query("ALTER TABLE client_trans ADD ".$key." varchar(200) NOT NULL  ");					
				}
			}
		}
		// exit();
		foreach ($form_data['ct_id'] as $key => $value)
		{
			// echo "<pre>"; print_r($form_data); exit;

			$client_trans_data = array();
			$client_trans_data['ct_client_id']	= $client_id;
			$client_trans_data['ct_app_id']		= $form_data['ct_app_id'][$key];
			$client_trans_data['ct_mm_id']		= $form_data['ct_mm_id'][$key];
			// $client_trans_data['ct_notes'] 	= $form_data['ct_notes'][$form_data['ct_mm_id'][$key]];
			$client_trans_data['ct_notes'] 		= $form_data['ct_notes'][$form_data['ct_mm_id'][$key]];
			$client_trans_data['ct_notes_maap'] = $form_data['ct_notes_maap'][$form_data['ct_mm_id'][$key]];
			$client_trans_data['ct_square_shoulder']= !empty($form_data['ct_square_shoulder'][$form_data['ct_mm_id'][$key]]) ? $form_data['ct_square_shoulder'][$form_data['ct_mm_id'][$key]] : 0;
			$client_trans_data['ct_down_shoulder']= !empty($form_data['ct_down_shoulder'][$form_data['ct_mm_id'][$key]]) ? $form_data['ct_down_shoulder'][$form_data['ct_mm_id'][$key]] : 0;
			$client_trans_data['ct_short_neck']= !empty($form_data['ct_short_neck'][$form_data['ct_mm_id'][$key]]) ? $form_data['ct_short_neck'][$form_data['ct_mm_id'][$key]] : 0;
			$client_trans_data['ct_forward_chest']= !empty($form_data['ct_forward_chest'][$form_data['ct_mm_id'][$key]]) ? $form_data['ct_forward_chest'][$form_data['ct_mm_id'][$key]] : 0;
			// echo "<pre>"; print_r($client_trans_data); exit;

			$maap_data = $this->ordermdl->get_measurement_data_by_apparel($form_data['ct_mm_id'][$key]);

			$style_data = $this->ordermdl->get_measurement_data_by_apparel_style($form_data['ct_mm_id'][$key]);
			// echo "<pre>"; print_r($maap_data); 
			// echo "<pre>"; print_r($client_trans_data); exit;

			foreach ($maap_data as $value1) 
			{
				// $col_name = strtolower(trim($value1['maap_name'], ' '));
				// $col_name = str_replace('-', '_', $col_name);
				// $col_name = str_replace(' ', '_', $col_name);
				$col_name = preg_replace("/[\s\-\.]/", "_", strtolower(trim($value1['maap_name'])));

			// echo "<pre>"; print_r($col_name); 

				if(array_key_exists('ct_'.$col_name, $form_data))
				{

					if(array_key_exists($form_data['ct_mm_id'][$key], $form_data['ct_'.$col_name]))
					{
						$client_trans_data['ct_'.$col_name] = empty($form_data['ct_'.$col_name][$form_data['ct_mm_id'][$key]]) ? '' : $form_data['ct_'.$col_name][$form_data['ct_mm_id'][$key]];
						// echo "<pre>"; print_r($col_name); 
						// echo "<pre>";print_r($client_trans_data);
					}
				}						
			}
			// exit;

			foreach ($style_data as $value2) 
			{
				// $col_name1 = strtolower(trim($value2['style_name'], ' '));
				// $col_name1 = str_replace('-', '_', $col_name1);
				// $col_name1 = str_replace(' ', '_', $col_name1);
				$col_name1 = preg_replace("/[\s\-\.]/", "_", strtolower(trim($value2['style_name'])));

				$client_trans_data1 = $this->db_operations->get_record('client_trans',array('ct_id' => $value));  
				// echo "<pre>"; print_r($client_trans_data1[0]); exit;
				
				if(!empty($client_trans_data1))
				{ 
					if(array_key_exists('ct_'.$col_name1, $client_trans_data1[0]))
                    {
                    	$check_update = array();
                    	$check_update['ct_'.$col_name1] = "";
                    }
                    $this->db_operations->data_update('client_trans', $check_update, 'ct_id', $value);
				}
				

						// echo "<pre>"; print_r($col_name1); 

				if(array_key_exists('ct_'.$col_name1, $form_data))
				{
					if(array_key_exists($form_data['ct_mm_id'][$key], $form_data['ct_'.$col_name1]))
					{
						$client_trans_data['ct_'.$col_name1] = empty($form_data['ct_'.$col_name1][$form_data['ct_mm_id'][$key]]) ? '' : $form_data['ct_'.$col_name1][$form_data['ct_mm_id'][$key]];
						// echo "<pre>"; print_r($col_name); 
						// echo "<pre>";print_r($client_trans_data);
					}
				}						
			}

			// echo "<pre>";print_r($client_trans_data);exit;		
			if ($value == 0)
			{
				$result = $this->db_operations->data_insert('client_trans', $client_trans_data);
									
			}
			else
			{
				
				$result = $this->db_operations->data_update('client_trans',$client_trans_data,'ct_id',$value);
			}	
		}

		if(!empty($result))
		{
			$flag = 1;
		}
		

		return $flag;
	}

	public function get_gst_bill_no()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_fin_year_wise_max_id('order_master','om_gst_inv_no','om_fin_year',$_SESSION['fin_year']);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}


	public function check_duplicate_app_code($app_code)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$chart = trim($app_code);
			$record = $this->ordermdl->check_duplicate_app_code_record($chart,$_SESSION['fin_year']);

			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function cancel_gst_bill_no($bill_no)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_fin_year_wise_max_id('order_master','om_gst_inv_no','om_fin_year',$_SESSION['fin_year']);
			
			if (($record - $bill_no) > 1) 
			{
				echo 2;
			}
			else
			{
				echo 1;
			}
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function order_update_approval($om_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$form_data = $this->input->post();

			
			
			$form_data['om_checkbox'] = isset($_POST['om_checkbox']) ? 1 : 0;

			

			// echo "<pre>";print_r($form_data);exit;
			$this->db->trans_begin();
			$result = $this->db_operations->data_update('order_master', $form_data, 'om_id', $om_id);

			if ($this->db->trans_status() === FALSE) {
			    $this->db->trans_rollback();
			    echo 0;
			} else {
			    $this->db->trans_commit();
			  	echo 1;
			}			
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}


	public function order_insert($om_id)
	{
		if (sessionExist()) 
		{			
			$form_data = $this->input->post();

			// echo "<pre>";print_r($form_data);exit();

			/*order master data array*/
			$order_data = array();
			
			$order_data['om_date'] 			= date('Y-m-d',strtotime($form_data['om_date']));
			$order_data['om_trial_date'] 	= date('Y-m-d',strtotime($form_data['om_trial_date']));
			$order_data['om_delivery_date'] = date('Y-m-d',strtotime($form_data['om_delivery_date']));
			$order_data['om_client_id'] 	= $form_data['om_client_id_hidden'];
			$order_data['om_client_id2'] 	= $form_data['om_client_id2'];
			$order_data['om_client_mobile'] = $form_data['om_client_mobile'];
			// $order_data['om_mojdi'] 		= $form_data['om_mojdi'];
			// $order_data['om_mojdi_size'] 	= $form_data['om_mojdi_size'];
			$order_data['om_notes'] 		= $form_data['om_notes'];
			$order_data['om_courier'] 		= !empty($form_data['om_courier']) ? $form_data['om_courier'] : '';
			$order_data['om_courier_address'] = !empty($form_data['om_courier_address']) ? $form_data['om_courier_address'] : '';
			$order_data['om_gross_total'] 	= $form_data['om_gross_total'];
			$order_data['om_disc_amt'] 		= $form_data['om_disc_amt'];
			$order_data['om_final_total'] 	= $form_data['om_final_total'];
			$order_data['om_advance'] 		= $form_data['om_advance'];
			$order_data['om_roundoff'] 		= $form_data['om_roundoff'];
			$order_data['om_balance'] 		= $form_data['om_balance'];
			$order_data['om_total_qty'] 	= $form_data['om_total_qty'];
			$order_data['om_approve'] 		= $form_data['om_approve'];

			$order_data['om_payment_mode'] 	= $form_data['om_payment_mode'];

			if (isset($form_data['om_bank_name'])) 
			{
				$order_data['om_bank_name'] 	= $form_data['om_bank_name'];
			}

			if (isset($form_data['om_cheq_dd_no'])) 
			{
				$order_data['om_cheq_dd_no'] 	= $form_data['om_cheq_dd_no'];
			}

			if (isset($form_data['om_cheq_dd_date'])) 
			{
				$order_data['om_cheq_dd_date'] 	= date('Y-m-d',strtotime($form_data['om_cheq_dd_date']));
			}

			if (isset($form_data['om_neft_amt'])) 
			{
				$order_data['om_neft_amt'] 	= $form_data['om_neft_amt'];
			}

			if (isset($form_data['om_neft_date'])) 
			{
				$order_data['om_neft_date'] 	= date('Y-m-d',strtotime($form_data['om_neft_date']));
			}

			if (isset($form_data['om_card_type'])) 
			{
				$order_data['om_card_type'] 	= $form_data['om_card_type'];
			}

			if (isset($form_data['om_card_no'])) 
			{
				$order_data['om_card_no'] 	= $form_data['om_card_no'];
			}

			if (isset($form_data['om_expiry_date'])) 
			{
				$order_data['om_expiry_date'] 	= date('Y-m-d',strtotime($form_data['om_expiry_date']));
			}

			// echo "<pre>";print_r($sale_data);exit();

			if ($om_id == 0) 
			{
				$this->db->trans_begin();
				/*check duplicate purchase entry no*/
				// $cnt = $this->ordermdl->check_duplicate_sale_entry($form_data['sm_inv_no'],$_SESSION['fin_year']);
				$max_id = $this->ordermdl->get_fin_year_wise_max_id('order_master','om_no','om_fin_year',$_SESSION['fin_year']);

				if($form_data['om_no'] == ''){
					$om_no = $max_id;
				}else{
					$om_no = $form_data['om_no'];
				}

				// $order_data['om_no'] 			= $max_id;
				$order_data['om_no'] 			= $om_no;
				$order_data['om_fin_year'] 		= $_SESSION['fin_year'];	
				$order_data['om_user_id'] 		= $_SESSION['user_id'];				
				$order_data['om_cdate'] 		= date('Y-m-d');				
				$order_data['om_modify_uid'] 	= $_SESSION['user_id'];				
				$order_data['om_modify_cdate'] 	= date('Y-m-d H:i:s');

				/*insert data to order_master table*/
				$result_id = $this->db_operations->data_insert('order_master', $order_data);
				
				if (!empty($result_id)) {

					$this->db_operations->data_update('client_master',array('client_mobile1'=>$order_data['om_client_mobile']),'client_id', $order_data['om_client_id']);

					/*insert data to order_trans table*/
					$ot_result 	= $this->insert_update_order_trans($form_data, $result_id);

					/*sms functionality is off for testing module*/
					$tot_bal = $form_data['om_balance'];
					$tot_amt = $form_data['om_final_total'];
					
					$mob = $form_data['om_client_mobile'];
					$ml_bill_no = $order_data['om_no'];

					if(($_SESSION['user_role_id'] == 1 || $_SESSION['user_role_id'] == 2 || $_SESSION['user_role_id'] == 4)):

						$tot_adv = $form_data['om_advance'];

						if($tot_adv != 0):
							$msg = "Thank you for your Payment . We acknowledge your advance payment of Rs. $tot_adv against Order no $ml_bill_no. Your balance amt is Rs.$tot_bal. We appreciate your time, Thank you.";
						// echo $msg;exit;
						else:
							$msg = "Thank you for your Purchase. Your Order no is $ml_bill_no Bill Amount is Rs $tot_amt. We truly appreciate your visit and look forward to serve you.";
						endif;
						$sms_result = $this->send_sms_for_order($mob,$msg);
					elseif($_SESSION['user_role_id'] == 3):
						$msg = "Thank you for your Purchase. Your Order no is $ml_bill_no Bill Amount is Rs $tot_amt. We truly appreciate your visit and look forward to serve you.";
						$sms_result = $this->send_sms_for_order($mob,$msg);
					endif;
				}

				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    echo 0;
				} else {
				    $this->db->trans_commit();

				    $resp = array();
					$om_id_print = encrypt_decrypt("encrypt", $result_id, SECRET_KEY);

					$resp['flag'] = 1;
					$resp['om_id'] = $om_id_print;

					echo json_encode($resp);
				}			
			}
			else
			{
				$this->db->trans_begin();
				/*update code*/
				$edit_cnt = $this->ordermdl->check_edit_duplicate_order_entry($form_data['om_no'],$_SESSION['fin_year'],$om_id);

				if ($edit_cnt != 0) 
				{
					echo 2;
				}
				else
				{
					$order_data['om_no'] 			= $form_data['om_no'];
					$order_data['om_fin_year'] 		= $_SESSION['fin_year'];	
					$order_data['om_modify_uid'] 	= $_SESSION['user_id'];				
					$order_data['om_modify_cdate'] 	= date('Y-m-d H:i:s');

					// echo "<pre>";print_r($order_data);exit();

					/*update data to order_master table*/
					$result = $this->db_operations->data_update('order_master', $order_data, 'om_id', $om_id);

					if (!empty($result)) 
					{
						$this->db_operations->data_update('client_master',array('client_mobile1'=>$order_data['om_client_mobile']),'client_id', $order_data['om_client_id']);
						/*update data to order_trans table*/
						$ot_result 	= $this->insert_update_order_trans($form_data, $om_id);
					}

					if ($this->db->trans_status() === FALSE) {
					    $this->db->trans_rollback();
					    echo 0;
					} else {
					    $this->db->trans_commit();
						$resp = array();
						$resp['flag'] = 1;
						echo json_encode($resp);
					}	
				} 
			}
		} 
		else 
		{
			redirect('loginctrl/logout');
		}
	}


	public function insert_update_order_trans($form_data,$om_id)
	{	
		// 0 = not avialable
		// 1 = avialable
		$order_trans_data = $this->db_operations->get_record('order_trans',array('ot_om_id' =>$om_id)); // get all db record first and all form data and match who is missing and those data delete by system  

		foreach ($order_trans_data as $key => $value) 
		{
			// check data from database exists in form, if not exists then delete data from database
			if (!in_array($value['ot_id'], $form_data['ot_id'])) 
			{
				// if($value['ot_app_type'] == 'Fabric')
			    // {
				// 	if($value['ot_item_code'] > 0)
				// 	{
				// 		// get branch barcode data from database
				// 		$isb_data_db = $this->db_operations->get_record('inward_stock_barcode', ['isb_id' => $value['ot_item_code']]);

				// 		if(empty($isb_data_db))
				// 		{
				// 			return -1;
				// 		}
				// 		else
				// 		{
				// 			$db_qty 	= $isb_data_db[0]['isb_sales_out_qty'];
				// 			$form_qty 	= $value['ot_final_out_qty'];

				// 			$total_qty = $db_qty - $form_qty;

				// 			$result = $this->db_operations->data_update('inward_stock_barcode' , ['isb_sales_out_qty' => $total_qty], 'isb_id', $value['ot_item_code']);

				// 			if($result < 0)
				// 			{
				// 				return -1;
				// 			}
				// 		}
				// 	}	
				// 	$del_res = $this->db_operations->delete_record('order_trans',array('ot_id' =>$value['ot_id']));
						
				// 	if(empty($del_res))
				// 	{
				// 		return -1;
				// 	}	
				// }

				// if($value['ot_app_type'] == 'Package' && $value['ot_qty_mtr'] != 0)
			    // {
				// 	if($value['ot_item_code'] > 0)
				// 	{
				// 		// get branch barcode data from database
				// 		$isb_data_db = $this->db_operations->get_record('inward_stock_barcode', ['isb_id' => $value['ot_item_code']]);

				// 		if(empty($isb_data_db))
				// 		{
				// 			return -1;
				// 		}
				// 		else
				// 		{
				// 			$db_qty 	= $isb_data_db[0]['isb_sales_out_qty'];
				// 			$form_qty 	= $value['ot_final_out_qty'];

				// 			$total_qty = $db_qty - $form_qty;

				// 			$result = $this->db_operations->data_update('inward_stock_barcode' , ['isb_sales_out_qty' => $total_qty], 'isb_id', $value['ot_item_code']);

				// 			if($result < 0)
				// 			{
				// 				return -1;
				// 			}
				// 		}
				// 	}	
				// 	$del_res = $this->db_operations->delete_record('order_trans',array('ot_id' =>$value['ot_id']));
						
				// 	if(empty($del_res))
				// 	{
				// 		return -1;
				// 	}	
				// }
			}

			if (!in_array($value['ot_logic'], $form_data['ot_logic'])) 
			{	
				/*delete transactions*/
				$del_res = $this->db_operations->delete_record('order_trans',array('ot_logic' =>$value['ot_logic']));
			}
		}

		$total_gross_amt 	= 0;
		$total_disc_amt 	= 0;
		$total_final_amt 	= 0;
		$total_final_qty 	= 0;

		// echo "<pre>";print_r($form_data);exit;
		foreach ($form_data['ot_id'] as $key => $value) 
		{
			/*order transaction data*/
			$order_trans = array();
			
			if($value == 0) 
			{
				if($form_data['ot_app_type'][$key] == 'Stitching' )
				{
					for($i = 0;$i < $form_data['ot_qty'][$key];$i++)
					{
						$order_trans['ot_om_id'] 		= $om_id;
						$order_trans['ot_app_type'] 	= $form_data['ot_app_type'][$key];
						$order_trans['ot_item_id'] 		= isset($form_data['ot_item_id'][$key]) ? $form_data['ot_item_id'][$key] : '';
						$order_trans['ot_makki_id'] 		= isset($form_data['ot_makki_id'][$key]) ? $form_data['ot_makki_id'][$key] : '';
						$order_trans['ot_item_code'] 	= isset($form_data['ot_item_code'][$key]) ? $form_data['ot_item_code'][$key] : '' ;
						$order_trans['ot_fabric'] 		= $form_data['ot_fabric'][$key];
						$order_trans['ot_embroidery'] 	= $form_data['ot_embroidery'][$key];
						// $order_trans['ot_makki'] 		= $form_data['ot_makki'][$key];
						// $order_trans['ot_p'] 			= $form_data['ot_p'][$key];
						// $order_trans['ot_pi'] 			= $form_data['ot_pi'][$key];
						$order_trans['ot_desc'] 		= $form_data['ot_desc'][$key];
						$order_trans['ot_qty'] 			= 1;
						// $order_trans['ot_final_out_qty']= $form_data['ot_final_out_qty'][$key];
						$order_trans['ot_rate'] 		= $form_data['ot_rate'][$key];
						$order_trans['ot_sub_amt'] 		= $form_data['ot_sub_amt'][$key];
						$order_trans['ot_disc_per'] 	= $form_data['ot_disc_per'][$key];
						$order_trans['ot_disc_amt'] 	= $form_data['ot_disc_amt'][$key];
						$order_trans['ot_final_total'] 	= $form_data['ot_final_total'][$key];
						$order_trans['ot_trial'] 		= $form_data['ot_trial'][$key];
						$order_trans['ot_attachment_preview'] 	= isset($form_data['ot_attachment_preview'][$key])?$form_data['ot_attachment_preview'][$key]:'';

						$year			= date('y');
						$month          = date('m');

						$order_trans['ot_chart_no'] 		= $this->ordermdl->generate_barcode_for_order();
						$order_trans['ot_barcode'] 			= $year.''.$month.''.$order_trans['ot_chart_no'];
				
						$order_trans['ot_barcode_year'] 	= $year;
						$order_trans['ot_barcode_month'] 	= $month;

						$log = $form_data['ot_logic'][$key];
						$code = $om_id.'_'.$log;

						$order_trans['ot_logic'] 		= $code;

						// echo "<pre>";print_r($order_trans);exit;


						$order_trans_result = $this->db_operations->data_insert('order_trans', $order_trans);
					}
				}
				else if($form_data['ot_app_type'][$key] == 'Fabric')
				{
					$order_trans['ot_om_id'] 		= $om_id;
					$order_trans['ot_app_type'] 	= $form_data['ot_app_type'][$key];
					$order_trans['ot_item_id'] 		= isset($form_data['ot_item_id'][$key]) ? $form_data['ot_item_id'][$key] : '';
					$order_trans['ot_makki_id'] 		= isset($form_data['ot_makki_id'][$key]) ? $form_data['ot_makki_id'][$key] : '';
					$order_trans['ot_item_code'] 	= isset($form_data['ot_item_code'][$key]) ? $form_data['ot_item_code'][$key] : '' ;
					$order_trans['ot_fabric'] 		= $form_data['ot_fabric'][$key];
					$order_trans['ot_embroidery'] 	= $form_data['ot_embroidery'][$key];
					// $order_trans['ot_makki'] 		= $form_data['ot_makki'][$key];
					// $order_trans['ot_p'] 			= $form_data['ot_p'][$key];
					// $order_trans['ot_pi'] 			= $form_data['ot_pi'][$key];
					$order_trans['ot_desc'] 		= $form_data['ot_desc'][$key];
					$order_trans['ot_qty'] 			= $form_data['ot_qty'][$key];
					// $order_trans['ot_final_out_qty']= $form_data['ot_final_out_qty'][$key];
					$order_trans['ot_rate'] 		= $form_data['ot_rate'][$key];
					$order_trans['ot_sub_amt'] 		= $form_data['ot_sub_amt'][$key];
					$order_trans['ot_disc_per'] 	= $form_data['ot_disc_per'][$key];
					$order_trans['ot_disc_amt'] 	= $form_data['ot_disc_amt'][$key];
					$order_trans['ot_final_total'] 	= $form_data['ot_final_total'][$key];
					$order_trans['ot_trial'] 		= $form_data['ot_trial'][$key];
					$order_trans['ot_attachment_preview'] 	= isset($form_data['ot_attachment_preview'][$key])?$form_data['ot_attachment_preview'][$key]:'';

			
					$year			= date('y');
					$month          = date('m');

					$log = $form_data['ot_logic'][$key];
					$code = $om_id.'_'.$log;

					$order_trans['ot_logic'] 		= $code;

					// echo "<pre>";print_r($order_trans);exit;


					$order_trans_result = $this->db_operations->data_insert('order_trans', $order_trans);

					if($order_trans_result < 1)
					{
						return -1;
					}
					

				}
				
			} 
			else 
			{
				// echo "<pre>";print_r($form_data);exit;
				/*order transaction update process*/
				// for($i = 0;$i < $form_data['ot_qty'][$key];$i++)
				// {
				if($form_data['ot_app_type'][$key] == 'Stitching' )
				{
					$order_trans['ot_qty'] 			= 1;
					$order_trans['ot_fabric'] 		= $form_data['ot_fabric'][$key];
					$order_trans['ot_embroidery'] 	= $form_data['ot_embroidery'][$key];
					// $order_trans['ot_makki'] 		= $form_data['ot_makki'][$key];
					// $order_trans['ot_p'] 			= $form_data['ot_p'][$key];
					// $order_trans['ot_pi'] 			= $form_data['ot_pi'][$key];
					$order_trans['ot_final_out_qty']= $form_data['ot_final_out_qty'][$key];
					$order_trans['ot_desc'] 		= $form_data['ot_desc'][$key];
					$order_trans['ot_rate'] 		= $form_data['ot_rate'][$key];
					$order_trans['ot_sub_amt'] 		= $form_data['ot_sub_amt'][$key];
					$order_trans['ot_disc_per'] 	= $form_data['ot_disc_per'][$key];
					$order_trans['ot_disc_amt'] 	= $form_data['ot_disc_amt'][$key];
					$order_trans['ot_final_total'] 	= $form_data['ot_final_total'][$key];
					$order_trans['ot_trial'] 		= $form_data['ot_trial'][$key];
					$order_trans['ot_attachment_preview'] 	= isset($form_data['ot_attachment_preview'][$key])?$form_data['ot_attachment_preview'][$key]:'';


					$order_trans_result = $this->db_operations->data_update('order_trans',$order_trans,'ot_logic',$form_data['ot_logic'][$key]);
				}
				else if($form_data['ot_app_type'][$key] == 'Fabric')
				{
					$order_trans['ot_qty'] 			= 1;
					$order_trans['ot_fabric'] 		= $form_data['ot_fabric'][$key];
					$order_trans['ot_embroidery'] 	= $form_data['ot_embroidery'][$key];
					// $order_trans['ot_makki'] 		= $form_data['ot_makki'][$key];
					// $order_trans['ot_p'] 			= $form_data['ot_p'][$key];
					// $order_trans['ot_pi'] 			= $form_data['ot_pi'][$key];
					$order_trans['ot_desc'] 		= $form_data['ot_desc'][$key];
					$order_trans['ot_rate'] 		= $form_data['ot_rate'][$key];
					$order_trans['ot_final_out_qty']= $form_data['ot_final_out_qty'][$key];
					$order_trans['ot_sub_amt'] 		= $form_data['ot_sub_amt'][$key];
					$order_trans['ot_disc_per'] 	= $form_data['ot_disc_per'][$key];
					$order_trans['ot_disc_amt'] 	= $form_data['ot_disc_amt'][$key];
					$order_trans['ot_final_total'] 	= $form_data['ot_final_total'][$key];
					$order_trans['ot_trial'] 		= $form_data['ot_trial'][$key];
					$order_trans['ot_item_code'] 	= isset($form_data['ot_item_code'][$key]) ? $form_data['ot_item_code'][$key] : '' ;
					$order_trans['ot_attachment_preview'] 	= isset($form_data['ot_attachment_preview'][$key])?$form_data['ot_attachment_preview'][$key]:'';


					$order_trans_result = $this->db_operations->data_update('order_trans',$order_trans,'ot_logic',$form_data['ot_logic'][$key]);

					if($order_trans_result < 1)
					{
						return -1;
					}
				
				}
				
			}

			$total_gross_amt 	+= $form_data['ot_sub_amt'][$key];
			$total_disc_amt 	+= $form_data['ot_disc_amt'][$key];
			$total_final_amt 	+= $form_data['ot_final_total'][$key];
			$total_final_qty 	+= $form_data['ot_qty'][$key];
		}

		$order_array = array();
		$order_array['om_gross_total'] 		= $total_gross_amt;
		$order_array['om_disc_amt'] 		= $total_disc_amt;
		$order_array['om_final_total'] 		= $total_final_amt;
		$order_array['om_total_qty'] 		= $total_final_qty;
		$order_array['om_balance'] 			= $total_final_amt - (float)$form_data['om_roundoff'] - (float)$form_data['om_advance'];
		
		$this->db_operations->data_update('order_master', $order_array, 'om_id', $om_id);
	}


	public function order_delete($om_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			/*db transaction starts*/
			$this->db->trans_begin();
			/*delete order records*/
			
			$data = $this->ordermdl->get_order_trans_record($om_id);
			
			$issue_flag = 0;

			foreach ($data as $key => $value) 
			{
				if ($value['ot_km_id'] != 0) 
				{
					$issue_flag = 1;
				}
			}

			if ($issue_flag == 0) 
			{
				foreach ($data as $key => $value) 
				{
					if($value['ot_app_type'] == 'Fabric')
					{
						if($value['ot_id'] > 0)
						{
							$bbim_data_db = $this->db_operations->get_record('inward_stock_barcode', ['isb_id' => $value['ot_item_code']]);

							$db_qty 	= $bbim_data_db[0]['isb_sales_out_qty'];
							$form_qty 	= $value['ot_qty'];

							$total_qty 	= $db_qty - $form_qty;

							$fb_result 	= $this->db_operations->data_update('inward_stock_barcode' , ['isb_sales_out_qty' => $total_qty], 'isb_id', $value['ot_item_code']);

							if($fb_result < 0)
							{
								$fb_flag = 1;
							}
						}
					}
				}

				$this->db_operations->delete_record('order_master', array('om_id' => $om_id));
				$this->db_operations->delete_record('order_trans', array('ot_om_id' => $om_id));
				
				if ($this->db->trans_status() === FALSE) {
				    $this->db->trans_rollback();
				    echo 0;
				} else {
				    $this->db->trans_commit();
					echo 1;
				}	

				
			}
			else
			{
				echo 2;
			}


			/*delete order voucher */
		} 
		else 
		{
			redirect('loginctrl/logout');
		}
	}


	/*Fabric Cutting Master */





	public function client_insert($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			
			$form_data = $this->input->post();

			// echo "<pre>";print_r($form_data);exit();
			/*client data*/
			

			$client_data = array();
			$client_data['client_accno'] 	= $this->ordermdl->get_max_id('client_master','client_accno');
			$client_data['client_name'] 	= trim($form_data['client_name']);
			$client_data['client_dob'] 		= date('Y-m-d',strtotime($form_data['client_dob']));
			$client_data['client_mobile1']	= trim($form_data['client_mobile1']);
			$client_data['client_mobile1_check']	= !empty($form_data['client_mobile1_check']) ? $form_data['client_mobile1_check'] : 0;
			$client_data['client_mobile2']	= !empty($form_data['client_mobile2']) ? $form_data['client_mobile2'] : '';
			$client_data['client_mobile2_check']	= !empty($form_data['client_mobile2_check']) ? $form_data['client_mobile2_check'] : 0;
			$client_data['client_reference_name']	= !empty($form_data['client_reference_name']) ? $form_data['client_reference_name'] : '';
			$client_data['client_country'] 	= !empty($form_data['client_country']) ? $form_data['client_country'] : '';
			$client_data['client_location'] = !empty($form_data['client_location']) ? $form_data['client_location'] : '';
			$client_data['client_location'] = !empty($form_data['client_location']) ? $form_data['client_location'] : '';
			$client_data['client_gst_type'] = $form_data['client_gst_type'];
			$client_data['client_status'] 	= 1;
			$client_data['client_type'] 	= $form_data['client_type'];

			// echo "<pre>";print_r($client_data);exit();

			if($id == 0) 
			{
				$this->db->trans_begin();

				$name_cnt 	= $this->ordermdl->check_duplicate_client_name($form_data['client_name']);
				$mob_cnt 	= $this->ordermdl->check_duplicate_client_mobile($form_data['client_mobile1']);

				if ($name_cnt != 0 && $mob_cnt != 0) 
				{
					echo 2;
				}
				// elseif($mob_cnt != 0)
				// {
				// 	echo 3;
				// } 
				else 
				{
					$client_data['client_userid'] 		 = $_SESSION['user_id'];
					$client_data['client_cdate'] 		 = date('Y-m-d');
					$client_data['client_modify_userid'] = $_SESSION['user_id'];
					
					// echo "<pre>";print_r($client_data);exit();

					$client_insertid = $this->db_operations->data_insert('client_master', $client_data);

					$resp = array();

					if ($this->db->trans_status() === FALSE) 
					{
					    $this->db->trans_rollback();
					    echo 0;
					} 
					else 
					{
					    $this->db->trans_commit();

					    $resp['flag'] 	= 1;
					    $resp['id'] 	= $client_insertid;
					    $resp['mob_no'] = $form_data['client_mobile1'];
					    $resp['name'] 	= $form_data['client_name'];

					    echo json_encode($resp);
					}			
				}
			}
		}
		else 
		{
			redirect('loginctrl/logout');		
		}
	}

	public function get_order_trans_data($ot_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$data = $this->ordermdl->get_order_trans_data($ot_id);
			// echo "<pre>";print_r($data);exit();

			echo json_encode($data);
		} 
		else 
		{
			redirect('loginctrl/logout');
		}
	}

	public function get_completed_order_data($om_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_done_order_trans_data($om_id);
			// echo "<pre>";print_r($record);exit();
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}	
	}

	public function update_delivery_status(){
        $post_data  = $this->input->post();

        // print_r($post_data); exit;
        if(!empty($post_data)){
            foreach ($post_data['ot_id'] as $key => $value){

                $order_trans_data['ot_delivered'] 	= 1;

                if($this->db_operations->data_update('order_trans', $order_trans_data, 'ot_id', $value) < 1){
                    echo json_encode(['status' => FALSE,'msg' => 'Process not updated.']);
                }
            }
            echo json_encode(['status' => TRUE, 'data' => [], 'msg' => 'Delivered successfully.']);
        }
        else{
            echo json_encode(['status' => FALSE,'msg' => 'Cannot Deliver']);
        }
	}


	public function get_fabric_barcode()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{	
			$record = $this->db_operations->get_record_order_by("inward_stock_barcode",array('isb_id'=>1),"isb_item_code","ASC");
			// echo "<pre>";print_r($record);exit;
			echo json_encode($record);
		}
		else{
			redirect('loginctrl/logout');
		}
	}

	public function get_stitching_apparel()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{	
			$record = $this->ordermdl->get_stitching_apparel_data();
			echo json_encode($record);
		}
		else
			redirect('loginctrl/logout');
	}

	public function get_package_apparel()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{	
			$record['fabric'] = $this->db_operations->get_record_order_by("inward_stock_barcode",array('isb_id'=>1),"isb_item_code","ASC");

			$record['stitching'] = $this->ordermdl->get_package_apparel_data();

			// echo "<pre>";print_r($record);exit;
			echo json_encode($record);
		}
		else
			redirect('loginctrl/logout');
	}

	public function get_single_fabric_barcode_on_add($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_fabric_barcode_with_name($id);
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}
	}

	public function get_single_fabric_barcode_and_apparel_on_add($id,$app_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record['fabric'] = $this->ordermdl->get_fabric_barcode_with_name($id);
			$record['stitching'] = $this->db_operations->get_record("apparel_master", array("app_id" => $app_id));
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}
	}

	public function get_single_stitching_apparel($app_id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->db_operations->get_record("apparel_master", array("app_id" => $app_id));

			// $record['makki_name_data'] = $this->ordermdl->get_ot_makki_with_name($ot_makki_id);
			// echo "<pre>"; print_r($record);die();
			echo json_encode($record);
		}
		else
			redirect('loginctrl/logout');
	}

	public function get_select2_fabric_barcode_data()
	{
		$json = [];
		if (!empty($_GET['isb_item_code'])) 
		{
			$data = $this->ordermdl->get_fabric_barcode_details_select2($_GET['isb_item_code']);
			foreach ($data as $key => $value) 
			{
				$json[] = ['id'=>$value['isb_id'], 'text'=>$value['isb_item_code']];
			}
		}
		echo json_encode($json);
	}

	public function get_single_fabric_barcode($id)
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$record = $this->ordermdl->get_fabric_barcode_with_name($id);
			echo json_encode($record);
		}
		else
		{
			redirect('loginctrl/logout');
		}
	}


	//select2

	public function get_select2($func){
		$json = [];
		$data = $this->ordermdl->$func();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}


	public function update_barcode_qty_utility()
	{
		// $record =	$this->db_operations->get_recordlist('inward_stock_barcode');
		$record =	$this->ordermdl->get_update_barcode_qty_utility();
		// echo "<pre>";print_r($record);exit;
		foreach ($record as $key => $value) 
		{
			
			$db_total_ot_out_qty = $this->ordermdl->get_total_qty_out_trans($value['isb_id']);

			$this->db_operations->data_update('inward_stock_barcode',array('isb_sales_out_qty'=>$db_total_ot_out_qty[0]['total_ot_qty']),'isb_id',$value['ot_item_code']);
		}
	}




	// public function fabric_cutting_all_insert()
	// {	
	// 	$user_id = $this->session->userdata('user_id');
	// 	$fin_year = $this->session->userdata('fin_year');

	// 	$form_data = $this->input->post();

	// 	// echo "<pre>";print_r($form_data);exit;

	// 	foreach ($form_data['fab_cut_id'] as $key => $value) 
	// 	{
	// 		/*order transaction data*/
	// 		$order_trans = array();
			
	// 		if($value == 0) 
	// 		{
	// 			$order_trans['fab_cut_om_no'] 	= $form_data['fab_cut_om_no'][$key];
	// 			$order_trans['fab_cut_om_date'] 	= date('Y-m-d',strtotime($form_data['fab_cut_om_date'][$key]));
	// 			$order_trans['fab_cut_client_name'] 	= $form_data['fab_cut_client_name'][$key];
	// 			$order_trans['fab_cut_client_id'] 	= $form_data['fab_cut_client_id'][$key];
	// 			$order_trans['fab_cut_fabric_name'] 	= $form_data['fab_cut_fabric_name'][$key];
	// 			$order_trans['fab_cut_fabric_id'] 	= $form_data['fab_cut_fabric_id'][$key];
	// 			$order_trans['fab_cut_client_mobile1']= $form_data['fab_cut_client_mobile1'][$key];
	// 			$order_trans['fab_cut_isb_item_code'] = $form_data['fab_cut_isb_item_code'][$key];
	// 			$order_trans['fab_cut_isb_id'] 		= $form_data['fab_cut_isb_id'][$key];
	// 			$order_trans['fab_cut_out_qty'] 		= $form_data['fab_cut_out_qty'][$key];
	// 			$order_trans['fab_cut_user_id'] 		= $user_id;
	// 			$order_trans['fab_cut_fin_year'] 		= $fin_year;
	// 			$order_trans['fab_cut_date_create'] 	= date("Y-m-d H:i:s");

	// 			unset($form_data['hidden_fab_cut_out_qty'][$key]);

	// 			$result = $this->db_operations->data_insert('fabric_cutting_master', $order_trans);

	// 			$this->db_operations->data_update('order_trans',array('ot_fab_cut_id'=>$result),'ot_id',$form_data['ot_id'][$key]);


	// 			// $order_trans_result = $this->db_operations->data_insert('order_trans', $order_trans);
	// 		} 
			
	// 	}
	// }

	 public function add_attachment_image($cnt){
        $files = $_FILES;
        if(!empty($cnt)){
            $record = $this->add_attachment($files,'ot_attachment_'.$cnt);
        }else{
            $record = $this->add_attachment($files,'ot_attachment');
        }
        echo json_encode($record);
    }
    
    public function add_attachment($files,$attachment_name){
        $data=[];
        // echo "<pre>";print_r($files); 
        // echo "<pre>";print_r($attachment_name);exit;
        if(isset($files[$attachment_name]) && !empty($files[$attachment_name])){
            if($files[$attachment_name]['error'] == 0){
            	
                $_FILES[$attachment_name]['name']       = $files[$attachment_name]['name'];
                $_FILES[$attachment_name]['type']       = $files[$attachment_name]['type'];
                $_FILES[$attachment_name]['tmp_name']   = $files[$attachment_name]['tmp_name'];
                $_FILES[$attachment_name]['error']      = $files[$attachment_name]['error'];
                $_FILES[$attachment_name]['size']       = $files[$attachment_name]['size'];

                unset($config);
                $config                     = array();
                $config['upload_path']      = 'public/uploads/order_trans_attachment';
                $config['allowed_types']    =  'gif|jpg|png|jpeg';
                $config['max_size'] 		=  '1024';
                $file_name                  = $files[$attachment_name]['name'];
                if(!file_exists($config['upload_path'])){
                    mkdir($config['upload_path'], 0777);
                }
                $ext                        = strtolower(substr($file_name, strrpos($file_name, '.') + 1));
                $filename                   = 'order_trans_attachment_'.''.time().'.'.$ext;
                $config['file_name']        = $filename;

                $this->upload->initialize($config);
                if(!$this->upload->do_upload($attachment_name)){
                    return ['status' => FALSE, 'data' => [],  'msg' =>$this->upload->display_errors()];
                                   
                }
                $imageinfo = $this->upload->data();
                $full_path = $imageinfo['full_path'];
                    
                $data = $filename;
            }
        }
        return ['status' => TRUE, 'data' => $data,  'msg' =>''];
    }


/**/
}
?>
