<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require FCPATH.'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet; 
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
// use PhpOffice\PhpSpreadsheet\Style\Alignment;
class Reportsctrl extends CI_Controller {
	public $reportsmdl;
	public $pagination;

	public function __construct()
	{
		parent::__construct();

		$this->load->model('reportsmdl');
		$this->load->library('session');
		$this->load->library('upload');
		$this->load->library('pagination');
		$this->config->load('extra');
		$this->load->library('db_operations');
	}

	public function index()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$this->load->view('pages/master/index');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}
	}

/********************* SALE REPORT **************************************/
	public function sale()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$user_id 	= $this->session->userdata('user_id');
			$role 		= $this->session->userdata('user_role_id');

			if($role == 1 || $role == 2 || $role == 4):
			$record = $this->reportsmdl->get_sale_summary_data($_SESSION['fin_year']); 
			elseif($role == 3):
			$record = $this->reportsmdl->get_sale_summary_data_for_designer($_SESSION['fin_year'],$user_id);
			endif;

			// echo "<pre>";print_r($record);exit();

			$this->load->view('pages/reports/sale_summary',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function sale_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$user_id 	= $this->session->userdata('user_id');
			$role 		= $this->session->userdata('user_role_id');
			
			if($role == 1 || $role == 2 || $role == 4): 
			$record = $this->reportsmdl->get_sale_summary_data_xls($_SESSION['fin_year']);
			// elseif($role == 3):
			// $record = $this->reportsmdl->get_sale_summary_data_xls_for_designer($_SESSION['fin_year'],$user_id);
			endif;

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
		    $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("SALE REPORT YEAR ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','K') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='sale_summary'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}
	public function sale_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_sale_summary_data($_SESSION['fin_year']);
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/sale_summary',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}
	public function get_data_for_chart()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$dataPoints = $this->reportsmdl->get_chart_sale_data($_SESSION['fin_year']);
			// echo "<pre>";print_r($dataPoints);exit();
			echo json_encode($dataPoints, JSON_NUMERIC_CHECK);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function get_chart_data_for_amount_collection()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$dataPoints = $this->reportsmdl->get_chart_sale_amount_collected_data($_SESSION['fin_year']);
			// echo "<pre>";print_r($dataPoints);exit();
			echo json_encode($dataPoints, JSON_NUMERIC_CHECK);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	/*********************** order_status_report **********************************/
	public function order_status_report()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_order_status_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/order_status_report',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function order_status_report_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_order_status_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/order_status_report_print',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}

	public function order_status_report_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_order_status_report_data_xls();

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("ORDER STATUS ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','I') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='order_status_report'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	/*********************** customer_data_report **********************************/
	public function customer_data_report()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_customer_data_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/customer_data_report',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function customer_data_report_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_customer_data_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/customer_data_report_print',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}
		/*********************** customer_data_report **********************************/


		/*********************** no_order_report **********************************/
	public function no_order_report()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_no_order_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/no_order_report',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function no_order_report_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_no_order_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/no_order_report_print',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}
		/*********************** no_order_report **********************************/


		/*********************** client_retention_report **********************************/
		public function client_retention_report()
		{
			$user_id = $this->session->userdata('user_id');
			if(!empty($user_id))
			{
				$record = $this->reportsmdl->get_client_retention_report_data();
				// echo "<pre>";print_r($record);exit();
				$this->load->view('pages/reports/client_retention_report',$record);
			}
			else
			{
				redirect('loginctrl/logout');
			}
		}
	
		public function client_retention_report_print()
		{
			$user_id = $this->session->userdata('user_id');
			if(!empty($user_id)) {
				$record = $this->reportsmdl->get_client_retention_report_data();
				// echo "<pre>";print_r($record);exit();
				$this->load->view('pdfs/client_retention_report_print',$record);
			} else {
				redirect('loginctrl/logout');	
			}	
		}
	
		public function client_retention_report_xls()
		{
			$user_id = $this->session->userdata('user_id');
			if(!empty($user_id)) 
			{
				$record = $this->reportsmdl->get_client_retention_report_data_xls();
	
				// echo "<pre>";print_r($record);exit();
	
				$spreadsheet = new Spreadsheet();
				$sheet = $spreadsheet->setActiveSheetIndex(0);
				$sheet->setTitle("CLIENT RETENTION ".$_SESSION['fin_year']); 
	
				$rowCount = 1;
				foreach ($record['excel_array'] as $key => $data) 
				{
					/*SET COLUMN WIDTH AND DATA*/
					foreach(range('A','E') as $key => $columnID)
					{
						/*set coulumn width*/
						$sheet->getColumnDimension($columnID)->setAutoSize(true);
						
						/*set column data*/
						$sheet->SetCellValue($columnID.$rowCount, $data[$key]);
					}
					$rowCount++; 
				}
	
				$filename='client_retention_report'.date('dMY').'.csv'; //save our workbook as this file name
				header('Content-Type: application/vnd.ms-excel'); //mime type
				header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
				header('Cache-Control: max-age=0'); //no cache
				// Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
				$objWriter = new Xlsx($spreadsheet);
				// Write the Excel file to filename some_excel_file.xlsx in the current directory
				$objWriter->save('php://output');
			} 
			else 
			{
				redirect('loginctrl/logout');	
			}	
		}
	



	/*********************** pending_delivery_report **********************************/
	public function pending_delivery_report()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_pending_delivery_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/pending_delivery_report',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function pending_delivery_report_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_pending_delivery_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/pending_delivery_report_print',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}

	public function pending_delivery_report_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_pending_delivery_report_data_xls();

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("PENDING DELIVERY ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','G') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='pending_delivery_report'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}


	/*********************** production_report **********************************/
	public function production_report()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_production_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/production_report',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function production_report_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_production_report_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/production_report_print',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}

	public function production_report_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_production_report_data_xls();

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("PRODUCTION REPORT ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','J') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='production_report'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}
	
/*********************** CUST BILL WISE OUTSTANDING **********************************/
	public function customer_outstanding()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_cust_outstanding_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/cust_outstanding',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function customer_outstanding_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_cust_outstanding_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/cust_outstanding',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}

	public function customer_outstanding_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_cust_outstanding_data_xls();

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("CUSTOMER OUTSTANDING ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','I') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='cust_outstanding_report'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}
// Stock Report Start
	// public function stock_report_master()
	// {
	// 	if(sessionExist()) 
	// 	{
	// 		$record	= $this->reportsmdl->stock_report();
	// 		// echo "<pre>";print_r($record);exit;
 //    		$this->load->view('pages/report/stock_report',$record);	
	// 	} 
	// 	else 
	// 	{
	// 		redirect('loginctrl/logout');	
	// 	}
	// }

	public function stock_report_master()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id))
		{
			$config = array();
			$this->config->load('extra');
			$config = $this->config->item('pagination');
			$config['total_rows'] = $this->reportsmdl->get_all_bal_stock_data_rows();
			$config['base_url'] = base_url("Reportsctrl/stock_report_master?search=true");
			foreach ($_GET as $key => $value) 
			{
				if($key != 'search' && $key != 'offset')
				{
					$config['base_url'] .= "&" . $key . "=" .$value;
				}
			}

			$offset = (!empty($_GET['offset'])) ? $_GET['offset'] : 0;
			$this->pagination->initialize($config);
			$record['count'] = $offset;
			$record['total_rows'] = $config['total_rows'];
			$record['bal_stock'] = $this->reportsmdl->get_bal_stock_data($config['per_page'],$offset);

			$this->load->view('pages/reports/stock_report',$record);	
		}
		else
		{
			redirect('loginctrl/logout');	
		}
	}
	
/***************************** DESIGNER WISE OUTSTANDING ***************************************/

	public function delivery_report()
	{
		$user_id = $this->session->userdata('user_id');
		$f_year = $this->session->userdata('f_year');


		if(!empty($user_id))
		{
			$record['del_data'] = $this->reportsmdl->get_delivery_report_data($f_year);
			// echo "<pre>";print_r($record);exit;
			$this->load->view('pages/reports/delivery_report',$record);
		}
		else
		{
			redirect('loginctrl/logout');	
		}
	}

	public function delivery_report_print()
	{
		$user_id = $this->session->userdata('user_id');
		$f_year = $this->session->userdata('f_year');

		if(!empty($user_id)) {
			$record['data'] = $this->reportsmdl->get_delivery_report_data($f_year);
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/delivery_report',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}

	public function delivery_report_xls()
	{
		$user_id = $this->session->userdata('user_id');
		$f_year = $this->session->userdata('f_year');

		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_delivery_report_data_xls($f_year);

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("SUPPLIER OUTSTANDING ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','J') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='delivery_report_report'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function designer_outstanding()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_designer_outstanding_data($_SESSION['user_role_id'],$_SESSION['user_id']);

			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/designer_outstanding',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}

	public function designer_outstanding_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_designer_outstanding_data($_SESSION['user_role_id'],$_SESSION['user_id']);

			// echo "<pre>";print_r($record);exit();
			// $record['party'] = $this->Reportsmdl->get_account_details_data();
			$this->load->view('pdfs/designer_outstanding',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}

	public function designer_outstanding_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_designer_outstanding_data_xls($_SESSION['user_role_id'],$_SESSION['user_id']);

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("DESIGNER OUTSTNDING ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','J') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='designer_outstanding_report'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}


/**************************** KARIGAR OUTSTANDING *******************************************/
	public function karigar_outstanding()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_karigar_outstanding_data();

			// echo "<pre>";print_r($record);exit();
			// $record['party'] = $this->Reportsmdl->get_account_details_data();
			$this->load->view('pages/reports/karigar_outstanding',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function karigar_outstanding_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_karigar_outstanding_data();
			// echo "<pre>";print_r($record);exit();
			// $record['party'] = $this->Reportsmdl->get_account_details_data();

			$this->load->view('pdfs/karigar_outstanding',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function karigar_outstanding_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_karigar_outstanding_data_xls();
			
			// echo "<pre>";print_r($record);
			// exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("CUSTOMER SALE ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','H') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='karigar_outstanding_report'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}


/***************************** GST REPORT ***************************************/
	public function gst_report()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_gst_report_data();

			// echo "<pre>";print_r($record);exit();
			// $record['party'] = $this->Reportsmdl->get_account_details_data();
			$this->load->view('pages/reports/gst_report',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function gst_report_print_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_gst_report_data_xls();

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("GST REPORT ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','O') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='cust_gst_summary'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}
/**************************** DAILY TRANSACTION REPORT **************************************/
	public function daily_trans()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_daily_trans_data($_SESSION['fin_year']);
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/daily_transaction',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function daily_tran_pdf()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_daily_trans_data($_SESSION['fin_year']);
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/daily_trans',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

public function daily_tran_xls()
{	
		if(!sessionExist()){
			redirect('login/logout'); return;
		}
		$record = $this->reportsmdl->get_daily_trans_data($_SESSION['fin_year']);
		// echo "<pre>"; print_r($record); exit;

		$line_no= 1;
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->setActiveSheetIndex(0);
		$sheet->setTitle("DAILY TRANS");
		$sheet->setCellValue('A'.$line_no, "DAILY TRANS");			 
		$sheet->mergeCells('A'.$line_no.":K".$line_no);			 
		$sheet->getStyle('A'.$line_no.":K".$line_no)->getFont()->setBold( true );	
	 	$sheet->getStyle('A'.$line_no.":K".$line_no)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
		 $line_no++;
		 $line_no++;
		 if(!empty($record)){
			$sheet->getColumnDimension('A')->setAutoSize(true);
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('A'.$line_no, 'CASH');

			$sheet->getColumnDimension('B')->setAutoSize(true);
			$sheet->getStyle('B'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('B'.$line_no, 'CHEQUE/DD');

			$sheet->getColumnDimension('C')->setAutoSize(true);
			$sheet->getStyle('C'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('C'.$line_no, 'NET BANK');
 
			$sheet->getColumnDimension('D')->setAutoSize(true);
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('D'.$line_no, 'CARD');	
 
			$line_no++;
 
			$sheet->getColumnDimension('A')->setAutoSize(true);		                    
			$sheet->SetCellValue('A'.$line_no, $record['total_cash_collection']);

			$sheet->getColumnDimension('B')->setAutoSize(true);		                    
			$sheet->SetCellValue('B'.$line_no, $record['total_upi_gpay_collection']);

			$sheet->getColumnDimension('C')->setAutoSize(true);		                    
			$sheet->SetCellValue('C'.$line_no, $record['total_credit_card_collection']);

			$sheet->getColumnDimension('D')->setAutoSize(true);		                    
			$sheet->SetCellValue('D'.$line_no, $record['total_debit_card_collection']);
 
			$line_no++;
			$line_no++;
			
			$sheet->getColumnDimension('A')->setAutoSize(true);
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('A'.$line_no, 'ENTRY NO');

			$sheet->getColumnDimension('B')->setAutoSize(true);
			$sheet->getStyle('B'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('B'.$line_no, 'DATE');

			$sheet->getColumnDimension('C')->setAutoSize(true);
			$sheet->getStyle('C'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('C'.$line_no, 'CLIENT NAME');
 
			$sheet->getColumnDimension('D')->setAutoSize(true);
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('D'.$line_no, 'GROSS AMT');

			$sheet->getColumnDimension('E')->setAutoSize(true);
			$sheet->getStyle('E'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('E'.$line_no, 'DISC. AMT');

			$sheet->getColumnDimension('F')->setAutoSize(true);
			$sheet->getStyle('F'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('F'.$line_no, 'FINAL AMT');

			$sheet->getColumnDimension('G')->setAutoSize(true);
			$sheet->getStyle('G'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('G'.$line_no, 'ADVANCE');

			$sheet->getColumnDimension('H')->setAutoSize(true);
			$sheet->getStyle('H'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('H'.$line_no, 'ROUND OFF');

			$sheet->getColumnDimension('I')->setAutoSize(true);
			$sheet->getStyle('I'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('I'.$line_no, 'BALANCE AMT');

			$sheet->getColumnDimension('J')->setAutoSize(true);
			$sheet->getStyle('J'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('J'.$line_no, 'AMOUNT');

			$sheet->getColumnDimension('K')->setAutoSize(true);
			$sheet->getStyle('K'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('K'.$line_no, 'TRANS TYPE');
			$line_no++;
			foreach ($record['receipt_voucher_data'] as $key => $value) {
				$sheet->getColumnDimension('A')->setAutoSize(true);	
				$sheet->SetCellValue('A'.$line_no, $value['vc_entry_no']);

				$sheet->getColumnDimension('B')->setAutoSize(true);
				$sheet->SetCellValue('B'.$line_no, date('d-m-Y',strtotime($value['vc_entry_date'])));

				$sheet->getColumnDimension('C')->setAutoSize(true);	
				$sheet->SetCellValue('C'.$line_no, $value['client_name']);
 
				$sheet->getColumnDimension('J')->setAutoSize(true);	
				$sheet->SetCellValue('J'.$line_no, $value['vc_amount']);

				$sheet->getColumnDimension('K')->setAutoSize(true);	
				$sheet->SetCellValue('K'.$line_no, ($value['vc_voucher_type'] == 2) ?"RECEIPT" : "");
 
				$line_no++;
			}

			foreach ($record['adv_data'] as $key => $value) {
				$sheet->getColumnDimension('A')->setAutoSize(true);	
				$sheet->SetCellValue('A'.$line_no, $value['om_no']);

				$sheet->getColumnDimension('B')->setAutoSize(true);
				$sheet->SetCellValue('B'.$line_no, date('d-m-Y',strtotime($value['om_date'])));

				$sheet->getColumnDimension('C')->setAutoSize(true);	
				$sheet->SetCellValue('C'.$line_no, $value['client_name']);
 
				$sheet->getColumnDimension('J')->setAutoSize(true);	
				$sheet->SetCellValue('J'.$line_no, $value['om_advance']);

				$sheet->getColumnDimension('K')->setAutoSize(true);	
				$sheet->SetCellValue('K'.$line_no, 'ADVANCE');
 
				$line_no++;
			}
			foreach ($record['sale_data'] as $key => $value) {
				$sheet->getColumnDimension('A')->setAutoSize(true);	
				$sheet->SetCellValue('A'.$line_no, $value['om_no']);

				$sheet->getColumnDimension('B')->setAutoSize(true);
				$sheet->SetCellValue('B'.$line_no, date('d-m-Y',strtotime($value['om_date'])));

				$sheet->getColumnDimension('C')->setAutoSize(true);	
				$sheet->SetCellValue('C'.$line_no, $value['client_name']);
 
				$sheet->getColumnDimension('D')->setAutoSize(true);	
				$sheet->SetCellValue('D'.$line_no, $value['om_gross_total']);

				$sheet->getColumnDimension('E')->setAutoSize(true);	
				$sheet->SetCellValue('E'.$line_no, ($value['om_disc_amt'] == 2) ?"RECEIPT" : "");

				$sheet->getColumnDimension('F')->setAutoSize(true);	
				$sheet->SetCellValue('F'.$line_no, $value['om_final_total']);

				$sheet->getColumnDimension('G')->setAutoSize(true);	
				$sheet->SetCellValue('G'.$line_no, $value['om_advance']);

				$sheet->getColumnDimension('H')->setAutoSize(true);	
				$sheet->SetCellValue('H'.$line_no, $value['om_roundoff']);

				$sheet->getColumnDimension('I')->setAutoSize(true);	
				$sheet->SetCellValue('I'.$line_no, $value['om_balance']);

				$sheet->getColumnDimension('J')->setAutoSize(true);	
				$sheet->SetCellValue('J'.$line_no, 0);

				$sheet->getColumnDimension('K')->setAutoSize(true);	
				$sheet->SetCellValue('K'.$line_no, 'sale');
 
				$line_no++;
			}
		 }

		 $filename='DAILY TRANS_REPORT_'.time().'.xlsx';
		 header('Content-Type: application/vnd.ms-excel');
		 header('Content-Disposition: attachment;filename="'.$filename.'"');
		 header('Cache-Control: max-age=0');
		 $objWriter = new Xlsx($spreadsheet);
		 $objWriter->save('php://output');
}


/************************** cash collection customer wise ****************************************/
	public function collection_report()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record['data'] = $this->reportsmdl->get_daily_collection_data($_SESSION['fin_year']);
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/collection_report',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function collection_report_pdf()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record['data'] = $this->reportsmdl->get_daily_collection_data($_SESSION['fin_year']);
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/collection',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function collection_report_xls()
	{	
		if(!sessionExist()){
			redirect('login/logout'); return;
		}
		$record['data']= $this->reportsmdl->get_daily_collection_data($_SESSION['fin_year']);
		// echo "<pre>"; print_r($record); exit;

		$line_no= 1;
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->setActiveSheetIndex(0);
		$sheet->setTitle("DAILY TRANS");
		$sheet->setCellValue('A'.$line_no, "DAILY TRANS");			 
		$sheet->mergeCells('A'.$line_no.":E".$line_no);			 
		$sheet->getStyle('A'.$line_no.":E".$line_no)->getFont()->setBold( true );	
	 	$sheet->getStyle('A'.$line_no.":E".$line_no)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
		 $line_no++;

	 	$sheet->setCellValue('A'.$line_no, "COLLECTION");			 
		$sheet->mergeCells('A'.$line_no.":E".$line_no);			 
		$sheet->getStyle('A'.$line_no.":E".$line_no)->getFont()->setBold( true );	
	 	$sheet->getStyle('A'.$line_no.":E".$line_no)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);

		 $line_no++;
		 $line_no++;
		 if(!empty($record)){
		 	$sheet->getColumnDimension('A')->setAutoSize(true);
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('A'.$line_no, 'DATE');

			$sheet->getColumnDimension('B')->setAutoSize(true);
			$sheet->getStyle('B'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('B'.$line_no, 'CASH');

			$sheet->getColumnDimension('C')->setAutoSize(true);
			$sheet->getStyle('C'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('C'.$line_no, 'CHEQUE/DD');

			$sheet->getColumnDimension('D')->setAutoSize(true);
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('D'.$line_no, 'NET BANK');
 
			$sheet->getColumnDimension('E')->setAutoSize(true);
			$sheet->getStyle('E'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('E'.$line_no, 'CARD');	
 
			$line_no++;

			$tot_cash   = 0;
         	$tot_cheque = 0;
          	$tot_netbnk = 0;
          	$tot_card   = 0;
			foreach ($record['data'] as $key => $value) {
				$tot_cash   += $value['total_cash_collection'];
                $tot_cheque += $value['total_upi_gpay_collection'];
                $tot_netbnk += $value['total_credit_card_collection'];
                $tot_card   += $value['total_debit_card_collection'];
				$sheet->getColumnDimension('A')->setAutoSize(true);	
				$sheet->SetCellValue('A'.$line_no, date('d-m-Y',strtotime($value['date'])));					

				$sheet->getColumnDimension('B')->setAutoSize(true);
				$sheet->SetCellValue('B'.$line_no, $value['total_cash_collection']);

				$sheet->getColumnDimension('C')->setAutoSize(true);	
				$sheet->SetCellValue('C'.$line_no, $value['total_upi_gpay_collection']);
 
				$sheet->getColumnDimension('D')->setAutoSize(true);	
				$sheet->SetCellValue('D'.$line_no, $value['total_credit_card_collection']);

				$sheet->getColumnDimension('E')->setAutoSize(true);	
				$sheet->SetCellValue('E'.$line_no, $value['total_debit_card_collection']);
				$line_no++;
			}
			$line_no++;
			$sheet->getColumnDimension('A')->setAutoSize(true);	
			$sheet->SetCellValue('A'.$line_no,'TOTAL');
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );

			$sheet->getColumnDimension('B')->setAutoSize(true);
			$sheet->SetCellValue('B'.$line_no, $tot_cash);
			$sheet->getStyle('B'.$line_no)->getFont()->setBold( true );

			$sheet->getColumnDimension('C')->setAutoSize(true);	
			$sheet->SetCellValue('C'.$line_no, $tot_cheque);
			$sheet->getStyle('C'.$line_no)->getFont()->setBold( true );

			$sheet->getColumnDimension('D')->setAutoSize(true);	
			$sheet->SetCellValue('D'.$line_no, $tot_netbnk);
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );

			$sheet->getColumnDimension('E')->setAutoSize(true);	
			$sheet->SetCellValue('E'.$line_no, $tot_card);
			$sheet->getStyle('E'.$line_no)->getFont()->setBold( true );	
			
		 }

		 $filename='DAILY_COLLECTION_'.time().'.xlsx';
		 header('Content-Type: application/vnd.ms-excel');
		 header('Content-Disposition: attachment;filename="'.$filename.'"');
		 header('Cache-Control: max-age=0');
		 $objWriter = new Xlsx($spreadsheet);
		 $objWriter->save('php://output');
}

	/********************* SALE REPORT **************************************/
	public function purchase()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$user_id 	= $this->session->userdata('user_id');
			$role 		= $this->session->userdata('user_role_id');

			$record = $this->reportsmdl->get_purchase_summary_data($_SESSION['fin_year']); 
			// echo "<pre>";print_r($record);exit();

			$this->load->view('pages/reports/purchase_summary',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function purchase_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$user_id 	= $this->session->userdata('user_id');
			$role 		= $this->session->userdata('user_role_id');
			
			if($role == 1 || $role == 2 || $role == 4): 
			$record = $this->reportsmdl->get_sale_summary_data_xls($_SESSION['fin_year']);
			// elseif($role == 3):
			// $record = $this->reportsmdl->get_sale_summary_data_xls_for_designer($_SESSION['fin_year'],$user_id);
			endif;

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("SALE REPORT YEAR ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','K') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='sale_summary'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

/*********************** CUST BILL WISE OUTSTANDING **********************************/
	public function supplier_outstanding()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_supp_outstanding_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pages/reports/supp_outstanding',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

	public function supplier_outstanding_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) {
			$record = $this->reportsmdl->get_supp_outstanding_data();
			// echo "<pre>";print_r($record);exit();
			$this->load->view('pdfs/supp_outstanding',$record);
		} else {
			redirect('loginctrl/logout');	
		}	
	}

	public function supplier_outstanding_xls()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			$record = $this->reportsmdl->get_supp_outstanding_data_xls();

			// echo "<pre>";print_r($record);exit();

			$spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->setActiveSheetIndex(0);
            $sheet->setTitle("SUPPLIER OUTSTANDING ".$_SESSION['fin_year']); 

            $rowCount = 1;
            foreach ($record['excel_array'] as $key => $data) 
            {
                /*SET COLUMN WIDTH AND DATA*/
                foreach(range('A','H') as $key => $columnID)
                {
                    /*set coulumn width*/
                    $sheet->getColumnDimension($columnID)->setAutoSize(true);
                    
                    /*set column data*/
                    $sheet->SetCellValue($columnID.$rowCount, $data[$key]);
                }
                $rowCount++; 
            }

            $filename='supp_outstanding_report'.date('dMY').'.csv'; //save our workbook as this file name
            header('Content-Type: application/vnd.ms-excel'); //mime type
            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
            header('Cache-Control: max-age=0'); //no cache
            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
            $objWriter = new Xlsx($spreadsheet);
            // Write the Excel file to filename some_excel_file.xlsx in the current directory
            $objWriter->save('php://output');
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

/************************* csutomer ledger Report Start ************************/

	public function customer_ledger()
	{
		$user_id = $this->session->userdata('user_id');
		
		if(!empty($user_id))
		{
	        $record = $this->reportsmdl->get_customer_ledger_data();
	        // echo "<pre>";print_r($record);exit;
	        $this->load->view('pages/reports/customer_ledger_report',$record);
	    }
		else
			redirect('loginctrl/logout');	
	}

	public function customer_ledger_print()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)) 
		{
			
			$record = $this->reportsmdl->get_customer_ledger_data();			
			// echo "<pre>"; print_r($record);exit();
			$this->load->view('pdfs/customer_ledger',$record);
		} 
		else 
		{
			redirect('loginctrl/logout');	
		}	
	}

public function customer_ledger_xls()
{	
		if(!sessionExist()){
			redirect('login/logout'); return;
		}
		$record = $this->reportsmdl->get_customer_ledger_data();
		// echo "<pre>"; print_r($record); exit;

		$line_no= 1;
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->setActiveSheetIndex(0);
		$sheet->setTitle("CUSTOMER LEDGER REPORT");
		$sheet->setCellValue('A'.$line_no, "CUSTOMER LEDGER REPORT");			 
		$sheet->mergeCells('A'.$line_no.":F".$line_no);			 
		$sheet->getStyle('A'.$line_no.":F".$line_no)->getFont()->setBold( true );	
	 	$sheet->getStyle('A'.$line_no.":F".$line_no)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
		 $line_no++;
		 $line_no++;
		 if(!empty($record)){
			$sheet->getColumnDimension('A')->setAutoSize(true);
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('A'.$line_no, 'ORDER NO');

			$sheet->getColumnDimension('B')->setAutoSize(true);
			$sheet->getStyle('B'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('B'.$line_no, 'ORDER DATE');

			$sheet->getColumnDimension('C')->setAutoSize(true);
			$sheet->getStyle('C'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('C'.$line_no, 'CLIENT NAME');
 
			$sheet->getColumnDimension('D')->setAutoSize(true);
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('D'.$line_no, 'FINAL AMT');	

			$sheet->getColumnDimension('E')->setAutoSize(true);
			$sheet->getStyle('E'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('E'.$line_no, 'ADV AMT');	

			$sheet->getColumnDimension('F')->setAutoSize(true);
			$sheet->getStyle('F'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('F'.$line_no, 'BAL AMT');	

		
			$line_no++;

			$total_amt = 0;
			$total_advace = 0;
            $total_balance = 0;
			foreach ($record['client_bill_data'] as $key => $value) {
				$total_amt += $value['om_final_total'];
                $total_advace += $value['om_advance'];
                $total_balance += $value['om_balance'];
				$sheet->getColumnDimension('A')->setAutoSize(true);	
				$sheet->SetCellValue('A'.$line_no, $value['om_no']);

				$sheet->getColumnDimension('B')->setAutoSize(true);	
				$sheet->SetCellValue('B'.$line_no, date('d-m-Y',strtotime($value['om_date'])));

				$sheet->getColumnDimension('C')->setAutoSize(true);	
				$sheet->SetCellValue('C'.$line_no, $value['client_name']);

				$sheet->getColumnDimension('D')->setAutoSize(true);	
				$sheet->SetCellValue('D'.$line_no, $value['om_final_total']);

				$sheet->getColumnDimension('E')->setAutoSize(true);	
				$sheet->SetCellValue('E'.$line_no, $value['om_advance']);

				$sheet->getColumnDimension('F')->setAutoSize(true);	
				$sheet->SetCellValue('F'.$line_no, $value['om_balance']);
				$line_no++;
			}
 			$sheet->getColumnDimension('A')->setAutoSize(true);	
			$sheet->SetCellValue('A'.$line_no, 'Total');
			$sheet->mergeCells('A'.$line_no.":C".$line_no);
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );	


			$sheet->getColumnDimension('D')->setAutoSize(true);	
			$sheet->SetCellValue('D'.$line_no, $total_amt);
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );	


			$sheet->getColumnDimension('E')->setAutoSize(true);	
			$sheet->SetCellValue('E'.$line_no, $total_advace);
			$sheet->getStyle('E'.$line_no)->getFont()->setBold( true );	


			$sheet->getColumnDimension('F')->setAutoSize(true);	
			$sheet->SetCellValue('F'.$line_no, $total_balance);
			$sheet->getStyle('F'.$line_no)->getFont()->setBold( true );	

 
			$line_no++;
			$line_no++;

			$sheet->getColumnDimension('A')->setAutoSize(true);
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('A'.$line_no, 'VOUCHER NO');

			$sheet->getColumnDimension('B')->setAutoSize(true);
			$sheet->getStyle('B'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('B'.$line_no, 'VOUCHER DATE');

			$sheet->getColumnDimension('C')->setAutoSize(true);
			$sheet->getStyle('C'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('C'.$line_no, 'CLIENT NAME');

			$sheet->getColumnDimension('D')->setAutoSize(true);
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('D'.$line_no, 'AMOUNT');
			$line_no++;

			$voucher_total_amt = 0;
			foreach ($record['voucher_data'] as $key => $value) {
				$voucher_total_amt = $voucher_total_amt + $value['vc_amount'];

				$sheet->getColumnDimension('A')->setAutoSize(true);	
				$sheet->SetCellValue('A'.$line_no, $value['vc_entry_no']);

				$sheet->getColumnDimension('B')->setAutoSize(true);
				$sheet->SetCellValue('B'.$line_no, date('d-m-Y',strtotime($value['vc_entry_date'])));

				$sheet->getColumnDimension('C')->setAutoSize(true);	
				$sheet->SetCellValue('C'.$line_no, $value['client_name']);
 
				$sheet->getColumnDimension('D')->setAutoSize(true);	
				$sheet->SetCellValue('D'.$line_no, $value['vc_amount']);
				$line_no++;
			}
			$line_no++;
			$sheet->getColumnDimension('A')->setAutoSize(true);	
			$sheet->SetCellValue('A'.$line_no, 'TOTAL');
			$sheet->mergeCells('A'.$line_no.":C".$line_no);
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );	

			$sheet->getColumnDimension('D')->setAutoSize(true);	
			$sheet->SetCellValue('D'.$line_no, $voucher_total_amt );
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );	


			$line_no++;
			$line_no++;

			$sheet->getColumnDimension('A')->setAutoSize(true);
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('A'.$line_no, 'CLIENT NAME');


			$sheet->getColumnDimension('B')->setAutoSize(true);
			$sheet->getStyle('B'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('B'.$line_no, 'TOTAL BALANCE SALE AMT');


			$sheet->getColumnDimension('C')->setAutoSize(true);
			$sheet->getStyle('C'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('C'.$line_no, 'TOTAL PAID AMT');


			$sheet->getColumnDimension('D')->setAutoSize(true);
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );	
			$sheet->SetCellValue('D'.$line_no, 'BALANCE AMT');
			$line_no++;

			$final_total_sale_amt = 0;
            $final_total_voucher_amt = 0;
            $final_balance_amt = 0;
			foreach ($record['balance_data'] as $key => $value) {
				$total_voucher = empty($value['total_voucher'])? 0:$value['total_voucher'];
                $total_sale = isset($value['total_sale']) ?  round($value['total_sale']) : '';
                
                $bal = $value['balance'];

                if($total_voucher != 0)
                {
                    $balance = $bal;
                }
                else
                {
                    $balance = isset($value['total_sale']) ?  $value['total_sale'] : '';
                }
                $final_total_sale_amt = $final_total_sale_amt + $total_sale;
                $final_total_voucher_amt = $final_total_voucher_amt + $total_voucher;
                $final_balance_amt = $final_balance_amt + $balance;

				$sheet->getColumnDimension('A')->setAutoSize(true);	
				$sheet->SetCellValue('A'.$line_no, $value['client_name']);

				$sheet->getColumnDimension('B')->setAutoSize(true);
				$sheet->SetCellValue('B'.$line_no, $total_sale);

				$sheet->getColumnDimension('C')->setAutoSize(true);	
				$sheet->SetCellValue('C'.$line_no, $total_voucher);
 
				$sheet->getColumnDimension('D')->setAutoSize(true);	
				$sheet->SetCellValue('D'.$line_no, $balance);
 
				$line_no++;
			}
			$line_no++;
			$sheet->getColumnDimension('A')->setAutoSize(true);	
			$sheet->SetCellValue('A'.$line_no, 'TOTAL');
			$sheet->getStyle('A'.$line_no)->getFont()->setBold( true );	

			$sheet->getColumnDimension('B')->setAutoSize(true);	
			$sheet->SetCellValue('B'.$line_no, $final_total_sale_amt );
			$sheet->getStyle('B'.$line_no)->getFont()->setBold( true );

			$sheet->getColumnDimension('C')->setAutoSize(true);	
			$sheet->SetCellValue('C'.$line_no, $final_total_voucher_amt );
			$sheet->getStyle('C'.$line_no)->getFont()->setBold( true );

			$sheet->getColumnDimension('D')->setAutoSize(true);	
			$sheet->SetCellValue('D'.$line_no, $final_balance_amt );
			$sheet->getStyle('D'.$line_no)->getFont()->setBold( true );
		 }

		 $filename='customer_ledger_'.time().'.csv';
		 header('Content-Type: application/vnd.ms-excel');
		 header('Content-Disposition: attachment;filename="'.$filename.'"');
		 header('Cache-Control: max-age=0');
		 $objWriter = new Xlsx($spreadsheet);
		 $objWriter->save('php://output');
}


/************************** csutomer ledger Report End ************************/

/************************* supplier ledger Report Start ************************/

	public function supplier_ledger()
	{
		$user_id = $this->session->userdata('user_id');
		
		if(!empty($user_id))
		{
	        $record = $this->reportsmdl->get_supplier_ledger_data();
	        // echo "<pre>";print_r($record);exit;
	        $this->load->view('pages/reports/supplier_ledger_report',$record);
	    }
		else
			redirect('loginctrl/logout');	
	}

/************************** supplier ledger Report End ************************/


// ****************************delivery report sms start************************
	
	public function delivery_report_sms()
	{
		$user_id = $this->session->userdata('user_id');
		if(!empty($user_id)){
			$formdata = $this->input->post();
			// print_r($formdata);exit;
			if(isset($formdata['del_sms_check']))
			{
				$del_sms_check_id = $formdata['del_sms_check'];
				$order_id = $formdata['om_id'];
				$om_delivery_date = $formdata['om_delivery_date'];
				$client_name = $formdata['client_name'];
				$client_mobile1 = $formdata['client_mobile1'];
				$om_no = $formdata['om_no'];
				$om_nod = $formdata['om_nod'];
				$om_id = $formdata['om_id'];



				foreach($del_sms_check_id as $t_key =>$t_value)
				{
					foreach($order_id as $o_key =>$o_value)
					{
						$name = $client_name[$o_key];
						$mobile1 = $client_mobile1[$o_key];
						$bill_no = $om_no[$o_key];
						$del_date = $om_delivery_date[$o_key];
						$tb_nod = $om_nod[$o_key];
						$tb_id = $om_id[$o_key];



						if($t_value == $o_value)
						{	
							if($mobile1 != "")
							{
								$msg = "Dear $name, Your Order No $bill_no is Ready for pickup since  $tb_nod Days Please Pay Your Balance. Contact Ph: 8850972807 Shop timings 10:30Am To 9Pm STYLO MENS WEAR Thanking you";

								$result = $this->send_sms($mobile1,$msg);

								$this->db_operations->data_update('tail_bill_master', array('om_del_sms_check' => 1), 'om_id', $tb_id);
							}
						}
					}
				}
				if(!empty($result))
				{
					echo 1;
				}
				else
				{
					echo 2;
				}
			}
			else
			{
				echo 2;
			}
		}
		else
		{
			redirect('loginctrl/logout');	
		}
	}	
// ****************************delivery report sms start************************
	

/*******************************SMS UTILITY end********************************************/		

	public function send_sms($mobile1,$msg)
    {	
			// echo '<pre>';print_r($mobile1);
			// echo '<pre>';print_r($msg);exit;

  //   	<user>SAIRAM</user>
		// <key>568eb3e8edXX</key>
		// <mobile>'.$mobile1.'</mobile>
		// <message>'.$msg.'</message>
		// <accusage>1</accusage>
		// <senderid>SAIRAM</senderid>

    	
		$msg = str_replace('%20', ' ', $msg);
		$xml_data ='<?xml version="1.0"?>
		<parent>
		<child>
		<user>DELUXE</user>
		<key>ec562c620fXX</key>
		<mobile>'.$mobile1.'</mobile>
		<message>'.$msg.'</message>
		<accusage>1</accusage>
		<senderid>DALERT</senderid>
		</child>
		</parent>';
		$URL = "http://sms.interlinkconsultant.com/submitsms.jsp?"; 


		$ch = curl_init($URL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
		curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$output = curl_exec($ch);
		curl_close($ch);
		if(!empty($output))
		{
			$output_array = explode(",", $output);
			// echo '<pre>';print_r($output_array);exit;
			if(!empty($output_array))
			{
				if($output_array[1]=="success")
				{
					return 1;
				}
				else
				{	
					return 4;
				}  
			}
			else
			{
				return 5;
			}   
		}
		else
		{
			return 1;
		}
    }


	
/**/
}
?>
