<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Job_issue extends CI_Controller{
	public $model;
	public $pagination;

	protected $session_expired;
	public function __construct(){
		parent::__construct();

		$this->session_expired  = ['status' => false, 'flag' => -1, 'data' => [], 'msg' => '']; 
		$this->load->library('session');
		$this->load->library('pagination');
		$this->load->library('db_operations');
		$this->config->load('extra');
		$this->load->model('production/Jobissuemdl', 'model');
	} 
	public function index(){	  
		if(sessionExist()){
			if(isset($_GET['action']) && !empty($_GET['action'])){
				if($_GET['action'] == 'add'){
					$record = $this->model->get_process(); 
					// echo "<pre>"; print_r($record);exit();
					$this->load->view('pages/production/job_issue_form', $record);
				}else if ($_GET['action'] == 'edit') { 
					if(isset($_GET['id']) && !empty($_GET['id'])){
						$id = encrypt_decrypt("decrypt", $_GET['id'], SECRET_KEY);
						$record = $this->model->get_data_for_edit($id);
						// echo "<pre>"; print_r($record);exit();
						$this->load->view('pages/production/job_issue_form', $record);
					}else{
						$this->load->view('errors/error');		
					}
				}else{ 
					$config 				= array();
					$config 				= $this->config->item('pagination');	
					$config['total_rows'] 	= $this->model->get_data(true);
					$config['base_url'] 	= base_url("production/job_issue?search=true");

					foreach ($_GET as $key => $value) 
					{
						if($key != 'search' && $key != 'offset')
						{
							$config['base_url'] .= "&" . $key . "=" .$value;
						}
					}

					$offset = (!empty($_GET['offset'])) ? $_GET['offset'] : 0;
					$this->pagination->initialize($config);

					$record['count']		= $offset;
					$record['total_rows'] 	= $config['total_rows'];
					$record['data']			= $this->model->get_data(false, $config['per_page'], $offset);

					// echo "<pre>"; print_r($record); exit;
					
					$this->load->view('pages/production/job_issue_master', $record);
				}
			}else{
				$this->load->view('errors/error');
			}
		}else{
			redirect('loginctrl/logout');	
		}
	}
	public function get_karigar($id){
		if(!sessionExist()){
			echo json_encode($this->session_expired);
			return;
		}
		$data = $this->model->get_karigar($id);
		echo json_encode(['status' => true, 'flag' => 1, 'data' => $data, 'msg' => 'Data fetched successfully.']);
	}
	public function get_barcode($id, $_from_date, $_to_date){
		if(!sessionExist()){ 
			echo json_encode($this->session_expired);
			return;
		}
		$data['barcode_data'] = $this->model->get_barcode($id);
		$data['pending_job']  = $this->model->get_pending_job($id, $_from_date, $_to_date);
		echo json_encode(['status' => true, 'flag' => 1, 'data' => $data, 'msg' => 'Data fetched successfully.']);
	}
	public function get_pending_job($id, $_from_date, $_to_date){ 
		if(!sessionExist()){
			echo json_encode($this->session_expired);
			return;
		}
		$data['pending_job']  = $this->model->get_pending_job($id, $_from_date, $_to_date);
		echo json_encode(['status' => true, 'flag' => 1, 'data' => $data, 'msg' => 'Data fetched successfully.']);
	}
	public function scan_barcode($bm_item_code){ 
		if(!sessionExist()){  
			echo json_encode($this->session_expired);
			return;
		}
		
		$ot_data=$this->db_operations->get_record('order_trans',['ot_barcode'=>$bm_item_code]);
		if(empty($ot_data)){
			echo json_encode(['status' => false, 'data' => [], 'msg' => '1. Barcode not found.']);
			return;
		} 
		$data = $this->model->scan_barcode($ot_data[0]['ot_id']); 
		$latest_data= $this->model->get_latest_data($ot_data[0]['ot_id']);
		// echo "<pre>"; print_r($data);die;
		if(empty($data)){
			echo json_encode(['status' => false, 'data' => [], 'msg' => 'Barcode not found.']);return;
		} 
		if(!empty($latest_data)){ 
            if($latest_data[0]['jrt_id'] == 0){
            	 echo json_encode(['status' => false,'data' => [], 'msg' => '1. Barcode already issued in '.$latest_data[0]['designation_name']]);
        		return; 
            } 
           
        }

		echo json_encode(['status' => true, 'flag' => 1, 'data' => $data, 'msg' => 'Data fetched successfully.']);
	}
	public function add_update($id){   
		if(!sessionExist()){
			echo json_encode($this->session_expired);
			return;
		}
		$post_data = $this->input->post();
		// echo "<pre>"; print_r($post_data); exit;
		if(empty($post_data)){
			echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Form data is empty.']);
			return;
		}  
		$master_data['jim_entry_date']	= isset($post_data['jim_entry_date']) && !empty($post_data['jim_entry_date']) ? date('Y-m-d', strtotime($post_data['jim_entry_date'])) : date('Y-m-d');
		$master_data['jim_km_id']		= trim($post_data['jim_km_id']);
		$master_data['jim_designation']	= trim($post_data['jim_km_designation']);
		$master_data['jim_uuid'] 		 	= trim($post_data['jim_uuid']);
		// if($post_data['jim_km_designation'] == 'MAKER'){
		// 	$master_data['jim_bom'] = $post_data['bom'];
		// }
		if($id == 0){ 
			$this->db->trans_begin(); 

			$uuidExist 		= $this->db_operations->get_cnt('job_issue_master', ['jim_uuid' => $master_data['jim_uuid']]);
            if($uuidExist > 0){ 
                $this->db->trans_rollback();
                echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Form already submited.']);
				return;
            }

			$master_data['jim_entry_no'] 		= $this->db_operations->get_max_id_custom('job_issue_master', 'jim_entry_no');
			$master_data['jim_userid'] 			= $_SESSION['user_id'];
			$master_data['jim_create_date'] 	= date("Y-m-d H:i:s");					
			$master_data['jim_update_userid']	= $_SESSION['user_id'];
			$master_data['jim_update_date'] 	= date("Y-m-d H:i:s");	
			$id  = $this->db_operations->data_insert('job_issue_master', $master_data);
		// echo "<pre>"; print_r($id); exit;

			$msg = 'Added successfully';
			if($id < 1){
				$this->db->trans_rollback();
				echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Master data not inserted']);
				return;
			}

			if($this->insert_update_trans($post_data, $id) < 1){
				$this->db->trans_rollback();
				echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Transaction data not inserted']);
				return;
			}
			if ($this->db->trans_status() === FALSE){
			    $this->db->trans_rollback();
			    echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Data not inserted']);
				return;
		    }
		    $this->db->trans_commit();
		}else{
			$this->db->trans_begin();
			$master_data['jim_update_userid']	= $_SESSION['user_id'];
			$master_data['jim_update_date'] 	= date("Y-m-d H:i:s");	
			$msg = 'Updated successfully';
			if($this->db_operations->data_update('job_issue_master', $master_data, 'jim_id', $id) < 1){
				$this->db->trans_rollback();
				echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Master data not inserted']);
				return;
			}

			if($this->insert_update_trans($post_data, $id) < 1){
				$this->db->trans_rollback();
				echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Transaction data not inserted']);
				return;
			}
			if ($this->db->trans_status() === FALSE){
			    $this->db->trans_rollback();
			    echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Data not inserted']);
				return;
		    }
		    $this->db->trans_commit();
		}
		$data['id'] = $id;
		echo json_encode(['status' => true, 'flag' => 1, 'data' => $data,  'msg' => $msg]);
	}
	public function insert_update_trans($post_data, $id){  
		$trans_db_data = $this->db_operations->get_record('job_issue_trans', ['jit_jim_id' => $id]);
		if(!empty($trans_db_data)){
			foreach ($trans_db_data as $key => $value){ 
				if(!in_array($value['jit_id'], $post_data['jit_id'])){
					if($this->db_operations->delete_record('job_issue_trans',array('jit_id' =>$value['jit_id'])) < 1){
						return 0;
					}
				} 
			}
		}

		foreach ($post_data['jit_id'] as $key => $value){
			$trans_data['jit_jim_id'] 	= $id;
			$trans_data['jit_ot_id'] 	= $post_data['jit_ot_id'][$key];

			if($value == 0){
				$jit_id = $this->db_operations->data_insert('job_issue_trans', $trans_data);
				if($jit_id < 1){
					return 0;
				}

			}else{
				if($this->db_operations->data_update('job_issue_trans', $trans_data, 'jit_id', $value) < 1){
					return 0;
				}
			}
		}
		return 1;
	}
	public function update_barcode_master($trans_data, $jit_id,$ot_id, $isDelete = false){
		$barcode_db_data = $this->db_operations->get_record('order_trans', ['ot_id' => $ot_id]);
		if(empty($barcode_db_data)) return 0;
		if(!$isDelete){	 		
				$barcode_data 				= [];
				$barcode_data['ot_jim_id'] 	= $trans_data['jit_jim_id'];
				$barcode_data['ot_jit_id'] 	= $jit_id;
				if($this->db_operations->data_update('order_trans', $barcode_data, 'ot_id', $ot_id) < 1){
					return 0;
				}	
			
		}else{
			// if($barcode_db_data[0]['ot_loc'] == 'OUT'){
				$prev_data 	= $this->model->get_prev_data($otb_id);
				$barcode_data 				= [];
				$barcode_data['otb_jim_id'] 	= $prev_data['jit_jim_id'];
				$barcode_data['otb_jit_id'] 	= $prev_data['jit_jit_id'];
				// $barcode_data['ot_loc'] 	= 'IN';
				if($this->db_operations->data_update('order_trans_barcode', $barcode_data, 'otb_id', $otb_id) < 1){
					return 0;
				}	
			// }else{
			// 	return -1;
			// }
		}
		return 1;
	}
	public function get_select2_entry_no(){
		$json = [];
		$data = $this->model->get_select2_entry_no();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_barcode(){
		$json = [];
		$data = $this->model->get_select2_barcode();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_karigar(){
		$json = [];
		$data = $this->model->get_select2_karigar();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_apparel(){
		$json = [];
		$data = $this->model->get_select2_apparel();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_client(){
		$json = [];
		$data = $this->model->get_select2_client();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_order(){
		$json = [];
		$data = $this->model->get_select2_order();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	
	public function get_select2_proces(){
		$json = [];
		$data = $this->model->get_select2_proces();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function remove($id){
		if(!sessionExist()){
			echo json_encode($this->session_expired);
			return;
		}
		$data = $this->db_operations->get_record('job_issue_trans',['jit_id' => $id], false);
		if(empty($data)){
			echo json_encode(['status' => true, 'flag' => 2, 'data' => [], 'msg' => ' Already deleted']);
			return;	
		}
		// $isExist = $this->model->isExist($id, true);
		// if($isExist){
		// 	echo json_encode(['status' => true, 'flag' => 2, 'data' => [], 'msg' => 'Already exist.']);
		// 	return;	
		// }
		$this->db->trans_begin();
		if($this->db_operations->delete_record('job_issue_trans', ['jit_id' => $id]) < 1){
			$this->db->trans_rollback();
			echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Transaction not deleted']);
			return;
		}
		// if($this->update_barcode_master($data[0], $id, true) < 1){
		// 	$this->db->trans_rollback();
		// 	echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Barcode not updated']);
		// 	return;
		// }		
		if ($this->db->trans_status() === FALSE){
		    $this->db->trans_rollback();
		    echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Rollback']);
			return;
	    }
	    $this->db->trans_commit();
		echo json_encode(['status' => true, 'flag' => 1, 'data' => [], 'msg' => 'Deleted successfully']);
	}
}
?>
