<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Job_receive extends CI_Controller{
	public $model;
	public $pagination;

	protected $session_expired;
	public function __construct(){
		parent::__construct();

		$this->session_expired  = ['status' => false, 'flag' => -1, 'data' => [], 'msg' => ''];
		$this->load->library('session');
		$this->load->library('pagination');
		$this->load->library('db_operations');
		$this->config->load('extra');
		$this->load->model('production/Jobreceivemdl', 'model');
	}
	public function index(){ 	
		if(sessionExist()){
			if(isset($_GET['action']) && !empty($_GET['action'])){
				if($_GET['action'] == 'add'){
					$record = $this->model->get_process(); 
					// echo "<pre>"; print_r($record);exit();
					$this->load->view('pages/production/job_receive_form', $record);
				}else if ($_GET['action'] == 'edit') {
					if(isset($_GET['id']) && !empty($_GET['id'])){
						$id = encrypt_decrypt("decrypt", $_GET['id'], SECRET_KEY);
						$record = $this->model->get_data_for_edit($id);
						// echo "<pre>"; print_r($record);exit();
						$this->load->view('pages/production/job_receive_form', $record);
					}else{
						$this->load->view('errors/error');		
					}
				}else{
					$config 				= array();
					$config 				= $this->config->item('pagination');	
					$config['total_rows'] 	= $this->model->get_data(true);
					$config['base_url'] 	= base_url("production/job_receive?search=true");

					foreach ($_GET as $key => $value) 
					{
						if($key != 'search' && $key != 'offset')
						{
							$config['base_url'] .= "&" . $key . "=" .$value;
						}
					}

					$offset = (!empty($_GET['offset'])) ? $_GET['offset'] : 0;
					$this->pagination->initialize($config);

					$record['count']		= $offset;
					$record['total_rows'] 	= $config['total_rows'];
					$record['data']			= $this->model->get_data(false, $config['per_page'], $offset);
					// echo "<pre>"; print_r($record); exit;
					
					$this->load->view('pages/production/job_receive_master', $record);
				}
			}else{
				$this->load->view('errors/error');
			}
		}else{
			redirect('loginctrl/logout');	
		}
	}
	public function get_karigar($id){
		if(!sessionExist()){
			echo json_encode($this->session_expired);
			return;
		}
		$data = $this->model->get_karigar($id);
		echo json_encode(['status' => true, 'flag' => 1, 'data' => $data, 'msg' => 'Data fetched successfully.']);
	}
	public function get_barcode($id){ 
		if(!sessionExist()){
			echo json_encode($this->session_expired);
			return;
		}
		$data = $this->model->get_barcode($id);
		echo json_encode(['status' => true, 'flag' => 1, 'data' => $data, 'msg' => 'Data fetched successfully.']);
	}
	public function scan_barcode($bm_item_code){  
		if(!sessionExist()){
			echo json_encode($this->session_expired);
			return;
		}
		$ot_data=$this->db_operations->get_record('order_trans',['ot_barcode'=>$bm_item_code]);
		if(empty($ot_data)){
			echo json_encode(['status' => false, 'data' => [], 'msg' => '1. Barcode not found.']);
			return;
		} 
		$data = $this->model->scan_barcode($ot_data[0]['ot_id']); 
		// echo "<pre>"; print_r($data);die;
		if(empty($data)){
			echo json_encode(['status' => false,'data' => [], 'msg' => 'Barcode not found.']);
			return;	
		}
		if($data[0]['jrt_jit_id'] != 0){
			echo json_encode(['status' => false,'data' => [], 'msg' => '1. Barcode already received from '.$data[0]['Designation_name']]);
			return;	
		} 
		echo json_encode(['status' => true, 'data' => $data, 'msg' => 'Data fetched successfully.']);
	}
	public function add_update($id){ 
		if(!sessionExist()){
			echo json_encode($this->session_expired);
			return;
		}
		$post_data = $this->input->post();
		// echo "<pre>"; print_r($post_data); exit;
		if(empty($post_data)){
			echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Form data is empty.']);
			return;
		}
		
		$master_data['jrm_entry_date']		= isset($post_data['jrm_entry_date']) && !empty($post_data['jrm_entry_date']) ? date('Y-m-d', strtotime($post_data['jrm_entry_date'])) : date('Y-m-d');
		$master_data['jrm_km_id']			= trim($post_data['jrm_km_id']);
		$master_data['jrm_designation']		= trim($post_data['jrm_designation']);
		$master_data['jrm_uuid'] 		 	= trim($post_data['jrm_uuid']);
		if($id == 0){
			$this->db->trans_begin();

			$uuidExist 		= $this->db_operations->get_cnt('job_receive_master', ['jrm_uuid' => $master_data['jrm_uuid']]);
            if($uuidExist > 0){ 
                $this->db->trans_rollback();
                echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Form already submited.']);
				return;
            }

			$master_data['jrm_entry_no'] 	= $this->db_operations->get_max_id_custom('job_receive_master', 'jrm_entry_no');
			// $master_data['jrm_branch_id'] 		= $_SESSION['user_branch_id'];
			$master_data['jrm_userid'] 			= $_SESSION['user_id'];
			$master_data['jrm_create_date'] 	= date("Y-m-d H:i:s");					
			$master_data['jrm_update_userid']	= $_SESSION['user_id'];
			$master_data['jrm_fin_year']		= $_SESSION['fin_year'];
			$master_data['jrm_update_date'] 	= date("Y-m-d H:i:s");	
			$id  = $this->db_operations->data_insert('job_receive_master', $master_data);
			$msg = 'Added successfully';
			if($id < 1){
				$this->db->trans_rollback();
				echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Master data not inserted']);
				return;
			}

			if($this->insert_update_trans($post_data, $id) < 1){
				$this->db->trans_rollback();
				echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Transaction data not inserted']);
				return;
			}
			if ($this->db->trans_status() === FALSE){
			    $this->db->trans_rollback();
			    echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Data not inserted']);
				return;
		    }
		    $this->db->trans_commit();
		}else{
			$this->db->trans_begin();
			$master_data['jrm_update_userid']	= $_SESSION['user_id'];
			$master_data['jrm_update_date'] 	= date("Y-m-d H:i:s");	
			$msg = 'Updated successfully';
			if($this->db_operations->data_update('job_receive_master', $master_data, 'jrm_id', $id) < 1){
				$this->db->trans_rollback();
				echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Master data not inserted']);
				return;
			}
			if($this->insert_update_trans($post_data, $id) < 1){
				$this->db->trans_rollback();
				echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Transaction data not inserted']);
				return;
			}
			if ($this->db->trans_status() === FALSE){
			    $this->db->trans_rollback();
			    echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Data not inserted']);
				return;
		    }
		    $this->db->trans_commit();
		}
		$data['id'] = $id;
		echo json_encode(['status' => true, 'flag' => 1, 'data' => $data,  'msg' => $msg]);
	}
	public function insert_update_trans($post_data, $id){
		$trans_db_data = $this->db_operations->get_record('job_receive_trans', ['jrt_jrm_id' => $id]);
		// echo "<pre>"; print_r($id);die; 
		if(!empty($trans_db_data)){
			foreach ($trans_db_data as $key => $value){
				if(!in_array($value['jrt_id'], $post_data['jrt_id'])){
					if($this->db_operations->delete_record('job_receive_trans',array('jrt_id' =>$value['jrt_id'])) < 1){
						return 0;
					}
				} 
			}
		}
		foreach ($post_data['jrt_id'] as $key => $value){
				$trans_data['jrt_jrm_id'] 	= $id;
				$trans_data['jrt_ot_id'] 	= $post_data['jrt_ot_id'][$key];
				$trans_data['jrt_jim_id'] 	= $post_data['jrt_jim_id'][$key];
				$trans_data['jrt_jit_id'] 	= $post_data['jrt_jit_id'][$key];
			
			if($value == 0){
				$jrt_id = $this->db_operations->data_insert('job_receive_trans', $trans_data);
				if($jrt_id < 1) return 0;
			}else{
				if($this->db_operations->data_update('job_receive_trans', $trans_data, 'jrt_id', $value) < 1){
					return 0;
				}
			}
		}
		return 1;
	}
	public function update_barcode_master($trans_data, $jrt_id, $isDelete = false){
		$barcode_db_data = $this->db_operations->get_record('order_trans_barcode', ['otb_id' => $trans_data['jrt_ot_id']]);
		if(empty($barcode_db_data)) return 0;
		// echo "<pre>"; print_r($barcode_db_data); exit;
		if(!$isDelete){
			// if($barcode_db_data[0]['bm_loc'] == 'OUT'){
				$barcode_data 				= [];
				// $barcode_data['bm_loc'] 	= 'IN';
				$barcode_data['otb_jrm_id'] 	= $trans_data['jrt_jrm_id'];
				$barcode_data['otb__jrt_id'] 	= $jrt_id;

				if($this->db_operations->data_update('order_trans_barcode', $barcode_data, 'otb_id', $trans_data['jrt_ot_id']) < 1){
					return 0;
				}	
			
		}else{
			// if($barcode_db_data[0]['bm_loc'] == 'IN'){
				$prev_data 				= $this->model->get_prev_data($trans_data['jrt_ot_id']);
				$barcode_data 				= [];
				$barcode_data['otb_jrm_id'] 	= $prev_data['jrm_id'];
				$barcode_data['otb__jrt_id'] 	= $prev_data['jrt_id'];
				// $barcode_data['bm_loc'] 	= 'OUT';
				if($this->db_operations->data_update('order_trans_barcode', $barcode_data, 'otb_id', $trans_data['jrt_ot_id']) < 1){
					return 0;
				}	
			// }else{
			// 	return -1;
			// }
		}
		return 1;
	}
	public function all_ready($bm_id){
		$is_all_ready = $this->model->all_ready($bm_id);
		if($is_all_ready){
			// echo "<pre>"; print_r($is_all_ready); exit();
			$order_data 	= $this->model->get_order_data($bm_id);
			$order_no 		= $order_data[0]['om_entry_no'];
		    $apparel_detail = $this->model->get_apparel_with_qty($order_data[0]['om_id']);
		    $mob 			= $order_data[0]['client_mob1'];
		    $msg = "Dear Sir,\nWe are happy to inform you that your Order $order_no $apparel_detail is ready.\nPlz collect it.\nFor home delivery plz call ".ASSIST_NO."\nTailoring Demo.\nClick : ".YOUTUBE_LINK;
		    // echo"<pre>"; print_r($msg); exit;
		    if(!empty($mob)) send_whatsapp($mob, $msg);
		}
		return 1;
	}
	public function get_select2_entry_no(){
		$json = [];
		$data = $this->model->get_select2_entry_no();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_barcode(){
		$json = [];
		$data = $this->model->get_select2_barcode();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_karigar(){
		$json = [];
		$data = $this->model->get_select2_karigar();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_apparel(){
		$json = [];
		$data = $this->model->get_select2_apparel();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_client(){
		$json = [];
		$data = $this->model->get_select2_client();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function get_select2_order(){
		$json = [];
		$data = $this->model->get_select2_order();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	
	public function get_select2_proces(){
		$json = [];
		$data = $this->model->get_select2_proces();
		foreach ($data as $key => $value){
			$json[] = ['id'=>$value['id'], 'text'=>$value['name']];
		}
		echo json_encode($json);
	}
	public function remove($id){ 
		if(!sessionExist()){
			echo json_encode($this->session_expired);
			return;
		}
		$data = $this->db_operations->get_record('job_receive_trans',['jrt_id' => $id], false);
		if(empty($data)){
			echo json_encode(['status' => true, 'flag' => 2, 'data' => [], 'msg' => ' Already deleted']);
			return;	
		}
		// $isExist = $this->model->isExist($id, true);
		// if($isExist){
		// 	echo json_encode(['status' => true, 'flag' => 2, 'data' => [], 'msg' => 'Already exist.']);
		// 	return;	
		// }
		$this->db->trans_begin();
		if($this->db_operations->delete_record('job_receive_trans', ['jrt_id' => $id]) < 1){
			$this->db->trans_rollback();
			echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Transaction not deleted']);
			return;
		}
		// if($this->update_barcode_master($data[0], $id, true) < 1){
		// 	$this->db->trans_rollback();
		// 	echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Barcode not updated']);
		// 	return;
		// }		
		if ($this->db->trans_status() === FALSE){
		    $this->db->trans_rollback();
		    echo json_encode(['status' => true, 'flag' => 0, 'data' => [], 'msg' => 'Rollback']);
			return;
	    }
	    $this->db->trans_commit();
		echo json_encode(['status' => true, 'flag' => 1, 'data' => [], 'msg' => 'Deleted successfully']);
	}
}
?>
