<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	
class Productionctrl extends CI_Controller
{
	public $productionmdl;
	public $pagination;

		public function __construct()
		{
			parent::__construct();

			$this->load->model('production/productionmdl');
			$this->load->library('session');
			$this->load->library('upload');
			$this->load->library('pagination');
			$this->load->library('db_operations');
			$this->config->load('extra');
			
		}

	/******************************************* DASHBOARD ***********************************************************************/
		public function issue_receive_dashboard()
		{
			if(sessionExist()) 
			{
				if ($_GET['action'] == 'view') 
				{
					
					$record['issue_data']	= $this->productionmdl->get_all_job_data_for_issue();
					// echo "<pre>"; print_r($record);exit();
					$this->load->view('pages/production/dashboard', $record);
				}
				elseif($_GET['action'] == 'add')
				{
					$record = $this->productionmdl->add_job_issue_master();
					// echo "<pre>"; print_r($record); exit;
					$this->load->view('pages/production/job_issue_form', $record);
				}
				elseif($_GET['action'] == 'edit')
				{
					if($_GET['type'] == 'issue')
					{
						$jim_id = encrypt_decrypt("decrypt", $_GET['id'], SECRET_KEY);
						$record = $this->productionmdl->edit_job_issue($jim_id);
						// echo "<pre>"; print_r($record); exit;
						$this->load->view('pages/production/dashboard_issue', $record);	
					}
					else if($_GET['type'] == 'receive')
					{
						$jrm_id = encrypt_decrypt("decrypt", $_GET['id'], SECRET_KEY);
						$record = $this->productionmdl->edit_job_receive($jrm_id);
						// echo "<pre>"; print_r($record); exit;
						$this->load->view('pages/production/dashboard_receive', $record);	
					}
					else
					{
						$this->load->view('errors/error');			
					}
					
				}
				else if($_GET['action'] == 'print')
				{
					$jim_id = encrypt_decrypt("decrypt", $_GET['id'], SECRET_KEY);
					$record = $this->productionmdl->get_single_job_issue_data_for_print($jim_id);
					// echo "<pre>"; print_r($record); exit;	
					$this->load->view('pdfs/production/job_issue_print', $record);
				}
				else
				{
					$this->load->view('errors/error');	
				}
			} 
			else 
			{
				redirect('loginctrl/logout');	
			}
		}
		public function get_karigar_data($designation)
		{
			if(sessionExist()) {
				echo json_encode($this->productionmdl->get_karigar_data($designation));
			} else {
				redirect('loginctrl/logout');
			}
		}
		public function get_barcode_data($km_id)
		{
			if(sessionExist()) {
				echo json_encode($this->productionmdl->get_barcode_data($km_id));
			} else {
				redirect('loginctrl/logout');
			}
		}
		public function get_dashboard_data()
		{
			if(sessionExist()) {
				echo json_encode($this->productionmdl->get_all_job_data_for_issue());
			} else {
				redirect('loginctrl/logout');
			}
		}
		public function order_data($bm_id)
		{
			if(sessionExist()) {
				echo json_encode($this->productionmdl->order_data($bm_id));
			} else {
				redirect('loginctrl/logout');
			}
		}
		public function add_job_issue($jim_id)
		{
			if(sessionExist()) {
				$form_data 	= $this->input->post();
			 	// echo"<pre>"; print_r($form_data); exit();
			 	$master_data 					= [];
				$master_data['jim_bm_id']		= $form_data['jim_bm_id'];
				$master_data['jim_km_id']		= $form_data['jim_km_id'];
				$master_data['jim_designation']	= $form_data['jim_km_designation'];
				if($form_data['jim_km_designation'] == 'MAKER')
				{
					$master_data['jim_bom'] = $form_data['bom'];
				}
				if($jim_id == 0) 
				{
					$this->db->trans_begin();
					$master_data['jim_entry_no'] 		= $this->db_operations->get_max_id_custom('job_issue_master', 'jim_entry_no');
					$master_data['jim_entry_date']		= date('Y-m-d');
					$master_data['jim_branch_id'] 		= $_SESSION['user_branch_id'];
					$master_data['jim_userid'] 			= $_SESSION['user_id'];
					$master_data['jim_create_date'] 	= date("Y-m-d H:i:s");					
					$master_data['jim_update_userid']	= $_SESSION['user_id'];
					$master_data['jim_update_date'] 	= date("Y-m-d H:i:s");	

					// echo "<pre>"; print_r($client_data); exit;

					$jim_id = $this->db_operations->data_insert('job_issue_master', $master_data);
					if(!empty($jim_id))
					{
						$result_id = $this->update_barcode_master($form_data, $jim_id);
						if($result_id > 0)
						{

							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
							} 
							else 
							{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							}
						}
						else
						{
							$this->db->trans_rollback();
						    $response['resp'] = $result_id;
						}
					}
					else
					{
						$this->db->trans_rollback();
					    $response['resp'] = 0;
					}
				} 
				else
				{
					$this->db->trans_begin();
					$master_data['jim_update_userid']	= $_SESSION['user_id'];
					$master_data['jim_update_date'] 	= date("Y-m-d H:i:s");	

					// echo "<pre>"; print_r($client_data); exit;

					if($this->db_operations->data_update('job_issue_master', $master_data, 'jim_id', $jim_id) > 0)
					{
						$result_id = $this->update_barcode_master($form_data, $jim_id, true);
						if($result_id > 0)
						{

							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
							} 
							else 
							{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							}
						}
						else
						{
							$this->db->trans_rollback();
						    $response['resp'] = $result_id;
						}
					}
					else
					{
						$this->db->trans_rollback();
					    $response['resp'] = 0;
					}
				}
				echo json_encode($response);
			} 
			else 
			{
				redirect('loginctrl/logout');		
			}
		}
		public function update_barcode_master($form_data, $jim_id, $isEdit = false)
		{
			$barcode_db_data = $this->db_operations->get_record('barcode_master', ['bm_id' => $form_data['jim_bm_id'], 'bm_delete_status' => 0]);
			// echo "<pre>"; print_r($barcode_db_data); exit();
			// echo "<pre>"; print_r($isEdit); exit();
			if(!empty($barcode_db_data))
			{
				if(!$isEdit)
				{
					if($barcode_db_data[0]['bm_loc'] == 'IN')
					{
						$barcode_data 				= [];
						$barcode_data['bm_loc'] 	= 'OUT';
						$barcode_data['bm_jim_id'] 	= $jim_id;
						$barcode_data['bm_bom'] 	= $form_data['bom'];

						if($this->db_operations->data_update('barcode_master', $barcode_data, 'bm_id', $form_data['jim_bm_id']) > 0)
						{
							return 1;
						}
						else
						{

							return 0;
						}	
					}
					else
					{
						return -1;
					}
				}
				else
				{
					if($barcode_db_data[0]['bm_loc'] == 'OUT')
					{
						$barcode_data 				= [];
						$barcode_data['bm_loc'] 	= 'OUT';
						$barcode_data['bm_jim_id'] 	= $jim_id;
						$barcode_data['bm_bom'] 	= $form_data['bom'];

						if($this->db_operations->data_update('barcode_master', $barcode_data, 'bm_id', $form_data['jim_bm_id']) > 0)
						{
							return 1;
						}
						else
						{

							return 0;
						}	
					}
					else
					{
						return -1;
					}
				}
			}
			else
			{
				return 0;
			}
		}
		public function get_issue_data($jim_id)
		{
			if(sessionExist()) {
				echo json_encode($this->productionmdl->get_issue_data($jim_id));
			} else {
				redirect('loginctrl/logout');
			}
		}
		public function add_job_receive($jrm_id)
		{
			if(sessionExist()) {
				$form_data 	= $this->input->post();
			 	// echo"<pre>"; print_r($form_data); exit();
				$master_data 					= [];
				$master_data['jrm_jim_id'] 		= $form_data['bm_jim_id'];
				$master_data['jrm_bm_id'] 		= $form_data['jrm_bm_id'];
				$master_data['jrm_km_id'] 		= $form_data['jrm_km_id'];
				$master_data['jrm_designation'] = $form_data['jrm_designation'];

				if($jrm_id == 0) 
				{
					$this->db->trans_begin();
					$master_data['jrm_entry_no'] 		= $this->db_operations->get_max_id_custom('job_receive_master', 'jrm_entry_no');;
					$master_data['jrm_entry_date'] 		= date("Y-m-d");
					$master_data['jrm_userid'] 			= $_SESSION['user_id'];
					$master_data['jrm_branch_id'] 		= $_SESSION['user_branch_id'];
					$master_data['jrm_create_date'] 	= date("Y-m-d H:i:s");					
					$master_data['jrm_update_userid']	= $_SESSION['user_id'];
					$master_data['jrm_update_date'] 	= date("Y-m-d H:i:s");	

					// echo "<pre>"; print_r($client_data); exit;

					$jrm_id = $this->db_operations->data_insert('job_receive_master', $master_data);
					if(!empty($jrm_id))
					{
						$result_id 	= $this->update_barcode_master_after_receive($form_data, $jrm_id);
						if($result_id > 0)
						{

							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
							} 
							else 
							{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							}
						}
						else
						{
							$this->db->trans_rollback();
						    $response['resp'] = $result_id;
						}
					}
					else
					{
						$this->db->trans_rollback();
					    $response['resp'] = 0;					    
					}
				} 
				else
				{
					$this->db->trans_begin();
					$master_data['jrm_update_userid']	= $_SESSION['user_id'];
					$master_data['jrm_update_date'] 	= date("Y-m-d H:i:s");	

					// echo "<pre>"; print_r($client_data); exit;

					if($this->db_operations->data_update('job_receive_master', $master_data, 'jrm_id', $jrm_id))
					{
						$result_id 	= $this->update_barcode_master_after_receive($form_data, $jrm_id, true);
						if($result_id > 0)
						{

							if ($this->db->trans_status() === FALSE) 
							{
							    $this->db->trans_rollback();
							    $response['resp'] = 0;
							} 
							else 
							{
							    $this->db->trans_commit();
							    $response['resp'] = 1;
							}
						}
						else
						{
							$this->db->trans_rollback();
						    $response['resp'] = $result_id;
						}
					}
					else
					{
						$this->db->trans_rollback();
					    $response['resp'] = 0;					    
					}
				}
				echo json_encode($response);	
			} 
			else 
			{
				redirect('loginctrl/logout');		
			}
		}
		public function update_barcode_master_after_receive($form_data, $jrm_id, $isEdit = false)
		{
			$barcode_db_data = $this->db_operations->get_record('barcode_master', ['bm_jim_id' => $form_data['bm_jim_id'], 'bm_delete_status' => 0]);
			// echo "<pre>"; print_r($barcode_db_data); exit();
			if(!empty($barcode_db_data))
			{
				if($isEdit)
				{
					
					$prev_db_data = $this->db_operations->get_record('barcode_master', ['bm_jrm_id' => $jrm_id, 'bm_delete_status' => 0]);
					// echo "<pre>"; print_r($prev_db_data); exit();
					if(!empty($prev_db_data))
					{
						if($prev_db_data[0]['bm_loc'] == 'IN')
						{
							$prev_data 				= [];
							$prev_data['bm_loc'] 	= 'OUT';
							$prev_data['bm_jrm_id']	= $this->productionmdl->get_prev_jrm_id($jrm_id, $prev_db_data[0]['bm_id']);

							if($this->db_operations->data_update('barcode_master', $prev_data, 'bm_jrm_id', $jrm_id) > 0)
							{
								if($barcode_db_data[0]['bm_loc'] == 'OUT')
								{
									$barcode_data 				= [];
									$barcode_data['bm_loc'] 	= 'IN';
									$barcode_data['bm_jrm_id'] 	= $jrm_id;

									if($this->db_operations->data_update('barcode_master', $barcode_data, 'bm_jim_id', $form_data['bm_jim_id']) > 0)
									{
										return 1;
									}
									else
									{

										return 0;
									}	
								}
								else
								{
									return -1;
								}		

							}
							else
							{

								return 0;
							}	
						}
						else
						{
							return -1;
						}	
					}
					else
					{

						return 0;
					}	
				}
				else
				{
					if($barcode_db_data[0]['bm_loc'] == 'OUT')
					{
						$barcode_data 				= [];
						$barcode_data['bm_loc'] 	= 'IN';
						$barcode_data['bm_jrm_id'] 	= $jrm_id;

						if($this->db_operations->data_update('barcode_master', $barcode_data, 'bm_jim_id', $form_data['bm_jim_id']) > 0)
						{
							return 1;
						}
						else
						{

							return 0;
						}	
					}
					else
					{
						return -1;
					}		

				}	
								
			}
			else
			{
				return 0;
			}
		}
	/******************************************* DASHBOARD ***********************************************************************/
	/******************************************* JOB ISSUE MASTER ****************************************************************/
		public function job_issue_master()
		{
			if(sessionExist()) 
			{
				if ($_GET['action'] == 'view') 
				{
					$config 				= array();
					$config 				= $this->config->item('pagination');
					$config['total_rows'] 	= $this->productionmdl->get_all_job_issue_data_cnt();
					$config['base_url'] 	= base_url("production/productionctrl/job_issue_master?search=true");

					foreach ($_GET as $key => $value) 
					{
						if($key != 'search' && $key != 'offset')
						{
							$config['base_url'] .= "&" . $key . "=" .$value;
						}
					}

					$offset = (!empty($_GET['offset'])) ? $_GET['offset'] : 0;
					$this->pagination->initialize($config);

					$record['count'] 				= $offset;
					$record['total_rows'] 			= $config['total_rows'];
					$record['data']					= $this->productionmdl->get_all_job_issue_data($config['per_page'],$offset);
					// echo "<pre>"; print_r($record); exit;
					
					$this->load->view('pages/production/job_issue_master', $record);
				}
				elseif($_GET['action'] == 'add')
				{
					$record = $this->productionmdl->add_job_issue_master();
					// echo "<pre>"; print_r($record); exit;
					$this->load->view('pages/production/job_issue_form', $record);
				}
				elseif($_GET['action'] == 'edit')
				{
					$jim_id = encrypt_decrypt("decrypt", $_GET['id'], SECRET_KEY);
					$record = $this->productionmdl->edit_job_issue_master($jim_id);
					// echo "<pre>"; print_r($record); exit;
					$this->load->view('pages/production/job_issue_form', $record);
				}
				else if($_GET['action'] == 'print')
				{
					$jim_id = encrypt_decrypt("decrypt", $_GET['id'], SECRET_KEY);
					$record = $this->productionmdl->get_single_job_issue_data_for_print($jim_id);
					// echo "<pre>"; print_r($record); exit;	
					$this->load->view('pdfs/production/job_issue_print', $record);
				}
				else
				{
					$this->load->view('errors/error');	
				}
			} 
			else 
			{
				redirect('loginctrl/logout');	
			}
		}
		public function get_barcode_detail($bm_id)
		{
			if(sessionExist()) {
				$record = $this->productionmdl->get_barcode_detail($bm_id);
				// echo "<pre>";print_r($record);exit();
				echo json_encode($record);
			} else {
				redirect('loginctrl/logout');
			}
		}
		
		public function insert_update_job_issue_trans($form_data, $jim_id)
		{	
			// 0 = not avialable
			// 1 = avialable
			$flag = 0;
			$jit_db_data = $this->db_operations->get_record('job_issue_trans',array('jit_jim_id' =>$jim_id)); // get all db record first and all form data and match who is missing and those data delete by system  
			// echo "<pre>"; print_r($jit_db_data);
			// echo "<pre>"; print_r($form_data); exit(); 

			foreach ($jit_db_data as $key => $value) 
			{
				if (!in_array($value['jit_id'], $form_data['jit_id'])) 
				{	
					/*delete transactions*/			
					// $ot_data = $this->db_operations->get_record('barcode_master', ['bm_id'=>$value['jit_bm_id']]);
					// if(!empty($ot_data))
					// {
					// 	$this->db_operations->data_update('order_trans', ['ot_status' => 0, 'ot_in_out' => 0, 'ot_jim_id'=>$jim_id, 'ot_jit_id'=>$flag], 'ot_id', $ot_data[0]['bm_ot_id']);
					// }
					

					// $this->db_operations->data_update('barcode_master', ['bm_status' => 1, 'bm_in_out' => 1, 'bm_jim_id'=>$jim_id, 'bm_jit_id'=>$flag]);
					$del_res = $this->db_operations->delete_record('job_issue_trans',array('jit_id' =>$value['jit_id']));
				}
				
			}

			foreach ($form_data['jit_id'] as $key => $value) 
			{
				// echo "<pre>"; print_r($value); 
				/*purchase transaction data*/
				$jit_trans_data = array();
				
				$jit_trans_data['jit_jim_id'] 		  	= $jim_id;
				$jit_trans_data['jit_bm_id']	 	 	= $form_data['jit_bm_id'][$key];
				$jit_trans_data['jit_km_id']	 	 	= $form_data['jit_km_id'][$key];;
				$jit_trans_data['jit_process_id'] 	 	= $form_data['jit_process_id'][$key];;
				$jit_trans_data['jit_status'] 	 		= $form_data['jit_status'][$key];;
				$jit_trans_data['jit_notes']	 	 	= $form_data['jit_notes'][$key];;
				if ($value == 0) 
				{
					/*sale transaction insert process*/

					// echo "<pre>"; print_r('111'); 


					$flag = $this->db_operations->data_insert('job_issue_trans', $jit_trans_data);

					// echo "<pre>"; print_r($flag); exit(); 


					if($flag < 1)
					{	
						return 0;
					}
					else
					{
						$ot_data = $this->db_operations->get_record('barcode_master', ['bm_id'=>$form_data['jit_bm_id'][$key]]);
						if(!empty($ot_data))
						{
							$this->db_operations->data_update('order_trans', ['ot_trial_status' => $jit_trans_data['jit_status'],'ot_status' => 1, 'ot_in_out' => 1, 'ot_jim_id'=>$jim_id, 'ot_jit_id'=>$flag], 'ot_id', $ot_data[0]['bm_ot_id']);
						}
						

						$this->db_operations->data_update('barcode_master', ['bm_trial_status' => $jit_trans_data['jit_status'], 'bm_status' => 1, 'bm_in_out' => 1, 'bm_jim_id'=>$jim_id, 'bm_jit_id'=>$flag, 'bm_km_id'=>$jit_trans_data['jit_km_id'], 'bm_process_id'=>$jit_trans_data['jit_process_id']], 'bm_id', $jit_trans_data['jit_bm_id']);						
					}
				} 
				else 
				{
					/*purchase transaction update process*/
					// echo "<pre>"; print_r('222'); 

					$flag = $this->db_operations->data_update('job_issue_trans',$jit_trans_data,'jit_id',$value);
					if($flag < 1)
					{	
						return 0;
					}
					else
					{
						$ot_data = $this->db_operations->get_record('barcode_master', ['bm_id'=>$form_data['jit_bm_id'][$key]]);
						if(!empty($ot_data))
						{
							$this->db_operations->data_update('order_trans', ['ot_trial_status' => $jit_trans_data['jit_status'],'ot_status' => 1, 'ot_in_out' => 1, 'ot_jim_id'=>$jim_id, 'ot_jit_id'=>$value], 'ot_id', $ot_data[0]['bm_ot_id']);
						}
						

						$this->db_operations->data_update('barcode_master', ['bm_trial_status' => $jit_trans_data['jit_status'],'bm_status' => 1, 'bm_in_out' => 1, 'bm_jim_id'=>$jim_id, 'bm_jit_id'=>$flag, 'bm_km_id'=>$jit_trans_data['jit_km_id'], 'bm_process_id'=>$jit_trans_data['jit_process_id']], 'bm_id', $jit_trans_data['jit_bm_id']);
						
					}
				}			
			}
			// echo "<pre>"; print_r($flag);
			// exit();
			return $flag;
			
		}
	/******************************************* JOB ISSUE MASTER ****************************************************************/

	/******************************************* JOB RECEIVE MASTER **************************************************************/
		public function job_receive_master()
		{
			if(sessionExist()) 
			{
				if ($_GET['action'] == 'view') 
				{
					$config 				= array();
					$config 				= $this->config->item('pagination');
					$config['total_rows'] 	= $this->productionmdl->get_all_job_receive_data_cnt();
					$config['base_url'] 	= base_url("production/productionctrl/job_receive_master?search=true");

					foreach ($_GET as $key => $value) 
					{
						if($key != 'search' && $key != 'offset')
						{
							$config['base_url'] .= "&" . $key . "=" .$value;
						}
					}

					$offset = (!empty($_GET['offset'])) ? $_GET['offset'] : 0;
					$this->pagination->initialize($config);

					$record['count'] 				= $offset;
					$record['total_rows'] 			= $config['total_rows'];
					$record['data']					= $this->productionmdl->get_all_job_receive_data($config['per_page'],$offset);
					// echo "<pre>"; print_r($record); exit;
					
					$this->load->view('pages/production/job_receive_master', $record);
				}
				elseif($_GET['action'] == 'add')
				{
					$record = $this->productionmdl->add_job_receive_master();
					// echo "<pre>"; print_r($record); exit;
					$this->load->view('pages/production/job_receive_form', $record);
				}
				elseif($_GET['action'] == 'edit')
				{
					$jim_id = encrypt_decrypt("decrypt", $_GET['id'], SECRET_KEY);
					$record = $this->productionmdl->edit_job_receive_master($jim_id);
					// echo "<pre>"; print_r($record); exit;
					$this->load->view('pages/production/job_receive_form', $record);
				}
				else
				{
					$this->load->view('errors/error');	
				}
			} 
			else 
			{
				redirect('loginctrl/logout');	
			}
		}
		public function get_job_issue_detail($bm_id)
		{
			if(sessionExist()) 
			{
				$record = $this->productionmdl->get_job_issue_detail($bm_id);
				echo json_encode($record);
			} 
			else 
			{
				redirect('loginctrl/logout');
			}
		}
		
		public function insert_update_job_receive_trans($form_data, $jrm_id)
		{	
			// 0 = not avialable
			// 1 = avialable
			$flag = 0;
			$jrt_db_data = $this->db_operations->get_record('job_receive_trans',array('jrt_jrm_id' =>$jrm_id)); // get all db record first and all form data and match who is missing and those data delete by system  
			// echo "<pre>"; print_r($jrt_db_data);
			// echo "<pre>"; print_r($form_data); exit(); 

			foreach ($jrt_db_data as $key => $value) 
			{
				if (!in_array($value['jrt_id'], $form_data['jrt_id'])) 
				{	
					/*delete transactions*/			
					// $ot_data = $this->db_operations->get_record('barcode_master', ['bm_id'=>$value['jit_bm_id']]);
					// if(!empty($ot_data))
					// {
					// 	$this->db_operations->data_update('order_trans', ['ot_status' => 0, 'ot_in_out' => 0, 'ot_jim_id'=>$jim_id, 'ot_jit_id'=>$flag], 'ot_id', $ot_data[0]['bm_ot_id']);
					// }
					

					// $this->db_operations->data_update('barcode_master', ['bm_status' => 1, 'bm_in_out' => 1, 'bm_jim_id'=>$jim_id, 'bm_jit_id'=>$flag]);
					$del_res = $this->db_operations->delete_record('job_receive_trans',array('jrt_id' =>$value['jrt_id']));
				}
				
			}

			foreach ($form_data['jrt_id'] as $key => $value) 
			{
				// echo "<pre>"; print_r($value); 
				/*purchase transaction data*/
				$ot_data = $this->db_operations->get_record('barcode_master', ['bm_id'=>$form_data['jrt_ot_id'][$key]]);
				$jrt_trans_data = array();
				
				$jrt_trans_data['jrt_jrm_id'] 		  	= $jrm_id;
				$jrt_trans_data['jrt_bm_id']	 	 	= $form_data['jrt_bm_id'][$key];
				$jrt_trans_data['jrt_km_id']	 	 	= $form_data['jrt_km_id'][$key];
				$jrt_trans_data['jrt_process_id']	 	= $form_data['jrt_process_id'][$key];
				$jrt_trans_data['jrt_status']	 	 	= $form_data['jrt_status'][$key];
				$jrt_trans_data['jrt_notes']	 	 	= $form_data['jrt_notes'][$key];
				if(!empty($ot_data))
				{
					$jrt_trans_data['jrt_jim_id']	 	 	= $ot_data[0]['bm_jim_id'];
					$jrt_trans_data['jrt_jit_id']	 	 	= $ot_data[0]['bm_jit_id'];
				}
				if ($value == 0) 
				{
					/*sale transaction insert process*/

					// echo "<pre>"; print_r('111'); 


					$flag = $this->db_operations->data_insert('job_receive_trans', $jrt_trans_data);

					// echo "<pre>"; print_r($flag); exit(); 


					if($flag < 1)
					{	
						return 0;
					}
					else
					{
						
						if(!empty($ot_data))
						{
							if($jrt_trans_data['jrt_status'] == 1)
							{
								$this->db_operations->data_update('order_trans', ['ot_trial_status' => 1, 
																				'ot_status' => $jrt_trans_data['jrt_status'], 
																				'ot_in_out' => 0, 
																				'ot_jrm_id'=>$jrm_id, 
																				'ot_jrt_id'=>$flag, 
																				'ot_jim_id'=>$ot_data[0]['bm_jim_id'], 
																				'ot_jit_id'=>$ot_data[0]['bm_jit_id']], 
																'ot_id', $ot_data[0]['bm_ot_id']);
							}
							else
							{
								$this->db_operations->data_update('order_trans', ['ot_status' => $jrt_trans_data['jrt_status'], 
																				'ot_in_out' => 0, 
																				'ot_jrm_id'=>$jrm_id, 
																				'ot_jrt_id'=>$flag, 
																				'ot_jim_id'=>$ot_data[0]['bm_jim_id'], 
																				'ot_jit_id'=>$ot_data[0]['bm_jit_id']], 
																'ot_id', $ot_data[0]['bm_ot_id']);
							}
						}
						
						if($jrt_trans_data['jrt_status'] == 1)
						{
							$this->db_operations->data_update('barcode_master', ['bm_trial_status' => 1, 
																				'bm_status' => $jrt_trans_data['jrt_status'], 
																				'bm_in_out' => 0, 
																				'bm_jrm_id'=>$jrm_id, 
																				'bm_jrt_id'=>$flag, 
																				'bm_km_id'=>$jrt_trans_data['jrt_km_id']], 
																'bm_id', $jrt_trans_data['jrt_bm_id']);		
						}
						else
						{
							$this->db_operations->data_update('barcode_master', ['bm_status' => $jrt_trans_data['jrt_status'], 
																				'bm_in_out' => 0, 
																				'bm_jrm_id'=>$jrm_id, 
																				'bm_jrt_id'=>$flag, 
																				'bm_km_id'=>$jrt_trans_data['jrt_km_id']], 
																'bm_id', $jrt_trans_data['jrt_bm_id']);		
						}				
					}
				} 
				else 
				{
					/*purchase transaction update process*/
					// echo "<pre>"; print_r('222'); 

					$flag = $this->db_operations->data_update('job_receive_trans',$jrt_trans_data,'jrt_id',$value);
					if($flag < 1)
					{	
						return 0;
					}
					else
					{
						if(!empty($ot_data))
						{
							if($jrt_trans_data['jrt_status'] == 1)
							{
								$this->db_operations->data_update('order_trans', ['ot_trial_status' => 1, 
																				'ot_status' => $jrt_trans_data['jrt_status'], 
																				'ot_in_out' => 0, 
																				'ot_jrm_id'=>$jrm_id, 
																				'ot_jrt_id'=>$flag, 
																				'ot_jim_id'=>$ot_data[0]['bm_jim_id'], 
																				'ot_jit_id'=>$ot_data[0]['bm_jit_id']], 
																'ot_id', $ot_data[0]['bm_ot_id']);
							}
							else
							{
								$this->db_operations->data_update('order_trans', ['ot_status' => $jrt_trans_data['jrt_status'], 
																				'ot_in_out' => 0, 
																				'ot_jrm_id'=>$jrm_id, 
																				'ot_jrt_id'=>$flag, 
																				'ot_jim_id'=>$ot_data[0]['bm_jim_id'], 
																				'ot_jit_id'=>$ot_data[0]['bm_jit_id']], 
																'ot_id', $ot_data[0]['bm_ot_id']);
							}
						}
						

						if($jrt_trans_data['jrt_status'] == 1)
						{
							$this->db_operations->data_update('barcode_master', ['bm_trial_status' => 1, 
																				'bm_status' => $jrt_trans_data['jrt_status'], 
																				'bm_in_out' => 0, 
																				'bm_jrm_id'=>$jrm_id, 
																				'bm_jrt_id'=>$flag, 
																				'bm_km_id'=>$jrt_trans_data['jrt_km_id']], 
																'bm_id', $jrt_trans_data['jrt_bm_id']);		
						}
						else
						{
							$this->db_operations->data_update('barcode_master', ['bm_status' => $jrt_trans_data['jrt_status'], 
																				'bm_in_out' => 0, 
																				'bm_jrm_id'=>$jrm_id, 
																				'bm_jrt_id'=>$flag, 
																				'bm_km_id'=>$jrt_trans_data['jrt_km_id']], 
																'bm_id', $jrt_trans_data['jrt_bm_id']);		
						}
						
					}
				}			
			}
			// echo "<pre>"; print_r($flag);
			// exit();
			return $flag;
			
		}
	/******************************************* JOB RECEIVE MASTER **************************************************************/

	/****************** JOB STATUS MASTER *********************************************************************************************/
		public function job_status_master()
		{
			if(sessionExist()) 
			{
				if ($_GET['action'] == 'view') 
				{
					$config 				= array();
					$config 				= $this->config->item('pagination');
					$config['total_rows'] 	= $this->productionmdl->get_all_job_status_data_cnt();
					$config['base_url'] 	= base_url("production/productionctrl/job_status_master?search=true");

					foreach ($_GET as $key => $value) 
					{
						if($key != 'search' && $key != 'offset')
						{
							$config['base_url'] .= "&" . $key . "=" .$value;
						}
					}

					$offset = (!empty($_GET['offset'])) ? $_GET['offset'] : 0;
					$this->pagination->initialize($config);

					$record['count'] 		= $offset;
					$record['total_rows'] 	= $config['total_rows'];
					$record['data']			= $this->productionmdl->get_all_job_status_data($config['per_page'],$offset);
					// echo "<pre>"; print_r($record); exit;
					
					$this->load->view('pages/production/job_status_master', $record);
				}
				else
				{
					$this->load->view('errors/error');	
				}
			} 
			else 
			{
				redirect('loginctrl/logout');	
			}
		}


		public function job_tot_xls()
		{	
			if(sessionExist()) 
			{
				$this->load->library('excel');
	            $this->excel->setActiveSheetIndex(0);
	            $this->excel->getActiveSheet()->setTitle("TOTAL ORDER".$_SESSION['fin_year']); 

				$record = $this->productionmdl->get_job_status_tot_xls();
				
				// echo "<pre>"; print_r($record); exit();

				$rowCount = 1;
	            foreach ($record['excel_array'] as $key => $data) 
	            {
	                /*SET COLUMN WIDTH AND DATA*/
	                foreach(range('A','R') as $key => $columnID)
	                {
	                    /*set coulumn width*/
	                    $this->excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
	                    
	                    /*set column data*/
	                    $this->excel->getActiveSheet()->SetCellValue($columnID.$rowCount, $data[$key]);
	                }
	                $rowCount++; 
	            }

	            $filename='job_status_total_orders'.date('dMY').'.csv'; //save our workbook as this file name
	            header('Content-Type: application/vnd.ms-excel'); //mime type
	            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	            header('Cache-Control: max-age=0'); //no cache
	            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
	            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel2007');
	            // Write the Excel file to filename some_excel_file.xlsx in the current directory
	            $objWriter->save('php://output');

				// echo "<pre>"; print_r($record); exit();
				// $this->load->view('pages/master/index');
				// $this->load->view('pages/master/trial_dashboard',$record);
			} else {
				redirect('loginctrl/logout');	
			}
		}

		public function job_complete_xls()
		{	
			if(sessionExist()) 
			{
				$this->load->library('excel');
	            $this->excel->setActiveSheetIndex(0);
	            $this->excel->getActiveSheet()->setTitle("TOTAL ORDER".$_SESSION['fin_year']); 

				$record = $this->productionmdl->get_job_status_complete_xls();
				// echo "<pre>"; print_r($record); exit();

				$rowCount = 1;
	            foreach ($record['excel_array'] as $key => $data) 
	            {
	                /*SET COLUMN WIDTH AND DATA*/
	                foreach(range('A','R') as $key => $columnID) {
	                    /*set coulumn width*/
	                    $this->excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
	                    
	                    /*set column data*/
	                    $this->excel->getActiveSheet()->SetCellValue($columnID.$rowCount, $data[$key]);
	                }
	                $rowCount++; 
	            }

	            $filename='job_status_complete_orders'.date('dMY').'.csv'; //save our workbook as this file name
	            header('Content-Type: application/vnd.ms-excel'); //mime type
	            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	            header('Cache-Control: max-age=0'); //no cache
	            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
	            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel2007');
	            // Write the Excel file to filename some_excel_file.xlsx in the current directory
	            $objWriter->save('php://output');

				// echo "<pre>"; print_r($record); exit();
				// $this->load->view('pages/master/index');
				// $this->load->view('pages/master/trial_dashboard',$record);
			} else {
				redirect('loginctrl/logout');	
			}
		}

		public function job_inprocess_xls()
		{	
			if(sessionExist()) 
			{
				$this->load->library('excel');
	            $this->excel->setActiveSheetIndex(0);
	            $this->excel->getActiveSheet()->setTitle("TOTAL ORDER".$_SESSION['fin_year']); 

				$record = $this->productionmdl->get_job_status_inprocess_xls();
				
				// echo "<pre>"; print_r($record); exit();

				$rowCount = 1;
	            foreach ($record['excel_array'] as $key => $data) 
	            {
	                /*SET COLUMN WIDTH AND DATA*/
	                foreach(range('A','R') as $key => $columnID)
	                {
	                    /*set coulumn width*/
	                    $this->excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
	                    
	                    /*set column data*/
	                    $this->excel->getActiveSheet()->SetCellValue($columnID.$rowCount, $data[$key]);
	                }
	                $rowCount++; 
	            }

	            $filename='job_status_inprocess_orders'.date('dMY').'.csv'; //save our workbook as this file name
	            header('Content-Type: application/vnd.ms-excel'); //mime type
	            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	            header('Cache-Control: max-age=0'); //no cache
	            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
	            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel2007');
	            // Write the Excel file to filename some_excel_file.xlsx in the current directory
	            $objWriter->save('php://output');

				// echo "<pre>"; print_r($record); exit();
				// $this->load->view('pages/master/index');
				// $this->load->view('pages/master/trial_dashboard',$record);
			} else {
				redirect('loginctrl/logout');	
			}
		}

		public function job_pending_xls()
		{	
			if(sessionExist()) 
			{
				$this->load->library('excel');
	            $this->excel->setActiveSheetIndex(0);
	            $this->excel->getActiveSheet()->setTitle("TOTAL ORDER".$_SESSION['fin_year']); 

				$record = $this->productionmdl->get_job_status_pending_xls();
				
				// echo "<pre>"; print_r($record); exit();

				$rowCount = 1;
	            foreach ($record['excel_array'] as $key => $data) 
	            {
	                /*SET COLUMN WIDTH AND DATA*/
	                foreach(range('A','R') as $key => $columnID)
	                {
	                    /*set coulumn width*/
	                    $this->excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
	                    
	                    /*set column data*/
	                    $this->excel->getActiveSheet()->SetCellValue($columnID.$rowCount, $data[$key]);
	                }
	                $rowCount++; 
	            }

	            $filename='job_status_pending_orders'.date('dMY').'.csv'; //save our workbook as this file name
	            header('Content-Type: application/vnd.ms-excel'); //mime type
	            header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	            header('Cache-Control: max-age=0'); //no cache
	            // Instantiate a Writer to create an OfficeOpenXML Excel .xlsx file
	            $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel2007');
	            // Write the Excel file to filename some_excel_file.xlsx in the current directory
	            $objWriter->save('php://output');

				// echo "<pre>"; print_r($record); exit();
				// $this->load->view('pages/master/index');
				// $this->load->view('pages/master/trial_dashboard',$record);
			} else {
				redirect('loginctrl/logout');	
			}
		}

	/****************** JOB STATUS MASTER *********************************************************************************************/
}
?>
