<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mastermdl extends CI_model{

	public function get_cnt($table, $arr){

		$this->db->where($arr);
		return $this->db->count_all_results($table);
	}
	public function get_user($email){

		$this->db->where(array('user_name' => $email));
		return $this->db->get('user_master')->result_array();
	}


    /***************************** Account Master Start *****************************/
    public function get_account_data($type)
    {
        $subsql = '';
        if($type != 0)
        {
            $subsql .= " WHERE a.acc_grp_id=$type";
        }
        else
        {
            $subsql .= " WHERE a.acc_grp_id NOT IN(5,6,23)";    
        }
        return $this->db->query("SELECT a.*,g.grp_name FROM account_master a INNER JOIN group_master g ON(a.acc_grp_id=g.grp_id) $subsql ORDER BY a.acc_name")->result_array();
    }
    
    public function get_acc_name_first_letter($acc_id)
    {
        return $this->db->query("SELECT SUBSTRING(acc_name ,1,1)  FROM account_master WHERE acc_id='$acc_id'")->result_array();
    }

    public function get_max_acc_code_supp($acc_name)
    {
        $acc_name = substr($acc_name,0,1);
        
        $max_id = $this->db->query("SELECT MAX(acc_code) as acc_code FROM account_master WHERE acc_name LIKE '$acc_name%' AND acc_grp_id = 6 ")->result_array();
        
        if(empty($max_id[0]['acc_code']))
        {
            $max_id = 1000;
        }
        else
        {
            $max_id = $max_id[0]['acc_code']+1;
        }
        return $max_id;
    }

    public function get_group_list()
    {
        return $this->db->query("SELECT g.* FROM group_master g WHERE g.grp_id NOT IN(5,6,23)")->result_array();
    }

	public function get_client_data_count($fin_year)
	{
		$subsql = '';

		if(isset($_GET['field']) && isset($_GET['keyword']))
		{
			$field    = $_GET['field'];
	  	    $keyword  = $_GET['keyword'];

  	          if(!empty($field) && !empty($keyword))
  	          {
  	            	if ($field == 'client_dob')
  	              {
  	                  $subsql .= "AND $field like '%".date('Y-m-d',strtotime($keyword))."%'";
  	              }
  	              else if (!empty($field) && !empty($keyword))
  	              {
  	                 $subsql .= " AND ".$_GET['field']." like '%".$_GET['keyword']."%'";
  	              }
  	          }
		}

		$query = "SELECT *,cm.country_name FROM client_master c LEFT JOIN country_master cm ON(c.client_country = cm.country_id) WHERE 1 $subsql";

		return $this->db->query($query)->num_rows();
	}	

	public function get_client_data($fin_year,$per_page,$offset)
	{
		$subsql = '';

		if(isset($_GET['field']) && isset($_GET['keyword']))
		{
			$field    = $_GET['field'];
	  	    $keyword  = $_GET['keyword'];

  	          if(!empty($field) && !empty($keyword))
  	          {
  	            	if ($field == 'client_dob')
  	              {
  	                  $subsql .= "AND $field like '%".date('Y-m-d',strtotime($keyword))."%'";
  	              }
  	              else if (!empty($field) && !empty($keyword))
  	              {
  	                 $subsql .= " AND ".$_GET['field']." like '%".$_GET['keyword']."%'";
  	              }
  	          }
		}

		$query = "SELECT c.*,ct.city_name,a.area_name,s.state_name,cm.country_name FROM client_master c LEFT JOIN city_master ct ON(c.client_city = ct.city_id) LEFT JOIN country_master cm ON(c.client_country = cm.country_id) LEFT JOIN area_master a ON (c.client_area = a.area_id) LEFT JOIN state_master s ON (c.client_state = s.state_id) WHERE 1 $subsql ORDER BY client_id DESC  LIMIT $per_page OFFSET $offset";

		$record['client_data'] = $this->db->query($query)->result_array();

		return $record;
	}	

	public function get_data_for_client_entry($fin_year)
	{
		$record =array();

		$designer = $this->db->query("SELECT user_id,user_full_name FROM user_master WHERE user_role_id = 3")->result_array();
		$record['designer_data'][0] = "Please Select";
		foreach ($designer as $key => $value) {
			$record['designer_data'][$value['user_id']] = $value['user_full_name'];
		}

		$customer = $this->db->query("SELECT client_id,client_name FROM client_master ORDER BY client_name ASC")->result_array();
		$record['client'][0] = "Please Select";
		foreach ($customer as $key => $value) {
			$record['client'][$value['client_id']] = $value['client_name'];
		}

		$city = $this->db->query("SELECT city_id,city_name FROM city_master ORDER BY city_name ASC")->result_array();
		$record['city'][0] = "Please Select";
		foreach ($city as $key => $value) {
			$record['city'][$value['city_id']] = $value['city_name'];
		}

        $country = $this->db->query("SELECT country_id,country_name FROM country_master ORDER BY country_name ASC")->result_array();
        $record['country'][0] = "Please Select";
        foreach ($country as $key => $value) {
            $record['country'][$value['country_id']] = $value['country_name'];
        }

		$area = $this->db->query("SELECT area_id,area_name FROM area_master ORDER BY area_name ASC")->result_array();
		$record['area'][0] = "Please Select";
		foreach ($area as $key => $value) {
			$record['area'][$value['area_id']] = $value['area_name'];
		}

		$state = $this->db->query("SELECT state_id,state_name FROM state_master ORDER BY state_name ASC")->result_array();
		$record['state'][0] = "Please Select";
		foreach ($state as $key => $value) {
			$record['state'][$value['state_id']] = $value['state_name'];
		}

        $measurement_query = "SELECT mm.mm_id, app.app_name
                                FROM measurement_master mm
                                LEFT JOIN apparel_master app ON(app.app_id = mm.mm_app_id)
                            ";
        $measurement_data  = $this->db->query($measurement_query)->result_array();
        if(!empty($measurement_data))
        {
            $record['measurement_data'][0] = 'PLEASE SELECT';
            foreach ($measurement_data as $key => $value) 
            {
                $record['measurement_data'][$value['mm_id']] = strtoupper($value['app_name']);
            }
        }
        else
        {
            $record['measurement_data'][0] = 'NO MEASUREMENT ADDED';
        }

			$years = range('2017', date('Y'));
			$range = array();
			$size = sizeOf($years);

			$desc_year = array_reverse($years);

			foreach ($desc_year as $key => $value) 
			{
				$range[$value] = $value;
			}
			

		$record['year'] = $range;

		$record['category'] = $this->config->item('category');

		$client_maxid = $this->db_operations->get_max_id("client_master",'client_accno');

		($client_maxid==0) ? $record['client_maxid'] = 1000 : $record['client_maxid'] = $client_maxid + 1;


		return $record;
	}

    public function get_measurement_data_by_apparel($mm_id)
    {
        $query = "SELECT 
                    app.app_id, app.app_name, 
                    mt.mt_id, mt.mt_mm_id, maap.maap_id, maap.maap_name
                FROM 
                    measurement_trans mt
                LEFT JOIN
                    measurement_master mm ON(mt.mt_mm_id = mm.mm_id)
                LEFT JOIN 
                    apparel_master app ON(mm.mm_app_id = app.app_id)
                LEFT JOIN 
                    maap_master maap ON(maap.maap_id = mt.mt_maap_id)
                WHERE 
                    mt.mt_mm_id = $mm_id
                ORDER BY
                    mt.mt_id ASC 
                ";
        // echo "<pre>"; print_r($query); exit();
        $record = $this->db->query($query)->result_array();
        return $record;
    }

    public function get_measurement_data_by_apparel_style($mm_id)
    {
        $query = "SELECT 
                    app.app_id, app.app_name, 
                    mst.mst_id, mst.mst_mm_id,sty.style_id,sty.style_name
                FROM 
                    measurement_style_trans mst
                LEFT JOIN
                    measurement_master mm ON(mst.mst_mm_id = mm.mm_id)
                LEFT JOIN 
                    apparel_master app ON(mm.mm_app_id = app.app_id)
                LEFT JOIN 
                    style_master sty ON(sty.style_id = mst.mst_style_id)
                WHERE 
                    mst.mst_mm_id = $mm_id
                ORDER BY
                    mst.mst_id ASC 
                ";
        // echo "<pre>"; print_r($query); exit();
        $record = $this->db->query($query)->result_array();
        return $record;
    }

	public function check_duplicate_client_name($name)
	{
		return $this->db->query("SELECT client_id from client_master WHERE client_name = '$name'")->num_rows();
	}

	public function check_duplicate_client_mobile($mobile)
	{
		return $this->db->query("SELECT client_id from client_master WHERE client_mobile1 = '$mobile'")->num_rows();
	}

	public function check_edit_duplicate_client_name($name,$id)
    {
        $query = "SELECT client_id from client_master WHERE client_name = '$name' and client_id != $id";
        return $this->db->query($query)->num_rows();
    }

    public function check_edit_duplicate_client_mobile($mobile,$id)
    {
        return $this->db->query("SELECT client_id from client_master WHERE client_mobile1 = '$mobile' and client_id != $id")->num_rows();
    }

    public function get_single_client_data_for_update($client_id)
    {
    	$record =array();

    	$designer = $this->db->query("SELECT user_id,user_full_name FROM user_master WHERE user_role_id = 3")->result_array();
		$record['designer_data'][0] = "Please Select";
		foreach ($designer as $key => $value) {
			$record['designer_data'][$value['user_id']] = $value['user_full_name'];
		}

		$customer = $this->db->query("SELECT client_id,client_name FROM client_master ORDER BY client_name ASC")->result_array();
		foreach ($customer as $key => $value) {
			$record['client'][$value['client_id']] = $value['client_name'];
		}

		$client_query = "SELECT * FROM client_master WHERE client_id = $client_id";
		$record['client_data'] = $this->db->query($client_query)->result_array();

		$client_trans_query = "SELECT ct.*, app.app_name
                        FROM client_trans ct
                        LEFT JOIN apparel_master app ON(app.app_id = ct.ct_app_id)
                        WHERE ct.ct_client_id = $client_id
                        ";
        $record['client_trans_data'] = $this->db->query($client_trans_query)->result_array();

        foreach ($record['client_trans_data'] as $key => $value) 
        {
            // echo "<pre>"; print_r($value);

            $record['client_trans_data'][$key]['maap_data'] = $this->db->query("
                SELECT 
                    maap.maap_name 
                FROM 
                    measurement_master mm 
                LEFT JOIN 
                    measurement_trans mt ON(mt.mt_mm_id = mm.mm_id)
                LEFT JOIN 
                    maap_master maap ON(maap.maap_id = mt.mt_maap_id)
                WHERE 
                    mm.mm_id=".$value['ct_mm_id'] ."
                ORDER BY 
                    mt.mt_id ASC
                ")->result_array(); 

            // echo "<pre>"; print_r($result['cm_mstr_data']); exit();

        }

        foreach ($record['client_trans_data'] as $key => $value) 
        {
            // echo "<pre>"; print_r($value);

            $record['client_trans_data'][$key]['style_data'] = $this->db->query("
                SELECT 
                    sty.style_name 
                FROM 
                    measurement_master mm 
                LEFT JOIN 
                    measurement_style_trans mst ON(mst.mst_mm_id = mm.mm_id)
                LEFT JOIN 
                    style_master sty ON(sty.style_id = mst.mst_style_id)
                WHERE 
                    mm.mm_id=".$value['ct_mm_id'] ."
                ORDER BY 
                    mst.mst_id ASC
                ")->result_array(); 

            // echo "<pre>"; print_r($result['cm_mstr_data']); exit();

        }


		$city = $this->db->query("SELECT city_id,city_name FROM city_master ORDER BY city_name ASC")->result_array();
		$record['city'][0] = "Please Select";
		foreach ($city as $key => $value) {
			$record['city'][$value['city_id']] = $value['city_name'];
		}

		$area = $this->db->query("SELECT area_id,area_name FROM area_master ORDER BY area_name ASC")->result_array();
		$record['area'][0] = "Please Select";
		foreach ($area as $key => $value) {
			$record['area'][$value['area_id']] = $value['area_name'];
		}

        $country = $this->db->query("SELECT country_id,country_name FROM country_master ORDER BY country_name ASC")->result_array();
        $record['country'][0] = "Please Select";
        foreach ($country as $key => $value) {
            $record['country'][$value['country_id']] = $value['country_name'];
        }

		$state = $this->db->query("SELECT state_id,state_name FROM state_master ORDER BY state_name ASC")->result_array();
		$record['state'][0] = "Please Select";
		foreach ($state as $key => $value) {
			$record['state'][$value['state_id']] = $value['state_name'];
		}

        $measurement_query = "SELECT mm.mm_id, app.app_name
                                FROM measurement_master mm
                                LEFT JOIN apparel_master app ON(app.app_id = mm.mm_app_id)
                            ";
        $measurement_data  = $this->db->query($measurement_query)->result_array();
        if(!empty($measurement_data))
        {
            $record['measurement_data'][0] = 'PLEASE SELECT';
            foreach ($measurement_data as $key => $value) 
            {
                $record['measurement_data'][$value['mm_id']] = strtoupper($value['app_name']);
            }
        }
        else
        {
            $record['measurement_data'][0] = 'NO MEASUREMENT ADDED';
        }


			$years = range('2017', date('Y'));
			$range = array();
			$size = sizeOf($years);

			$desc_year = array_reverse($years);

			foreach ($desc_year as $key => $value) 
			{
				$range[$value] = $value;
			}
			

		$record['year'] = $range;

		$record['category'] = $this->config->item('category');


		return $record;
	}
	
/************************ Maap MASTER *******************************/
    public function get_all_maap_data_cnt()
    {
        // echo "<pre>"; print_r($_GET); exit;
        $subsql = "";
        if(!empty($_GET['search_value_by_maap_id']))
        {
            $subsql .= " AND maap_id =". $_GET['search_value_by_maap_id'];
        }        
        return $this->db->query("SELECT * FROM maap_master WHERE 1 $subsql")->num_rows();
    }
    public function get_all_maap_data($per_page, $offset)
    {
        $subsql = "";
        if(!empty($_GET['search_value_by_maap_id']))
        {
            $subsql .= " AND maap_id =". $_GET['search_value_by_maap_id'];
        } 
        $record['maap_data'] = $this->db->query("SELECT * FROM maap_master WHERE 1 $subsql ORDER BY maap_id DESC LIMIT $per_page OFFSET $offset")->result_array();

        foreach ($record['maap_data'] as $key => $value) 
        {
            $record['maap_data'][$key]['is_exists'] = $this->db_operations->get_cnt('measurement_trans', ['mt_maap_id'=>$value['maap_id']]);
        }

        
        $maap_data = $this->db_operations->get_recordlist('maap_master');
        $record['maap_drop_down'][0] = 'All';
        foreach ($maap_data as $key => $value) 
        {
            $record['maap_drop_down'][$value['maap_id']] = strtoupper($value['maap_name']);
        }

        return $record;
    }
    function get_single_maap($maap_id)
    {
        $record= $this->db_operations->get_record('maap_master', ['maap_id' => $maap_id]);
        // $query = "SELECT ct.ct_mm_id FROM measurement_trans mt LEFT JOIN client_trans ct ON(ct.ct_mm_id = mt.mt_mm_id) WHERE mt.mt_maap_id = $maap_id";
        // $record['is_maap_exists'] = $this->db->query($query)->num_rows();

        return $record;
    }
/************************ /Maap MASTER *******************************/
/************************ measurement MASTER *******************************/
    public function get_all_measurement_data_cnt()
    {
        $subsql = "";            

        if(!empty($_GET['search_value_by_app_id']))
        {
            $subsql .= " AND mm.mm_app_id =".$_GET['search_value_by_app_id'];
        }
        
        return $this->db->query("SELECT mm.* 
                FROM measurement_master mm
                WHERE 1 $subsql
            ")->num_rows();
    }
    public function get_all_measurement_data($per_page, $offset)
    {
        $subsql = "";
        if(!empty($_GET['search_value_by_app_id']))
        {
            $subsql .= " AND mm.mm_app_id =".$_GET['search_value_by_app_id'];
        }
        
        $query = "SELECT mm.mm_id, app.app_name
                FROM measurement_master mm
                LEFT JOIN apparel_master app ON(app.app_id = mm.mm_app_id)
                WHERE 1 $subsql 
                ORDER BY mm.mm_id DESC
                LIMIT $per_page OFFSET $offset
            ";
            // echo $_GET['search_value_by_app_id'];exit;
        $record['measurement_data'] = $this->db->query($query)->result_array();

        
        // apparel drop down
        $apparel_query = "SELECT 
                                app.app_id, app.app_name 
                            FROM 
                                measurement_master mm 
                            LEFT JOIN
                                apparel_master app ON(app.app_id = mm.mm_app_id)
                            ORDER BY 
                                app.app_id ASC";
        $apparel_data = $this->db->query($apparel_query)->result_array();
        $record['apparel_drop_down'][0] = 'ALL';
        foreach ($apparel_data as $key => $value) 
        {
            $record['apparel_drop_down'][$value['app_id']] = strtoupper($value['app_name']);
        }
        // apparel drop down

        return $record;
    }
    public function get_measurement_data()
    {
        $record = [];

        $apparel_data = $this->db_operations->get_record('apparel_master', ['app_maap_req' => 0, 'app_status' => 1]);
        // echo "<pre>";print_r($apparel_data);exit;
        if(!empty($apparel_data))
        {
            $record['apparel_data'][0] = 'Please Select';
            foreach ($apparel_data as $key => $value) 
            {
                $cnt = $this->db_operations->get_cnt('measurement_master', ['mm_app_id'=>$value['app_id']]);
                if($cnt < 1)
                {
                    $record['apparel_data'][$value['app_id']] = strtoupper($value['app_name']);
                }
                
            }

            $record['apparel_data_copy'][0] = 'Please Select';
            foreach ($apparel_data as $key => $value) 
            {
                $cnt = $this->db_operations->get_cnt('measurement_master', ['mm_app_id'=>$value['app_id']]);
                if($cnt > 0)
                {
                    $record['apparel_data_copy'][$value['app_id']] = strtoupper($value['app_name']);
                }
                
            }
        }
        else
        {
            $record['apparel_data'][0] = 'No Apparel Added';
            $record['apparel_data_copy'][0] = 'No Apparel Added';

        }
        $record['maap_data'][0] = 'Select Apparel First';
        $record['style_data'][0] = 'Select Apparel First';



        return $record; 
    }
    public function get_single_measurement_data($mm_id)
    {
        $record = [];
        $master_query = "SELECT mm.*, app.* 
                        FROM measurement_master mm 
                        LEFT JOIN apparel_master app ON(app.app_id = mm.mm_app_id) 
                        WHERE mm.mm_id = $mm_id";
        $record['measurement_data'] = $this->db->query($master_query)->result_array();
        $record['measurement_data'][0]['is_mm_exists'] = 0;

        $trans_query = "SELECT mt.*, maap.* 
                        FROM measurement_trans mt
                        LEFT JOIN maap_master maap ON(maap.maap_id = mt.mt_maap_id)
                        WHERE mt.mt_mm_id = $mm_id";
        $record['measurement_trans_data'] = $this->db->query($trans_query)->result_array();

        $trans_style_query = "SELECT mst.*, sty.* 
                        FROM measurement_style_trans mst
                        LEFT JOIN style_master sty ON(sty.style_id = mst.mst_style_id)
                        WHERE mst.mst_mm_id = $mm_id";
        $record['measurement_style_trans_data'] = $this->db->query($trans_style_query)->result_array();


        foreach ($record['measurement_trans_data'] as $key => $value) 
        {
            $cnt = $this->db_operations->get_cnt('client_trans', ['ct_mm_id'=>$value['mt_mm_id']]);
            if($cnt > 0)
            {
                $record['measurement_data'][0]['is_mm_exists'] = 1;
            }
            
        }

        foreach ($record['measurement_style_trans_data'] as $key => $value) 
        {
            $cnt = $this->db_operations->get_cnt('client_trans', ['ct_mm_id'=>$value['mst_mm_id']]);
            if($cnt > 0)
            {
                $record['measurement_data'][0]['is_mm_exists'] = 1;
            }
            
        }

        $apparel_data = $this->db_operations->get_record('apparel_master', ['app_maap_req' => 0, 'app_status' => 1]);
        if(!empty($apparel_data))
        {
            $record['apparel_data'][0] = 'PLEASE SELECT';
            foreach ($apparel_data as $key => $value) 
            {
                $cnt = $this->db_operations->get_cnt('measurement_master', ['mm_app_id'=>$value['app_id']]);
                if($cnt < 1)
                {
                    $record['apparel_data'][$value['app_id']] = strtoupper($value['app_name']);
                }
            }

            $record['apparel_data_copy'][0] = 'Please Select';
            foreach ($apparel_data as $key => $value) 
            {
                $cnt = $this->db_operations->get_cnt('measurement_master', ['mm_app_id'=>$value['app_id']]);
                if($cnt > 0)
                {
                    $record['apparel_data_copy'][$value['app_id']] = strtoupper($value['app_name']);
                }
                
            }
        }
        else
        {
            $record['apparel_data'][0] = 'NO APPAREL ADDED';
            $record['apparel_data_copy'][0] = 'No Apparel Added';
        }
        foreach ($record['measurement_data'] as $key => $value) 
        {
            
            $record['apparel_data'][$value['app_id']] = strtoupper($value['app_name']);
           
        }
        $maap_data = $this->db_operations->get_recordlist('maap_master');
        if(!empty($maap_data))
        {
            $record['maap_data'][0] = 'PLEASE SELECT';
            foreach ($maap_data as $key => $value) 
            {
                $record['maap_data'][$value['maap_id']] = strtoupper($value['maap_name']);
            }
        }
        else
        {
            $record['maap_data'][0] = 'NO MAAP ADDED';
        }

        $style_data = $this->db_operations->get_recordlist('style_master');
        if(!empty($style_data))
        {
            $record['style_data'][0] = 'PLEASE SELECT';
            foreach ($style_data as $key => $value) 
            {
                $record['style_data'][$value['style_id']] = strtoupper($value['style_name']);
            }
        }
        else
        {
            $record['style_data'][0] = 'NO STYLE ADDED';
        }        


        return $record; 
    }

    public function get_measurement_data_from_table($app_id)
    {
        $record = [];
        $trans_query = "SELECT mt.*, maap.maap_name
                        FROM measurement_master mm
                        LEFT JOIN measurement_trans mt ON(mt.mt_mm_id = mm.mm_id)
                        LEFT JOIN maap_master maap ON(maap.maap_id = mt.mt_maap_id)
                        WHERE mm.mm_app_id = $app_id";
        $record['maap_d'] = $this->db->query($trans_query)->result_array();
        return $record; 
    }

    public function get_measurement_data_from_table_style($app_id)
    {
        $record = [];
        $trans_query1 = "SELECT mst.*, style.style_name
                        FROM measurement_master mm
                        LEFT JOIN measurement_style_trans mst ON(mst.mst_mm_id = mm.mm_id)
                        LEFT JOIN style_master style ON(style.style_id = mst.mst_style_id)
                        WHERE mm.mm_app_id = $app_id";
        $record['style_d'] = $this->db->query($trans_query1)->result_array();
        return $record; 
    }


    
/************************ /measurement MASTER *******************************/

	// ***** index page order details ******
	public function get_all_order_details()
    {
		$subsql = '';
		$start_date	= isset($_GET['start_date']) ? date('Y-m-d',strtotime($_GET['start_date'])): date('Y-m-d');
		$end_date  	= isset($_GET['end_date']) ? date('Y-m-d',strtotime($_GET['end_date'])): date('Y-m-t');
		$client_id  = isset($_GET['om_client_id']) ? $_GET['om_client_id']: 0;
		
		if($client_id > 0)
		{
			$subsql = " AND ord.om_client_id = $client_id";
		}

		$query = "SELECT ord.om_no,ord.om_id,ord.om_final_total,ord.om_advance,ord.om_allocated_amt,ord.om_roundoff,ord.om_date,ord.om_delivery_date,c.client_name,c.client_mobile1,um.user_name,ord.om_trial_date
			FROM order_master ord 
			LEFT JOIN client_master c ON(ord.om_client_id=c.client_id)
			LEFT JOIN user_master um ON(ord.om_designer_id=um.user_id)
			WHERE ord.om_sms_flag = 0 AND ord.om_delivery_date BETWEEN '$start_date' AND '$end_date' $subsql";

		$order_data  = $this->db->query($query)->result_array();

		if (!empty($order_data)) 
		{
			foreach ($order_data as $key => $value) 
			{   
				$order_trans_data = $this->get_order_status($value['om_id']);

				$record['order_data'][$key] = array_merge($value,array('order_status' =>$order_trans_data ));
			} 
		}
		else
		{
			$record['order_data'] = array();
		}

		//  SMS sent order

		$sent_query = "SELECT ord.om_no,ord.om_id,ord.om_date,ord.om_delivery_date,ord.om_sms_flag,ord.om_sms_date,ord.om_client_id2,c.client_mobile1
			FROM order_master ord 
			LEFT JOIN client_master c ON(ord.om_client_id=c.client_id)
			WHERE ord.om_sms_flag = 1";

		$record['order_sent_data']  = $this->db->query($sent_query)->result_array();

		// $skip_query = "SELECT ord.om_no,ord.om_id,ord.om_final_total,ord.om_advance,ord.om_allocated_amt,ord.om_roundoff,ord.om_date,ord.om_delivery_date,ord.om_sms_flag,ord.om_sms_date,ord.om_client_id2,c.client_mobile1
		// 	FROM order_master ord 
		// 	LEFT JOIN client_master c ON(ord.om_client_id=c.client_id)
		// 	WHERE ord.om_sms_flag = 2";

		$skip_query = "SELECT ord.om_no,ord.om_id,ord.om_final_total,ord.om_advance,ord.om_allocated_amt,ord.om_roundoff,ord.om_date,ord.om_delivery_date,c.client_name,c.client_mobile1,um.user_name
			FROM order_master ord 
			LEFT JOIN client_master c ON(ord.om_client_id=c.client_id)
			LEFT JOIN user_master um ON(ord.om_designer_id=um.user_id)
			WHERE ord.om_sms_flag = 2";

		$record['order_skip_data']  = $this->db->query($skip_query)->result_array();
		
		
		$client = $this->db->query("SELECT client_id,client_name FROM client_master WHERE client_status = 1 ORDER BY client_name ASC")->result_array();
		$record['client_data'][0] = "Enter Client Name";
		foreach ($client as $key => $value) {
			$record['client_data'][$value['client_id']] = $value['client_name'];
		}



		return $record;
	}
	
	public function get_order_status($om_id)
	{
		// $query = "SELECT ot_current_status FROM order_trans WHERE ot_om_id = $om_id";

		$query = "SELECT ot.ot_current_status,a.app_name,a.app_chart_rec FROM order_trans ot LEFT JOIN apparel_master a ON(ot.ot_app_code = a.app_id) WHERE ot.ot_om_id = $om_id AND a.app_chart_rec = 1";

		$data = $this->db->query($query)->result_array();
		$flag = 1;

		foreach ($data as $key => $value) 
		{
			if ($value['ot_current_status'] != 5) {
				$flag = 0;
			}
		}
		
		return $flag;
	}

	public function get_order_single_details($id)
	{
		$query = "SELECT ord.om_no,ord.om_id,ord.om_date,ord.om_final_total,ord.om_advance,ord.om_allocated_amt,ord.om_roundoff,c.client_name,c.client_mobile1
		FROM order_master ord 
		LEFT JOIN client_master c ON(ord.om_client_id=c.client_id)
		WHERE om_id = $id";
		
		return $this->db->query($query)->result_array();
	}


	/************************ AREA MASTER *******************************/  

    public function check_dulicate_area_name($area_name)
    {
        return $this->db->query("SELECT * from area_master WHERE area_name = '$area_name'")->num_rows();
    }

    public function check_edit_dulicate_area_name($area_name,$area_id)
    {
        return $this->db->query("SELECT * from area_master WHERE area_name = '$area_name' and area_id != $area_id")->num_rows();
    }

	/************************ /AREA MASTER *******************************/ 

    /************************ country MASTER *******************************/  

    public function check_dulicate_country_name($country_name)
    {
        return $this->db->query("SELECT * from country_master WHERE country_name = '$country_name'")->num_rows();
    }

    public function check_edit_dulicate_country_name($country_name,$country_id)
    {
        return $this->db->query("SELECT * from country_master WHERE country_name = '$country_name' and country_id != $country_id")->num_rows();
    }

    /************************ /country MASTER *******************************/

    /************************ makki MASTER *******************************/  

    public function check_dulicate_makki_name($makki_name)
    {
        return $this->db->query("SELECT * from makki_master WHERE makki_name = '$makki_name'")->num_rows();
    }

    public function check_edit_dulicate_makki_name($makki_name,$makki_id)
    {
        return $this->db->query("SELECT * from makki_master WHERE makki_name = '$makki_name' and makki_id != $makki_id")->num_rows();
    }

    /************************ /makki MASTER *******************************/

	 /************************ style MASTER *******************************/  

    public function check_dulicate_style_name($style_name)
    {
        return $this->db->query("SELECT * from style_master WHERE style_name = '$style_name'")->num_rows();
    }

    public function check_edit_dulicate_style_name($style_name,$style_id)
    {
        return $this->db->query("SELECT * from style_master WHERE style_name = '$style_name' and style_id != $style_id")->num_rows();
    }

	/************************ /style MASTER *******************************/ 

	/************************ city MASTER *******************************/  

    public function check_dulicate_city_name($city_name)
    {
        return $this->db->query("SELECT * from city_master WHERE city_name = '$city_name'")->num_rows();
    }

    public function check_edit_dulicate_city_name($city_name,$city_id)
    {
        return $this->db->query("SELECT * from city_master WHERE city_name = '$city_name' and city_id != $city_id")->num_rows();
    }

	/************************ /city MASTER *******************************/

	/************************ state MASTER *******************************/  

    public function check_dulicate_state_name($state_name)
    {
        return $this->db->query("SELECT * from state_master WHERE state_name = '$state_name'")->num_rows();
    }

    public function check_edit_dulicate_state_name($state_name,$state_id)
    {
        return $this->db->query("SELECT * from state_master WHERE state_name = '$state_name' and state_id != $state_id")->num_rows();
    }

	/************************ /state MASTER *******************************/

    public function get_done_order_trans_data($om_id)
		{
			$query="SELECT om.om_no,
				om.om_date,
				om.om_client_id2,
				ot.ot_id,
				ot.ot_qty,
				ot.ot_barcode,
                jrm.jrm_designation,
				ot.ot_delivered,
                UPPER(app.app_name) as apparel_name,
                UPPER(dm1.designation_name) as ready_status,
                ot_delivered
                FROM order_master om
                INNER JOIN order_trans ot ON(ot.ot_om_id = om.om_id)
                INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
				LEFT JOIN job_receive_trans jrt ON(jrt.jrt_ot_id = ot.ot_id)
				LEFT JOIN job_receive_master jrm ON(jrt.jrt_jrm_id = jrm.jrm_id)
				LEFT JOIN designation_master dm1 ON(dm1.designation_id = jrm.jrm_designation)
                WHERE ot.ot_om_id = $om_id
                ORDER BY app.app_name ASC";
        	$record['order_data'] = $this->db->query($query)->result_array();

		foreach ($record['order_data'] as $key => $value) {
			$data =  $this->get_job_status($value['ot_id']);
			$status = ($value['jrm_designation'] > 0) ? $value['ready_status'] : $data['designation_name'];
			if(!empty($data)){
				$record['order_data'][$key]['karigar_name'] = $data['karigar_name'];
				$record['order_data'][$key]['designation_name'] = $data['designation_name'];
				$record['order_data'][$key]['process'] = $status;
				$record['order_data'][$key]['status'] = $data['status'];
				$record['order_data'][$key]['jrm_designation'] = $value['jrm_designation'];
			}
			
		}
			// print_r($record);
			return $record;
		}

		public function get_job_status($ot_id) {
			$query="SELECT upper(km.km_name) as karigar_name,
					IFNULL((SELECT IF(IFNULL(jrt.jrt_id, 0) = 0, 'ISSUE', 'RECEIVED') as job_status  
					FROM job_issue_trans jit 
					LEFT JOIN job_receive_trans jrt ON(jit.jit_id = jrt.jrt_jit_id)
					WHERE jit.jit_ot_id= $ot_id ORDER BY jit.jit_id DESC LIMIT 1),'') as job_status,
					IFNULL((SELECT upper(dm.designation_name) as designation_name  
					FROM job_issue_trans jit 
					INNER JOIN job_issue_master jim ON(jit.jit_jim_id = jim.jim_id)
					INNER JOIN designation_master dm ON(dm.designation_id = jim.jim_designation)
					WHERE jit.jit_ot_id=$ot_id ORDER BY jit.jit_id DESC LIMIT 1),'') as designation_name
					
					FROM job_issue_trans jit 
					INNER JOIN job_issue_master jim ON(jit.jit_jim_id = jim.jim_id)
					INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
					WHERE jit.jit_ot_id = $ot_id ORDER BY jit.jit_id DESC LIMIT 1";
			$data = $this->db->query($query)->result_array();  

			// print_r($data); exit;

			if(!empty($data)) {
				return ['karigar_name' => $data[0]['karigar_name'],'designation_name' => $data[0]['designation_name'], 'status' => $data[0]['job_status']];
			}
			 return ['karigar_name' => '', 'designation_name' => '', 'status' => 'NOT ACCEPTED'];
	
		}

        public function get_last(){ 
			$record = [];
			$data =$this->db->query("SELECT SUM(om.om_final_total) as amt
						FROM order_master om")->result_array();
			$record['amt']['tailoring_total'] =  (!empty($data[0]['amt']))? $data[0]['amt']:0;

			$data =$this->db->query("SELECT SUM(om.om_advance) as amt
						FROM order_master om")->result_array();
			$record['amt']['tailoring_adv'] =  (!empty($data[0]['amt']))? $data[0]['amt']:0;

			$data =$this->db->query("SELECT SUM(om.om_balance) as amt
						FROM order_master om")->result_array();
			$record['amt']['tailoring_bal'] =  (!empty($data[0]['amt']))? $data[0]['amt']:0;

			$data =$this->db->query("SELECT SUM(om.om_balance) as amt
						FROM order_master om")->result_array();
			$record['amt']['total_bal'] =  (!empty($data[0]['amt']))? $data[0]['amt']:0;

			$data =$this->db->query("SELECT SUM(om.om_allocated_amt) as amt
						FROM order_master om")->result_array();
			$record['amt']['allocated_amt'] =  (!empty($data[0]['amt']))? $data[0]['amt']:0;

			$data =$this->db->query("SELECT SUM(om.om_advance + om.om_allocated_amt) as amt
						FROM order_master om")->result_array();
			$record['amt']['total_collected_amt'] = (!empty($data))? $data[0]['amt']:0;

			$data =$this->db->query("SELECT SUM(om.om_final_total - (om.om_advance + om.om_allocated_amt)) as amt
						FROM order_master om")->result_array();
			$record['amt']['total_due_amt'] =  (!empty($data[0]['amt']))? $data[0]['amt']:0;
			  	
			  	$query = "SELECT jit.jit_id 
			  				FROM job_issue_master jim
							INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
			                LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jit_id = jit.jit_id)
			                WHERE jim.jim_proces_id = 14 AND IFNULL(jrt.jrt_jit_id, 0)=0";
				$record['data']['trial_pending']=$this->db->query($query)->num_rows();                
			 	
			 	$query="SELECT 
							om.om_trial_date as trial_date
							FROM order_master om
							INNER JOIN client_master client ON(client.client_id = om.om_client_id)
							HAVING trial_date != ''
							AND trial_date ='".date('Y-m-d')."'";
				$record['data']['today_trial']=$this->db->query($query)->num_rows();
				$query="SELECT 
					om.om_delivery_date as delivery_date
					FROM order_master om
					INNER JOIN client_master client ON(client.client_id = om.om_client_id)
					HAVING delivery_date != ''
					AND delivery_date ='".date('Y-m-d')."'";
				$record['data']['today_delivery']=$this->db->query($query)->num_rows();			

			    $query ="SELECT om.om_id 
					    FROM order_master om
		                INNER JOIN client_master client ON(client.client_id = om.om_client_id)
		                WHERE om.om_fin_year = '".$_SESSION['fin_year']."'";
		        $record['data']['today_invoice']=$this->db->query($query)->num_rows();
		        
		        $query ="SELECT om.om_id 
					    FROM order_master om
		                INNER JOIN client_master client ON(client.client_id = om.om_client_id)
		                WHERE om.om_fin_year = '".$_SESSION['fin_year']."'";
		        $data = $this->db->query($query)->result_array();
		        $pending_inv=0;
		        $close_inv=0;
		        if(!empty($data)){
		        	foreach ($data as $key => $value) {
		        		$trans_cnt= $this->db_operations->get_cnt('order_trans',['ot_item_id!='=>0,'ot_om_id'=>$value['om_id']]);
		        		$is_deliverd = $this->db_operations->get_cnt('order_trans',['ot_item_id!='=>0,'ot_om_id'=>$value['om_id']]);
		        		if($is_deliverd<$trans_cnt){
		        			$pending_inv++;
		        		}else{
		        			$close_inv++;
		        		}
		        	}
		        }

		        $record['data']['pending_inv'] = $pending_inv;
		        $record['data']['close_inv']   = $close_inv;  

		       $record['today'] = $this->get_today_amount(); 
		       // echo "<pre>"; print_r($record);die;                                

			return $record;
		}

		public function get_today_amount(){ 
			$subsql = " om_date = '".date('Y-m-d')."'";
			$record = [];
			$data =$this->db->query("SELECT SUM(om.om_final_total) as amt
						FROM order_master om WHERE $subsql ")->result_array();
			$record['tailoring_total'] = (!empty($data[0]['amt']))? $data[0]['amt']:0;	

			$data =$this->db->query("SELECT SUM(om.om_advance) as amt
						FROM order_master om WHERE $subsql")->result_array();
			$record['tailoring_adv'] = (!empty($data[0]['amt']))? $data[0]['amt']:0;	

			$data =$this->db->query("SELECT SUM(om.om_balance) as amt
						FROM order_master om WHERE $subsql")->result_array();
			$record['tailoring_bal'] = (!empty($data[0]['amt']))? $data[0]['amt']:0;		

			$data =$this->db->query("SELECT SUM(om.om_allocated_amt) as amt
						FROM order_master om WHERE $subsql")->result_array();
			$record['allocated_amt'] =  (!empty($data[0]['amt']))? $data[0]['amt']:0;	

			$data =$this->db->query("SELECT SUM(om.om_advance + om.om_allocated_amt) as amt
						FROM order_master om WHERE $subsql")->result_array();
			$record['total_collected_amt'] = (!empty($data[0]['amt']))? $data[0]['amt']:0;

			$data =$this->db->query("SELECT SUM(om.om_final_total - (om.om_advance + om.om_allocated_amt)) as amt
						FROM order_master om WHERE $subsql")->result_array();
			$record['total_due_amt'] =  (!empty($data[0]['amt']))? $data[0]['amt']:0;

			return $record;
		}

        public function _id(){
            $subsql = "";
            $page 	= 1;
            if(isset($_GET['limit']) && !empty($_GET['limit'])){
                $limit = $_GET['limit'];
            }
            if(isset($_GET['page']) && !empty($_GET['page'])){
                $page 	= $_GET['page'];
                $offset = $limit * ($page - 1);
            }
            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name 	= $_GET['name'];
                $subsql .= " AND (app_name LIKE '".$name."%') ";
            }
            if(isset($_GET['param']) && !empty($_GET['param'])){
                $param 	= $_GET['param'];
                $subsql .= " AND (app_status = $param) ";
            }
            $query="SELECT 
                    app_id as id, 
                    UPPER(app_name) as name
                    FROM apparel_master
                    WHERE 1
                    $subsql
                    GROUP BY app_name ASC";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }

        public function get_apparel_apparel_trans_data($app_id)
	    {
            $query = "SELECT aat.aat_apparel_id, app.app_name
            FROM apparel_apparel_trans aat
            LEFT JOIN apparel_master app ON(app.app_id = aat.aat_apparel_id) 
            WHERE apparel_id = $app_id ORDER BY aat.aat_id ASC";

            return $this->db->query($query)->result_array();
	    }	
}
?>