<?php
defined('BASEPATH') OR exit('No direct script access allowed');
	class Reportsmdl extends CI_model{

		public function get_cnt($table, $arr){

			$this->db->where($arr);
			return $this->db->count_all_results($table);
		}

		public function get_fin_year_wise_max_id($table,$col_name,$col_fin_year,$sess_fin_year)
	    {   
	        $record = $this->db->query("SELECT MAX($col_name) as max_no FROM $table WHERE $col_fin_year = '$sess_fin_year'")->result_array();

	        if(empty($record[0]['max_no']))
	        {
	            return 1;
	        }
	        else
	        {
	            return $record[0]['max_no']+1;
	        }
	    }

	/**** sale report ******/
	    public function get_sale_summary_data($fin_year)
	    {
	    	$record = array();

	    	$date_start = date("Y-m-01");
			$date_end   = date("Y-m-t");

	    	$extra = "";
	    	$dsg_extra = "";
	    	
	    	if (isset($_GET['date_start'])) 
	    	{
	    		$date_start = date("Y-m-d", strtotime($_GET['date_start']));
				$date_end 	= date("Y-m-d", strtotime($_GET['date_end']));
				
	    	}
	    	if(isset($_GET['client_id']) && (!empty($_GET['client_id'])) )
			{
				$extra .= " AND c.client_id = '".$_GET['client_id']."'";
			}

	    	$order_query = "SELECT o.*,c.client_id,c.client_name,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_fin_year = '$fin_year' $extra AND o.om_date BETWEEN '$date_start' AND '$date_end' ORDER BY om_no ASC";

	    	$record['order_data'] = $this->db->query($order_query)->result_array();
	    	
	    	$user = $this->db->query("SELECT user_id,user_full_name FROM user_master WHERE user_role_id = 3 AND user_status = 1")->result_array();
			$record['user_data'][0] = "Enter Designer Name";
	    	foreach ($user as $key => $value) {
				$record['user_data'][$value['user_id']] = $value['user_full_name'];
			}

			$client = $this->db->query("SELECT client_id,client_name FROM client_master ")->result_array();
			$record['client_data'][0] = "Enter Client Name";
	    	foreach ($client as $key => $value) {
				$record['client_data'][$value['client_id']] = $value['client_name'];
			}


			return $record;
	    }

	    public function get_sale_summary_data_for_designer($fin_year,$user_id)
	    {
	    	$record = array();

	    	$date_start = date("Y-m-01");
			$date_end   = date("Y-m-t");

	    	$extra = "";
	    	
	    	if (isset($_GET['date_start'])) 
	    	{
	    		$date_start = date("Y-m-d", strtotime($_GET['date_start']));
				$date_end 	= date("Y-m-d", strtotime($_GET['date_end']));
	    	}

	    	$order_query = "SELECT o.*,c.client_name,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_fin_year = '$fin_year' AND o.om_designer_id = $user_id AND o.om_date BETWEEN '$date_start' AND '$date_end' ORDER BY om_no ASC";

	    	$record['order_data'] = $this->db->query($order_query)->result_array();
	    	
	    	$user = $this->db->query("SELECT user_id,user_full_name FROM user_master WHERE user_id = $user_id")->result_array();
	    	foreach ($user as $key => $value) {
				$record['user_data'][$value['user_id']] = $value['user_full_name'];
			}

			return $record;
	    }


	    // public function get_sale_summary_data_xls($fin_year)
	    // {
	    // 	$record = array();

	    // 	$date_start = date("Y-m-01");
		// 	$date_end   = date("Y-m-t");

	    // 	$extra = "";
	    	
	    // 	if (isset($_GET['date_start'])) 
	    // 	{
	    // 		$date_start = date("Y-m-d", strtotime($_GET['date_start']));
		// 		$date_end 	= date("Y-m-d", strtotime($_GET['date_end']));
	    // 	}

	    // 	$order_query = "SELECT o.*,c.client_name,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_fin_year = '$fin_year' AND o.om_date BETWEEN '$date_start' AND '$date_end' ORDER BY om_no ASC";

	    // 	$order_data = $this->db->query($order_query)->result_array();

	    // 	// echo "<pre>";print_r($order_data);exit();

	    // 	$record['excel_array'][0] = array(
        //         0 =>  'ORDER NO',
        //         1 =>  'DATE',
        //         2 =>  'CLIENT NAME',
        //         3 =>  'TOTAL',
        //         4 =>  'DISC AMT',
        //        	5 =>  'SUB AMT',
        //         6 =>  'ADVANCE',
        //         7 =>  'ROUND OFF',
        //         8 =>  'ADJUST AMT',
        //         9 =>  'BALANCE AMT',
        //         10 =>  'NO OF DAYS'
        //     );

	    // 	foreach ($order_data as $key => $value) 
	    // 	{
	    // 		$balance = $value['om_final_total'] - $value['om_advance'] - $value['om_roundoff'] - $value['om_allocated_amt'];

        //         $bill_date  = date_create(date('Y-m-d',strtotime($value['om_date'])));
        //         $today      = date_create(date('Y-m-d'));
        //         $date_diff  = date_diff($today,$bill_date);
        //         $noofdays   = $date_diff->days;

	    // 		/*excel_array*/
	    //        	$record['excel_array'][$key+1][0] = $value['om_no'];
	    //        	$record['excel_array'][$key+1][1] = date('d-m-Y',strtotime($value['om_date']));
	    //        	$record['excel_array'][$key+1][2] = $value['client_name'];
	    //        	$record['excel_array'][$key+1][3] = $value['om_final_total'];
	    //        	$record['excel_array'][$key+1][4] = $value['om_disc_amt'];
	    //        	$record['excel_array'][$key+1][5] = $value['om_taxable_total'];
	    //        	$record['excel_array'][$key+1][6] = $value['om_advance'];
	    //        	$record['excel_array'][$key+1][7] = $value['om_roundoff'];
	    //        	$record['excel_array'][$key+1][8] = $value['om_allocated_amt'];
	    //        	$record['excel_array'][$key+1][9] = $balance;
	    //        	$record['excel_array'][$key+1][10] = $noofdays;
	    // 	}


		// 	return $record;
	    // }

	    public function get_sale_summary_data_xls($fin_year)
{
    $record = array();

    $date_start = date("Y-m-01");
    $date_end   = date("Y-m-t");

    if (isset($_GET['date_start'])) {
        $date_start = date("Y-m-d", strtotime($_GET['date_start']));
        $date_end   = date("Y-m-d", strtotime($_GET['date_end']));
    }

    $order_query = "SELECT o.*, c.client_name, u.user_name 
                    FROM order_master o 
                    LEFT JOIN client_master c ON (o.om_client_id = c.client_id) 
                    LEFT JOIN user_master u ON (o.om_designer_id = u.user_id) 
                    WHERE o.om_fin_year = '$fin_year' 
                    AND o.om_date BETWEEN '$date_start' AND '$date_end' 
                    ORDER BY om_no ASC";

    $order_data = $this->db->query($order_query)->result_array();

    $record['excel_array'][0] = array(
        'ORDER NO', 'DATE', 'CLIENT NAME', 'TOTAL', 'DISC AMT', 'SUB AMT', 'ADVANCE', 'ROUND OFF', 'ADJUST AMT', 'BALANCE AMT', 'NO OF DAYS'
    );

    $total = 0;
    $disc_total = 0;
    $sub_total = 0;
    $adv_total = 0;
    $round_total = 0;
    $adjust_total = 0;
    $bal_total = 0;

    foreach ($order_data as $key => $value) {
        $balance = $value['om_final_total'] - $value['om_advance'] - $value['om_roundoff'] - $value['om_allocated_amt'];

        $bill_date  = date_create(date('Y-m-d', strtotime($value['om_date'])));
        $today      = date_create(date('Y-m-d'));
        $date_diff  = date_diff($today, $bill_date);
        $noofdays   = $date_diff->days;

        $record['excel_array'][$key + 1] = array(
            $value['om_no'],
            date('d-m-Y', strtotime($value['om_date'])),
            $value['client_name'],
            $value['om_final_total'],
            $value['om_disc_amt'],
            $value['om_taxable_total'],
            $value['om_advance'],
            $value['om_roundoff'],
            $value['om_allocated_amt'],
            $balance,
            $noofdays
        );

        $total += $value['om_final_total'];
        $disc_total += $value['om_disc_amt'];
        $sub_total += $value['om_taxable_total'];
        $adv_total += $value['om_advance'];
        $round_total += $value['om_roundoff'];
        $adjust_total += $value['om_allocated_amt'];
        $bal_total += $balance;
    }

    $record['excel_array'][] = array(
        '', '', 'TOTAL', $total, $disc_total, $sub_total, $adv_total, $round_total, $adjust_total, $bal_total, ''
    );

    return $record;
}


	    public function get_sale_summary_data_xls_for_designer($fin_year,$user_id)
	    {
	    	$record = array();

	    	$date_start = date("Y-m-01");
			$date_end   = date("Y-m-t");

	    	$extra = "";
	    	
	    	if (isset($_GET['date_start'])) 
	    	{
	    		$date_start = date("Y-m-d", strtotime($_GET['date_start']));
				$date_end 	= date("Y-m-d", strtotime($_GET['date_end']));
	    	}

	    	$order_query = "SELECT o.*,c.client_name,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_fin_year = '$fin_year' AND o.om_designer_id = $user_id AND o.om_date BETWEEN '$date_start' AND '$date_end' ORDER BY om_no ASC";

	    	$order_data = $this->db->query($order_query)->result_array();

	    	$record['excel_array'][0] = array(
                0 =>  'ORDER NO',
                1 =>  'DATE',
                2 =>  'CLIENT NAME',
                3 =>  'DESIGNER NAME',
                4 =>  'TOTAL',
                5 =>  'DISC AMT',
               	6 =>  'SUB AMT',
                7 =>  'ADVANCE',
                8 =>  'ROUND OFF',
                9 =>  'ADJUST AMT',
                10 =>  'BALANCE AMT',
                11 =>  'NO OF DAYS'
            );

	    	foreach ($order_data as $key => $value) 
	    	{
	    		$balance = $value['om_final_total'] - $value['om_advance'] - $value['om_roundoff'] - $value['om_allocated_amt'];

                $bill_date  = date_create(date('Y-m-d',strtotime($value['om_date'])));
                $today      = date_create(date('Y-m-d'));
                $date_diff  = date_diff($today,$bill_date);
                $noofdays   = $date_diff->days;

	    		/*excel_array*/
	           	$record['excel_array'][$key+1][0] = $value['om_no'];
	           	$record['excel_array'][$key+1][1] = date('d-m-Y',strtotime($value['om_date']));
	           	$record['excel_array'][$key+1][2] = $value['client_name'];
	           	$record['excel_array'][$key+1][3] = $value['user_name'];
	           	$record['excel_array'][$key+1][4] = $value['om_final_total'];
	           	$record['excel_array'][$key+1][5] = $value['om_disc_amt'];
	           	$record['excel_array'][$key+1][6] = $value['om_taxable_total'];
	           	$record['excel_array'][$key+1][7] = $value['om_advance'];
	           	$record['excel_array'][$key+1][8] = $value['om_roundoff'];
	           	$record['excel_array'][$key+1][9] = $value['om_allocated_amt'];
	           	$record['excel_array'][$key+1][10] = $balance;
	           	$record['excel_array'][$key+1][11] = $noofdays;
	    	}


			return $record;
	    }

	    public function get_chart_sale_data($fin_year)
	    {

	    	$today 	= date('Y-m-d');
	    	$prev_1 = date('Y-m-d', strtotime('-1 days'));
	    	$prev_2 = date('Y-m-d', strtotime('-2 days'));
	    	$prev_3 = date('Y-m-d', strtotime('-3 days'));
	    	$prev_4 = date('Y-m-d', strtotime('-4 days'));
	    	$prev_5 = date('Y-m-d', strtotime('-5 days'));
	    	$prev_6 = date('Y-m-d', strtotime('-6 days'));

	    	$date_array = array();

	    	$date_array[date('D', strtotime($prev_6))] = $prev_6;
	    	$date_array[date('D', strtotime($prev_5))] = $prev_5;
	    	$date_array[date('D', strtotime($prev_4))] = $prev_4;
	    	$date_array[date('D', strtotime($prev_3))] = $prev_3;
	    	$date_array[date('D', strtotime($prev_2))] = $prev_2;
	    	$date_array[date('D', strtotime($prev_1))] = $prev_1;
	    	$date_array[date('D', strtotime($today))]  = $today;
	    

	    	$today_extra1 = "";
			$today_extra2 = "";
			$today_extra3 = "";
			
			// echo "<pre>";print_r($date_array);exit();

			$resp_array = array();
			$cnt = 0;
	    	foreach ($date_array as $key1 => $value1) 
	    	{
	    		$extra1 = " AND o.om_date BETWEEN '$value1' AND '$value1'";

				$query1 = "SELECT SUM(o.om_final_total) as cash_total FROM order_master o 
		 				WHERE o.om_fin_year = '$fin_year' $extra1" ;

				$cash_total = $this->db->query($query1)->result_array()[0]['cash_total'];

	            $resp_array[$cnt]['y'] = $cash_total;
	            $resp_array[$cnt]['label'] = strtoupper($key1);
	           	$cnt++;
	    	}
	    	return $resp_array;
	    }

	    public function get_chart_sale_amount_collected_data($fin_year)
	    {

	    	$today 	= date('Y-m-d');
	    	$prev_1 = date('Y-m-d', strtotime('-1 days'));
	    	$prev_2 = date('Y-m-d', strtotime('-2 days'));
	    	$prev_3 = date('Y-m-d', strtotime('-3 days'));
	    	$prev_4 = date('Y-m-d', strtotime('-4 days'));
	    	$prev_5 = date('Y-m-d', strtotime('-5 days'));
	    	$prev_6 = date('Y-m-d', strtotime('-6 days'));

	    	$date_array = array();

	    	$date_array[date('D', strtotime($prev_6))] = $prev_6;
	    	$date_array[date('D', strtotime($prev_5))] = $prev_5;
	    	$date_array[date('D', strtotime($prev_4))] = $prev_4;
	    	$date_array[date('D', strtotime($prev_3))] = $prev_3;
	    	$date_array[date('D', strtotime($prev_2))] = $prev_2;
	    	$date_array[date('D', strtotime($prev_1))] = $prev_1;
	    	$date_array[date('D', strtotime($today))]  = $today;
	    

	    	$today_extra1 = "";
			$today_extra2 = "";
			$today_extra3 = "";
			
			// echo "<pre>";print_r($date_array);exit();

			$resp_array = array();
			$cnt = 0;
	    	foreach ($date_array as $key1 => $value1) 
	    	{
	    		$extra1 = " AND o.om_date BETWEEN '$value1' AND '$value1'";
	    		$extra2 = " AND v.vc_entry_date BETWEEN '$value1' AND '$value1'";

				$query1 = "SELECT SUM(o.om_advance) as order_cash_total FROM order_master o WHERE o.om_fin_year = '$fin_year' $extra1" ;
				
				$query2 = "SELECT SUM(v.vc_amount) as voucher_total FROM voucher_master v WHERE v.vc_fin_year = '$fin_year' $extra2" ;


				$cash_total = $this->db->query($query1)->result_array()[0]['order_cash_total'];
				$voucher_total = $this->db->query($query2)->result_array()[0]['voucher_total'];

				$total_collection = $cash_total + $voucher_total;

	            $resp_array[$cnt]['y'] = $total_collection;
	            $resp_array[$cnt]['label'] = strtoupper($key1);
	           	$cnt++;
	    	}
	    	return $resp_array;
	    }

	/**** sale report end ******/

	/**** client_retention_report******/
	public function get_client_retention_report_data()
	{
		$extra = "";
		
		$number_of_days	= isset($_GET['number_of_days']) ? $_GET['number_of_days']: '';

		if(!empty($number_of_days)){

		// if(isset($_GET['client']) && $_GET['client'] != 0)
		// {
		// 	$client_id = $_GET['client']; 
		// 	$extra .= "AND om.om_client_id = $client_id"; 
		// }

		if(isset($_GET['client_type']) && $_GET['client_type'] != '')
		{
			$client_type = $_GET['client_type']; 
			$extra .= "AND cm.client_type = '$client_type'"; 
		}

		$order_query="SELECT 
    					ot.ot_id, 
    					UPPER(cm.client_name) AS client_name, 
    					cm.client_mobile1, 
						cm.client_type,
    					om.om_no, 
    					MAX(om.om_date) AS latest_order_date,
    					DATEDIFF(CURRENT_DATE(), MAX(om.om_date)) AS days_difference
						FROM order_master om
						LEFT JOIN client_master cm ON cm.client_id = om.om_client_id
						LEFT JOIN order_trans ot ON ot.ot_om_id = om.om_id
						WHERE 1 $extra
						GROUP BY cm.client_id
						HAVING
    						DATEDIFF(CURRENT_DATE(), MAX(om.om_date)) > $number_of_days
						ORDER BY cm.client_id ASC";

		$data = $this->db->query($order_query)->result_array();
		$record['order_data'] = [];
		if(!empty($data)){ 
			$client_count = 0;
            foreach ($data as $key => $value) {
				array_push($record['order_data'], [
					'client_name'       => $value['client_name'],
					'om_no'             => (int)$value['om_no'],
					'om_date'         	=> date('d-m-Y',strtotime($value['latest_order_date'])),
					'client_mobile'   	=> $value['client_mobile1'],
					'client_type'   	=> $value['client_type']
				]);
				$client_count++;
			}
			$record['order_data'][0]['client_count'] = $client_count;
		}
	}
		$client = $this->db->query("SELECT client_id,client_name FROM client_master")->result_array();
		$record['client_data'][0] = "All";
		foreach ($client as $key => $value) {
			$record['client_data'][$value['client_id']] = $value['client_name'];
		}

		return $record;
	

	}

	public function get_client_retention_report_data_xls()
	{
		$extra = "";
		
		$number_of_days	= isset($_GET['number_of_days']) ? $_GET['number_of_days']: '';

		if(!empty($number_of_days)){

		// if(isset($_GET['client']) && $_GET['client'] != 0)
		// {
		// 	$client_id = $_GET['client']; 
		// 	$extra .= "AND om.om_client_id = $client_id"; 
		// }

		if(isset($_GET['client_type']) && $_GET['client_type'] != '')
		{
			$client_type = $_GET['client_type']; 
			$extra .= "AND cm.client_type = '$client_type'"; 
		}

		$order_query="SELECT 
    					ot.ot_id, 
    					UPPER(cm.client_name) AS client_name, 
    					cm.client_mobile1,
						cm.client_type, 
    					om.om_no, 
    					MAX(om.om_date) AS latest_order_date,
    					DATEDIFF(CURRENT_DATE(), MAX(om.om_date)) AS days_difference
						FROM order_master om
						LEFT JOIN client_master cm ON cm.client_id = om.om_client_id
						LEFT JOIN order_trans ot ON ot.ot_om_id = om.om_id
						WHERE 1 $extra
						GROUP BY cm.client_id
						HAVING
    						DATEDIFF(CURRENT_DATE(), MAX(om.om_date)) > $number_of_days
						ORDER BY cm.client_id ASC";

		$data = $this->db->query($order_query)->result_array();
	
		if(!empty($data)){ 
	       	$record['excel_array'][0] = array(
                0 =>  'ORDER NO',
                1 =>  'DATE',
                2 =>  'CLIENT NAME',
                3 =>  'MOBILE NO',
                4 =>  'TYPE',
            );

	    	foreach ($data as $key => $value) 
	    	{
				$status_data = $this->get_status_data($value['ot_id']);
	    		/*excel_array*/
	           	$record['excel_array'][$key+1][0] = $value['om_no'];
	           	$record['excel_array'][$key+1][1] = date('d-m-Y',strtotime($value['latest_order_date']));
	           	$record['excel_array'][$key+1][2] = $value['client_name'];
	           	$record['excel_array'][$key+1][3] = $value['client_mobile1'];
	           	$record['excel_array'][$key+1][4] = $value['client_type'];
	    	}
			return $record;
		}
		}
	}
	/**** client_retention_report******/
	

	/**** order_status report******/
	public function get_order_status_report_data()
	{
		$extra = "";
		
		$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-01');
		$date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

		if(isset($_GET['client']) && $_GET['client'] != 0)
		{
			$client_id = $_GET['client']; 
			$extra .= "AND om.om_client_id = $client_id"; 
		}

		$order_query="SELECT ot.ot_id, UPPER(cm.client_name) as client_name, cm.client_mobile1, UPPER(app.app_name) as apparel_name, om.om_no, DATE_FORMAT(om.om_date, '%d-%m-%Y') as om_date, om.om_date, ot.ot_barcode as qrcode, ot.ot_delivered FROM order_master om 
		INNER JOIN client_master cm ON(cm.client_id = om.om_client_id) 
		INNER JOIN order_trans ot ON(ot.ot_om_id = om.om_id) 
		INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id) 
        WHERE om.om_date BETWEEN '$date_start' AND '$date_end' $extra
        GROUP BY ot.ot_logic   
        ORDER BY om.om_date DESC";

		$data = $this->db->query($order_query)->result_array();
		$record['order_data'] = [];
		if(!empty($data)){ 
            foreach ($data as $key => $value) { 
                $status_data = $this->get_status_data($value['ot_id']);
				array_push($record['order_data'], [
					'client_name'       => $value['client_name'],
					'apparel_name'      => $value['apparel_name'],
					'qrcode'            => $value['qrcode'],
					'om_no'             => (int)$value['om_no'],
					'ot_delivered'      => (int)$value['ot_delivered'],
					'om_date'         	=> date('d-m-Y',strtotime($value['om_date'])),
					'client_mobile'   	=> $value['client_mobile1'],
					'karigar_name'      => $status_data['karigar_name'],
					'designation_name'  => $status_data['designation_name'],
					'status'            => $status_data['status'],
				]);
			}
		}

		$client = $this->db->query("SELECT client_id,client_name FROM client_master")->result_array();
		$record['client_data'][0] = "All";
		foreach ($client as $key => $value) {
			$record['client_data'][$value['client_id']] = $value['client_name'];
		}

		return $record;
	}

	public function get_status_data($ot_id) {
        $query="SELECT 
                UPPER(km.km_name) as karigar_name,
                UPPER(designation.designation_name) as designation_name,
                'ISSUED' as status
                FROM job_issue_trans jit
                INNER JOIN job_issue_master jim ON(jim.jim_id = jit.jit_jim_id)
                INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
                LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jit_id = jit.jit_id)
                WHERE jit.jit_ot_id = $ot_id
                AND IFNULL(jrt.jrt_jit_id, 0) = 0
                ORDER BY jit.jit_id DESC
                LIMIT 1";
        $data = $this->db->query($query)->result_array();
        // echo "<pre>"; print_r($query); exit();
        // echo "<pre>"; print_r($data); exit();
        if(!empty($data)){
            return ['karigar_name' => $data[0]['karigar_name'], 'designation_name' => $data[0]['designation_name'], 'status' =>  $data[0]['status']];
        }

        $query="SELECT 
                UPPER(km.km_name) as karigar_name,
                UPPER(designation.designation_name) as designation_name,
                'RECEIVED' as status
                FROM job_receive_trans jrt
                INNER JOIN job_issue_master jim ON(jim.jim_id = jrt.jrt_jim_id)
                INNER JOIN job_receive_master jrm ON(jrm.jrm_id = jrt.jrt_jrm_id)
                INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                INNER JOIN designation_master designation ON(designation.designation_id = jrm.jrm_designation)
                WHERE jrt.jrt_ot_id = $ot_id
                AND jrt.jrt_jim_id != 0
                ORDER BY jrt.jrt_id DESC
                LIMIT 1";
        $data = $this->db->query($query)->result_array();
        // echo "<pre>"; print_r($query); exit();
        // echo "<pre>"; print_r($data); exit();

        if(!empty($data)){
            return ['karigar_name' => $data[0]['karigar_name'], 'designation_name' => $data[0]['designation_name'], 'status' =>  $data[0]['status']];
        }
        return ['karigar_name' => 'NOT ASSIGN', 'designation_name' => 'NOT DEFINE', 'status' => 'PENDING'];
    }

	public function get_order_status_report_data_xls()
	{
		$extra = "";
		
		$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-01');
		$date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

		if(isset($_GET['client']) && $_GET['client'] != 0)
		{
			$client_id = $_GET['client']; 
			$extra .= "AND om.om_client_id = $client_id"; 
		}

		$order_query="SELECT ot.ot_id, UPPER(cm.client_name) as client_name, cm.client_mobile1, UPPER(app.app_name) as apparel_name, om.om_no, DATE_FORMAT(om.om_date, '%d-%m-%Y') as om_date, om.om_date, ot.ot_barcode as qrcode, ot.ot_delivered FROM order_master om 
		INNER JOIN client_master cm ON(cm.client_id = om.om_client_id) 
		INNER JOIN order_trans ot ON(ot.ot_om_id = om.om_id) 
		INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id) 
        WHERE om.om_date BETWEEN '$date_start' AND '$date_end' $extra
        GROUP BY ot.ot_logic   
        ORDER BY om.om_date DESC";

		$data = $this->db->query($order_query)->result_array();
	
		if(!empty($data)){ 
	       	$record['excel_array'][0] = array(
                0 =>  'ORDER NO',
                1 =>  'DATE',
                2 =>  'CLIENT NAME',
                3 =>  'MOBILE NO',
                4 =>  'APPAREL',
                5 =>  'QRCODE',
                6 =>  'KARIGAR',
                7 =>  'PROCESS',
                8 =>  'STATUS',
            );

	    	foreach ($data as $key => $value) 
	    	{
				$status_data = $this->get_status_data($value['ot_id']);
	    		/*excel_array*/
	           	$record['excel_array'][$key+1][0] = $value['om_no'];
	           	$record['excel_array'][$key+1][1] = date('d-m-Y',strtotime($value['om_date']));
	           	$record['excel_array'][$key+1][2] = $value['client_name'];
	           	$record['excel_array'][$key+1][3] = $value['client_mobile1'];
	           	$record['excel_array'][$key+1][4] = $value['apparel_name'];
	           	$record['excel_array'][$key+1][5] = $value['qrcode'];
	           	$record['excel_array'][$key+1][6] = $status_data['karigar_name'];
	           	$record['excel_array'][$key+1][7] = $status_data['designation_name'];
	           	$record['excel_array'][$key+1][8] = $status_data['status'];
	    	}
			return $record;
		}
		}

		/**** customer_data_report******/
	public function get_customer_data_report_data()
	{
		$record     = [];
		
		$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-01');
		$date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

		$record['totals']['om_final_total']    = 0;
		if(!empty($_REQUEST['date_start']) && !empty($_REQUEST['date_end'])){
 $order_query="SELECT 
    cm.client_type, 
    COUNT(DISTINCT cm.client_id) AS total_clients,
    SUM(om.om_final_total) AS om_final_total
FROM 
    client_master cm
LEFT JOIN 
    order_master om ON cm.client_id = om.om_client_id 
WHERE 
    1
    AND (
        DATE(om.om_date) < '".$date_start."'
    )
    AND om.om_client_id NOT IN (
        SELECT om_client_id
        FROM order_master
        WHERE DATE(om_date) >= '".$date_start."'
    )
GROUP BY 
    cm.client_type
ORDER BY 
    cm.client_type";

		$data = $this->db->query($order_query)->result_array();
		$record['totals']['rows']           = count($data);
        $record['totals']['om_final_total']    = 0;
        $record['data']                     = [];
		if(!empty($data)){ 
            foreach ($data as $key => $value) { 
				array_push($record['data'], [
					'client_type'     => $value['client_type'],
					'total_clients'   => (int)$value['total_clients'],
					'om_final_total'  => (float)$value['om_final_total']
				]);

				$record['totals']['om_final_total'] 	= $record['totals']['om_final_total'] + $value['om_final_total'];
			}
		}
		}else{
			$record['data']  = [];
		}
		// echo "<pre>";print_r($record); exit;

		return $record;
	}

			/**** no_order_report******/
			public function get_no_order_report_data()
			{
				$record     = [];
				
				$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-01');
				$date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');
		
				if(!empty($_REQUEST['date_start']) && !empty($_REQUEST['date_end'])){
					$query="SELECT
					UPPER(billing.client_name) AS billing_name,
					billing.client_mobile1 AS billing_mobile
				FROM 
					order_master om
				INNER JOIN 
					client_master billing ON billing.client_id = om.om_client_id
				WHERE 
					1
					AND (
						DATE(om.om_date) < '$date_start'
					)
					AND om.om_client_id NOT IN (
						SELECT om_client_id
						FROM order_master
						WHERE DATE(om_date) >= '$date_start'
					)
				GROUP BY om.om_client_id
				ORDER BY
					om.om_date DESC";
		
				$data = $this->db->query($query)->result_array();
				$record['totals']['rows']           = count($data);
				$record['data']                     = [];
				if(!empty($data)){ 
					foreach ($data as $key => $value) { 
						array_push($record['data'], [
							'billing_name'      => $value['billing_name'],
							'billing_mobile'    => (int)$value['billing_mobile']
						]);
					}
				}
				}else{
					$record['data']  = [];
				}
				// echo "<pre>";print_r($record); exit;
		
				return $record;
			}

	/**** pending_delivery_report******/

		public function get_pending_delivery_report_data()
	{
		$subsql = "";
		
		if(isset($_GET['date_start']))
		{
			$date_start = date('Y-m-d',strtotime($_GET['date_start'])); 
			$subsql .= " AND om.om_date >= '".$date_start."'";
		}

		if(isset($_GET['date_end']))
		{
			$date_end = date('Y-m-d',strtotime($_GET['date_end'])); 
			$subsql .= " AND om.om_date <= '".$date_end."'";
		}

		if(isset($_GET['client']) && $_GET['client'] != 0)
		{
			$client_id = $_GET['client']; 
			$subsql .= "AND om.om_client_id = $client_id"; 
		}

		$query="SELECT 
		 jrt.jrt_id, jrt.jrt_jim_id as jim_id, jrt.jrt_jit_id as jit_id, ot.*, UPPER(app.app_name) as apparel_name, UPPER(client.client_name) as client_name, UPPER(km.km_name) as karigar_name, om.om_no as om_no, DATE_FORMAT(om.om_date, '%d-%m-%Y') as om_date, DATE_FORMAT(om.om_trial_date, '%d-%m-%Y') as trial_date, DATE_FORMAT(om.om_delivery_date, '%d-%m-%Y') as delivery_date,
		UPPER(designation.designation_name) as designation_name,
		jrm.jrm_designation,
		UPPER(designation1.designation_name) as ready_status
		FROM job_receive_trans jrt
		INNER JOIN order_trans ot ON(ot.ot_id = jrt.jrt_ot_id)
		INNER JOIN order_master om ON(om.om_id = ot.ot_om_id)
		INNER JOIN client_master client ON(client.client_id = om.om_client_id) 
		INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id) 
		INNER JOIN job_issue_master jim ON(jim.jim_id = jrt.jrt_jim_id)  
		INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
		INNER JOIN job_receive_master jrm ON(jrm.jrm_id = jrt.jrt_jrm_id)  
		LEFT JOIN designation_master designation1 ON(designation1.designation_id = jrm.jrm_designation)  
		INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id) 
		WHERE ot.ot_delivered = 0  
		AND jim.jim_designation != 1
		$subsql
		ORDER BY jrt.jrt_id DESC";

		$record['data'] = $this->db->query($query)->result_array();

		$client = $this->db->query("SELECT client_id,client_name FROM client_master")->result_array();
		$record['client_data'][0] = "All";
		foreach ($client as $key => $value) {
			$record['client_data'][$value['client_id']] = $value['client_name'];
		}

		// echo "<pre>";print_r($query);exit();
		return $record;
	}

	public function get_pending_delivery_report_data_xls()
	{
		$subsql = "";

		if(isset($_GET['date_start']))
		{
			$date_start = date('Y-m-d',strtotime($_GET['date_start'])); 
			$subsql .= " AND om.om_date >= '".$date_start."'";
		}

		if(isset($_GET['date_end']))
		{
			$date_end = date('Y-m-d',strtotime($_GET['date_end'])); 
			$subsql .= " AND om.om_date <= '".$date_end."'";
		}

		if(isset($_GET['client']) && $_GET['client'] != 0)
		{
			$client_id = $_GET['client']; 
			$subsql .= "AND om.om_client_id = $client_id"; 
		}

		$query="SELECT 
		 jrt.jrt_id, jrt.jrt_jim_id as jim_id, jrt.jrt_jit_id as jit_id, ot.*, UPPER(app.app_name) as apparel_name, UPPER(client.client_name) as client_name, UPPER(km.km_name) as karigar_name, om.om_no as om_no, DATE_FORMAT(om.om_date, '%d-%m-%Y') as om_date, DATE_FORMAT(om.om_trial_date, '%d-%m-%Y') as trial_date, DATE_FORMAT(om.om_delivery_date, '%d-%m-%Y') as delivery_date,
		UPPER(designation.designation_name) as designation_name,
		jrm.jrm_designation,
		UPPER(designation1.designation_name) as ready_status
		FROM job_receive_trans jrt
		INNER JOIN order_trans ot ON(ot.ot_id = jrt.jrt_ot_id)
		INNER JOIN order_master om ON(om.om_id = ot.ot_om_id)
		INNER JOIN client_master client ON(client.client_id = om.om_client_id) 
		INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id) 
		INNER JOIN job_issue_master jim ON(jim.jim_id = jrt.jrt_jim_id)  
		INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
		INNER JOIN job_receive_master jrm ON(jrm.jrm_id = jrt.jrt_jrm_id)  
		LEFT JOIN designation_master designation1 ON(designation1.designation_id = jrm.jrm_designation)  
		INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id) 
		WHERE ot.ot_delivered = 0  
		AND jim.jim_designation != 1
		$subsql
		ORDER BY jrt.jrt_id DESC";

		$data = $this->db->query($query)->result_array();
	
		if(!empty($data)){ 
	       	$record['excel_array'][0] = array(
                0 =>  'QRCODE',
                1 =>  'APPAREL',
                2 =>  'CLIENT NAME',
                3 =>  'ORDER NO',
                4 =>  'DATE',
                5 =>  'PROCESS',
                6 =>  'KARIGAR'
            );

	    	foreach ($data as $key => $value) 
	    	{
				$status = ($value['jrm_designation'] > 0) ? $value['ready_status'] : $value['designation_name'];

				$status_data = $this->get_status_data($value['ot_id']);
	    		/*excel_array*/
	           	$record['excel_array'][$key+1][0] = $value['ot_barcode'];
	           	$record['excel_array'][$key+1][1] = $value['apparel_name'];
	           	$record['excel_array'][$key+1][2] = $value['client_name'];
	           	$record['excel_array'][$key+1][3] = $value['om_no'];
	           	$record['excel_array'][$key+1][4] = date('d-m-Y',strtotime($value['om_date']));
	           	$record['excel_array'][$key+1][5] = $status;
	           	$record['excel_array'][$key+1][6] = $status_data['karigar_name'];
	    	}

			return $record;
		}
		}


		/**** production_report******/

		public function get_production_report_data()
	{
		$subsql = "";
		
		if(isset($_GET['date_start']))
		{
			$date_start = date('Y-m-d',strtotime($_GET['date_start'])); 
			$subsql .= " AND om.om_date >= '".$date_start."'";
		}

		if(isset($_GET['date_end']))
		{
			$date_end = date('Y-m-d',strtotime($_GET['date_end'])); 
			$subsql .= " AND om.om_date <= '".$date_end."'";
		}

		if(isset($_GET['client']) && $_GET['client'] != 0)
		{
			$client_id = $_GET['client']; 
			$subsql .= "AND om.om_client_id = $client_id"; 
		}

		$query="SELECT 
				jim.jim_entry_no as entry_no,
                ot.ot_barcode, 
				DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as entry_date,
                om.om_no as order_no,
                DATE_FORMAT(om.om_date, '%d-%m-%Y') as order_date,
                UPPER(app.app_name) as apparel_name,
                UPPER(client.client_name) as client_name,
              
                IFNULL((SELECT upper(km.km_name) as karigar_name  
                FROM job_issue_trans jit 
                INNER JOIN job_issue_master jim ON(jit.jit_jim_id = jim.jim_id)
                INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                WHERE jit.jit_ot_id=ot.ot_id ORDER BY jit.jit_id DESC LIMIT 1),'') as karigar_name,

                IFNULL((SELECT upper(designation.designation_name) as designation_name  
                FROM job_issue_trans jit 
                INNER JOIN job_issue_master jim ON(jit.jit_jim_id = jim.jim_id)
                INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
                WHERE jit.jit_ot_id=ot.ot_id ORDER BY jit.jit_id DESC LIMIT 1),'') as designation_name,
   
                IFNULL((SELECT IF(IFNULL(jrt.jrt_id, 0) = 0, 'ISSUED', 'RECEIVED') as job_status  
                FROM job_issue_trans jit 
                LEFT JOIN job_receive_trans jrt ON(jit.jit_id = jrt.jrt_jit_id)
                WHERE jit.jit_ot_id=ot.ot_id ORDER BY jit.jit_id DESC LIMIT 1),'') as job_status, 
                jim.jim_create_date as created_at
                FROM job_issue_master jim
                INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
                INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
                INNER JOIN order_trans ot ON(ot.ot_id = jit.jit_ot_id)
                INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
                INNER JOIN order_master om ON(om.om_id = ot.ot_om_id)
                INNER JOIN client_master client ON(client.client_id = om.om_client_id)
                LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jit_id = jit.jit_id)
                WHERE 1 
                $subsql
                GROUP BY ot.ot_id
                
                ORDER BY jim.jim_id DESC";

		$record['data'] = $this->db->query($query)->result_array();

		$client = $this->db->query("SELECT client_id,client_name FROM client_master")->result_array();
		$record['client_data'][0] = "All";
		foreach ($client as $key => $value) {
			$record['client_data'][$value['client_id']] = $value['client_name'];
		}

		// echo "<pre>";print_r($record);exit();
		return $record;
	}

	public function get_production_report_data_xls()
	{
		$subsql = "";
		
		if(isset($_GET['date_start']))
		{
			$date_start = date('Y-m-d',strtotime($_GET['date_start'])); 
			$subsql .= " AND om.om_date >= '".$date_start."'";
		}

		if(isset($_GET['date_end']))
		{
			$date_end = date('Y-m-d',strtotime($_GET['date_end'])); 
			$subsql .= " AND om.om_date <= '".$date_end."'";
		}

		if(isset($_GET['client']) && $_GET['client'] != 0)
		{
			$client_id = $_GET['client']; 
			$subsql .= "AND om.om_client_id = $client_id"; 
		}

		$query="SELECT 
				jim.jim_entry_no as entry_no,
                ot.ot_barcode, 
				DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as entry_date,
                om.om_no as order_no,
                DATE_FORMAT(om.om_date, '%d-%m-%Y') as order_date,
                UPPER(app.app_name) as apparel_name,
                UPPER(client.client_name) as client_name,
              
                IFNULL((SELECT upper(km.km_name) as karigar_name  
                FROM job_issue_trans jit 
                INNER JOIN job_issue_master jim ON(jit.jit_jim_id = jim.jim_id)
                INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                WHERE jit.jit_ot_id=ot.ot_id ORDER BY jit.jit_id DESC LIMIT 1),'') as karigar_name,

                IFNULL((SELECT upper(designation.designation_name) as designation_name  
                FROM job_issue_trans jit 
                INNER JOIN job_issue_master jim ON(jit.jit_jim_id = jim.jim_id)
                INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
                WHERE jit.jit_ot_id=ot.ot_id ORDER BY jit.jit_id DESC LIMIT 1),'') as designation_name,
   
                IFNULL((SELECT IF(IFNULL(jrt.jrt_id, 0) = 0, 'ISSUED', 'RECEIVED') as job_status  
                FROM job_issue_trans jit 
                LEFT JOIN job_receive_trans jrt ON(jit.jit_id = jrt.jrt_jit_id)
                WHERE jit.jit_ot_id=ot.ot_id ORDER BY jit.jit_id DESC LIMIT 1),'') as job_status, 
                jim.jim_create_date as created_at
                FROM job_issue_master jim
                INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
                INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
                INNER JOIN order_trans ot ON(ot.ot_id = jit.jit_ot_id)
                INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
                INNER JOIN order_master om ON(om.om_id = ot.ot_om_id)
                INNER JOIN client_master client ON(client.client_id = om.om_client_id)
                LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jit_id = jit.jit_id)
                WHERE 1 
                $subsql
                GROUP BY ot.ot_id
                
                ORDER BY jim.jim_id DESC";

		$data = $this->db->query($query)->result_array();
	
		if(!empty($data)){ 
	       	$record['excel_array'][0] = array(
                0 =>  'ISSUE NO',
                1 =>  'ISSUE DATE',
                2 =>  'ORDER NO',
                3 =>  'ORDER DATE',
                4 =>  'BARCODE',
                5 =>  'CLIENT',
                6 =>  'PROCESS',
                7 =>  'KARIGAR',
                8 =>  'APPAREL',
                9 =>  'STATUS'
            );

	    	foreach ($data as $key => $value) 
	    	{
	    		/*excel_array*/
	           	$record['excel_array'][$key+1][0] = $value['entry_no'];
	           	$record['excel_array'][$key+1][1] = date('d-m-Y',strtotime($value['entry_date']));;
	           	$record['excel_array'][$key+1][2] = $value['order_no'];
	           	$record['excel_array'][$key+1][3] = date('d-m-Y',strtotime($value['order_date']));
	           	$record['excel_array'][$key+1][4] = $value['ot_barcode'];
	           	$record['excel_array'][$key+1][5] = $value['client_name'];
	           	$record['excel_array'][$key+1][6] = $value['designation_name'];
	           	$record['excel_array'][$key+1][7] = $value['karigar_name'];
	           	$record['excel_array'][$key+1][8] = $value['apparel_name'];
	           	$record['excel_array'][$key+1][9] = $value['job_status'];

	    	}

			return $record;
		}
		}

	/**** customer outstanding report******/
		public function get_cust_outstanding_data()
		{
			$extra = "";
			
			$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('2016-04-01');
		    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

			if(isset($_GET['customer']))
		    {
		        $customer_id = $_GET['customer']; 
		        if ($customer_id == '0') {
		        	$extra .="AND o.om_client_id != 1";
		        } else{
		        	$extra .= "AND o.om_client_id = $customer_id"; 
		        }
		    }
		    else
		    {
		    	$extra .="";	
		    }

			$order_query = "SELECT o.*,c.client_name,c.client_mobile1,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra GROUP BY o.om_no ORDER BY o.om_no ASC";

			// $order_query = "SELECT o.*,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";
			// echo $order_query;exit();

	    	$record['order_data'] = $this->db->query($order_query)->result_array();

			$customer = $this->db->query("SELECT client_id,client_name FROM client_master")->result_array();
			$record['cust_data'][0] = "All";
			foreach ($customer as $key => $value) {
				$record['cust_data'][$value['client_id']] = $value['client_name'];
			}
			return $record;
		}

		public function get_cust_outstanding_data_xls()
		{
			$extra = "";
			
			$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('2016-04-01');
		    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

			if(isset($_GET['customer'])) {

		        $customer_id = $_GET['customer']; 
		        if ($customer_id == '0') {
		        	$extra .="AND o.om_client_id != 1";
		        } else{
		        	$extra .= "AND o.om_client_id = $customer_id"; 
		        }

		    } else {
		    	$extra .="";	
		    }

			$order_query = "SELECT o.*,c.client_name,c.client_mobile1,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";

			// $order_query = "SELECT o.*,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";
	    	$order_data = $this->db->query($order_query)->result_array();

	        $record['excel_array'][0] = array(
        'ORDER NO', 'DATE', 'CLIENT NAME', 'MOBILE NO', 'TOTAL', 'ADVANCE', 'ROUND OFF', 'ADJUST AMT', 'BALANCE AMT'
    );

    $total_amt = 0;
    $total_advance_amt = 0;
    $total_round_off_amt = 0;
    $total_adjust_amt = 0;
    $total_bal_amt = 0;

    $row_index = 1; // Start from the second row since the first row is the header

    foreach ($order_data as $key => $value) {
        $balance = $value['om_final_total'] - $value['om_advance'] - $value['om_roundoff'] - $value['om_allocated_amt'];

        if ($balance > 0) {
            $record['excel_array'][$row_index] = array(
                $value['om_no'],
                date('d-m-Y', strtotime($value['om_date'])),
                $value['client_name'],
                $value['client_mobile1'],
                $value['om_final_total'],
                $value['om_advance'],
                $value['om_roundoff'],
                $value['om_allocated_amt'],
                $balance
            );

            $total_amt += $value['om_final_total'];
            $total_advance_amt += $value['om_advance'];
            $total_round_off_amt += $value['om_roundoff'];
            $total_adjust_amt += $value['om_allocated_amt'];
            $total_bal_amt += $balance;

            $row_index++;
        }
    }

    $record['excel_array'][$row_index] = array(
        '', '', '', 'TOTAL', $total_amt, $total_advance_amt, $total_round_off_amt, $total_adjust_amt, $total_bal_amt
    );

    return $record;
		}
	/**** customer outstanding report end ******/

	/**** designer outstanding report******/
		public function get_designer_outstanding_data($role,$user_id)
		{
			$extra = "";
			
			$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('2016-04-01');
		    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

			if(isset($_GET['designer']))
		    {
		        $designer_id = $_GET['designer'];

		        if ($designer_id == '0') {
		        	$extra .="AND o.om_designer_id != 1";
		        } else{
		        	$extra .= "AND o.om_designer_id = $designer_id"; 
		        }

		        $customer_id = $_GET['customer']; 
			    if ($customer_id == '0') {
			    	$extra .=" AND o.om_client_id != 1";
			    } else{
			    	$extra .= " AND o.om_client_id = $customer_id"; 
			    }
		    }
		    else
		    {
		    	if ($role == 3) 
		    	{
		    		$extra .= "AND o.om_designer_id = $user_id"; 
		    	}
		    	else
		    	{
		    		$extra .="";	
		    	}

		    }

		    $order_query = "SELECT o.*,c.client_name,c.client_mobile1,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";

		     // echo "<pre>";print_r($order_query);exit();
			// $order_query = "SELECT o.*,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";

			// echo $order_query;exit();

	    	$record['order_data'] = $this->db->query($order_query)->result_array();

	    	if ($role == 3) 
	    	{
	    		$designer = $this->db->query("SELECT user_id,user_name FROM user_master WHERE user_id = $user_id")->result_array();
	    		$record['designer_data'][0] = "All";
				foreach ($designer as $key => $value) {
					$record['designer_data'][$value['user_id']] = $value['user_name'];
				}
	    	}
	    	else
	    	{	
	    		$designer = $this->db->query("SELECT user_id,user_name FROM user_master")->result_array();
				$record['designer_data'][0] = "All";
				foreach ($designer as $key => $value) {
					$record['designer_data'][$value['user_id']] = $value['user_name'];
				}
	    	}

	    	$customer = $this->db->query("SELECT client_id,client_name FROM client_master")->result_array();
			$record['cust_data'][0] = "All";
			foreach ($customer as $key => $value) {
				$record['cust_data'][$value['client_id']] = $value['client_name'];
			}
			return $record;
		}

		public function get_designer_outstanding_data_xls($role,$user_id)
		{
			$extra = "";
			
			$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('2016-04-01');
		    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

			if(isset($_GET['designer']))
		    {
		        $designer_id = $_GET['designer']; 
		        if ($designer_id == '0') {
		        	$extra .="AND o.om_designer_id != 1";
		        } else{
		        	$extra .= "AND o.om_designer_id = $designer_id"; 
		        }

		        $customer_id = $_GET['customer']; 
			    if ($customer_id == '0') {
			    	$extra .=" AND o.om_client_id != 1";
			    } else{
			    	$extra .= " AND o.om_client_id = $customer_id"; 
			    }
		    }
		    else
		    {
		    	if ($role == 3) 
		    	{
		    		$extra .= "AND o.om_designer_id = $user_id"; 
		    	}
		    	else
		    	{
		    		$extra .="";	
		    	}

		    }

		    $order_query = "SELECT o.*,c.client_name,c.client_mobile1,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";


		    // echo "<pre>";print_r($order_query);exit();

	    	$order_data = $this->db->query($order_query)->result_array();

	       	$record['excel_array'][0] = array(
                0 =>  'ORDER NO',
                1 =>  'DATE',
                2 =>  'CLIENT NAME',
                3 =>  'MOBILE NO',
                4 =>  'DESIGNER NAME',
                5 =>  'TOTAL',
                6 =>  'ADVANCE',
                7 =>  'ROUND OFF',
                8 =>  'ADJUST AMT',
                9 =>  'BALANCE AMT',
            );

	    	foreach ($order_data as $key => $value) 
	    	{
	    		$balance = $value['om_final_total'] - $value['om_advance'] - $value['om_roundoff'] - $value['om_allocated_amt'];

	    		if ($balance > 0):
	    		/*excel_array*/
	           	$record['excel_array'][$key+1][0] = $value['om_no'];
	           	$record['excel_array'][$key+1][1] = date('d-m-Y',strtotime($value['om_date']));
	           	$record['excel_array'][$key+1][2] = $value['client_name'];
	           	$record['excel_array'][$key+1][3] = $value['client_mobile1'];
	           	$record['excel_array'][$key+1][4] = $value['user_name'];
	           	$record['excel_array'][$key+1][5] = $value['om_final_total'];
	           	$record['excel_array'][$key+1][6] = $value['om_advance'];
	           	$record['excel_array'][$key+1][7] = $value['om_roundoff'];
	           	$record['excel_array'][$key+1][8] = $value['om_allocated_amt'];
	           	$record['excel_array'][$key+1][9] = $balance;

	           	endif;
	    	}
			
			return $record;
		}

	/**** designer outstanding report end ******/
	

	/**** karigar outstanding report start ****/

	public function get_karigar_outstanding_data()
	{
		$extra = "";
		
		$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-01');
	    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

		if(isset($_GET['karigar']))
	    {
	        $karigar_id = $_GET['karigar'];

	        if ($karigar_id == '0') {
	        	$extra .="";
	        } else{
	        	$extra .= "AND h.hm_karigar_id = $karigar_id"; 
	        }
	    }
	    else
	    {
	    	$extra .="";	
	    }

		$hisab_query = "SELECT h.*,k.km_name,k.km_mob FROM hisab_master h LEFT JOIN karigar_master k ON(h.hm_karigar_id = k.km_id) WHERE h.hm_entry_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY hm_entry_no ASC";

		// $order_query = "SELECT o.*,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";

		// echo $hisab_query;exit();

    	$record['hisab_data'] = $this->db->query($hisab_query)->result_array();

		$karigar = $this->db->query("SELECT km_id,km_name FROM karigar_master ORDER BY km_name ASC")->result_array();
		$record['karigar_data'][0] = "All";
		foreach ($karigar as $key => $value) {
			$record['karigar_data'][$value['km_id']] = $value['km_name'];
		}
		return $record;
	}

	public function get_karigar_outstanding_data_xls()
	{
		$extra = "";
		
		$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-01');
	    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

		if(isset($_GET['karigar']))
	    {
	        $karigar_id = $_GET['karigar'];

	        if ($karigar_id == '0') {
	        	$extra .="";
	        } else{
	        	$extra .= "AND h.hm_karigar_id = $karigar_id"; 
	        }
	    }
	    else
	    {
	    	$extra .="";	
	    }

		$hisab_query = "SELECT h.*,k.km_name,k.km_mob FROM hisab_master h LEFT JOIN karigar_master k ON(h.hm_karigar_id = k.km_id) WHERE h.hm_entry_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY hm_entry_no ASC";

		// $order_query = "SELECT o.*,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";

		// echo $hisab_query;exit();
    	$hisab_data = $this->db->query($hisab_query)->result_array();


       	$record['excel_array'][0] = array(
            0 =>  'ENTRY NO',
            1 =>  'DATE',
            2 =>  'KARIGAR NAME',
            3 =>  'MOBILE NO',
            4 =>  'TOTAL',
            5 =>  'ADJUST AMT',
            6 =>  'ROUND OFF',
            7 =>  'BALANCE AMT',
        );

    	foreach ($hisab_data as $key => $value) 
    	{
    		$balance = $value['hm_amount'] - $value['hm_round_off'] - $value['hm_allocated_amt'];

    		if ($balance > 0):
    		/*excel_array*/
           	$record['excel_array'][$key+1][0] = $value['hm_entry_no'];
           	$record['excel_array'][$key+1][1] = date('d-m-Y',strtotime($value['hm_entry_date']));
           	$record['excel_array'][$key+1][2] = $value['km_name'];
           	$record['excel_array'][$key+1][3] = $value['km_mob'];
           	$record['excel_array'][$key+1][4] = $value['hm_amount'];
           	$record['excel_array'][$key+1][5] = $value['hm_allocated_amt'];
           	$record['excel_array'][$key+1][6] = $value['hm_round_off'];
           	$record['excel_array'][$key+1][7] = $balance;
           	endif;
    	}
		
		return $record;

	}

	/**** karigar outstanding report end ******/


	/**** gst report start ******/

		public function get_gst_report_data()
		{
			$extra = "";
			
			$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-01');
		    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

			if(isset($_GET['customer']))
		    {
		        $customer_id = $_GET['customer']; 
		        if ($customer_id == '0') {
		        	$extra .="AND o.om_client_id != 1";
		        } else{
		        	$extra .= "AND o.om_client_id = $customer_id"; 
		        }
		    }
		    else
		    {
		    	$extra .="";	
		    }

			$order_query = "SELECT o.*,c.client_name,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_gst_inv_no != 0 AND o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";

			// $order_query = "SELECT o.*,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";

			// echo $order_query;exit();

	    	$record['order_data'] = $this->db->query($order_query)->result_array();

			$customer = $this->db->query("SELECT client_id,client_name FROM client_master")->result_array();
			$record['cust_data'][0] = "All";
			foreach ($customer as $key => $value) {
				$record['cust_data'][$value['client_id']] = $value['client_name'];
			}
			return $record;
		}

		public function get_gst_report_data_xls()
		{
			$extra = "";
			
			$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-01');
		    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

			if(isset($_GET['customer']))
		    {
		        $customer_id = $_GET['customer']; 
		        if ($customer_id == '0') {
		        	$extra .="AND o.om_client_id != 1";
		        } else{
		        	$extra .= "AND o.om_client_id = $customer_id"; 
		        }
		    }
		    else
		    {
		    	$extra .="";	
		    }

			$order_query = "SELECT o.*,c.client_name,u.user_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_gst_inv_no != 0 AND o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";

			// $order_query = "SELECT o.*,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";

			// echo $order_query;exit();

	    	$order_data = $this->db->query($order_query)->result_array();

	    	$record['excel_array'][0] = array(
                0 =>  'GST INV NO',
                1 =>  'ORDER NO',
                2 =>  'DATE',
                3 =>  'CLIENT NAME',
                4 =>  'DESIGNER',
                5 =>  'SGST',
                6 =>  'cGST',
                7 =>  'IGST',
                8 =>  'TOTAL',
                9 =>  'DISC AMT',
                10 =>  'SUB AMT',
                11 =>  'ADVANCE',
                12 =>  'ROUND OFF',
                13 =>  'ADJUST AMT',
                14 =>  'BALANCE AMT'
                
            );

	    	foreach ($order_data as $key => $value) 
	    	{
	    		$balance = $value['om_final_total'] - $value['om_advance'] - $value['om_roundoff'] - $value['om_allocated_amt'];

	    		/*excel_array*/
	           	$record['excel_array'][$key+1][0] = $value['om_gst_inv_no'];
	           	$record['excel_array'][$key+1][1] = $value['om_no'];
	           	$record['excel_array'][$key+1][2] = date('d-m-Y',strtotime($value['om_date']));
	           	$record['excel_array'][$key+1][3] = $value['client_name'];
	           	$record['excel_array'][$key+1][4] = $value['user_name'];
	           	$record['excel_array'][$key+1][5] = $value['om_sgst_amt'];
	           	$record['excel_array'][$key+1][6] = $value['om_cgst_amt'];
	           	$record['excel_array'][$key+1][7] = $value['om_igst_amt'];
	           	$record['excel_array'][$key+1][8] = $value['om_final_total'];
	           	$record['excel_array'][$key+1][9] = $value['om_disc_amt'];
	           	$record['excel_array'][$key+1][10] = $value['om_taxable_total'];
	           	$record['excel_array'][$key+1][11] = $value['om_advance'];
	           	$record['excel_array'][$key+1][12] = $value['om_roundoff'];
	           	$record['excel_array'][$key+1][13] = $value['om_allocated_amt'];
	           	$record['excel_array'][$key+1][14] = $balance;
	    	}
			return $record;
		}

	/**** gst report end ******/
	



	/***** daily transaction data  ********/

		public function get_daily_trans_data($fin_year)
		{
			$extra = "";
			
			$start_date	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-d');
		    $end_date  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-d');

		    /*receipt voucher data*/
			$receipt_voucher_query = "SELECT v.*,c.client_name FROM voucher_master v LEFT JOIN client_master c ON(v.vc_party_id = c.client_id) WHERE v.vc_fin_year = '$fin_year' AND v.vc_voucher_type = 2 AND v.vc_entry_date BETWEEN '$start_date' AND '$end_date' ORDER BY client_name ASC";
			
			$record['receipt_voucher_data'] = $this->db->query($receipt_voucher_query)->result_array();

			$vc_cash_total 			= 0;
			$vc_upi_gpay_total 		= 0;
			$vc_credit_card_total 	= 0;
			$vc_debit_card_total 	= 0;

			foreach ($record['receipt_voucher_data'] as $key => $value) 
			{
				if ($value['vc_payment_type'] == 1) 
				{
					$vc_cash_total += $value['vc_amount'];
				}
				else if ($value['vc_payment_type'] == 5) 
				{
					$vc_upi_gpay_total += $value['vc_amount'];
				}
				else if ($value['vc_payment_type'] == 6) 
				{
					$vc_credit_card_total += $value['vc_amount'];
				}
				else if ($value['vc_payment_type'] == 7) 
				{
					$vc_debit_card_total += $value['vc_amount'];
				}
			}

			/******** payment voucher data ***********/
			$payment_voucher_query = "SELECT v.*,k.km_name as name,acc.acc_name as name FROM voucher_master v LEFT JOIN karigar_master k ON(v.vc_party_id = k.km_id) LEFT JOIN account_master acc ON(v.vc_party_id = acc.acc_id) WHERE v.vc_fin_year = '$fin_year' AND v.vc_voucher_type = 1 AND v.vc_entry_date BETWEEN '$start_date' AND '$end_date' ORDER BY km_name ASC";
			
			$record['payment_voucher_data'] = $this->db->query($payment_voucher_query)->result_array();

			$pvc_cash_total 		= 0;
			$pvc_upi_gpay_total 	= 0;
			$pvc_credit_card_total 	= 0;
			$pvc_debit_card_total 	= 0;

			foreach ($record['payment_voucher_data'] as $key => $value) 
			{
				if ($value['vc_payment_type'] == 1) 
				{
					$pvc_cash_total += $value['vc_amount'];
				}
				else if ($value['vc_payment_type'] == 5) 
				{
					$pvc_upi_gpay_total += $value['vc_amount'];
				}
				else if ($value['vc_payment_type'] == 6) 
				{
					$pvc_credit_card_total += $value['vc_amount'];
				}
				else if ($value['vc_payment_type'] == 7) 
				{
					$pvc_debit_card_total += $value['vc_amount'];
				}
			}

			// echo "<pre>";print_r($voucher_data);exit();
			
			$sale_adv_query = "SELECT o.om_id,o.om_no,o.om_date,o.om_client_id,o.om_advance,o.om_payment_mode,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_fin_year = '$fin_year' AND (o.om_advance > 0) AND o.om_date BETWEEN '$start_date' AND '$end_date' ORDER BY client_name ASC";
			
			$record['adv_data'] = $this->db->query($sale_adv_query)->result_array();

			$sa_cash_total 			= 0;
			$sa_upi_gpay_total 		= 0;
			$sa_credit_card_total 	= 0;
			$sa_debit_card_total 	= 0;

			foreach ($record['adv_data'] as $key => $value) {
				
				if ($value['om_payment_mode'] == 1) 
				{
					$sa_cash_total += $value['om_advance'];
				}
				else if ($value['om_payment_mode'] == 5) 
				{
					$sa_upi_gpay_total += $value['om_advance'];
				}
				else if ($value['om_payment_mode'] == 6) 
				{
					$sa_credit_card_total += $value['om_advance'];
				}
				else if ($value['om_payment_mode'] == 7) 
				{
					$sa_debit_card_total += $value['om_advance'];
				}
			}

			$sale_query = "SELECT o.*,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_fin_year = '$fin_year' AND o.om_date BETWEEN '$start_date' AND '$end_date' ORDER BY client_name ASC";
			
			$record['sale_data'] = $this->db->query($sale_query)->result_array();


			$record['total_cash_collection']   = $vc_cash_total   + $sa_cash_total;
			$record['total_upi_gpay_collection'] = $vc_upi_gpay_total + $sa_upi_gpay_total;
			$record['total_credit_card_collection'] = $vc_credit_card_total + $sa_credit_card_total;
			$record['total_debit_card_collection']   = $vc_debit_card_total   + $sa_debit_card_total;

			$record['total_cash_payment']   = $pvc_cash_total;
			$record['total_upi_gpay_payment'] = $pvc_upi_gpay_total;
			$record['total_credit_card_payment'] = $pvc_credit_card_total;
			$record['total_debit_card_payment']   = $pvc_debit_card_total;


			$user_query = "SELECT u.user_id,u.user_name,u.user_role_id FROM user_master u WHERE u.user_role_id = 3";
			$data = $this->db->query($user_query)->result_array();

			// echo"<pre>";print_r($data);exit;
			
			// $designer_data = array();
			// foreach ($data as $key => $value) 
			// {
			// 	$uid = $value['user_id'];

			// 	$dsg_sale_query = "SELECT sum(om_final_total) as today_sale FROM order_master WHERE om_fin_year = '$fin_year' AND om_date BETWEEN '$start_date' AND '$end_date' AND om_designer_id = $uid";
			// 	$sale_data = $this->db->query($dsg_sale_query)->result_array();

			// 	$designer_data[$key]['designer_name'] = $value['user_name'];
			// 	$designer_data[$key]['sale_amt'] 	= $sale_data[0]['today_sale'];
			// }
			
			// $record['designer_sale'] = $designer_data;
			return $record;
		}
	/***** cust daily collection end ********/

	/***** daily transaction data  ********/

		// Function to get all the dates in given range 
		function getDatesFromRange($start, $end, $format = 'Y-m-d') { 
		      
		    // Declare an empty array 
		    $array = array(); 
		      
		    // Variable that store the date interval 
		    // of period 1 day 
		    $interval = new DateInterval('P1D'); 
		  
		    $realEnd = new DateTime($end); 
		    $realEnd->add($interval); 
		  
		    $period = new DatePeriod(new DateTime($start), $interval, $realEnd); 
		  
		    // Use loop to store date into array 
		    foreach($period as $date) {                  
		        $array[] = $date->format($format);  
		    } 
		  
		    // Return the array elements 
		    return $array; 
		} 

		public function get_daily_collection_data($fin_year)
		{
			$extra = "";
			
			$st_start_date	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('Y-m-d');
		    $st_end_date  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-d');

		    $Date = $this->getDatesFromRange($st_start_date, $st_end_date); 
			
		    // echo "<pre>";print_r($Date);exit;
			// var_dump($Date); 

		    /*receipt voucher data*/
		    $days_collection = array();

		    foreach ($Date as $key1 => $value1) {

		    	$start_date	= date('Y-m-d',strtotime($value1));
		    	$end_date  	= date('Y-m-d',strtotime($value1));

				$receipt_voucher_query = "SELECT v.*,c.client_name FROM voucher_master v LEFT JOIN client_master c ON(v.vc_party_id = c.client_id) WHERE v.vc_fin_year = '$fin_year' AND v.vc_voucher_type = 2 AND v.vc_entry_date BETWEEN '$start_date' AND '$end_date'";
				
				$record['receipt_voucher_data'] = $this->db->query($receipt_voucher_query)->result_array();


		    // echo "<pre>";print_r($record);exit;


				$vc_cash_total 			= 0;
				$vc_upi_gpay_total 		= 0;
				$vc_credit_card_total 	= 0;
				$vc_debit_card_total 	= 0;

				foreach ($record['receipt_voucher_data'] as $key => $value) 
				{
					if ($value['vc_payment_type'] == 1) 
					{
						$vc_cash_total += $value['vc_amount'];
					}
					else if ($value['vc_payment_type'] == 5) 
					{
						$vc_upi_gpay_total += $value['vc_amount'];
					}
					else if ($value['vc_payment_type'] == 6) 
					{
						$vc_credit_card_total += $value['vc_amount'];
					}
					else if ($value['vc_payment_type'] == 7) 
					{
						$vc_debit_card_total += $value['vc_amount'];
					}
				}
				

				// echo "<pre>";print_r($voucher_data);exit();
				
				$sale_adv_query = "SELECT o.om_id,o.om_no,o.om_date,o.om_client_id,o.om_advance,o.om_payment_mode,u.user_name,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) LEFT JOIN user_master u ON(o.om_designer_id = u.user_id) WHERE o.om_fin_year = '$fin_year' AND (o.om_advance > 0) AND o.om_date BETWEEN '$start_date' AND '$end_date'";
				
				$record['adv_data'] = $this->db->query($sale_adv_query)->result_array();

				$sa_cash_total 		= 0;
				$sa_upi_gpay_total 	= 0;
				$sa_credit_card_total 	= 0;
				$sa_debit_card_total 		= 0;

				foreach ($record['adv_data'] as $key => $value) {
					
					if ($value['om_payment_mode'] == 1) 
					{
						$sa_cash_total += $value['om_advance'];
					}
					else if ($value['om_payment_mode'] == 5) 
					{
						$sa_upi_gpay_total += $value['om_advance'];
					}
					else if ($value['om_payment_mode'] == 6) 
					{
						$sa_credit_card_total += $value['om_advance'];
					}
					else if ($value['om_payment_mode'] == 7) 
					{
						$sa_debit_card_total += $value['om_advance'];
					}
				}


				$days_collection[$key1]['sr_no']   				   = $key1;
				$days_collection[$key1]['date']   				   = $start_date;
				$days_collection[$key1]['total_cash_collection']   = $vc_cash_total   + $sa_cash_total;
				$days_collection[$key1]['total_upi_gpay_collection'] = $vc_upi_gpay_total + $sa_upi_gpay_total;
				$days_collection[$key1]['total_credit_card_collection'] = $vc_credit_card_total + $sa_credit_card_total;
				$days_collection[$key1]['total_debit_card_collection']   = $vc_debit_card_total   + $sa_debit_card_total;

		    	// echo "<pre>";print_r($days_collection);exit;

		    }

		    // $collection =  ksort($days_collection);


		    // echo "<pre>";print_r($days_collection);exit;

			
			return $days_collection;
		}
	/***** cust daily collection end ********/
	// Stock Report Start
    	public function get_all_bal_stock_data_rows()
		{
			$limit = '';
			$subsql = "";		
			$check_box = "";	
			
			if(isset($_GET['search_value_supp_name']) && (!empty($_GET['search_value_supp_name'])) )
			{
				$subsql .= " AND acc.acc_id = '".$_GET['search_value_supp_name']."'";
			}
			if(isset($_GET['search_value_fabric_code']) && (!empty($_GET['search_value_fabric_code'])) )
			{
				$subsql .= " AND isb.isb_fabric_code like '%".$_GET['search_value_fabric_code']."%'";
			}
			if(isset($_GET['search_value_by_width']) && (!empty($_GET['search_value_by_width'])) )
			{
				$subsql .= " AND isb.isb_width like '%".$_GET['search_value_by_width']."%'";
			}
			if(isset($_GET['search_value_by_design_no']) && (!empty($_GET['search_value_by_design_no'])) )
			{
				$subsql .= " AND isb.isb_design_no like '%".$_GET['search_value_by_design_no']."%'";
			}
			if(isset($_GET['bal_zero']) && (!empty($_GET['bal_zero'])) )
			{
				$check_box .= "AND isb.isb_sales_out_qty >= isb.isb_meter_per_pc";
			}
		
			return $this->db->query("SELECT isb.*,acc.acc_name,fm.fabric_name,
				isb.isb_meter_per_pc-isb.isb_sales_out_qty as bal_qty
				FROM inward_stock_barcode isb
				LEFT JOIN account_master acc ON(isb.isb_ism_supplier_id=acc.acc_id)
				LEFT JOIN fabric_master fm ON(isb.isb_fabric_id=fm.fabric_id)
				WHERE 1 $subsql $check_box AND isb.isb_delete_status = 0 
				
				")->num_rows();
		}

		public function get_bal_stock_data($per_page,$offset)
		{
			$limit = '';
			$subsql = "";		
			$check_box = "";	
			
			if(isset($_GET['search_value_supp_name']) && (!empty($_GET['search_value_supp_name'])) )
			{
				$subsql .= " AND acc.acc_id = '".$_GET['search_value_supp_name']."'";
			}
			if(isset($_GET['search_value_fabric_name']) && (!empty($_GET['search_value_fabric_name'])) )
			{
				$subsql .= " AND fm.fabric_name like '%".$_GET['search_value_fabric_name']."%'";
			}
			if(isset($_GET['search_value_fabric_code']) && (!empty($_GET['search_value_fabric_code'])) )
			{
				$subsql .= " AND isb.isb_item_code like '%".$_GET['search_value_fabric_code']."%'";
			}
			if(isset($_GET['search_value_by_width']) && (!empty($_GET['search_value_by_width'])) )
			{
				$subsql .= " AND isb.isb_width like '%".$_GET['search_value_by_width']."%'";
			}
			if(isset($_GET['search_value_by_design_no']) && (!empty($_GET['search_value_by_design_no'])) )
			{
				$subsql .= " AND isb.isb_design_no like '%".$_GET['search_value_by_design_no']."%'";
			}
			if(isset($_GET['bal_zero']) && (!empty($_GET['bal_zero'])) )
			{
				$check_box .= "AND isb.isb_sales_out_qty >= isb.isb_meter_per_pc";
			}
		
			$result['stock_data'] = $this->db->query("SELECT isb.*,acc.acc_name,fm.fabric_name,
				isb.isb_meter_per_pc-isb.isb_sales_out_qty as bal_qty
				FROM inward_stock_barcode isb
				LEFT JOIN account_master acc ON(isb.isb_ism_supplier_id=acc.acc_id)
				LEFT JOIN fabric_master fm ON(isb.isb_fabric_id=fm.fabric_id)
				WHERE 1 $subsql $check_box AND isb.isb_delete_status = 0 LIMIT $per_page OFFSET $offset
				
				")->result_array();

			$total_data = $this->db->query("SELECT isb.*,acc.acc_name,fm.fabric_name,
				isb.isb_meter_per_pc-isb.isb_sales_out_qty as bal_qty
				FROM inward_stock_barcode isb
				LEFT JOIN account_master acc ON(isb.isb_ism_supplier_id=acc.acc_id)
				LEFT JOIN fabric_master fm ON(isb.isb_fabric_id=fm.fabric_id)
				WHERE 1 $subsql $check_box AND isb.isb_delete_status = 0
				
				")->result_array();

 

	        $query = "SELECT isb.*,acc.acc_id,acc.acc_name,fm.fabric_id,fm.fabric_name,
				isb.isb_meter_per_pc-isb.isb_sales_out_qty as bal_qty
				FROM inward_stock_barcode isb
				LEFT JOIN account_master acc ON(isb.isb_ism_supplier_id=acc.acc_id)
				LEFT JOIN fabric_master fm ON(isb.isb_fabric_id=fm.fabric_id)
				WHERE 1 AND isb.isb_delete_status = 0 
				";
	       	$data = $this->db->query($query)->result_array();

	       	// echo "<pre>";print_r($data);exit;

		  $total_isb_meter_per_pc = 0;
		  $total_isb_sales_out_qty = 0;
		  $total_bal_qty = 0;
		  foreach($total_data as $key => $value)
		  {
		  	$total_isb_meter_per_pc = $total_isb_meter_per_pc + $value['isb_meter_per_pc'];
          	$total_isb_sales_out_qty = $total_isb_sales_out_qty + $value['isb_sales_out_qty'];
          	$total_bal_qty = $total_bal_qty + $value['bal_qty'];
		  }

		  $result['total_isb_meter_per_pc'] = $total_isb_meter_per_pc;
		  $result['total_isb_sales_out_qty'] = $total_isb_sales_out_qty;
		  $result['total_bal_qty'] = $total_bal_qty;



        	// supplier drop down
        	$result['supplier_data'][0] = "All";
        	foreach ($data as $key => $value) {
        		$result['supplier_data'][$value['acc_id']] = strtoupper($value['acc_name']);
        	}
    //     	// supplier drop down       	

    //     	// barcode drop down        	        	
    //     	$result['item_code_data'][0] = "All";
    //     	foreach ($data as $key => $value) {
    //     		$result['item_code_data'][$value['isb_id']] = $value['isb_item_code'];
    //     	}
    //     	// barcode drop down        	        	

        	// fabric drop down
        	$result['fabric_data'][0] = "All";
        	foreach ($data as $key => $value) {
        		$result['fabric_data'][$value['fabric_id']] = strtoupper($value['fabric_name']);
        	}
    //     	// fabric drop down

    //     	// width drop down  
    //     	$query = "SELECT
				// bim.bim_id, bim.bim_width				
				// FROM barcode_inward_master bim 
	   //       	WHERE bim.bim_delete_status = 0 
	   //       	GROUP BY bim.bim_width ASC	   
    //     	";
	   //     	$data = $this->db->query($query)->result_array();      	
    //     	$result['width_data'][0] = "All";
    //     	foreach ($data as $key => $value) 
    //     	{
    //     		if(!empty($value['bim_width']))
    //     		{
    //     			$result['width_data'][$value['bim_id']] = $value['bim_width'];
    //     		}
    //     	}
    //     	// width drop down  

    //     	// desc drop down  
    //     	$query = "SELECT
				// isb.isb_id, isb.isb_desc			
				// FROM inward_stock_barcode isb 
	   //       	WHERE isb.isb_delete_status = 0 
	   //       	GROUP BY isb.isb_desc ASC	   
    //     	";
	   //     	$data = $this->db->query($query)->result_array();      	
    //     	$result['desc_data'][0] = "All";
    //     	foreach ($data as $key => $value) 
    //     	{
    //     		if(!empty($value['isb_desc']))
    //     		{
    //     			$result['desc_data'][$value['isb_id']] = $value['isb_desc'];
    //     		}
    //     	}
        	// desc drop down        	

			
	       	// echo "<pre>"; print_r($result);exit;
			return $result;
		}

		/**** purchase report ******/
	    public function get_purchase_summary_data($fin_year)
	    {
	    	$record = array();

	    	$date_start = date("Y-m-01");
			$date_end   = date("Y-m-t");

	    	$extra = "";
	    	$dsg_extra = "";
	    	
	    	if (isset($_GET['date_start'])) 
	    	{
	    		$date_start = date("Y-m-d", strtotime($_GET['date_start']));
				$date_end 	= date("Y-m-d", strtotime($_GET['date_end']));
	    	}

	    	if(isset($_GET['acc_id']) && (!empty($_GET['acc_id'])) )
			{
				$extra .= " AND acc.acc_id = '".$_GET['acc_id']."'";
			}

	    	$order_query = "SELECT im.*,acc.acc_id,acc.acc_name,im.ism_entry_date FROM inward_stock_master im LEFT JOIN account_master acc ON(im.ism_supplier_id = acc.acc_id) WHERE 1 $extra $dsg_extra AND im.ism_entry_date BETWEEN '$date_start' AND '$date_end' ORDER BY ism_bill_no ASC";

	    	$record['inward_data'] = $this->db->query($order_query)->result_array();
	    	
	    	$acc = $this->db->query("SELECT acc_id,acc_name FROM account_master WHERE acc_grp_id = 6 ")->result_array();
			$record['acc_data'][0] = "Enter Supplier Name";
	    	foreach ($acc as $key => $value) {
				$record['acc_data'][$value['acc_id']] = $value['acc_name'];
			}

			return $record;
	    }

	    /**** customer outstanding report******/
		public function get_supp_outstanding_data()
		{
			$extra = "";
			
			$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('2016-04-01');
		    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

			if(isset($_GET['supplier']))
		    {
		        $supplier_id = $_GET['supplier']; 
		        if ($supplier_id == '0') {
		        	$extra .="AND ism.ism_supplier_id != 1";
		        } else{
		        	$extra .= "AND ism.ism_supplier_id = $supplier_id"; 
		        }
		    }
		    else
		    {
		    	$extra .="";	
		    }

			$order_query = "SELECT ism.*,acc.acc_name,acc.acc_mobile FROM inward_stock_master ism LEFT JOIN account_master acc ON(ism.ism_supplier_id = acc.acc_id) WHERE ism.ism_entry_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY ism_entry_no ASC";

			// $order_query = "SELECT o.*,c.client_name FROM order_master o LEFT JOIN client_master c ON(o.om_client_id = c.client_id) WHERE o.om_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY om_no ASC";
			// echo $order_query;exit();

	    	$record['order_data'] = $this->db->query($order_query)->result_array();

			$supplier = $this->db->query("SELECT acc_id,acc_name FROM account_master")->result_array();
			$record['supp_data'][0] = "All";
			foreach ($supplier as $key => $value) {
				$record['supp_data'][$value['acc_id']] = $value['acc_name'];
			}
			return $record;
		}

		public function get_supp_outstanding_data_xls()
		{
			$extra = "";
			
			$date_start	= isset($_GET['date_start']) ? date('Y-m-d',strtotime($_GET['date_start'])): date('2016-04-01');
		    $date_end  	= isset($_GET['date_end']) ? date('Y-m-d',strtotime($_GET['date_end'])): date('Y-m-t');

			if(isset($_GET['supplier']))
		    {
		        $supplier_id = $_GET['supplier']; 
		        if ($supplier_id == '0') {
		        	$extra .="AND ism.ism_supplier_id != 1";
		        } else{
		        	$extra .= "AND ism.ism_supplier_id = $supplier_id"; 
		        }
		    }
		    else
		    {
		    	$extra .="";	
		    }

			$order_query = "SELECT ism.*,acc.acc_name,acc.acc_mobile FROM inward_stock_master ism LEFT JOIN account_master acc ON(ism.ism_supplier_id = acc.acc_id) WHERE ism.ism_entry_date BETWEEN '$date_start' AND '$date_end' $extra ORDER BY ism_entry_no ASC";
	    	$order_data = $this->db->query($order_query)->result_array();

	       	$record['excel_array'][0] = array(
                0 =>  'ENTRY NO',
                1 =>  'ENTRY DATE',
                2 =>  'SUPPLIER NAME',
                3 =>  'MOBILE NO',
                4 =>  'TOTAL',
                5 =>  'ROUND OFF',
                6 =>  'ADJUST AMT',
                7 =>  'BALANCE AMT'
            );

	    	foreach ($order_data as $key => $value) 
	    	{
	    		$balance = $value['ism_total'] - $value['ism_allocated_amt'];
	    		/*excel_array*/
	           	if ($balance > 0):

	           	$record['excel_array'][$key+1][0] = $value['ism_entry_no'];
	           	$record['excel_array'][$key+1][1] = date('d-m-Y',strtotime($value['ism_entry_date']));
	           	$record['excel_array'][$key+1][2] = $value['acc_name'];
	           	$record['excel_array'][$key+1][3] = $value['acc_mobile'];
	           	$record['excel_array'][$key+1][4] = $value['ism_total'];
	           	$record['excel_array'][$key+1][5] = $value['ism_round_off'];
	           	$record['excel_array'][$key+1][6] = $value['ism_allocated_amt'];
	           	$record['excel_array'][$key+1][7] = $balance;

	           endif;
	    	}
			
			return $record;
		}
	/**** customer outstanding report end ******/

/************************ Customer Report Start *************************************/

	public function get_customer_ledger_data()
	{
		$extra1 = "";
		$extra2 = "";
		$extra3 = "";

		if(!empty($_GET['client_id']))
		{				
			$client_id = $_GET['client_id'];
			$extra1 = " AND om.om_client_id = $client_id";
			$extra2 = " AND vc.vc_party_id = $client_id";
			$extra3 = " AND om.om_client_id = $client_id AND vc.vc_party_id = $client_id";

			$client_nm = $this->db->query("SELECT client_name FROM client_master WHERE client_id=$client_id")->result_array();
		
			$client_name = $client_nm[0]['client_name'];
		}
		else
		{
			$client_id = "";

			$client_name = "";
		}

		$record['client_bill_data'] = $this->db->query("SELECT om.*,cm.client_mobile1,cm.client_name,cm.client_accno FROM order_master om 
	 		LEFT JOIN client_master cm ON(om.om_client_id=cm.client_id)
	 		WHERE 1 $extra1  ORDER BY om.om_no")->result_array();

		$record['voucher_data'] = $this->db->query("SELECT vc.*,cm.client_name
							FROM voucher_master vc
							LEFT JOIN client_master cm ON (vc.vc_party_id = cm.client_id)
							WHERE vc.vc_voucher_type = 2 AND vc.vc_grp_id = 5  $extra2 ORDER BY vc.vc_entry_no")->result_array();

		// echo "SELECT vc.*,cm.client_name
		// 					FROM voucher_master vc
		// 					LEFT JOIN client_master cm ON (vc.vc_cash_acc_id = cm.client_id)
		// 					WHERE vc.vc_voucher_type = 2 AND vc.vc_grp_id = 5  $extra2 ORDER BY vc.vc_entry_no";exit;


		$record['client_bill_data1'] = $this->db->query("SELECT (SUM(om.om_final_total -om.om_advance)) AS total_sale,cm.client_name FROM order_master om 
	 		LEFT JOIN client_master cm ON(om.om_client_id=cm.client_id)
	 		WHERE 1 $extra1 GROUP BY om.om_client_id ORDER BY om.om_no")->result_array();

		$record['voucher_data1'] = $this->db->query("SELECT (SUM(vc_amount)) AS total_voucher,cm.client_name
					FROM voucher_master vc
					LEFT JOIN client_master cm ON (vc.vc_party_id = cm.client_id)
					WHERE vc.vc_voucher_type = 2 AND vc.vc_grp_id = 5  $extra2 GROUP BY vc.vc_party_id ORDER BY vc.vc_entry_no ")->result_array();

		// echo "<pre>";print_r($record['voucher_data']);exit;

		$record['balance_data'] = array();

		foreach ($record['client_bill_data1'] as $key => $value) {
			$record['balance_data'][$value['client_name']]['client_name'] = $value['client_name'];
			$record['balance_data'][$value['client_name']]['total_sale'] = $value['total_sale'];
			$record['balance_data'][$value['client_name']]['balance'] = 0;
		}			

		foreach ($record['voucher_data1'] as $key => $value) 
		{
			$total_sale = isset($record['balance_data'][$value['client_name']]['total_sale'])  ? round($record['balance_data'][$value['client_name']]['total_sale']) : '';
			$record['balance_data'][$value['client_name']]['client_name'] = $value['client_name'];
			$record['balance_data'][$value['client_name']]['total_voucher'] = $value['total_voucher'];
			$record['balance_data'][$value['client_name']]['balance'] = $total_sale - round($record['balance_data'][$value['client_name']]['total_voucher']);
		}
		// echo "<pre>";print_r($record['balance_data']);exit;

		$record['client_name_show']['client_name'] = $client_name;
		// print_r($record['client_name_show']);exit;

		$client_data = $this->db->query("SELECT client_id, client_name,client_mobile1 FROM client_master ORDER BY client_name ASC")->result_array();

		$record['client_data'][0] = "Please Select";
		foreach ($client_data as $key => $value) {
			$record['client_data'][$value['client_id']] = $value['client_name'] .'-'. $value['client_mobile1'];
		}

		return $record;
	}

/******************************* Customer Report End ********************************/
/************************ Supplier Report Start *************************************/

	public function get_supplier_ledger_data()
	{
		$extra1 = "";
		$extra2 = "";
		$extra3 = "";

		if(!empty($_GET['acc_id']))
		{				
			$acc_id = $_GET['acc_id'];
			$extra1 = " AND ism.ism_supplier_id = $acc_id";
			$extra2 = " AND vc.vc_party_id = $acc_id";
			$extra3 = " AND ism.ism_supplier_id = $acc_id AND vc.vc_party_id = $acc_id";

			$acc_nm = $this->db->query("SELECT acc_name FROM account_master WHERE acc_id=$acc_id")->result_array();
		
			$acc_name = $acc_nm[0]['acc_name'];
		}
		else
		{
			$acc_id = "";

			$acc_name = "";
		}

		$record['acc_bill_data'] = $this->db->query("SELECT ism.*,acc.acc_mobile,acc.acc_name,acc.acc_mobile FROM inward_stock_master ism 
	 		LEFT JOIN account_master acc ON(ism.ism_supplier_id=acc.acc_id)
	 		WHERE 1 $extra1  ORDER BY ism.ism_entry_no")->result_array();

		$record['voucher_data'] = $this->db->query("SELECT vc.*,acc.acc_name
							FROM voucher_master vc
							LEFT JOIN account_master acc ON (vc.vc_party_id = acc.acc_id)
							WHERE vc.vc_voucher_type = 1 AND vc.vc_grp_id = 6  $extra2 ORDER BY vc.vc_entry_no")->result_array();

		// echo "SELECT vc.*,acc.acc_name
		// 					FROM voucher_master vc
		// 					LEFT JOIN account_master acc ON (vc.vc_cash_acc_id = acc.acc_id)
		// 					WHERE vc.vc_voucher_type = 2 AND vc.vc_grp_id = 5  $extra2 ORDER BY vc.vc_entry_no";exit;


		$record['acc_bill_data1'] = $this->db->query("SELECT (SUM(ism.ism_total)) AS total_sale,acc.acc_name FROM inward_stock_master ism 
	 		LEFT JOIN account_master acc ON(ism.ism_supplier_id=acc.acc_id)
	 		WHERE 1 $extra1 GROUP BY ism.ism_supplier_id ORDER BY ism.ism_entry_no")->result_array();

		$record['voucher_data1'] = $this->db->query("SELECT (SUM(vc_amount)) AS total_voucher,acc.acc_name
					FROM voucher_master vc
					LEFT JOIN account_master acc ON (vc.vc_party_id = acc.acc_id)
					WHERE vc.vc_voucher_type = 1 AND vc.vc_grp_id = 6  $extra2 GROUP BY vc.vc_party_id ORDER BY vc.vc_entry_no ")->result_array();

		// echo "<pre>";print_r($record['voucher_data']);exit;

		$record['balance_data'] = array();

		foreach ($record['acc_bill_data1'] as $key => $value) {
			$record['balance_data'][$value['acc_name']]['acc_name'] = $value['acc_name'];
			$record['balance_data'][$value['acc_name']]['total_sale'] = $value['total_sale'];
			$record['balance_data'][$value['acc_name']]['balance'] = 0;
		}			

		foreach ($record['voucher_data1'] as $key => $value) 
		{
			$total_sale = isset($record['balance_data'][$value['acc_name']]['total_sale'])  ? round($record['balance_data'][$value['acc_name']]['total_sale']) : '';
			$record['balance_data'][$value['acc_name']]['acc_name'] = $value['acc_name'];
			$record['balance_data'][$value['acc_name']]['total_voucher'] = $value['total_voucher'];
			$record['balance_data'][$value['acc_name']]['balance'] = $total_sale - round($record['balance_data'][$value['acc_name']]['total_voucher']);
		}
		// echo "<pre>";print_r($record['balance_data']);exit;

		$record['acc_name_show']['acc_name'] = $acc_name;
		// print_r($record['acc_name_show']);exit;

		$acc_data = $this->db->query("SELECT acc_id, acc_name,acc_mobile FROM account_master ORDER BY acc_name ASC")->result_array();

		$record['acc_data'][0] = "Please Select";
		foreach ($acc_data as $key => $value) {
			$record['acc_data'][$value['acc_id']] = $value['acc_name'] .'-'. $value['acc_mobile'];
		}

		return $record;
	}

/******************************* Customer Report End ********************************/


	public function get_delivery_report_data($f_year)
	{
		$extra1 = "";
		if(isset($_GET['date_start']) && isset($_GET['date_end']))
		{
	    	$date_start = date('Y-m-d',strtotime($_GET['date_start']));
	    	$date_end 	= date('Y-m-d',strtotime($_GET['date_end']));

	    	if($date_end == "1970-01-01")
	    	{ 
	    		$date_end = date('Y-m-d');
	    	}
	    }
	    else
	    {
	    	$date_start = date('2019-01-01');
	    	$date_end 	= date('Y-m-d');
	    }

	    if(isset($_GET['delivry']))
	    {
	    	$delivry = $_GET['delivry'];
	        $extra1 .= "AND om.om_checkbox = '".$delivry."'";
	    }
	    else
	    {
	    	$extra1 .= "AND om.om_checkbox = 0";
	    }
	    
	    if(isset($_GET['client_name_sr']) && $_GET['client_name_sr'] != "")
	    {
	    	
	    	$client_name_sr = $_GET['client_name_sr'];
	        $extra1 .= "AND cm.client_name like '%".$client_name_sr."%'";
	    }
	    else
	    {
	    	$extra1 .= "";
	    }

	    return $this->db->query("SELECT om.*,cm.client_mobile1,cm.client_name 
	    		FROM order_master om 
			    LEFT JOIN client_master cm ON(om.om_client_id=cm.client_id)
			    WHERE 1 AND om.om_delivery_date BETWEEN '$date_start' AND '$date_end' $extra1 
			     ")->result_array();
	}

	public function get_delivery_report_data_xls($f_year)
	{
			$delivery_data = $this->get_delivery_report_data($f_year);
		// echo "<pre>";print_r($delivery_data);die();			
			$record['excel_array'][0] = array(
        'OR NO', 'ORDER DATE', 'CLIENT NAME', 'MOBILE', 'TRIAL DATE', 'DELIVERY DATE', 'FINAL TOTAL', 'ADVANCE', 'BALANCE', 'NO OF DAYS'
    );

    $tail_final_amt = 0;
    $tail_advance_amt = 0;
    $tail_bal_amt = 0;
    $sms_cnt = 0;

    foreach ($delivery_data as $key => $value) 
    {
        $date1 = date_create(date('Y-m-d', strtotime($value['om_delivery_date'])));
        $date2 = date_create(date('Y-m-d'));
        $diff = date_diff($date1, $date2);

        $no_of_days = $diff->days; 

        $tail_final_amt += $value['om_final_total'];
        $tail_advance_amt += $value['om_advance'];
        $tail_bal_amt += $value['om_balance'];

        $record['excel_array'][$key + 1] = array(
            $value['om_no'],
            date('d-m-Y', strtotime($value['om_date'])),
            $value['client_name'],
            $value['client_mobile1'],
            date('d-m-Y', strtotime($value['om_trial_date'])),
            date('d-m-Y', strtotime($value['om_delivery_date'])),
            $value['om_final_total'],           
            $value['om_advance'],
            $value['om_balance'],
            $no_of_days
        );
    }

    $record['excel_array'][] = array(
        'TOTAL', '', '', '', '', '', $tail_final_amt, $tail_advance_amt, $tail_bal_amt, ''
    );

    return $record;
	}


/*Reportsmdl model end*/
	}
?>