<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Job_issue_model extends CI_Model
{   
    
    public function get_list($date_from,$to_date){     
        $subsql     = '';
        $subsql .= " AND jrm.jrm_entry_date >= '".$date_from."'";
        $subsql .= " AND jrm.jrm_entry_date <= '".$to_date."'";
        $query="SELECT jrm.*, 
                UPPER(cuser.user_full_name) as created_by,
                UPPER(muser.user_full_name) as updated_by,
                jrm.jrm_created_at as create_date,
                jrm.jrm_updated_at as update_date
                FROM job_receive_master jrm
                INNER JOIN job_receive_trans jrt ON(jrt.jrt_jrm_id = jrm.jrm_id)
                INNER JOIN barcode_master bm ON(bm.bm_id = jrt.jrt_bm_id)
                LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                LEFT JOIN branch_master branch ON(branch.branch_id = om.om_branch_id)
                LEFT JOIN user_master cuser ON(jrm.jrm_created_by = cuser.user_id) 
                LEFT JOIN user_master muser ON(jrm.jrm_updated_by = muser.user_id)
                WHERE jrm.jrm_delete_status = 0 
                $subsql
                GROUP BY jrm.jrm_id
                ORDER BY jrm.jrm_id DESC";

        return $this->db->query($query)->result_array();           
    }

    public function get_pending_barcode_data($karigar_id,$process_id){     
        
        $record=[];        
        $query="SELECT 
                ot.ot_id,
                ot.ot_barcode,
                UPPER(app.app_name) as product_name
                FROM job_issue_master jim
                INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
                INNER JOIN order_trans ot ON(ot.ot_id = jit.jit_ot_id)
                LEFT JOIN order_master om ON(om.om_id = ot.ot_om_id)
                LEFT JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
                LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jim_id = jit.jit_jim_id) 
                WHERE 1
                AND jim.jim_km_id = $karigar_id
                AND IFNULL(jrt.jrt_jim_id, 0)=0 
                GROUP BY ot.ot_id
                ORDER BY jit.jit_id DESC ";
        // print_r($query);die;          
        $data = $this->db->query($query)->result_array(); 
        if(!empty($data)){  
             foreach ($data as $key => $value) {     
                    $latest_data= $this->get_latest_data($value['ot_id']);
                    // if(!empty($value['product_attachment'])){
                    //     $img = base_url('public/uploads/product/'.$value['product_attachment']);
                    // }else{
                    //     $img = base_url('public/assets/img/no_image.jpg');
                    // }
                    $job_status = 'START';
                    $process_id = $process_id;

                    // if(!empty($latest_data)){  
                    //     if($latest_data[0]['jrt_id'] == 0){      
                    //         $job_status = 'FINISHED';
                    //         $process_id = '-1';
                    //     }
                    //  }    

                    array_push($record,[
                       'barcode'        => $value['ot_barcode'],
                       'apparel_name'   => $value['product_name'],
                       // 'apparel_image' => $img,
                       'process' =>[ 
                                [
                                   'name'=> $job_status,
                                   'id'=>  $process_id,
                                ]
                            ]
                    ]);
            }
        }

        return $record;
    }

    public function get_detail_data($id){  
        // $query="SELECT jrm.*
        //         FROM job_receive_master jrm
        //         WHERE jrm.jrm_delete_status = 0
        //         AND jrm.jrm_id = $id";
        // $record['master_data'] = $this->db->query($query)->result_array();

        $query="SELECT jrt.jrt_id,
                jrm.jrm_id, 
                jrt.jrt_jim_id as jim_id,
                jrt.jrt_jit_id as jit_id,
                bm.*,
                UPPER(app.app_name) as apparel_name,
                UPPER(client.client_name) as customer_name,
                UPPER(proces.proces_name) as proces_name,
                UPPER(km.km_name) as karigar_name,
                 UPPER(user.user_name) as user_name,
                 UPPER(branch.branch_name) as branch_name,
                om.om_entry_no as entry_no,
                DATE_FORMAT(om.om_entry_date, '%d-%m-%Y') as entry_date,
                IF(ot.ot_trial_date='0000-00-00','',DATE_FORMAT(ot.ot_trial_date, '%d-%m-%Y'))  as trial_date,
                IF(ot.ot_makeone_date='0000-00-00','',DATE_FORMAT(ot.ot_makeone_date, '%d-%m-%Y'))  as makeone_date,
                IF(om.om_grn_date='0000-00-00','',DATE_FORMAT(om.om_grn_date, '%d-%m-%Y'))  as grn_date,
                IF(om.om_delivery_date='0000-00-00','',DATE_FORMAT(om.om_delivery_date, '%d-%m-%Y'))  as delivery_date,
                IF(om.om_factory_date='0000-00-00','',DATE_FORMAT(om.om_factory_date, '%d-%m-%Y'))  as factory_date 
                FROM job_receive_trans jrt
                INNER JOIN job_receive_master jrm ON(jrm.jrm_id = jrt.jrt_jrm_id)
                INNER JOIN barcode_master bm ON(bm.bm_id = jrt.jrt_bm_id)
                INNER JOIN order_master om ON(om.om_id = bm.bm_om_id)
                LEFT JOIN branch_master branch ON(branch.branch_id = om.om_branch_id)
                LEFT JOIN client_master client ON(client.client_id = om.om_client_id)
                INNER JOIN order_trans ot ON(ot.ot_id = bm.bm_ot_id)
                INNER JOIN apparel_master app ON(app.app_id = ot.ot_app_id)
                INNER JOIN job_issue_master jim ON(jim.jim_id = jrt.jrt_jim_id)
                INNER JOIN proces_master proces ON(proces.proces_id = jim.jim_proces_id)
                INNER JOIN karigar_master km ON(km.km_id = jim.jim_karigar_id)
                INNER JOIN user_master user ON(user.user_id = om.om_km_id)
                WHERE jrt.jrt_delete_status = 0
                AND jrm.jrm_delete_status = 0
                AND om.om_status='RELEASED'
                AND jrt.jrt_jrm_id = $id
                GROUP BY jrt.jrt_id";
        $record = $this->db->query($query)->result_array();
       
        return $record;
    }
    public function _bm_id($bm_item_code){  
        $subsql = "";
        if(isset($bm_item_code) && !empty($bm_item_code)){
            $name   = $bm_item_code;
            $subsql .= " AND (bm.bm_item_code LIKE '".$name."%')";
        } 

        $query="SELECT bm.bm_id as id, 
                UPPER(bm.bm_item_code) as name
                FROM  barcode_master bm 
                WHERE 1
                $subsql
                GROUP BY bm.bm_id
                ORDER BY bm.bm_item_code ASC LIMIT 10 ";
        // echo $query; exit;
        $data = $this->db->query($query)->result_array();
        if(!empty($data)) return $data;
    }

    public function get_barcode_data($id){  
        $record=[];     
        $query="SELECT 
                ot.*,
                UPPER(app.app_name) as product_name,
                om.om_no as entry_no
                FROM order_trans ot
                INNER JOIN order_master om ON(om.om_id = ot.ot_om_id)
                INNER JOIN client_master client ON(client.client_id = om.om_client_id)
                INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
                WHERE ot.ot_id = $id";
        // print_r($query);die;        
        return $this->db->query($query)->result_array();
    }
    public function get_latest_data($id){  
        $query="SELECT jim.*,
                IFNULL(jrt.jrt_id, 0) as jrt_id,
                UPPER(designation.designation_name) as designation_name
                FROM job_issue_master jim
                INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
                INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
                LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jim_id = jit.jit_jim_id)
                WHERE 1
                AND jit.jit_ot_id = $id
                ORDER BY jit.jit_id DESC
                LIMIT 1";
        return $this->db->query($query)->result_array();
    }

    public function get_received_barcode($id){
        $record=[];    
        $query="SELECT 
                jit.jit_id,
                jit.jit_jim_id,    
                ot.ot_id as id, 
                UPPER(ot.ot_barcode) as name,
                IFNULL(jrt.jrt_jim_id, 0) as jrt_jim_id
                FROM job_issue_trans jit
                INNER JOIN order_trans ot ON(ot.ot_id = jit.jit_ot_id)
                LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jim_id = jit.jit_jim_id)
                WHERE ot.ot_id=$id
                HAVING jrt_jim_id = 0
                ORDER BY jit.jit_id DESC
                LIMIT 1";
        return $this->db->query($query)->result_array();
    }

    public function get_received_barcode_data($id){  
        $query="SELECT 
                ot.*,
                jim.*,
                UPPER(designation.designation_name) as designation_name,
                jit.jit_id,
                IFNULL(jrt.jrt_jim_id, 0) as jrt_jim_id
                FROM job_issue_master jim
                INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
                LEFT JOIN order_trans ot ON(ot.ot_id = jit.jit_ot_id)
                LEFT JOIN designation_master designation ON(designation.designation_id = jim.jim_designation) 
                LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jim_id = jit.jit_jim_id)        
                WHERE ot.ot_id = $id
                HAVING jrt_jim_id = 0";
            // print_r($query);

        return $this->db->query($query)->result_array();
    }
  
}