<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Jobissuemdl extends CI_model{
        public function isExist($id, $trans = false){ 
            if($trans){  
                $query ="SELECT ot.ot_id
                         FROM order_trans ot
                         WHERE ot.ot_delete_status = 0
                         AND ot.ot_done = 0
                         AND ot.ot_loc = 'OUT'
                         AND ot.ot_jit_id = $id
                        ";
                $data = $this->db->query($query)->result_array();
                if(!empty($data)) return false;
            }else{ 
                $query ="SELECT jrt.jrt_id
                         FROM job_receive_trans jrt
                         WHERE jrt.jrt_jim_id = $id
                        ";
                $data = $this->db->query($query)->result_array();
                if(empty($data)) return false;
            }
            return true;
        }
        public function get_issue_no($condition){
            $data   = $this->db->get_where('job_issue_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['jim_id'];
            $text   = $data[0]['jim_entry_no'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_barcode_no($condition){
            $data   = $this->db->get_where('order_trans',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['ot_id'];
            $text   = $data[0]['ot_barcode'];
            return ['value' => $value, 'text' => $text];
        }
        public function got_ot_barcode($condition){
            $data   = $this->db->get_where('order_trans',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['ot_id'];
            $text   = $data[0]['ot_barcode'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_km_code($condition){
            $data   = $this->db->get_where('karigar_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['km_id'];
            $text   = $data[0]['km_name'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_app_name($condition){
            $data   = $this->db->get_where('apparel_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['app_id'];
            $text   = $data[0]['app_name'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_designation($condition){
            $data   = $this->db->get_where('designation_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['designation_id'];
            $text   = $data[0]['designation_name'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_client_name($condition){
            $data   = $this->db->get_where('account_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['acc_id'];
            $text   = $data[0]['acc_name'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_order_no($condition){
            $data   = $this->db->get_where('order_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['om_id'];
            $text   = $data[0]['om_no'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_data($wantCount, $per_page = 20, $offset = 0){ 
            $record     = [];
            $subsql     = '';
            $having     = '';
            $limit      = '';
            $ofset      = '';
            
            if(!$wantCount){
                $limit .= " LIMIT $per_page";
                $ofset .= " OFFSET $offset";
            }
            
            if(isset($_GET['bm_id']) && !empty($_GET['bm_id'])){
                $subsql .=" AND ot.ot_id = ".$_GET['bm_id'];
                $record['search']['bm_id'] = $this->get_barcode_no(['ot_id' => $_GET['bm_id']]);
            }
            if(isset($_GET['jim_id']) && !empty($_GET['jim_id'])){
                $subsql .=" AND jim.jim_id = ".$_GET['jim_id'];
                $record['search']['jim_id'] = $this->get_issue_no(['jim_id' => $_GET['jim_id']]);
            }
            if(isset($_GET['jim_entry_date']) && !empty($_GET['jim_entry_date'])){
                $subsql .= " AND jim.jim_entry_date ='".date('Y-m-d', strtotime($_GET['jim_entry_date']))."'";
            }
            if(isset($_GET['ot_id']) && !empty($_GET['ot_id'])){
                $subsql .=" AND jit.jit_ot_id = ".$_GET['ot_id'];
                $record['search']['ot_id'] = $this->got_ot_barcode(['ot_id' => $_GET['ot_id']]);
            }
            if(isset($_GET['km_id']) && !empty($_GET['km_id'])){
                $subsql .=" AND jim.jim_km_id = ".$_GET['km_id'];
                $record['search']['km_id'] = $this->get_km_code(['km_id' => $_GET['km_id']]);
            } 
           
            if(isset($_GET['km_process']) && !empty($_GET['km_process'])){
                $subsql .=" AND jim.jim_designation = ".$_GET['km_process'];
                $record['search']['km_process'] = $this->get_designation(['designation_name' => $_GET['km_process']]);
            }

            if(isset($_GET['app_id']) && !empty($_GET['app_id'])){
                $subsql .=" AND app.app_id = ".$_GET['app_id'];
                $record['search']['app_id'] = $this->get_app_name(['app_id' => $_GET['app_id']]);
            }
            if(isset($_GET['client_id']) && !empty($_GET['client_id'])){
                $subsql .=" AND client.client_id = ".$_GET['client_id'];
                $record['search']['client_id'] = $this->get_client_name(['acc_id' => $_GET['client_id']]);
            }
            if(isset($_GET['om_id']) && !empty($_GET['om_id'])){
                $subsql .=" AND ot.ot_om_id = ".$_GET['om_id'];
                $record['search']['om_id'] = $this->get_order_no(['om_id' => $_GET['om_id']]);
            }
            if(isset($_GET['om_date']) && !empty($_GET['om_date'])){
                $subsql .= " AND om.om_date ='".date('Y-m-d', strtotime($_GET['om_date']))."'";
            }
            if(isset($_GET['om_delivery_date']) && !empty($_GET['om_delivery_date'])){
                $subsql .= " AND om.om_delivery_date ='".date('Y-m-d', strtotime($_GET['om_delivery_date']))."'";
            }
            if(isset($_GET['issue_status']) && !empty($_GET['issue_status'])){
                if($_GET['issue_status']==1){
                    $having =" AND status = 0";
                }else{
                    $having =" AND status > 0";
                }
            }

            if(isset($_GET['order_by']) && !empty($_GET['order_by'])){
                $order_by = $_GET['order_by'];
            }else{
                $order_by =" jim.jim_id";
            }
            if(isset($_GET['sort_by']) && !empty($_GET['sort_by'])){
                $sort_by = $_GET['sort_by'];
            }else{
                 $sort_by= "DESC";
            }
         
            $query ="
                        SELECT jim.jim_id, jim.jim_designation,designation.designation_name, 
                        jim.jim_entry_no, jim.jim_entry_date, jit.jit_id,
                        IFNULL((SELECT COUNT(jrt.jrt_id) FROM job_receive_trans jrt LEFT JOIN job_receive_master jrm
                        ON (jrt.jrt_jrm_id=jrm.jrm_id) WHERE jrm.jrm_designation=jim.jim_designation AND jrt.jrt_ot_id=ot.ot_id),0) as status,

                        om.om_no as om_no,
                        DATE_FORMAT(om.om_date, '%d-%m-%Y') as om_date,
                        DATE_FORMAT(om.om_delivery_date, '%d-%m-%Y') as om_delivery_date,
                        ot.ot_barcode, app.app_name,km.km_name,
                        client.client_name as client_name,ot.ot_id
                        FROM job_issue_master jim
                        INNER JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                        INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
                        INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
                        INNER JOIN order_trans ot ON(ot.ot_id = jit.jit_ot_id)
                        INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
                        LEFT JOIN order_master om ON(om.om_id = ot.ot_om_id)
                        INNER JOIN client_master client ON(client.client_id = om.om_client_id)
                        WHERE 1 
                        $subsql
                        GROUP BY jit.jit_id HAVING 1 $having
                        ORDER BY $order_by $sort_by
                        $limit
                        $ofset
                    ";
            // echo "<pre>"; print_r($query); exit;
            if($wantCount){
                return $this->db->query($query)->num_rows();
            }
            $record['data'] = $this->db->query($query)->result_array();

            if(!empty($record['data'])){
                foreach ($record['data'] as $key => $value) {
                $record['data'][$key]['isExist'] = $this->isexist_in_receive($value['ot_id'],$value['jim_designation']);
                }
            }
             // echo "<pre>"; print_r($record); exit;  
            return $record;
        }
        
        public function isexist_in_receive($ot_id,$process)
        {
            $query="SELECT * FROM job_receive_trans jrt LEFT JOIN job_receive_master jrm
            ON (jrt.jrt_jrm_id=jrm.jrm_id) WHERE jrm.jrm_designation='$process' AND jrt_ot_id='$ot_id'";
            return $this->db->query($query)->num_rows();
        }

        public function get_process(){ 
            $query ="
                        SELECT ot.ot_id, ot.ot_barcode 
                        FROM order_trans ot 
                        WHERE 1
                    ";

            $data = $this->db->query($query)->result_array(); 
            if(!empty($data)){
                // $record['data'][''] = 'SELECT'; 
                // $record['data']['DYING'] =  'DYING'; 
                // $record['data']['EMBROIDERY']  = 'EMBROIDERY'; 
                // $record['data']['STITCHING']  = 'STITCHING'; 

                $designation = $this->db->query("SELECT designation_id, UPPER(designation_name) AS designation_name FROM designation_master WHERE designation_id IN (1,2)")->result_array();
                $record['data'][0] = "SELECT";
                foreach ($designation as $key => $value) {
                    $record['data'][$value['designation_id']] = $value['designation_name'];
                }

            }else{
                $record['data'][''] = 'NO PENDING BARCODE AVAILABLE';
            }
            return $record;
        }
        public function get_data_for_edit($id){
            $master_query ="
                            SELECT jim.*, km.km_code
                            FROM job_issue_master jim
                            LEFT JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                            WHERE jim.jim_id = $id
                          "; 
            $data['master_data'] = $this->db->query($master_query)->result_array();
            $trans_query ="
                            SELECT jit.*, ot.ot_barcode, app.app_group, app.app_name, 
                            IF(bm.bm_am_id = 0 , CONCAT(UPPER(om.om_bill_series),'', om.om_entry_no), am.am_entry_no) as om_entry_no,
                            IF(bm.bm_am_id = 0 , DATE_FORMAT(om.om_entry_date, '%d-%m-%Y'), DATE_FORMAT(am.am_entry_date, '%d-%m-%Y')) as om_entry_date,
                            IF(bm.bm_am_id = 0 , DATE_FORMAT(om.om_delivery_date, '%d-%m-%Y'), DATE_FORMAT(am.am_delivery_date, '%d-%m-%Y')) as om_delivery_date,
                            client.client_name, client.client_mobile1 as client_code
                            FROM job_issue_trans jit
                            INNER JOIN barcode_master bm ON(bm.bm_id = jit.jit_ot_id)
                            INNER JOIN apparel_master app ON(app.app_id = bm.bm_app_id)
                            INNER JOIN client_master client ON(client.client_id = bm.bm_client_id)
                            LEFT JOIN order_master om ON(om.om_id = bm.bm_om_id)
                            LEFT JOIN alter_master am ON(am.am_id = bm.bm_am_id)
                            WHERE jit.jit_jim_id = $id
                            AND om.om_delete_status = 0
                          "; 
            $data['trans_data'] = $this->db->query($trans_query)->result_array();
            if(!empty($data['trans_data'])){
                foreach ($data['trans_data'] as $key => $value) {
                    $data['trans_data'][$key]['isExist'] = $this->isExist($value['jit_id'], true);
                }
            }
            return $data;
        }
        public function get_karigar($id){
            $query ="
                        SELECT km.km_id, UPPER(km.km_name) AS km_name
                        FROM karigar_master km
                        WHERE 1
                        AND km.km_desig = '$id'
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
         public function get_barcode($id){  
            $query ="
                        SELECT ot.*
                        FROM order_trans ot
                        LEFT JOIN apparel_master app ON(ot.ot_item_id = app.app_id)
                        WHERE 1
                        LIMIT 1
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_pending_job($id, $_from_date, $_to_date){ 
            $subsql = '';
            if(empty($_from_date)){
                $subsql .= " AND jim.jim_entry_date >= '".date('Y-m-d', strtotime('-7 DAYS'))."'";
            }else{
                $subsql .= " AND jim.jim_entry_date >= '".$_from_date."'";
            }
            if(empty($_to_date)){
                $subsql .= " AND jim.jim_entry_date <= '".date('Y-m-d')."'";
            }else{
                $subsql .= " AND jim.jim_entry_date <= '".$_to_date."'";
            }
            $query="SELECT jim.jim_id,
                    om.om_no as order_no,
                    DATE_FORMAT(jim.jim_entry_date, '%d-%m-%Y') as issue_date,
                    UPPER(app.app_name) as app_name,
                    ot.ot_id
                    FROM job_issue_master jim
                    INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
                    INNER JOIN order_trans ot ON(ot.ot_id = jit.jit_ot_id)
                    INNER JOIN order_master om ON(om.om_id = ot.ot_om_id)
                    INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
                    WHERE jim.jim_km_id = $id
                    $subsql
                    ORDER BY jim.jim_entry_date ASC";
            // echo "<pre>"; print_r($query); exit;
            $data = $this->db->query($query)->result_array();
            $record = [];
            if(!empty($data)){
                foreach ($data as $key => $value) {
                    $cnt = $this->db_operations->get_cnt('job_receive_trans', ['jrt_jim_id' => $value['jim_id'], 'jrt_ot_id' => $value['ot_id']]);
                    if($cnt <= 0){
                        array_push($record, $value);
                    }
                }
            }
            return $record;
        }
        public function get_issued_count($id){
            return [
                    'shirt_count'   => $this->get_issued_count_group($id, 'SHIRT_GROUP'), 
                ];
        }
        public function get_issued_count_group($id, $group){
            $query ="
                        SELECT COUNT(app_id) as cnt
                        FROM barcode_master bm
                        INNER JOIN job_issue_master jim ON(jim.jim_id = bm.bm_jim_id)
                        INNER JOIN job_issue_trans jit ON(jit.jit_id = bm.bm_jit_id)
                        INNER JOIN apparel_master app ON(app.app_id = bm.bm_app_id)
                        WHERE bm.bm_delete_status = 0
                        AND bm.bm_delivery_status = 0
                        AND bm.bm_style_id != 0
                        AND bm.bm_loc = 'OUT'
                        AND jim.jim_km_id = $id
                        AND app.app_group = '".$group."'
                    ";
            $data = $this->db->query($query)->result_array();
            if(!empty($data)) return $data[0]['cnt'];
            return 0;
        } 
        public function scan_barcode($id){ 
            $query="SELECT 0 as jit_id,
                ot.*,
                UPPER(app.app_name) as app_name,
                UPPER(client.client_name) as client_name,
                client.client_mobile1,
                om.om_no as om_no,
                DATE_FORMAT(om.om_date, '%d-%m-%Y') as om_entry_date,
                DATE_FORMAT(om.om_delivery_date, '%d-%m-%Y') as om_delivery_date
                FROM order_trans ot
                INNER JOIN order_master om ON(om.om_id = ot.ot_om_id)
                INNER JOIN client_master client ON(client.client_id = om.om_client_id)
                INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
                WHERE ot.ot_id = $id";
                 // print_r($query);die;     
            return $this->db->query($query)->result_array();
        }

        public function get_latest_data($id){ 
            $query="SELECT jim.*,
                    IFNULL(jrt.jrt_id, 0) as jrt_id,
                    UPPER(designation.designation_name) as designation_name
                    FROM job_issue_master jim
                    INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
                    INNER JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
                    LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jit_id = jit.jit_id)
                    WHERE 1
                    AND jit.jit_ot_id = $id
                    ORDER BY jit.jit_id DESC
                    LIMIT 1";
               // print_r($query);die;     
            return $this->db->query($query)->result_array();
        }

        public function is_opt_for_trial($ot_barcode){
            $query ="
                        SELECT ot.ot_trial
                        FROM order_trans ot
                        WHERE ot.ot_barcode = $ot_barcode
                    ";
            // echo "<pre>"; print_r($query); exit();
            $data = $this->db->query($query)->result_array();
            if(!empty($data)){
                if($data[0]['ot_trial'] != '0000-00-00') return 1;
            }

            return 0;
        }
        public function get_prev_data($ot_id){
            $query ="
                    SELECT jit.*
                    FROM job_issue_trans jit
                    WHERE jit.jit_ot_id = $ot_id
                    ORDER BY jit.jit_id DESC
                    LIMIT 1
                    ";
            $data = $this->db->query($query)->result_array();
            if(empty($data)) return ['jim_id' => 0, 'jit_id' => 0];
            return ['jim_id' => $data[0]['jit_jim_id'], 'jit_id' => $data[0]['jit_id']];
        }
        public function get_select2_entry_no(){
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (jim.jim_entry_no LIKE '%".$name."%') ";
            }
            $query ="
                        SELECT jim.jim_id as id, jim.jim_entry_no as name
                        FROM job_issue_master jim
                        WHERE jim.jim_ot_id = 0
                        $subsql
                        ORDER BY jim.jim_entry_no ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_select2_barcode(){ 
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (ot.ot_barcode LIKE '".$name."%') ";
            }
            $query ="
                        SELECT ot.ot_id as id, ot.ot_barcode as name
                        FROM order_trans ot
                        INNER JOIN job_issue_trans jit ON(jit.jit_ot_id = ot.ot_id)
                        WHERE 1
                        $subsql
                        GROUP BY ot.ot_id
                        ORDER BY ot.ot_barcode ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_select2_karigar(){ 
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (km.km_name LIKE '".$name."%') ";
            }
            $query ="
                        SELECT km.km_id as id, km.km_name as name
                        FROM karigar_master km
                        INNER JOIN job_issue_master jim ON(jim.jim_km_id = km.km_id)
                        WHERE 1
                        $subsql
                        GROUP BY km.km_id
                        ORDER BY km.km_name ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_select2_apparel(){ 
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (app.app_name LIKE '%".$name."%') ";
            }
            $query ="
                        SELECT app.app_id as id, app.app_name as name
                        FROM apparel_master app
                        INNER JOIN order_trans ot ON(ot.ot_item_id = app.app_id)
                        INNER JOIN job_issue_trans jit ON(jit.jit_ot_id = ot.ot_id)
                        WHERE 1
                        $subsql
                        GROUP BY app.app_id
                        ORDER BY app.app_name ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_select2_client(){
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (client.client_name LIKE '".$name."%') ";
            }
            $query ="
                        SELECT client.client_id as id, CONCAT(client.client_name,'-',client.client_mobile1) as name
                        FROM client_master client
                        INNER JOIN order_master om ON(om.om_client_id = client.client_id)
                        WHERE 1
                        $subsql
                        GROUP BY client.client_id
                        ORDER BY client.client_name ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_select2_order(){
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (om.om_no LIKE '%".$name."%') ";
            }
            $query ="
                        SELECT om.om_id as id, om.om_no as name
                        FROM order_master om
                        INNER JOIN order_trans ot ON(ot.ot_om_id = om.om_id)
                        INNER JOIN job_issue_trans jit ON(jit.jit_ot_id = ot.ot_id)
                        WHERE 1
                        $subsql
                        GROUP BY om.om_id
                        ORDER BY om.om_no ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }

        public function get_select2_proces(){
            $subsql = "";
            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (designation_name LIKE '".$name."%') ";
            }
            $query ="
                        SELECT designation_id as id, designation_name as name
                        FROM designation_master 
                        WHERE 1
                        $subsql
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
	}
?>