<?php defined('BASEPATH') OR exit('No direct script access allowed');
	class Jobreceivemdl extends CI_model{
        public function isExist($id, $trans = false){  
            if($trans){
                $query ="SELECT jrt_id
                         FROM job_receive_trans
                         WHERE jrt_id = $id
                         AND jrt_ht_id != 0
                        ";
                $data = $this->db->query($query)->result_array();
                if(!empty($data)) return true;
            }
            return false;
        } 
        public function get_issue_no($condition){
            $data   = $this->db->get_where('job_receive_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['jrm_id'];
            $text   = $data[0]['jrm_entry_no'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_bm_item_code($condition){
            $data   = $this->db->get_where('order_trans',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['ot_id'];
            $text   = $data[0]['ot_item_code'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_km_name($condition){
            $data   = $this->db->get_where('karigar_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['km_id'];
            $text   = $data[0]['km_name'];
            return ['value' => $value, 'text' => $text];
        }

        public function get_designation($condition){
            $data   = $this->db->get_where('designation_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['designation_id'];
            $text   = $data[0]['designation_name'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_app_name($condition){
            $data   = $this->db->get_where('apparel_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['app_id'];
            $text   = $data[0]['app_name'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_client_name($condition){
            $data   = $this->db->get_where('client_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['client_id'];
            $text   = $data[0]['client_name']. ' - '. $data[0]['client_custom_no'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_order_no($condition){
            $data   = $this->db->get_where('order_master',$condition)->result_array();
            if(empty($data)) return ['value' => '', 'text' => ''];
            $value  = $data[0]['om_id'];
            $text   = $data[0]['om_no'];
            return ['value' => $value, 'text' => $text];
        }
        public function get_data($wantCount, $per_page = 20, $offset = 0){
            $record     = [];
            $subsql     = '';
            $limit      = '';
            $ofset      = '';
            
            if(!$wantCount){
                $limit .= " LIMIT $per_page";
                $ofset .= " OFFSET $offset";
            }
            if(isset($_GET['jrm_id']) && !empty($_GET['jrm_id'])){
                $subsql .=" AND jrm.jrm_id = ".$_GET['jrm_id'];
                $record['search']['jrm_id'] = $this->get_issue_no(['jrm_id' => $_GET['jrm_id']]);
            }
            if(isset($_GET['jrm_entry_date']) && !empty($_GET['jrm_entry_date'])){
                $subsql .= " AND jrm.jrm_entry_date ='".date('Y-m-d', strtotime($_GET['jrm_entry_date']))."'";
            }
            if(isset($_GET['ot_id']) && !empty($_GET['ot_id'])){
                $subsql .=" AND jrt.jrt_ot_id = ".$_GET['ot_id'];
                $record['search']['ot_id'] = $this->get_bm_item_code(['ot_id' => $_GET['ot_id']]);
            }
            if(isset($_GET['km_id']) && !empty($_GET['km_id'])){
                $subsql .=" AND jrm.jrm_km_id = ".$_GET['km_id'];
                $record['search']['km_id'] = $this->get_km_name(['km_id' => $_GET['km_id']]);
            }
            if(isset($_GET['km_process']) && !empty($_GET['km_process'])){ 
                $subsql .=" AND jrm.jrm_designation = '".$_GET['km_process']."'";
                $subsql .=" AND jrm.jrm_designation = ".$_GET['km_process'];
                $record['search']['km_process'] = $this->get_designation(['designation_name' => $_GET['km_process']]);
            }
            if(isset($_GET['app_id']) && !empty($_GET['app_id'])){
                $subsql .=" AND app.app_id = ".$_GET['app_id'];
                $record['search']['app_id'] = $this->get_app_name(['app_id' => $_GET['app_id']]);
            }
            if(isset($_GET['client_id']) && !empty($_GET['client_id'])){
                $subsql .=" AND client.client_id = ".$_GET['client_id'];
                $record['search']['client_id'] = $this->get_client_name(['client_id' => $_GET['client_id']]);
            }
            if(isset($_GET['om_id']) && !empty($_GET['om_id'])){
                $subsql .=" AND ot.ot_om_id = ".$_GET['om_id'];
                $record['search']['om_id'] = $this->get_order_no(['om_id' => $_GET['om_id']]);
            } 
            if(isset($_GET['om_entry_date']) && !empty($_GET['om_entry_date'])){
                $subsql .= " AND om.om_entry_date ='".date('Y-m-d', strtotime($_GET['om_entry_date']))."'";
            }
            if(isset($_GET['om_delivery_date']) && !empty($_GET['om_delivery_date'])){
                $subsql .= " AND om.om_delivery_date ='".date('Y-m-d', strtotime($_GET['om_delivery_date']))."'";
            }
            $query ="
                        SELECT jrm.jrm_id, jrm.jrm_designation,designation.designation_name, jrm.jrm_entry_no, jrm.jrm_entry_date, jrt.jrt_id, ot.ot_item_code, km.km_name, app.app_name,ot.ot_barcode,client.client_name,client.client_accno,om.om_no as om_entry_no,
                        DATE_FORMAT(om.om_date, '%d-%m-%Y') as om_entry_date,
                        DATE_FORMAT(om.om_delivery_date, '%d-%m-%Y') as om_delivery_date
                        FROM job_receive_master jrm
                        INNER JOIN designation_master designation ON(designation.designation_id = jrm.jrm_designation)
                        INNER JOIN karigar_master km ON(km.km_id = jrm.jrm_km_id)
                        INNER JOIN job_receive_trans jrt ON(jrt.jrt_jrm_id = jrm.jrm_id)
                        LEFT JOIN order_trans ot ON(ot.ot_id = jrt.jrt_ot_id)
                        INNER JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
                        LEFT JOIN order_master om ON(om.om_id = ot.ot_om_id)
                        INNER JOIN client_master client ON(client.client_id = om.om_client_id)
                        WHERE 1
                        $subsql
                        GROUP BY jrt.jrt_id
                        ORDER BY jrm.jrm_id DESC
                        $limit
                        $ofset
                    ";
            // echo "<pre>"; print_r($query); exit;
            if($wantCount){
                return $this->db->query($query)->num_rows();
            }
            $record['data'] = $this->db->query($query)->result_array();

            if(!empty($record['data'])){
                foreach ($record['data'] as $key => $value) {
                    $record['data'][$key]['isExist'] = $this->isExist($value['jrt_id'], true);
                }
            }
            return $record;
        }
        public function get_process(){ 
            $query ="
                    SELECT ot.ot_id, ot.ot_barcode 
                    FROM order_trans ot 
                    WHERE 1
                    ";
                    $data = $this->db->query($query)->result_array(); 

            if(!empty($data)){
                // $record['data'][''] = 'SELECT'; 
                // $record['data']['DYING'] =  'DYING'; 
                // $record['data']['EMBROIDERY']  = 'EMBROIDERY'; 
                // $record['data']['STITCHING']  = 'STITCHING'; 

                $designation = $this->db->query("SELECT designation_id, UPPER(designation_name) AS designation_name FROM designation_master WHERE designation_id IN (3,4)")->result_array();
                $record['data'][0] = "SELECT";
                foreach ($designation as $key => $value) {
                    $record['data'][$value['designation_id']] = $value['designation_name'];
                }

            }else{
                $record['data'][''] = 'NO PENDING BARCODE AVAILABLE';
            }
            return $record;
           
        }
        public function get_data_for_edit($id){
            $master_query ="
                            SELECT jrm.*, km.km_name
                            FROM job_receive_master jrm
                            LEFT JOIN karigar_master km ON(km.km_id = jrm.jrm_km_id)
                            WHERE jrm.jrm_id = $id
                          "; 
            $data['master_data'] = $this->db->query($master_query)->result_array();
            $data['issued_data'] = !empty($data['master_data']) ? $this->get_issued_count($data['master_data'][0]['jrm_km_id']) : $this->get_issued_count(0);
            $trans_query ="
                            SELECT jrt.*, ot.ot_item_code, p.product_group, p.product_name, 
                            IF(ot.ot_am_id = 0 , CONCAT(UPPER(om.om_bill_series),'', om.om_entry_no), am.am_entry_no) as om_entry_no,
                            IF(ot.ot_am_id = 0 , DATE_FORMAT(om.om_entry_date, '%d-%m-%Y'), DATE_FORMAT(am.am_entry_date, '%d-%m-%Y')) as om_entry_date,
                            IF(ot.ot_am_id = 0 , DATE_FORMAT(om.om_delivery_date, '%d-%m-%Y'), DATE_FORMAT(am.am_delivery_date, '%d-%m-%Y')) as om_delivery_date,
                            client.client_name, client.client_mob1, client.client_custom_no as client_code
                            FROM job_receive_trans jrt
                            INNER JOIN order_trans ot ON(ot.ot_id = jrt.jrt_ot_id)
                            INNER JOIN product_master p ON(p.product_id = ot.ot_item_id)
                            LEFT JOIN order_master om ON(om.om_id = ot.ot_om_id)
                            INNER JOIN client_master client ON(client.client_id = om.om_client_id)
                            LEFT JOIN alter_master am ON(am.am_id = ot.ot_am_id)
                            WHERE jrt.jrt_jrm_id = $id
                            AND om.om_delete_status = 0
                            AND ot.ot_delete_status = 0
                          "; 
            $data['trans_data'] = $this->db->query($trans_query)->result_array();
            if(!empty($data['trans_data'])){
                foreach ($data['trans_data'] as $key => $value) {
                    $data['trans_data'][$key]['isExist'] = $this->isExist($value['jrt_id'], true);
                }
            }
            return $data;
        }
        public function get_karigar($id){
            $query ="
                        SELECT km.km_id, km.km_name
                        FROM karigar_master km
                        WHERE km.km_status = 1
                        AND km.km_designation = '$id'
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }

        public function get_barcode($id){
            $query ="
                        SELECT bm.*
                        FROM karigar_master km
                        LEFT JOIN karigar_group_trans kgt ON(kgt.kgt_km_id = km.km_id)
                        LEFT JOIN product_master p ON(p.product_group = kgt.kgt_group)
                        LEFT JOIN order_trans ot ON(ot.ot_item_id = p.product_id)
                        WHERE km.km_id = $id
                        AND ot.ot_delete_status = 0
                        AND ot.ot_delivery_status = 0
                        AND ot.ot_cancel_status = 0
                        AND ot.ot_loc = 'IN'
                        AND p.product_group != ''
                        GROUP BY ot.ot_id ASC
                        LIMIT 1
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }

        public function scan_barcode($id){       
        $query="SELECT 0 as jrt_id,
                ot.*,
                jim.*,
                jit.jit_id,
                IFNULL(jrt.jrt_jit_id, 0) as jrt_jit_id,
                UPPER(app.app_name) as app_name,
                UPPER(client.client_name) as client_name,
                om.om_no as entry_no,
                IFNULL((SELECT kt.kt_app_charges FROM karigar_transaction kt WHERE kt.kt_km_id =km.km_id  AND kt.kt_app_id = app.app_id), 0) as jrt_rate,
                DATE_FORMAT(om.om_date, '%d-%m-%Y') as entry_date,
                DATE_FORMAT(om.om_delivery_date, '%d-%m-%Y') as om_delivery_date,
                UPPER(designation.designation_name) as designation_name,
                UPPER(km.km_name) as km_name
                FROM job_issue_master jim
                INNER JOIN job_issue_trans jit ON(jit.jit_jim_id = jim.jim_id)
                LEFT JOIN order_trans ot ON(ot.ot_id = jit.jit_ot_id)
                LEFT JOIN order_master om ON(om.om_id = ot.ot_om_id)
                LEFT JOIN client_master client ON(client.client_id = om.om_client_id)  
                LEFT JOIN apparel_master app ON(app.app_id = ot.ot_item_id)
                LEFT JOIN designation_master designation ON(designation.designation_id = jim.jim_designation)
                LEFT JOIN karigar_master km ON(km.km_id = jim.jim_km_id)
                LEFT JOIN job_receive_trans jrt ON(jrt.jrt_jit_id = jit.jit_id)
                WHERE 1
                AND ot.ot_id = $id
                AND IFNULL(jrt.jrt_jit_id, 0)=0
                ORDER BY jit.jit_id DESC LIMIT 1
                "; 
        return $this->db->query($query)->result_array();
    }
        // public function get_issued_count($id){
        //     return [
        //             'shirt_count'   => $this->get_issued_count1($id), 
        //         ];
        // }

        public function get_issued_count($id){
            $query ="
                        SELECT COUNT(otb.otb_id) as cnt
                        FROM order_trans_barcode otb
                        INNER JOIN job_issue_master jim ON(jim.jim_id = otb.otb_jim_id)
                        INNER JOIN job_issue_trans jit ON(jit.jit_id = otb.otb_jit_id)
                        INNER JOIN product_master p ON(p.product_id = otb.otb_product_id)
                        AND jim.jim_km_id = $id ";
            $data = $this->db->query($query)->result_array();
            if(!empty($data)) return $data[0]['cnt'];
            return 0;
        }

        public function get_prev_data($otb_id){
            $query ="
                        SELECT jrt.*
                        FROM job_receive_trans jrt
                        WHERE jrt.jrt_ot_id = $otb_id
                        ORDER BY jrt.jrt_id DESC
                        LIMIT 1
                    ";
            $data = $this->db->query($query)->result_array();
            if(empty($data)) return ['jrm_id' => 0, 'jrt_id' => 0];
            return ['jrm_id' => $data[0]['jrt_jrm_id'], 'jrt_id' => $data[0]['jrt_id']];
        }
        public function get_select2_entry_no(){ 
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (jrm.jrm_entry_no LIKE '%".$name."%') ";
            }
            $query ="
                        SELECT jrm.jrm_id as id, jrm.jrm_entry_no as name
                        FROM job_receive_master jrm
                        INNER JOIN job_receive_trans jrt ON (jrt.jrt_jrm_id=jrm.jrm_id)
                        WHERE 1
                        $subsql
                        ORDER BY jrm.jrm_entry_no ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        } 
        public function get_select2_barcode(){
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " WHERE (ot.ot_barcode LIKE '%".$name."%') ";
            }
            $query ="
                        SELECT ot.ot_id as id, ot.ot_barcode as name
                        FROM order_trans ot
                        INNER JOIN job_receive_trans jrt ON(jrt.jrt_ot_id = ot.ot_id)
                        $subsql
                        GROUP BY ot.ot_id
                        ORDER BY ot.ot_barcode ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_select2_karigar(){
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (km.km_name LIKE '%".$name."%') ";
            }
            $query ="
                        SELECT km.km_id as id, km.km_name as name
                        FROM karigar_master km
                        INNER JOIN job_receive_master jrm ON(jrm.jrm_km_id = km.km_id)
                        WHERE jrm.jrm_jim_id = 0
                        $subsql
                        GROUP BY km.km_id
                        ORDER BY km.km_name ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_select2_apparel(){ 
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " WHERE (app.app_name LIKE '".$name."%') ";
            }
            $query ="
                        SELECT app.app_id as id, app.app_name as name
                        FROM apparel_master app
                        INNER JOIN order_trans ot ON(ot.ot_item_id = app.app_id)
                        INNER JOIN job_receive_trans jrt ON(jrt.jrt_ot_id = ot.ot_id)
                        $subsql
                        GROUP BY app.app_id
                        ORDER BY app.app_name ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_select2_client(){
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " WHERE (client.client_name LIKE '".$name."%') ";
            }
            $query ="
                        SELECT client.client_id as id, CONCAT(client.client_name,'-',client.client_mobile1) as name
                        FROM client_master client
                        $subsql
                        GROUP BY client.client_id
                        ORDER BY client.client_name ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function get_select2_order(){
            $subsql = "";

            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " WHERE (om.om_no LIKE '".$name."%') ";
            }
            $query ="
                        SELECT om.om_id as id, om.om_no as name
                        FROM order_master om
                        INNER JOIN order_trans ot ON(ot.ot_om_id = om.om_id)
                        INNER JOIN job_receive_trans jrt ON(jrt.jrt_ot_id = ot.ot_id)
                        $subsql
                        GROUP BY om.om_id
                        ORDER BY om.om_no ASC
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }

        public function get_select2_proces(){
            $subsql = "";
            if(isset($_GET['name']) && !empty($_GET['name'])){
                $name   = $_GET['name'];
                $subsql .= " AND (designation_name LIKE '".$name."%') ";
            }
            $query ="
                        SELECT designation_id as id, designation_name as name
                        FROM designation_master 
                        WHERE 1
                        $subsql
                        LIMIT 10
                    ";
            // echo $query; exit();
            return $this->db->query($query)->result_array();
        }
        public function all_ready($bm_id){
            $query="SELECT ot.ot_om_id as om_id
                    FROM order_trans ot
                    WHERE ot.ot_delete_status = 0
                    AND ot.ot_id = $bm_id";
            $data = $this->db->query($query)->result_array();
            // echo "<pre>"; print_r($query);exit;
            // echo "<pre>"; print_r($data);exit;
            $om_id = empty($data) ? 0 : $data[0]['om_id'];
            $query="SELECT COUNT(ot.ot_id) as cnt
                    FROM order_trans ot
                    WHERE ot.ot_delete_status = 0
                    AND ot.ot_delivery_status = 0
                    AND ot.ot_cancel_status = 0
                    AND ot.ot_om_id = $om_id
                    GROUP BY ot.ot_om_id";
            $data = $this->db->query($query)->result_array();
            // echo "<pre>"; print_r($query);exit;
            // echo "<pre>"; print_r($data);exit;

            $cnt  = 0;
            if(!empty($data)){
                $cnt = $data[0]['cnt'];
            }
            $query="SELECT p.product_group, jrm.jrm_designation, COUNT(ot.ot_id) as cnt
                    FROM order_trans ot
                    INNER JOIN job_receive_master jrm ON(jrm.jrm_id = ot.ot_jrm_id)
                    INNER JOIN product_master p ON(p.product_id = ot.ot_item_id)
                    WHERE ot.ot_delete_status = 0
                    AND ot.ot_delivery_status = 0
                    AND ot.ot_cancel_status = 0
                    AND ot.ot_loc = 'IN'
                    AND ot.ot_om_id = $om_id
                    GROUP BY p.product_id ASC";
            $order_data = $this->db->query($query)->result_array();
            // echo "<pre>"; print_r($query);exit;
            // echo "<pre>"; print_r($order_data);exit;
            $cntt = 0;
            if(!empty($order_data)){
                foreach ($order_data as $key => $value) {
                    if($value['app_group'] == 'PANT_GROUP' || $value['app_group'] == 'COAT_GROUP'){
                        if($value['jrm_designation'] == 'MAKER' || $value['jrm_designation'] == 'ALTER'){
                            $cntt = $cntt + $value['cnt'];
                        }
                    }else{
                        if($value['jrm_designation'] == 'PRESS' || $value['jrm_designation'] == 'ALTER'){
                            $cntt = $cntt + $value['cnt'];
                        }
                    }
                }
            }
            // echo $cnt." = ".$cntt;exit;

            if(!empty($cnt) && !empty($cntt)){
                if($cnt == $cntt) return true;
            }
            return false;
        }
        public function get_order_data($bm_id){
            $query="SELECT om.om_id,
                    CONCAT(UPPER(om.om_bill_series),'',om.om_entry_no) as om_entry_no,
                    client.client_mob1
                    FROM order_trans ot
                    INNER JOIN order_master om ON(om.om_id = ot.ot_om_id)
                    INNER JOIN client_master client ON(client.client_id = om.om_client_id)
                    WHERE ot.ot_id = $bm_id";
            return $this->db->query($query)->result_array();
        }
        public function get_apparel_with_qty($om_id){
            $query="SELECT CONCAT(UPPER(p.product_name), ' - ', SUM(ot.ot_qty)) as app_with_qty
                    FROM order_trans ot 
                    INNER JOIN product_master p ON(p.product_id = ot.ot_item_id)
                    WHERE ot.ot_om_id = $om_id
                    GROUP BY p.product_id
                    ORDER BY p.product_name ASC";
            $data = $this->db->query($query)->result_array();
            $temp = '';
            if(!empty($data)){
                foreach ($data as $key => $value) {
                    $temp .= empty($temp) ? $value['app_with_qty'] : ', '.$value['app_with_qty'];
                }
                $temp = '('.$temp.')';
            }
            return $temp;
        }
	}
?>