$(document).ready(()=>{
    $("#jrm_id").select2(select2_default({
        url:`production/job_receive/get_select2_entry_no`,
        placeholder:'RECEIVE NO',
    })).on('change', () => trigger_search());
    $("#bm_id").select2(select2_default({
        url:`production/job_receive/get_select2_barcode`,
        placeholder:'BARCODE',
    })).on('change', () => trigger_search());
    $("#km_id").select2(select2_default({
        url:`production/job_receive/get_select2_karigar`,
        placeholder:'KARIGAR',
    })).on('change', () => trigger_search());
    $("#app_id").select2(select2_default({
        url:`production/job_receive/get_select2_apparel`,
        placeholder:'APPAREL',
    })).on('change', () => trigger_search());
    $("#client_id").select2(select2_default({
        url:`production/job_receive/get_select2_client`,
        placeholder:'CLIENT - MOBILE',
    })).on('change', () => trigger_search());
    $("#om_id").select2(select2_default({
        url:`production/job_receive/get_select2_order`,
        placeholder:'ORDER NO',
    })).on('change', () => trigger_search());

    $("#km_process").select2(select2_default({
        url:`production/job_receive/get_select2_proces`,
        placeholder:'PROCESS',
    })).on('change', () => trigger_search());

});
const check_process_change = prcess => {
    let isExist = true
    if($('#jrm_designation').val() != ''){
        if($('#jrm_designation').val() != prcess){
            if(confirm('Barcode from another process. Do you want to continue?')){
                $('#job_receive_body_wrapper').empty()   
                set_header();
                calculate_app_group_count();
                isExist = true
            }else{
                isExist = false;
            }
        }
    }
    return isExist;
}
const check_karigar_change = km_id => {
    let isExist = true
    if($('#jrm_km_id').val() != ''){
        if($('#jrm_km_id').val() != km_id){
            if(confirm('Barcode from another karigar. Do you want to continue?')){
                $('#job_receive_body_wrapper').empty()   
                set_header();
                calculate_app_group_count();
                isExist = true
            }else{
                isExist = false;
            }
        }
    }
    return isExist;
}
const set_hisab = (bm_id, flag) =>{
    $(`#foc_${bm_id}`).html(flag == 0 ? 'YES' : 'NO');
    $(`#jrt_foc_${bm_id}`).val(flag);
    $("#popup_modal_sm").modal('hide');         
}
const hisab_popup = bm_id => {
    let hisab   = $(`#jrt_foc_${bm_id}`).val();
    let yes     = hisab == 0 ? 'checked' : '';
    let no      = hisab == 1 ? 'checked' : '';
    let data    = ''; 
    data += '<div class="alert_msg_popup"></div>';                      
    data += '<div class="row">';
    data += '<div class="col-md-12">'
    data += '<form class="form-horizontal" id="delivery_date_form">';
    data += '<div class="form-group floating-form">';
    data += '<div class="col-sm-12 floating-label">';
    data += '<label>This apparel received from same process more than once. Do you want to calculate hisab for this again?</label>';
    data += '</div>';
    data += '<div class="col-sm-5 col-sm-offset-1 floating-label">';
    data += '<label> YES </label> ';
    data += ' <input type="radio" id="yes" name="hisab" value="YES" onchange="set_hisab('+bm_id+','+0+')" '+yes+'/>';
    data += '</div>';
    data += '<div class="col-sm-6 floating-label">';
    data += '<label> NO </label> ';
    data += ' <input type="radio" id="no" name="hisab" value="NO" onchange="set_hisab('+bm_id+','+1+')" '+no+'/>';
    data += '</div>';
    data += '</div>';
    data += '</form>';
    data += '</div>';
    data += '</div>';
    $(".modal-body-sm").html(data);
    let sbt_btn = '<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>';
    $(".modal-title-sm").html('');
    $(".modal-footer").html(sbt_btn);
    $("#popup_modal_sm").modal('show');         

}
const scan_barcode = () => { 
    let bm_item_code = $('#bm_item_code').val();
    // alert(bm_item_code);
    if((bm_item_code.trim() !== '') && (bm_item_code.length > 8)){
        let path = `${base_url}/production/job_receive/scan_barcode/${bm_item_code}`;
        ajaxCall('GET',path,'','JSON',resp=>{
            const {status,data, msg} = resp;
            if(status){
                if (!isBarcodeAdded(data[0]["ot_id"])){
                    add_row(data); 
                        callToastify("success",
                        "Barcode Scanned",
                        "right");

                    $('#jrm_designation').removeAttr('readonly');
                    $('#jrm_designation').css('pointer-events','');

                    // $('#jrm_designation').val(data[0]['jim_designation']);
                    $('#process_id').val(data[0]['designation_name']);
                    $('#km_code').val(data[0]['km_name']);
                    $('#jrm_km_id').val(data[0]['jim_km_id']);
                    $("#bm_item_code").val('');   
                }else{
                    response_error(2,'Barcode Already added in list');
                }
            }else{
                response_error(2, msg);
            }
        },errmsg =>{});
    }
   
}
const calculate_issued_count = () => {
   
    if($('#jrm_designation').val() != '' && $('#jrm_km_id').val() != 0){
        let prev_shirt  = $('#prev_shirt_group_count').html();
        let shirt       = $('#shirt_group_count').html();
        let total_shirt = parseInt(prev_shirt) - parseInt(shirt);
        $('#total_shirt_group_count').html(total_shirt);

        let prev_pant  = $('#prev_pant_group_count').html();
        let pant       = $('#pant_group_count').html();
        let total_pant = parseInt(prev_pant) - parseInt(pant);
        $('#total_pant_group_count').html(total_pant);

        let prev_safari  = $('#prev_safari_group_count').html();
        let safari       = $('#safari_group_count').html();
        let total_safari = parseInt(prev_safari) - parseInt(safari);
        $('#total_safari_group_count').html(total_safari);

        let prev_coat  = $('#prev_coat_group_count').html();
        let coat       = $('#coat_group_count').html();
        let total_coat = parseInt(prev_coat) - parseInt(coat);
        $('#total_coat_group_count').html(total_coat);

        let prev_other  = $('#prev_other_group_count').html();
        let other       = $('#other_group_count').html();
        let total_other = parseInt(prev_other) - parseInt(other);
        $('#total_other_group_count').html(total_other);

        let total_prev = parseInt(prev_shirt) + parseInt(prev_pant) + parseInt(prev_safari) + parseInt(prev_coat) + parseInt(prev_other);
        $('#prev_total_group_count').html(total_prev);

        let total = parseInt(shirt) + parseInt(pant) + parseInt(safari) + parseInt(coat) + parseInt(other);
        $('#total_group_count').html(total);
        $('#total_total_group_count').html(parseInt(total_shirt) + parseInt(total_pant) + parseInt(total_safari) + parseInt(total_coat) + + parseInt(total_other))
    }else{
        $('#prev_shirt_group_count').html(0);
        $('#shirt_group_count').html(0);
        $('#total_shirt_group_count').html(0);

        $('#prev_pant_group_count').html(0);
        $('#pant_group_count').html(0);
        $('#total_pant_group_count').html(0);

        $('#prev_safari_group_count').html(0);
        $('#safari_group_count').html(0);
        $('#total_safari_group_count').html(0);

        $('#prev_coat_group_count').html(0);
        $('#coat_group_count').html(0);
        $('#total_coat_group_count').html(0);

        $('#prev_other_group_count').html(0);
        $('#other_group_count').html(0);
        $('#total_other_group_count').html(0);

        $('#prev_total_group_count').html(0);

        $('#total_group_count').html(0);
        $('#total_total_group_count').html(0)
    }
}
const get_karigar = () => {
    let designation = $('#jim_km_designation').val()
    $('#jim_km_id').html('<option value=0>SELECT PROCESS FIRST</option>')
    $('#jim_km_id').prop('disabled', true).val(0)
    $('#bm_item_code').prop('placeholder', 'SELECT KARIGAR FIRST').prop('disabled', true).val('')
    if(designation != ''){
        let path = `${base_url}/production/job_receive/get_karigar/${designation}`;
        ajaxCall('GET',path,'','JSON',resp=>{
            const {status, flag, data, msg} = resp;
            if(status){
                if(flag == 1){
                    if(data && data.length != 0){
                        let options = "<option value=0>SELECT</option>";
                        data.forEach(karigar => {
                            options += `<option value=${karigar.km_id}>${karigar.km_code}</option>`
                        })
                        $('#jim_km_id').html(options)
                        $('#jim_km_id').prop('disabled', false).val(0)
                    }else{
                        $('#jim_km_id').html('<option value=0>NO KARIGAR FOUND</option>')
                        $('#jim_km_id').val(0)
                    }   
                }else{
                    response_error(flag, msg)
                }
            }else{
                session_expired()
            }
        },errmsg =>{});
    }
}
const get_barcode = () => {
    let id = $('#jim_km_id').val()
    $('#bm_item_code').prop('placeholder', 'SELECT KARIGAR FIRST').prop('disabled', true).val('')
    if(id != 0){
        let path = `${base_url}/production/job_receive/get_barcode/${id}`;
        ajaxCall('GET',path,'','JSON',resp=>{
            const {status, flag, data, msg} = resp;
            if(status){
                if(flag == 1){
                    if(data && data.length != 0){
                        $('#bm_item_code').prop('placeholder', 'SCAN BARCODE').prop('disabled', false).val('')
                    }else{
                        $('#bm_item_code').prop('placeholder', 'NO BARCODE FOUND').prop('disabled', true).val('')
                    }   
                }else{
                    response_error(flag, msg)
                }
            }else{
                session_expired()
            }
        },errmsg =>{});
    }
}
const app_group_exist = (app_group, karigar_data) => {
    let isExist = false;
    if(karigar_data.length == 0) return false
    $.each(karigar_data, (index, value) => {
        if(value.app_group == app_group){
            isExist = true
        };
    })
    return isExist;
}
const isBarcodeAdded = bm_id => {

    let isExist = false
    let total_tr = $('#job_receive_body_wrapper tr').length
    if(total_tr == 0) return isExist;
    for (let i = 1; i <= total_tr; i++){
        let id = $('#job_receive_body_wrapper tr:nth-child('+i+')').attr('id');
        let lastunderscore = id.lastIndexOf("_");
        let cnt = id.substring(lastunderscore+1);
        if(cnt == bm_id){
            isExist = true
        }
    }
    return isExist;
}

const set_header = () =>{
    let tr =`<tr>
                <th colspan="10" style="text-align: center;"> NO BARCODE SELECTED</th>
            </tr>`;
    if($('#job_receive_body_wrapper tr').length > 0){
        tr =`<tr>
                <th>#</th>
                <th>Barcode</th>
                <th>Apparel</th>
                <th>Order No</th>
                <th>Order Date</th>
                <th>Delivery Date</th>
                <th>Client</th>
                <th>Remove</th>
            </tr>
            `
    }
    $('#job_receive_head_wrapper').html(tr);
}
const add_row = data => {
   
    let total_tr = $('#job_receive_body_wrapper tr').length;
    let sr_no = total_tr + 1;
    let {ot_id, ot_barcode,app_name, ot_om_id, entry_date, om_delivery_date, client_name, client_mobile1,jim_id,jit_id} = data[0];
    let td =`<tr id="rowid_${ot_id}">
                <td id="sr_no_${ot_id}">${sr_no}</td>
               
                <td>
                    <input type="hidden" id="jrt_id_${ot_id}" name="jrt_id[]" value="0" />
                    <input type="hidden" id="jrt_ot_id_${ot_id}" name="jrt_ot_id[]" value="${ot_id}" />
                    <input type="hidden" id="jrt_jit_id_${ot_id}" name="jrt_jit_id[]" value="${jit_id}" />
                    <input type="hidden" id="jrt_jim_id_${ot_id}" name="jrt_jim_id[]" value="${jim_id}" />
                    <input type="hidden" id="jrt_foc_${ot_id}" name="jrt_foc[]" value="0" />
                    ${ot_barcode}
                </td>
               
                <td>${app_name}</td>
                <td>${ot_om_id}</td>
                <td>
                    <input 
                        type="hidden" 
                        id="entry_date_${ot_id}" 
                        value="${entry_date}" 
                    />
                    <span id="om_entry_date_${ot_id}">${entry_date}</span>
                </td>
                <td>${om_delivery_date ? om_delivery_date.split('-').reverse().join('-') : ''}</td>
                <td>${client_name}</td>
                <td><a class="btn btn-sm btn-danger" onclick="remove_row(${ot_id})"><i class="glyphicon glyphicon-trash" aria-hidden="true"></i></a></td>
            </tr>
    `;

    $('#job_receive_body_wrapper').prepend(td)
    set_header();
    calculate_app_group_count();
}
const remove_row = id => {
    $(`#rowid_${id}`).detach();
    set_header();
    calculate_app_group_count();
    calculate_issued_count();
    callToastify('success', 'Barcode remove from list', 'right')
}
const calculate_app_group_count = () => {
    let total_tr    = $('#job_receive_body_wrapper tr').length
    if(total_tr > 0){
        $('#sbt_btn').prop('disabled', false)
    }else{
        $('#sbt_btn').prop('disabled', true)
    }
}
const check_date = () =>{
    let isExist = false
    let total_tr = $('#job_receive_body_wrapper tr').length
    if(total_tr == 0) return isExist;
    for (let i = 1; i <= total_tr; i++){
        let id = $('#job_receive_body_wrapper tr:nth-child('+i+')').attr('id');
        let lastunderscore = id.lastIndexOf("_");
        let cnt = id.substring(lastunderscore+1);
        let issue_date = new Date($('#jrm_entry_date').val().split('-').reverse().join('-'));
        let order_date = new Date($(`#entry_date_${cnt}`).val().split('-').reverse().join('-'));
        if(issue_date.getTime() < order_date.getTime()){
            $(`#om_entry_date_${cnt}`).addClass('text-danger');
            $("#jrm_entry_date").css({'border-color':'red'});
            $("#jrm_entry_date").addClass('shake');
            $('#jrm_entry_date').on('webkitAnimationEnd oanimationend msAnimationEnd animationend', function(e) {
                $('#jrm_entry_date').delay(200).removeClass('shake');
            });
            isExist = true;
        }else{
            $(`#om_entry_date_${cnt}`).removeClass('text-danger');
        }
    }
    return isExist;
}
const add_update_receive = id =>{
    let check = 0;        
    event.preventDefault();
    if($("#jrm_entry_date").val() == '')
    {
        $("#jrm_entry_date").css({'border-color':'red'});
        $("#jrm_entry_date").addClass('shake');
        $('#jrm_entry_date').on('webkitAnimationEnd oanimationend msAnimationEnd animationend', function(e) {
            $('#jrm_entry_date').delay(200).removeClass('shake');
        });
        check = 1;
    } else {

        $("#jrm_entry_date").css({ 'border-color':'#550a06' });
    }
    if($('#job_receive_body_wrapper tr').length < 1){
        check = 1;
    }
    
    if(check){
        $("body, html").animate({'scrollTop':0},1000);
    }else if(check_date()){
        callToastify('error', 'Receive date before order date are not accepted.', 'right');
    }
    else{
        let path        = base_url+"production/job_receive/add_update/"+id;   
        let form_data   = $("#job_receive_form").serialize();
        ajaxCall('POST',path,form_data,'JSON',function(resp){
            const{status, flag, data, msg} = resp
            if(status){
                if(flag == 1){
                    if(id == 0){
                        
                    }else{

                    }
                    callToastify('success', msg, 'right')
                    $("body, html").animate({'scrollTop':0},1000);
                    setTimeout(function(){window.location.reload(); },1000); 
                }else{
                    response_error(flag, msg)
                }
            }else{
                session_expired()
            }
        },errmsg=> {
        });
    } 
}

const remove_master = (id) => {
    var ans=confirm('Are you sure to delete');
    if (ans)
    {
        let path = base_url + "production/job_receive/remove/"+id;
        ajaxCall("POST",path,'',"JSON",function (resp) {
                const { status, flag, data, msg } = resp;
                if (status) {
                    if (flag == 1) {
                        if (id == 0) {
                        } else {
                        }
                        callToastify("success", msg, "right");
                        $("body, html").animate({ scrollTop: 0 }, 1000);
                        setTimeout(function () {
                            window.location.reload();
                        }, 1000);
                    } else {
                        response_error(flag, msg);
                    }
                } else {
                    session_expired();
                }
            },
            (errmsg) => {}
        );
    }
    
};